/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BootstrapperProxyIF;
import hydra.DynamicActionException;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.Platform;
import hydra.ProcessMgr;
import hydra.RebootPrms;
import hydra.RmiRegistryHelper;
import hydra.TestConfig;
import hydra.UnixPlatform;
import java.rmi.RemoteException;

public class RebootUtil {
    public static void reboot(String vm) {
        String host = RebootPrms.getBaseHost(vm);
        String vmconfig = RebootPrms.getConfigurationFileName(vm);
        String type = RebootPrms.useHardStop() ? "hard" : "soft";
        String header = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + host + " " + ((UnixPlatform)Platform.getInstance()).sudo() + " ";
        Log.getLogWriter().info("Rebooting virtual machine " + vm + " (" + type + ") on " + host + " using " + vmconfig);
        Log.getLogWriter().info("Checking for virtual machine " + vm);
        if (!RebootUtil.isListed(vm) || !RebootUtil.responds(vm)) {
            String s = "The virtual machine " + vm + " is not running on " + host;
            throw new DynamicActionException(s);
        }
        Log.getLogWriter().info("Stopping virtual machine " + vm);
        String stopcmd = header + "vmrun -T ws stop " + vmconfig + " " + type;
        String stopresult = ProcessMgr.fgexec(stopcmd, 120);
        Log.getLogWriter().info("Stopped virtual machine " + vm + " on host: " + host + "\n" + stopresult);
        Log.getLogWriter().info("Waiting for virtual machine " + vm + " to stop");
        long stoplimit = System.currentTimeMillis() + 120000L;
        while (RebootUtil.isListed(vm)) {
            if (System.currentTimeMillis() > stoplimit) {
                String s = "Timed out waiting for virtual machine to stop: " + vm;
                throw new HydraTimeoutException(s);
            }
            MasterController.sleepForMs(500);
        }
        Log.getLogWriter().info("Starting virtual machine " + vm);
        String startcmd = header + "vmrun -T ws start " + vmconfig + " nogui";
        String startresult = ProcessMgr.fgexec(startcmd, 120);
        Log.getLogWriter().info("Started virtual machine " + vm + " on host  " + host + "\n" + startresult);
        Log.getLogWriter().info("Waiting for virtual machine " + vm + " to start");
        long startlimit = System.currentTimeMillis() + 120000L;
        boolean exists = RebootUtil.isListed(vm);
        while (!RebootUtil.isListed(vm)) {
            if (System.currentTimeMillis() > startlimit) {
                String s = "Timed out waiting for virtual machine to start: " + vm;
                throw new HydraTimeoutException(s);
            }
            MasterController.sleepForMs(500);
        }
        while (!RebootUtil.responds(vm)) {
            if (System.currentTimeMillis() > startlimit) {
                String s = "Timed out waiting for virtual machine to respond to ssh: " + vm;
                throw new HydraTimeoutException(s);
            }
            MasterController.sleepForMs(500);
        }
        Log.getLogWriter().info("Rebooted virtual machine " + vm);
    }

    protected static boolean isAlive(String vm) {
        return RebootUtil.isListed(vm) && RebootUtil.responds(vm);
    }

    private static boolean isListed(String vm) {
        String host = RebootPrms.getBaseHost(vm);
        String vmconfig = RebootPrms.getConfigurationFileName(vm);
        String header = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + host + " " + ((UnixPlatform)Platform.getInstance()).sudo() + " ";
        String cmd = header + "vmrun -T ws list";
        String result = ProcessMgr.fgexec(cmd, 60);
        Log.getLogWriter().info("Executed " + cmd + "\n" + result);
        return result.contains(vmconfig);
    }

    private static boolean responds(String host) {
        HostDescription hd = TestConfig.getInstance().getAnyPhysicalHostDescription(host);
        if (hd.getOSType() == HostHelper.OSType.windows) {
            try {
                String cmd = "echo alive";
                String url = "rmi://" + hd.getHostName() + ":" + hd.getBootstrapPort() + "/" + "bootstrapper";
                Log.getLogWriter().info("Looking up bootstrapper at " + url);
                BootstrapperProxyIF bootstrapper = (BootstrapperProxyIF)RmiRegistryHelper.lookup(url);
                if (bootstrapper == null) {
                    return false;
                }
                Log.getLogWriter().info("Using bootstrapper to execute " + cmd);
                String result = bootstrapper.fgexec(cmd, 60);
                Log.getLogWriter().info("Executed " + cmd + "\n" + result);
                return result.contains("alive");
            }
            catch (RemoteException e) {
                return false;
            }
        }
        String cmd = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + host + " echo alive";
        try {
            String result = ProcessMgr.fgexec(cmd, 60);
            Log.getLogWriter().info("Executed " + cmd + "\n" + result);
            return result.contains("alive");
        }
        catch (HydraRuntimeException e) {
            return false;
        }
    }
}

