/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.DynamicActionUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RebootBlackboard;
import hydra.RebootHostNotFoundException;
import hydra.RebootInfo;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.TestTask;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class RebootMgr {
    public static RebootInfo reboot(String reason, String target, boolean liveOnly) throws RebootHostNotFoundException {
        RebootMgr.validate();
        return RebootMgr.reserveAndReboot(reason, target, liveOnly);
    }

    public static RebootInfo getInfo(String target) {
        return (RebootInfo)RebootBlackboard.getInstance().getSharedMap().get(target);
    }

    public static void clearInfo(String target) {
        RebootBlackboard.getInstance().getSharedMap().remove(target);
        RebootMgr.log().info("Removed " + target + " from reboot blackboard");
    }

    private static RebootInfo reserveAndReboot(final String reason, String target, boolean liveOnly) throws RebootHostNotFoundException {
        RebootMgr.log().info("Reserving " + target + " for dynamic reboot with liveOnly " + liveOnly);
        Vector hosts = TestConfig.getInstance().getPhysicalHostsIncludingHadoop();
        ArrayList hostNames = new ArrayList(hosts);
        if (!hostNames.contains(target)) {
            String s = "Host " + target + " is not in the list of hosts used in this test:" + hostNames;
            throw new IllegalArgumentException(s);
        }
        final String srcName = Thread.currentThread().getName();
        final int srcVmid = RemoteTestModule.MyVmid;
        final RebootInfo info = RebootMgr.reserveToRebootRemote(srcName, srcVmid, target, liveOnly);
        String act = "dynamic reboot " + target + "(liveOnly " + liveOnly + ") because " + reason;
        RebootMgr.log().info("Reserved " + target + " for " + act);
        final int actionId = DynamicActionUtil.nextActionId();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                RebootMgr.rebootRemote(srcName, srcVmid, actionId, reason, info);
            }
        };
        DynamicActionUtil.runActionThread(actionId, act, action, srcName, true);
        return info;
    }

    private static RebootInfo reserveToRebootRemote(String srcName, int srcVmid, String target, boolean liveOnly) throws RebootHostNotFoundException {
        RebootInfo info = null;
        try {
            info = RemoteTestModule.Master.reserveForReboot(srcName, srcVmid, target, liveOnly);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
        return info;
    }

    protected static void rebootRemote(String srcName, int srcVmid, int actionId, String reason, RebootInfo target) {
        try {
            RemoteTestModule.Master.reboot(srcName, srcVmid, actionId, reason, target);
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Problem with remote operation", e);
        }
    }

    private static void validate() {
        if (RemoteTestModule.getCurrentThread() == null) {
            String s = "The RebootMgr API can only be used from hydra threads -- use HydraSubthread when creating threads that use the API";
            throw new UnsupportedOperationException(s);
        }
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        if (task.getTaskType() != 3) {
            String s = "The RebootMgr API can only be used from tasks of type TASK";
            throw new UnsupportedOperationException(s);
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

