/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HostAgentMgr;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.Platform;
import hydra.ProductVersionHelper;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import util.TestHelper;

public class ProcessMgr {
    public static int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (NumberFormatException e) {
            String s = "Something changed in the RuntimeMXBean name, which we rely on to get the PID: " + name;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static String fgexec(String command, int maxWaitSec) {
        ProcessMgr.log("Executing fgexec command: " + command);
        String output = Platform.getInstance().fgexec(command, maxWaitSec);
        ProcessMgr.log("Executed fgexec command: " + command);
        return output;
    }

    public static String fgexec(String command, String[] envp, int maxWaitSec) {
        List<String> envps = Arrays.asList(envp);
        ProcessMgr.log("Executing fgexec command: " + command + " with envp " + envps);
        String output = Platform.getInstance().fgexec(command, envp, maxWaitSec);
        ProcessMgr.log("Executed fgexec command: " + command + " with envp " + envps);
        return output;
    }

    public static String fgexec(String[] command, int maxWaitSec) {
        StringBuilder stringBuilder = new StringBuilder().append("Executing fgexec command: ");
        Platform.getInstance();
        ProcessMgr.log(stringBuilder.append(Platform.getString(command)).toString());
        String output = Platform.getInstance().fgexec(command, maxWaitSec);
        StringBuilder stringBuilder2 = new StringBuilder().append("Executed fgexec command: ");
        Platform.getInstance();
        ProcessMgr.log(stringBuilder2.append(Platform.getString(command)).toString());
        return output;
    }

    public static String fgexec(String host, String command, int maxWaitSec) {
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Issuing fgexec command on localhost " + host + ": " + command);
            String result = ProcessMgr.fgexec(command, maxWaitSec);
            ProcessMgr.log("Issued fgexec command on localhost " + host + ": " + command + " with result: " + result);
            return result;
        }
        ProcessMgr.log("Issuing fgexec command on remote host " + host + ": " + command);
        try {
            String result = HostAgentMgr.getHostAgent(host).fgexec(command, maxWaitSec);
            ProcessMgr.log("Issued fgexec command on remote host " + host + ": " + command + " with result: " + result);
            return result;
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host + ": " + command;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static String fgexec(String host, String command, String[] envp, int maxWaitSec) {
        List<String> envps = Arrays.asList(envp);
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Issuing fgexec command on localhost " + host + ": " + command + " with envp " + envps);
            String result = ProcessMgr.fgexec(command, envp, maxWaitSec);
            ProcessMgr.log("Issued fgexec command on localhost " + host + ": " + command + " with env " + envps + " with result: " + result);
            return result;
        }
        ProcessMgr.log("Issuing fgexec command on remote host " + host + ": " + command + " with envp " + envps);
        try {
            String result = HostAgentMgr.getHostAgent(host).fgexec(command, envp, maxWaitSec);
            ProcessMgr.log("Issued fgexec command on remote host " + host + ": " + command + " with envp " + envps + " with result: " + result);
            return result;
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host + ": " + command + " with envp " + envps;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static int bgexec(String command) {
        return ProcessMgr.bgexec(command, null, null);
    }

    public static int bgexec(String host, String command) {
        if (HostHelper.isLocalHost(host)) {
            return ProcessMgr.bgexec(command, null, null);
        }
        return ProcessMgr.bgexec(host, command, null, null);
    }

    public static int bgexec(String command, String workdir, String logfile) {
        int pid;
        ProcessMgr.log("Executing bgexec command: " + command);
        try {
            pid = Platform.getInstance().bgexec(command, FileUtil.fileForName(workdir), FileUtil.fileForName(logfile));
        }
        catch (IOException e) {
            String s = "Unable to complete operation: " + command;
            throw new HydraRuntimeException(s, e);
        }
        ProcessMgr.log("Executed bgexec command: " + command);
        return pid;
    }

    public static int bgexec(String host, String command, String workdir, String logfile) {
        int pid;
        if (HostHelper.isLocalHost(host)) {
            return ProcessMgr.bgexec(command, workdir, logfile);
        }
        ProcessMgr.log("Issuing bgexec command on host " + host + ": " + command);
        try {
            pid = HostAgentMgr.getHostAgent(host).bgexec(command, FileUtil.fileForName(workdir), FileUtil.fileForName(logfile));
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host + ": " + command;
            throw new HydraRuntimeException(s, e);
        }
        ProcessMgr.log("Issued bgexec command on host " + host + ": " + command);
        return pid;
    }

    public static boolean processExists(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            return Platform.getInstance().exists(pid);
        }
        try {
            return HostAgentMgr.getHostAgent(host).exists(pid);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static void shutdownProcess(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Executing shutdown command on process:" + pid);
            Platform.getInstance().shutdown(pid);
            ProcessMgr.log("Executed shutdown command on process:" + pid);
        } else {
            try {
                ProcessMgr.log("Issuing shutdown command to process " + host + ":" + pid);
                HostAgentMgr.getHostAgent(host).shutdown(pid);
                ProcessMgr.log("Issued shutdown command to process " + host + ":" + pid);
            }
            catch (RemoteException e) {
                String s = "Unable to complete operation using hostagent on " + host;
                throw new HydraRuntimeException(s, e);
            }
        }
    }

    public static void killProcess(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Executing kill command on process:" + pid);
            Platform.getInstance().kill(pid);
            ProcessMgr.log("Executed kill command on process:" + pid);
        } else {
            try {
                ProcessMgr.log("Issuing kill command to process " + host + ":" + pid);
                HostAgentMgr.getHostAgent(host).kill(pid);
                ProcessMgr.log("Issued kill command to process " + host + ":" + pid);
            }
            catch (RemoteException e) {
                String s = "Unable to complete operation using hostagent on " + host;
                throw new HydraRuntimeException(s, e);
            }
        }
    }

    public static void printProcessStacks(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Executing stack dump command on process:" + pid);
            Platform.getInstance().printStacks(pid);
            ProcessMgr.log("Executed stack dump command on process:" + pid);
        } else {
            try {
                ProcessMgr.log("Issuing stack dump command to process " + host + ":" + pid);
                HostAgentMgr.getHostAgent(host).printStacks(pid);
                ProcessMgr.log("Issued stack dump command to process " + host + ":" + pid);
            }
            catch (RemoteException e) {
                String s = "Unable to complete operation using hostagent on " + host;
                throw new HydraRuntimeException(s, e);
            }
        }
    }

    public static void dumpHeap(String host, int pid, String userDir, String options) {
        if (HostHelper.isLocalHost(host)) {
            ProcessMgr.log("Executing heap dump command on process:" + pid);
            Platform.getInstance().dumpHeap(pid, userDir, options);
            ProcessMgr.log("Executed heap dump command on process:" + pid);
        } else {
            try {
                ProcessMgr.log("Issuing heap dump command to process " + host + ":" + pid);
                HostAgentMgr.getHostAgent(host).dumpHeap(pid, userDir, options);
                ProcessMgr.log("Issued heap dump command to process " + host + ":" + pid);
            }
            catch (RemoteException e) {
                String s = "Unable to complete operation using hostagent on " + host;
                throw new HydraRuntimeException(s, e);
            }
        }
    }

    public static void logNetworkStatistics() {
        ProcessMgr.log("Logging network statistics");
        try {
            String netstats = Platform.getInstance().getNetworkStatistics(120);
            ProcessMgr.log("Network statistics:\n" + netstats);
        }
        catch (HydraRuntimeException e) {
            ProcessMgr.log("Unable to log network statistics: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
        catch (HydraTimeoutException e) {
            ProcessMgr.log("Unable to log network statistics: " + TestHelper.getStackTrace((Throwable)((Object)e)));
        }
    }

    public static boolean shutdownProcessWait(String host, int pid, int maxWaitSec) {
        ProcessMgr.shutdownProcess(host, pid);
        if (ProcessMgr.processExists(host, pid)) {
            return ProcessMgr.waitForDeath(host, pid, maxWaitSec);
        }
        return true;
    }

    public static boolean killProcessWait(String host, int pid, int maxWaitSec) {
        ProcessMgr.killProcess(host, pid);
        if (ProcessMgr.processExists(host, pid)) {
            return ProcessMgr.waitForDeath(host, pid, maxWaitSec);
        }
        return true;
    }

    public static boolean waitForDeath(String host, int pid, int maxWaitSec) {
        long timeout = System.currentTimeMillis() + (long)(maxWaitSec * 1000);
        while (System.currentTimeMillis() < timeout) {
            MasterController.sleepForMs(1000);
            if (ProcessMgr.processExists(host, pid)) continue;
            return true;
        }
        return false;
    }

    public static boolean waitForLife(String host, int pid, int maxWaitSec) {
        long timeout = System.currentTimeMillis() + (long)(maxWaitSec * 1000);
        while (System.currentTimeMillis() < timeout) {
            MasterController.sleepForMs(1000);
            if (!ProcessMgr.processExists(host, pid)) continue;
            return true;
        }
        return false;
    }

    public static String processAndBuildInfoString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\n#####################################################\n\n");
        buff.append("Host name: " + HostHelper.getLocalHost() + "\n");
        buff.append("Process id: " + ProcessMgr.getProcessId() + "\n");
        buff.append("OS User name: " + System.getProperty("user.name") + "\n");
        buff.append("User home: " + System.getProperty("user.home") + "\n");
        buff.append("Current directory: " + System.getProperty("user.dir") + "\n\n");
        buff.append("OS name: " + System.getProperty("os.name") + "\n");
        buff.append("Architecture: " + System.getProperty("os.arch") + "\n");
        buff.append("OS version: " + System.getProperty("os.version") + "\n\n");
        buff.append("Java version: " + System.getProperty("java.version") + "\n");
        buff.append("Java vm name: " + System.getProperty("java.vm.name") + "\n");
        buff.append("Java vendor: " + System.getProperty("java.vm.vendor") + "\n");
        buff.append("Java home: " + System.getProperty("java.home") + "\n\n");
        buff.append("Java class path: " + System.getProperty("java.class.path") + "\n\n");
        buff.append("Java library path: " + System.getProperty("java.library.path") + "\n\n");
        buff.append("#####################################################\n\n");
        Properties p = ProductVersionHelper.getInfo();
        if (p != null) {
            buff.append("Product Version: " + p.getProperty("Product-Version") + "\n");
            buff.append("Source Date: " + p.getProperty("Source-Date") + "\n");
            buff.append("Source Revision: " + p.getProperty("Source-Revision") + "\n");
            buff.append("Source Repository: " + p.getProperty("Source-Repository") + "\n\n");
            buff.append("Build Id: " + p.getProperty("Build-Id") + "\n");
            buff.append("Build Date: " + p.getProperty("Build-Date") + "\n");
            buff.append("Build Version: " + p.getProperty("Product-Version") + " " + p.getProperty("Build-Id") + " " + p.getProperty("Build-Date") + " javac " + p.getProperty("Build-Java-Version") + "\n");
            buff.append("Build JDK: Java " + p.getProperty("Build-Java-Version") + "\n");
            buff.append("Build Platform: " + p.getProperty("Build-Platform") + "\n\n");
            buff.append("#####################################################");
        }
        return buff.toString();
    }

    public static String getProcessStatus(int maxWaitSec) {
        return Platform.getInstance().getProcessStatus(maxWaitSec);
    }

    public static String getProcessStatus(String host, int maxWaitSec) {
        if (HostHelper.isLocalHost(host)) {
            return ProcessMgr.getProcessStatus(maxWaitSec);
        }
        ProcessMgr.log("Getting process status on host " + host);
        try {
            return HostAgentMgr.getHostAgent(host).getProcessStatus(maxWaitSec);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    public static String getMemoryStatus(int maxWaitSec) {
        return Platform.getInstance().getMemoryStatus(maxWaitSec);
    }

    public static void setReadPermission(String dir) {
        Platform.getInstance().setReadPermission(dir);
    }

    private static void log(String msg) {
        try {
            Log.getLogWriter().info(msg);
        }
        catch (HydraRuntimeException e) {
            System.out.println(msg);
        }
    }
}

