/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.BridgeDescription;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.ConfigHashtable;
import hydra.Contact;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.PoolPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class PoolDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SERVER_LOCATOR = 0;
    private static final int CACHE_SERVER = 1;
    private String name;
    private String contactClass;
    private String contactMethod;
    private Integer contactNum;
    private String distributedSystem;
    private Integer freeConnectionTimeout;
    private Long idleTimeout;
    private Integer loadConditioningInterval;
    private Integer minConnections;
    private Integer maxConnections;
    private Boolean multiuserAuthentication;
    private Long pingInterval;
    private Boolean prSingleHopEnabled;
    private Integer readTimeout;
    private Integer retryAttempts;
    private String serverGroup;
    private Integer socketBufferSize;
    private Integer statisticInterval;
    private Integer subscriptionAckInterval;
    private Boolean subscriptionEnabled;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private Boolean threadLocalConnections;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private String getContactAlgorithm() {
        return this.getContactClass() + "." + this.getContactMethod() + "(int, String)";
    }

    private String getContactClass() {
        return this.contactClass;
    }

    private void setContactClass(String str) {
        this.contactClass = str;
    }

    private String getContactMethod() {
        return this.contactMethod;
    }

    private void setContactMethod(String str) {
        this.contactMethod = str;
    }

    private Integer getContactNum() {
        return this.contactNum;
    }

    private void setContactNum(Integer i) {
        this.contactNum = i;
    }

    private String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String str) {
        this.distributedSystem = str;
    }

    private Integer getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    private void setFreeConnectionTimeout(Integer i) {
        this.freeConnectionTimeout = i;
    }

    private Long getIdleTimeout() {
        return this.idleTimeout;
    }

    private void setIdleTimeout(Long l) {
        this.idleTimeout = l;
    }

    private Integer getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    private void setLoadConditioningInterval(Integer i) {
        this.loadConditioningInterval = i;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(Integer i) {
        this.minConnections = i;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer i) {
        this.maxConnections = i;
    }

    private Boolean getMultiuserAuthentication() {
        return this.multiuserAuthentication;
    }

    private void setMultiuserAuthentication(Boolean bool) {
        this.multiuserAuthentication = bool;
    }

    public Long getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(Long l) {
        this.pingInterval = l;
    }

    private Boolean getPRSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    private void setPRSingleHopEnabled(Boolean bool) {
        this.prSingleHopEnabled = bool;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    private void setReadTimeout(Integer i) {
        this.readTimeout = i;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(Integer i) {
        this.retryAttempts = i;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    private void setServerGroup(String str) {
        this.serverGroup = str;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    public Integer getStatisticInterval() {
        return this.statisticInterval;
    }

    public void setStatisticInterval(Integer v) {
        this.statisticInterval = v;
    }

    private Integer getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    private void setSubscriptionAckInterval(Integer i) {
        this.subscriptionAckInterval = i;
    }

    private Boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    private void setSubscriptionEnabled(Boolean bool) {
        this.subscriptionEnabled = bool;
    }

    private Integer getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    private void setSubscriptionMessageTrackingTimeout(Integer i) {
        this.subscriptionMessageTrackingTimeout = i;
    }

    private Integer getSubscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    private void setSubscriptionRedundancy(Integer i) {
        this.subscriptionRedundancy = i;
    }

    private Boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    private void setThreadLocalConnections(Boolean bool) {
        this.threadLocalConnections = bool;
    }

    public void configure(PoolFactory f) {
        List contacts = this.getContacts(this.getContactClass(), this.getContactMethod(), this.getContactNum(), this.getDistributedSystem());
        int contactType = this.getContactType(contacts, this.getContactAlgorithm());
        if (contactType == 0) {
            for (Contact contact : contacts) {
                f.addLocator(contact.getAddress(), contact.getPort());
            }
        } else if (contactType == 1) {
            for (Contact contact : contacts) {
                f.addServer(contact.getAddress(), contact.getPort());
            }
        } else {
            String s = "Illegal contact type: " + contactType;
            throw new HydraInternalException(s);
        }
        f.setFreeConnectionTimeout(this.getFreeConnectionTimeout().intValue());
        f.setIdleTimeout(this.getIdleTimeout().longValue());
        f.setLoadConditioningInterval(this.getLoadConditioningInterval().intValue());
        f.setMinConnections(this.getMinConnections().intValue());
        f.setMaxConnections(this.getMaxConnections().intValue());
        f.setMultiuserAuthentication(this.getMultiuserAuthentication().booleanValue());
        f.setPingInterval(this.getPingInterval().longValue());
        f.setPRSingleHopEnabled(this.getPRSingleHopEnabled().booleanValue());
        f.setReadTimeout(this.getReadTimeout().intValue());
        f.setRetryAttempts(this.getRetryAttempts().intValue());
        f.setServerGroup(this.getServerGroup());
        f.setSocketBufferSize(this.getSocketBufferSize().intValue());
        f.setStatisticInterval(this.getStatisticInterval().intValue());
        f.setSubscriptionAckInterval(this.getSubscriptionAckInterval().intValue());
        f.setSubscriptionEnabled(this.getSubscriptionEnabled().booleanValue());
        f.setSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout().intValue());
        f.setSubscriptionRedundancy(this.getSubscriptionRedundancy().intValue());
        f.setThreadLocalConnections(this.getThreadLocalConnections().booleanValue());
    }

    public void configure(ClientCacheFactory f) {
        List contacts = this.getContacts(this.getContactClass(), this.getContactMethod(), this.getContactNum(), this.getDistributedSystem());
        int contactType = this.getContactType(contacts, this.getContactAlgorithm());
        if (contactType == 0) {
            for (Contact contact : contacts) {
                f.addPoolLocator(contact.getAddress(), contact.getPort());
            }
        } else if (contactType == 1) {
            for (Contact contact : contacts) {
                f.addPoolServer(contact.getAddress(), contact.getPort());
            }
        } else {
            String s = "Illegal contact type: " + contactType;
            throw new HydraInternalException(s);
        }
        f.setPoolFreeConnectionTimeout(this.getFreeConnectionTimeout().intValue());
        f.setPoolIdleTimeout(this.getIdleTimeout().longValue());
        f.setPoolLoadConditioningInterval(this.getLoadConditioningInterval().intValue());
        f.setPoolMinConnections(this.getMinConnections().intValue());
        f.setPoolMaxConnections(this.getMaxConnections().intValue());
        f.setPoolMultiuserAuthentication(this.getMultiuserAuthentication().booleanValue());
        f.setPoolPingInterval(this.getPingInterval().longValue());
        f.setPoolPRSingleHopEnabled(this.getPRSingleHopEnabled().booleanValue());
        f.setPoolReadTimeout(this.getReadTimeout().intValue());
        f.setPoolRetryAttempts(this.getRetryAttempts().intValue());
        f.setPoolServerGroup(this.getServerGroup());
        f.setPoolSocketBufferSize(this.getSocketBufferSize().intValue());
        f.setPoolStatisticInterval(this.getStatisticInterval().intValue());
        f.setPoolSubscriptionAckInterval(this.getSubscriptionAckInterval().intValue());
        f.setPoolSubscriptionEnabled(this.getSubscriptionEnabled().booleanValue());
        f.setPoolSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout().intValue());
        f.setPoolSubscriptionRedundancy(this.getSubscriptionRedundancy().intValue());
        f.setPoolThreadLocalConnections(this.getThreadLocalConnections().booleanValue());
    }

    protected static synchronized String poolToString(Pool p) {
        return PoolDescription.poolToString(p.getName(), p);
    }

    private static synchronized String poolToString(String poolName, Pool p) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  freeConnectionTimeout: " + p.getFreeConnectionTimeout());
        buf.append("\n  idleTimeout: " + p.getIdleTimeout());
        buf.append("\n  loadConditioningInterval: " + p.getLoadConditioningInterval());
        buf.append("\n  locators: " + p.getLocators());
        buf.append("\n  minConnections: " + p.getMinConnections());
        buf.append("\n  maxConnections: " + p.getMaxConnections());
        buf.append("\n  multiuserAuthentication: " + p.getMultiuserAuthentication());
        buf.append("\n  pingInterval: " + p.getPingInterval());
        buf.append("\n  poolName: " + poolName);
        buf.append("\n  prSingleHopEnabled: " + p.getPRSingleHopEnabled());
        buf.append("\n  readTimeout: " + p.getReadTimeout());
        buf.append("\n  retryAttempts: " + p.getRetryAttempts());
        buf.append("\n  servers: " + p.getServers());
        buf.append("\n  serverGroup: " + p.getServerGroup());
        buf.append("\n  socketBufferSize: " + p.getSocketBufferSize());
        buf.append("\n  statisticInterval: " + p.getStatisticInterval());
        buf.append("\n  subscriptionAckInterval: " + p.getSubscriptionAckInterval());
        buf.append("\n  subscriptionEnabled: " + p.getSubscriptionEnabled());
        buf.append("\n  subscriptionMessageTrackingTimeout: " + p.getSubscriptionMessageTrackingTimeout());
        buf.append("\n  subscriptionRedundancy: " + p.getSubscriptionRedundancy());
        buf.append("\n  threadLocalConnections: " + p.getThreadLocalConnections());
        return buf.toString();
    }

    protected static synchronized String poolFactoryToString(String poolName, PoolFactory f) {
        PoolFactoryImpl.PoolAttributes pa = ((PoolFactoryImpl)f).getPoolAttributes();
        return PoolDescription.poolToString(poolName, (Pool)pa);
    }

    protected static boolean equals(PoolFactory f, Pool p) {
        PoolFactoryImpl.PoolAttributes pa = ((PoolFactoryImpl)f).getPoolAttributes();
        return pa.getFreeConnectionTimeout() == p.getFreeConnectionTimeout() && pa.getIdleTimeout() == p.getIdleTimeout() && pa.getLoadConditioningInterval() == p.getLoadConditioningInterval() && pa.getLocators().size() == p.getLocators().size() && pa.getMinConnections() == p.getMinConnections() && pa.getMaxConnections() == p.getMaxConnections() && pa.getMultiuserAuthentication() == p.getMultiuserAuthentication() && pa.getPingInterval() == p.getPingInterval() && pa.getPRSingleHopEnabled() == p.getPRSingleHopEnabled() && pa.getReadTimeout() == p.getReadTimeout() && pa.getRetryAttempts() == p.getRetryAttempts() && pa.getServers().size() == p.getServers().size() && pa.getServerGroup().equals(p.getServerGroup()) && pa.getSocketBufferSize() == p.getSocketBufferSize() && pa.getStatisticInterval() == p.getStatisticInterval() && pa.getSubscriptionAckInterval() == p.getSubscriptionAckInterval() && pa.getSubscriptionEnabled() == p.getSubscriptionEnabled() && pa.getSubscriptionMessageTrackingTimeout() == p.getSubscriptionMessageTrackingTimeout() && pa.getSubscriptionRedundancy() == p.getSubscriptionRedundancy() && pa.getThreadLocalConnections() == p.getThreadLocalConnections();
    }

    private List getContacts(String contactClass, String contactMethod, Integer numContacts, String ds) {
        Object[] args = new Object[]{numContacts, ds};
        MethExecutorResult result = MethExecutor.execute(contactClass, contactMethod, args);
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        return (List)result.getResult();
    }

    private int getContactType(List contacts, String contactAlgorithm) {
        if (contacts.size() == 0) {
            String s = "Contact algorithm " + contactAlgorithm + " returned no contacts";
            throw new HydraRuntimeException(s);
        }
        int type = -1;
        for (Object contact : contacts) {
            String s;
            if (contact instanceof DistributedSystemHelper.Endpoint) {
                if (type == -1) {
                    type = 0;
                    continue;
                }
                if (type == 0) {
                    if (((DistributedSystemHelper.Endpoint)contact).isServerLocator()) continue;
                    s = "Locator is not a server locator: " + contact;
                    throw new HydraRuntimeException(s);
                }
                if (type == 1) {
                    s = "Contact algorithm " + contactAlgorithm + " returned a mix of server locators and bridge servers: " + contacts;
                    continue;
                }
                throw new HydraInternalException("Unexpected type: " + type);
            }
            if (contact instanceof BridgeHelper.Endpoint) {
                if (type == -1) {
                    type = 1;
                    continue;
                }
                if (type == 0) {
                    s = "Contact algorithm " + contactAlgorithm + " returned a mix of server locators and bridge servers: " + contacts;
                    continue;
                }
                if (type == 1) continue;
                throw new HydraInternalException("Unexpected type: " + type);
            }
            s = "Contact algorithm " + contactAlgorithm + " returned illegal type: " + contact.getClass().getName();
            throw new HydraRuntimeException(s);
        }
        return type;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "contactAlgorithm", this.getContactAlgorithm());
        if (this.getContactNum() == -1) {
            map.put(header + "contactNum", "all available");
        } else {
            map.put(header + "contactNum", this.getContactNum());
        }
        if (this.getDistributedSystem() == null) {
            map.put(header + "distributedSystem", "all available");
        } else {
            map.put(header + "distributedSystem", this.getDistributedSystem());
        }
        map.put(header + "freeConnectionTimeout", this.getFreeConnectionTimeout());
        map.put(header + "idleTimeout", this.getIdleTimeout());
        map.put(header + "loadConditioningInterval", this.getLoadConditioningInterval());
        map.put(header + "minConnections", this.getMinConnections());
        map.put(header + "maxConnections", this.getMaxConnections());
        map.put(header + "multiuserAuthentication", this.getMultiuserAuthentication());
        map.put(header + "pingInterval", this.getPingInterval());
        map.put(header + "prSingleHopEnabled", this.getPRSingleHopEnabled());
        map.put(header + "readTimeout", this.getReadTimeout());
        map.put(header + "retryAttempts", this.getRetryAttempts());
        map.put(header + "serverGroup", this.getServerGroup());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "statisticInterval", this.getStatisticInterval());
        map.put(header + "subscriptionAckInterval", this.getSubscriptionAckInterval());
        map.put(header + "subscriptionEnabled", this.getSubscriptionEnabled());
        map.put(header + "subscriptionMessageTrackingTimeout", this.getSubscriptionMessageTrackingTimeout());
        map.put(header + "subscriptionRedundancy", this.getSubscriptionRedundancy());
        map.put(header + "threadLocalConnections", this.getThreadLocalConnections());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(PoolPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            PoolDescription pd = PoolDescription.createPoolDescription(name, config, i);
            config.addPoolDescription(pd);
        }
    }

    private static PoolDescription createPoolDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        PoolDescription pd = new PoolDescription();
        pd.setName(name);
        Long key = PoolPrms.contactAlgorithm;
        HydraVector strs = tab.vecAtWild(key, index, null);
        pd.setContactClass(PoolDescription.getContactClass(strs, key));
        pd.setContactMethod(PoolDescription.getContactMethod(strs, key));
        key = PoolPrms.contactNum;
        Number i = tab.getInteger(key, tab.getWild(key, index, null));
        pd.setContactNum(PoolDescription.getContactNum(i, key));
        key = PoolPrms.distributedSystem;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            pd.setDistributedSystem(PoolDescription.getDistributedSystem(str, key, config));
        }
        if ((i = tab.getInteger(key = PoolPrms.freeConnectionTimeout, tab.getWild(key, index, null))) == null) {
            i = new Integer(10000);
        }
        pd.setFreeConnectionTimeout((Integer)i);
        key = PoolPrms.idleTimeout;
        i = tab.getLong(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Long(5000L);
        }
        pd.setIdleTimeout((Long)i);
        key = PoolPrms.loadConditioningInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(300000);
        }
        pd.setLoadConditioningInterval((Integer)i);
        key = PoolPrms.minConnections;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(1);
        }
        pd.setMinConnections((Integer)i);
        key = PoolPrms.maxConnections;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(-1);
        }
        pd.setMaxConnections((Integer)i);
        key = PoolPrms.multiuserAuthentication;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        pd.setMultiuserAuthentication(bool);
        key = PoolPrms.pingInterval;
        i = tab.getLong(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Long(10000L);
        }
        pd.setPingInterval((Long)i);
        key = PoolPrms.prSingleHopEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = true;
        }
        pd.setPRSingleHopEnabled(bool);
        key = PoolPrms.readTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(10000);
        }
        pd.setReadTimeout((Integer)i);
        key = PoolPrms.retryAttempts;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(-1);
        }
        pd.setRetryAttempts((Integer)i);
        key = PoolPrms.serverGroup;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            pd.setServerGroup("");
        } else {
            pd.setServerGroup(PoolDescription.getServerGroup(str, key, config));
        }
        key = PoolPrms.socketBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(32768);
        }
        pd.setSocketBufferSize((Integer)i);
        key = PoolPrms.statisticInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(-1);
        }
        pd.setStatisticInterval((Integer)i);
        key = PoolPrms.subscriptionAckInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(100);
        }
        pd.setSubscriptionAckInterval((Integer)i);
        key = PoolPrms.subscriptionEnabled;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        pd.setSubscriptionEnabled(bool);
        key = PoolPrms.subscriptionMessageTrackingTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(900000);
        }
        pd.setSubscriptionMessageTrackingTimeout((Integer)i);
        key = PoolPrms.subscriptionRedundancy;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(0);
        }
        pd.setSubscriptionRedundancy((Integer)i);
        key = PoolPrms.threadLocalConnections;
        bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = false;
        }
        pd.setThreadLocalConnections(bool);
        return pd;
    }

    private static String getContactClass(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "hydra.PoolHelper";
        }
        if (strs.size() == 2) {
            return (String)strs.get(0);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static String getContactMethod(Vector strs, Long key) {
        if (strs == null || strs.size() == 0) {
            return "getRandomContacts";
        }
        if (strs.size() == 2) {
            return (String)strs.get(1);
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + strs;
        throw new HydraConfigException(s);
    }

    private static Integer getContactNum(Integer i, Long key) {
        if (i == null || i == -1) {
            return new Integer(-1);
        }
        if (i > 0) {
            return i;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + i;
        throw new HydraConfigException(s);
    }

    private static String getDistributedSystem(String str, Long key, TestConfig config) {
        Map<String, GemFireDescription> gfds = config.getGemFireDescriptions();
        if (gfds != null) {
            for (GemFireDescription gfd : gfds.values()) {
                if (!gfd.getDistributedSystem().equals(str)) continue;
                return str;
            }
        }
        String s = BasePrms.nameForKey(key) + " not found in any " + BasePrms.nameForKey(GemFirePrms.distributedSystem) + ": " + str;
        throw new HydraConfigException(s);
    }

    private static String getServerGroup(String str, Long key, TestConfig config) {
        Map bds = config.getBridgeDescriptions();
        if (bds != null) {
            for (BridgeDescription bd : bds.values()) {
                if (!Arrays.asList(bd.getGroups()).contains(str)) continue;
                return str;
            }
        }
        String s = BasePrms.nameForKey(key) + " not found in any " + BasePrms.nameForKey(BridgePrms.groups) + ": " + str;
        throw new HydraConfigException(s);
    }
}

