/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.FixedPartitionDescription;
import hydra.FixedPartitionPrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.PartitionPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class PartitionDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String colocatedWith;
    private FixedPartitionDescription fixedPartitionDescription;
    private String fixedPartitionDescriptionName;
    private Integer localMaxMemory;
    private List<String> partitionListeners;
    private String partitionResolver;
    private Long recoveryDelay;
    private Integer redundantCopies;
    private Long startupRecoveryDelay;
    private Long totalMaxMemory;
    private Integer totalNumBuckets;
    private transient PartitionAttributesFactory partitionAttributesFactory;
    private transient PartitionAttributes partitionAttributes;
    private transient List<PartitionListener> partitionListenerInstances;
    private transient PartitionResolver partitionResolverInstance;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private String getColocatedWith() {
        return this.colocatedWith;
    }

    private void setColocatedWith(String str) {
        this.colocatedWith = str;
    }

    private String getFixedPartitionDescriptionName() {
        return this.fixedPartitionDescriptionName;
    }

    private void setFixedPartitionDescriptionName(String str) {
        this.fixedPartitionDescriptionName = str;
    }

    public FixedPartitionDescription getFixedPartitionDescription() {
        return this.fixedPartitionDescription;
    }

    private void setFixedPartitionDescription(FixedPartitionDescription fpd) {
        this.fixedPartitionDescription = fpd;
    }

    private Integer getLocalMaxMemory() {
        return this.localMaxMemory;
    }

    private void setLocalMaxMemory(Integer i) {
        this.localMaxMemory = i;
    }

    private List<String> getPartitionListeners() {
        return this.partitionListeners;
    }

    private void setPartitionListeners(List classnames) {
        this.partitionListeners = classnames;
    }

    private String getPartitionResolver() {
        return this.partitionResolver;
    }

    private void setPartitionResolver(String str) {
        this.partitionResolver = str;
    }

    private synchronized List<PartitionListener> getPartitionListenerInstances() {
        if (this.partitionListenerInstances == null) {
            this.partitionListenerInstances = this.createPartitionListenerInstances();
        }
        return this.partitionListenerInstances;
    }

    private synchronized PartitionResolver getPartitionResolverInstance() {
        if (this.partitionResolverInstance == null) {
            this.partitionResolverInstance = this.createPartitionResolverInstance();
        }
        return this.partitionResolverInstance;
    }

    private Long getRecoveryDelay() {
        return this.recoveryDelay;
    }

    private void setRecoveryDelay(Long l) {
        this.recoveryDelay = l;
    }

    public Integer getRedundantCopies() {
        return this.redundantCopies;
    }

    private void setRedundantCopies(Integer i) {
        this.redundantCopies = i;
    }

    private Long getStartupRecoveryDelay() {
        return this.startupRecoveryDelay;
    }

    private void setStartupRecoveryDelay(Long l) {
        this.startupRecoveryDelay = l;
    }

    private Long getTotalMaxMemory() {
        return this.totalMaxMemory;
    }

    private void setTotalMaxMemory(Long l) {
        this.totalMaxMemory = l;
    }

    private Integer getTotalNumBuckets() {
        return this.totalNumBuckets;
    }

    private void setTotalNumBuckets(Integer i) {
        this.totalNumBuckets = i;
    }

    public synchronized PartitionAttributesFactory getPartitionAttributesFactory() {
        return this.getPartitionAttributesFactory("DefaultRegion");
    }

    protected synchronized PartitionAttributesFactory getPartitionAttributesFactory(String regionName) {
        if (this.partitionAttributesFactory == null) {
            List<FixedPartitionAttributes> fpas;
            PartitionAttributesFactory f = new PartitionAttributesFactory();
            f.setColocatedWith(this.getColocatedWith());
            if (this.getFixedPartitionDescription() != null && (this.getLocalMaxMemory() == null || this.getLocalMaxMemory() > 0) && (fpas = this.getFixedPartitionDescription().getFixedPartitionAttributes(regionName, this.getRedundantCopies())) != null) {
                for (FixedPartitionAttributes fpa : fpas) {
                    f.addFixedPartitionAttributes(fpa);
                }
            }
            if (this.getLocalMaxMemory() != null) {
                f.setLocalMaxMemory(this.getLocalMaxMemory().intValue());
            }
            f.setRecoveryDelay(this.getRecoveryDelay().longValue());
            f.setRedundantCopies(this.getRedundantCopies().intValue());
            f.setStartupRecoveryDelay(this.getStartupRecoveryDelay().longValue());
            f.setTotalMaxMemory(this.getTotalMaxMemory().longValue());
            f.setTotalNumBuckets(this.getTotalNumBuckets().intValue());
            if (this.getPartitionListeners() != null) {
                for (PartitionListener listener : this.getPartitionListenerInstances()) {
                    f.addPartitionListener(listener);
                }
            }
            if (this.getPartitionResolver() != null) {
                f.setPartitionResolver(this.getPartitionResolverInstance());
            }
            this.partitionAttributesFactory = f;
        }
        return this.partitionAttributesFactory;
    }

    public synchronized PartitionAttributes getPartitionAttributes() {
        return this.getPartitionAttributes("DefaultRegion");
    }

    protected synchronized PartitionAttributes getPartitionAttributes(String regionName) {
        if (this.partitionAttributes == null) {
            this.partitionAttributes = this.getPartitionAttributesFactory(regionName).create();
        }
        return this.partitionAttributes;
    }

    protected static synchronized String partitionAttributesToString(PartitionAttributes p) {
        if (p == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("\n    colocatedWith: " + p.getColocatedWith());
        buf.append("\n    fixedPartitionAttributes: " + p.getFixedPartitionAttributes());
        buf.append("\n    localMaxMemory: " + p.getLocalMaxMemory());
        buf.append("\n    partitionListeners: " + Arrays.toString(p.getPartitionListeners()));
        buf.append("\n    partitionResolver: " + p.getPartitionResolver());
        buf.append("\n    recoveryDelay: " + p.getRecoveryDelay());
        buf.append("\n    redundantCopies: " + p.getRedundantCopies());
        buf.append("\n    startupRecoveryDelay: " + p.getStartupRecoveryDelay());
        buf.append("\n    totalMaxMemory: " + p.getTotalMaxMemory());
        buf.append("\n    totalNumBuckets: " + p.getTotalNumBuckets());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "colocatedWith", this.getColocatedWith());
        map.put(header + "fixedPartitionName", this.getFixedPartitionDescriptionName());
        if (this.localMaxMemory == null) {
            map.put(header + "localMaxMemory", "computed");
        } else {
            map.put(header + "localMaxMemory", this.getLocalMaxMemory());
        }
        map.put(header + "partitionListeners", this.getPartitionListeners());
        map.put(header + "partitionResolver", this.getPartitionResolver());
        map.put(header + "recoveryDelay", this.getRecoveryDelay());
        map.put(header + "redundantCopies", this.getRedundantCopies());
        map.put(header + "startupRecoveryDelay", this.getStartupRecoveryDelay());
        map.put(header + "totalMaxMemory", this.getTotalMaxMemory());
        map.put(header + "totalNumBuckets", this.getTotalNumBuckets());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(PartitionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            PartitionDescription pd = PartitionDescription.createPartitionDescription(name, config, i);
            PartitionAttributes pa = PartitionDescription.createPartitionAttributes(pd);
            PartitionDescription.resetPartitionDescription(pd, pa);
            config.addPartitionDescription(pd);
        }
    }

    private static PartitionDescription createPartitionDescription(String name, TestConfig config, int index) {
        Long l;
        HydraVector strs;
        Integer i;
        ConfigHashtable tab = config.getParameters();
        PartitionDescription pd = new PartitionDescription();
        pd.setName(name);
        Long key = PartitionPrms.colocatedWith;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            pd.setColocatedWith(str);
        }
        if ((str = tab.getString(key = PartitionPrms.fixedPartitionName, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            pd.setFixedPartitionDescription(PartitionDescription.getFixedPartitionDescription(str, key, config));
            pd.setFixedPartitionDescriptionName("FixedPartitionDescription." + str);
        }
        if ((i = tab.getInteger(key = PartitionPrms.localMaxMemory, tab.getWild(key, index, null))) != null) {
            pd.setLocalMaxMemory(i);
        }
        if ((strs = tab.vecAtWild(key = PartitionPrms.partitionListeners, index, null)) != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str2 = tab.getString(key, i2.next());
                if (str2 != null && !str2.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                pd.setPartitionListeners(new ArrayList(strs));
            }
        }
        if ((str = tab.getString(key = PartitionPrms.partitionResolver, tab.getWild(key, index, null))) != null && !str.equalsIgnoreCase("none")) {
            pd.setPartitionResolver(str);
        }
        if ((l = tab.getLong(key = PartitionPrms.recoveryDelay, tab.getWild(key, index, null))) != null) {
            pd.setRecoveryDelay(l);
        }
        if ((i = tab.getInteger(key = PartitionPrms.redundantCopies, tab.getWild(key, index, null))) != null) {
            pd.setRedundantCopies(i);
        }
        if ((l = tab.getLong(key = PartitionPrms.startupRecoveryDelay, tab.getWild(key, index, null))) != null) {
            pd.setStartupRecoveryDelay(l);
        }
        if ((l = tab.getLong(key = PartitionPrms.totalMaxMemory, tab.getWild(key, index, null))) != null) {
            pd.setTotalMaxMemory(l);
        }
        if ((i = tab.getInteger(key = PartitionPrms.totalNumBuckets, tab.getWild(key, index, null))) != null) {
            pd.setTotalNumBuckets(i);
        }
        return pd;
    }

    private static PartitionAttributes createPartitionAttributes(PartitionDescription pd) {
        PartitionAttributesFactory f = new PartitionAttributesFactory();
        if (pd.localMaxMemory != null) {
            f.setLocalMaxMemory(pd.getLocalMaxMemory().intValue());
        }
        if (pd.recoveryDelay != null) {
            f.setRecoveryDelay(pd.getRecoveryDelay().longValue());
        }
        if (pd.redundantCopies != null) {
            f.setRedundantCopies(pd.getRedundantCopies().intValue());
        }
        if (pd.startupRecoveryDelay != null) {
            f.setStartupRecoveryDelay(pd.getStartupRecoveryDelay().longValue());
        }
        if (pd.totalMaxMemory != null) {
            f.setTotalMaxMemory(pd.getTotalMaxMemory().longValue());
        }
        if (pd.totalNumBuckets != null) {
            f.setTotalNumBuckets(pd.getTotalNumBuckets().intValue());
        }
        return f.create();
    }

    private static void resetPartitionDescription(PartitionDescription pd, PartitionAttributes pa) {
        if (pd.getLocalMaxMemory() != null) {
            pd.setLocalMaxMemory(new Integer(pa.getLocalMaxMemory()));
        }
        pd.setRecoveryDelay(new Long(pa.getRecoveryDelay()));
        pd.setRedundantCopies(new Integer(pa.getRedundantCopies()));
        pd.setStartupRecoveryDelay(new Long(pa.getStartupRecoveryDelay()));
        pd.setTotalMaxMemory(new Long(pa.getTotalMaxMemory()));
        pd.setTotalNumBuckets(new Integer(pa.getTotalNumBuckets()));
    }

    private List<PartitionListener> createPartitionListenerInstances() {
        ArrayList<PartitionListener> l = new ArrayList<PartitionListener>();
        for (String classname : this.getPartitionListeners()) {
            l.add(this.createPartitionListenerInstance(classname));
        }
        return l;
    }

    private PartitionListener createPartitionListenerInstance(String classname) {
        Long key = PartitionPrms.partitionListeners;
        Object obj = PartitionDescription.getInstance(key, classname);
        try {
            Log.getLogWriter().info("Instantiated  " + obj);
            return (PartitionListener)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement PartitionListener: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static FixedPartitionDescription getFixedPartitionDescription(String str, Long key, TestConfig config) {
        FixedPartitionDescription fpd = config.getFixedPartitionDescription(str);
        if (fpd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(FixedPartitionPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return fpd;
    }

    private PartitionResolver createPartitionResolverInstance() {
        Long key = PartitionPrms.partitionResolver;
        String classname = this.getPartitionResolver();
        Object obj = PartitionDescription.getInstance(key, classname);
        try {
            Log.getLogWriter().info("Instantiated  " + obj);
            return (PartitionResolver)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement PartitionResolver: " + classname;
            throw new HydraConfigException(s);
        }
    }
}

