/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.AgentBlackboard;
import hydra.BasePrms;
import hydra.BridgeBlackboard;
import hydra.ClientMgr;
import hydra.ClientNameLockStepTaskScheduler;
import hydra.ClientNameTaskScheduler;
import hydra.ComplexConcurrentTaskScheduler;
import hydra.ComplexRoundRobinTaskScheduler;
import hydra.ComplexSerialTaskScheduler;
import hydra.ComplexTaskScheduler;
import hydra.ConfigHashtable;
import hydra.ConfigParser;
import hydra.DerbyServerMgr;
import hydra.DistributedSystemBlackboard;
import hydra.FileUtil;
import hydra.GFMonMgr;
import hydra.GatewayHubBlackboard;
import hydra.GemFireLocatorAgentMgr;
import hydra.HostAgentMgr;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterDescription;
import hydra.MasterProxy;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.Nuker;
import hydra.Platform;
import hydra.PortHelper;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RMIHydraSocketFactory;
import hydra.ResultLogger;
import hydra.RmiRegistryHelper;
import hydra.SimpleConcurrentTaskScheduler;
import hydra.SimpleSerialTaskScheduler;
import hydra.SimpleTaskScheduler;
import hydra.StatMonitor;
import hydra.TestConfig;
import hydra.TestFileUtil;
import hydra.log.LogPrms;
import hydra.timeserver.TimeServer;
import hydra.timeserver.TimeServerMgr;
import hydra.timeserver.TimeServerPrms;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.List;
import java.util.Vector;
import perffmwk.PerfReportPrms;
import perffmwk.RemotePerfStatMgrImpl;

public class MasterController {
    public static final String RMI_NAME = "master";
    public static final String RMI_HOST_PROPERTY = "rmiHost";
    public static final String RMI_PORT_PROPERTY = "rmiPort";
    public static LogWriter log;
    private static final boolean parseOnly;

    public static void sleepForMs(int msToSleep) {
        if (msToSleep != 0) {
            try {
                Thread.sleep(msToSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected static String getNameFor(int vmid, int tid, String clientName, String host, int pid) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(vmid);
        if (tid >= 0) {
            buf.append("_thr_").append(tid);
        }
        buf.append("_").append(clientName).append("_").append(host);
        if (pid >= 0) {
            buf.append("_").append(pid);
        }
        return buf.toString();
    }

    private static ConfigHashtable tab() {
        return TestConfig.getInstance().getParameters();
    }

    public static synchronized Object invoke(String classname, String methodname) {
        MethExecutorResult result = MethExecutor.executeInstance(classname, methodname);
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        return result.getResult();
    }

    public static synchronized Object invoke(String classname, String methodname, Class[] types, Object[] args) {
        log.info("Invoking " + classname + "." + methodname);
        MethExecutorResult result = MethExecutor.executeInstance(classname, methodname, types, args);
        if (result.getStackTrace() != null) {
            throw new HydraRuntimeException(result.toString());
        }
        return result.getResult();
    }

    private static boolean doUnitTests() {
        TestConfig tc = TestConfig.getInstance();
        Vector inittasks = tc.getInitTasks();
        SimpleConcurrentTaskScheduler ts = new SimpleConcurrentTaskScheduler("UnitTests", inittasks, null);
        ts.createClients(tc.getClientDescriptions(), tc.getThreadGroups());
        ts.startClients();
        boolean passed = ts.executeTasks(MasterController.tab().booleanAt(Prms.haltIfBadResult), MasterController.tab().longAt(Prms.maxResultWaitSec));
        ts.stopClients();
        ts.printReport();
        return passed;
    }

    private static boolean doStartTasks() {
        TestConfig tc = TestConfig.getInstance();
        Vector starttasks = tc.getStartTasks();
        if (starttasks == null) {
            return true;
        }
        boolean passed = false;
        ClientNameTaskScheduler ts = MasterController.tab().booleanAt(Prms.doStartAndEndTasksLockStep) ? new ClientNameLockStepTaskScheduler("StartTasks", starttasks, "start") : new ClientNameTaskScheduler("StartTasks", starttasks, "start");
        ts.createClients(tc.getClientDescriptions(), null);
        ts.startClients();
        passed = ts.executeTasks(MasterController.tab().booleanAt(Prms.haltIfBadResult), MasterController.tab().longAt(Prms.maxResultWaitSec));
        ts.stopClients();
        ts.printReport();
        return passed;
    }

    private static boolean doInitTasks() {
        TestConfig tc = TestConfig.getInstance();
        Vector inittasks = tc.getInitTasks();
        if (inittasks == null) {
            return true;
        }
        boolean serial = MasterController.tab().booleanAt(Prms.doInitTasksSequentially);
        SimpleTaskScheduler ts = null;
        ts = serial ? new SimpleSerialTaskScheduler("InitTasks", inittasks, null) : new SimpleConcurrentTaskScheduler("InitTasks", inittasks, null);
        ts.createClients(tc.getClientDescriptions(), tc.getThreadGroups());
        ts.startClients();
        boolean passed = ts.executeTasks(MasterController.tab().booleanAt(Prms.haltIfBadResult), MasterController.tab().longAt(Prms.maxResultWaitSec));
        if (tc.getTasks() == null && tc.getCloseTasks() == null || !passed) {
            ts.stopClients();
        }
        ts.printReport();
        return passed;
    }

    private static boolean doTasks() {
        TestConfig tc = TestConfig.getInstance();
        Vector tasks = tc.getTasks();
        if (tasks == null) {
            return true;
        }
        boolean roundRobin = MasterController.tab().booleanAt(Prms.roundRobin);
        boolean serialExecution = MasterController.tab().booleanAt(Prms.serialExecution);
        long secs = MasterController.tab().longAt(Prms.totalTaskTimeSec);
        ComplexTaskScheduler ts = null;
        ts = roundRobin ? new ComplexRoundRobinTaskScheduler("Tasks", tasks, null, secs) : (serialExecution ? new ComplexSerialTaskScheduler("Tasks", tasks, null, secs) : new ComplexConcurrentTaskScheduler("Tasks", tasks, null, secs));
        if (tc.getInitTasks() == null) {
            ts.createClients(tc.getClientDescriptions(), tc.getThreadGroups());
            ts.startClients();
        }
        boolean passed = ts.executeTasks(MasterController.tab().booleanAt(Prms.haltIfBadResult), MasterController.tab().longAt(Prms.maxResultWaitSec));
        if (tc.getCloseTasks() == null || !passed) {
            ts.stopClients();
        }
        ts.printReport();
        return passed;
    }

    private static boolean doCloseTasks() {
        TestConfig tc = TestConfig.getInstance();
        Vector closetasks = tc.getCloseTasks();
        if (closetasks == null) {
            return true;
        }
        SimpleConcurrentTaskScheduler ts = new SimpleConcurrentTaskScheduler("CloseTasks", closetasks, null);
        if (tc.getInitTasks() == null && tc.getTasks() == null) {
            ts.createClients(tc.getClientDescriptions(), tc.getThreadGroups());
            ts.startClients();
        }
        long waitSec = MasterController.tab().longAt(Prms.maxCloseTaskResultWaitSec, MasterController.tab().longAt(Prms.maxResultWaitSec));
        boolean passed = ts.executeTasks(MasterController.tab().booleanAt(Prms.haltIfBadResult), waitSec);
        ts.stopClients();
        ts.printReport();
        return passed;
    }

    private static boolean doEndTasks() {
        return MasterController.doEndTasks(false);
    }

    private static boolean doEndTasksForced() {
        if (ResultLogger.hasHangFile()) {
            log.severe("Hang detected: dumping stacks before starting ENDTASKs");
            MasterController.dumpStacks(2);
        }
        return MasterController.doEndTasks(true);
    }

    private static boolean doEndTasks(boolean forced) {
        TestConfig tc = TestConfig.getInstance();
        Vector endtasks = tc.getEndTasks();
        if (endtasks == null) {
            return true;
        }
        ClientNameTaskScheduler ts = MasterController.tab().booleanAt(Prms.doStartAndEndTasksLockStep) ? new ClientNameLockStepTaskScheduler("EndTasks", endtasks, "end") : new ClientNameTaskScheduler("EndTasks", endtasks, "end");
        ts.createClients(tc.getClientDescriptions(), null);
        if (forced) {
            ts.startClientsForced();
        } else {
            ts.startClients();
        }
        boolean halt = MasterController.tab().booleanAt(Prms.haltIfBadResult);
        long waitSec = MasterController.tab().longAt(Prms.maxEndTaskResultWaitSec, MasterController.tab().longAt(Prms.maxResultWaitSec));
        boolean passed = ts.executeTasks(halt, waitSec);
        ts.stopClients();
        ts.printReport();
        return passed;
    }

    private static boolean doUnitTestLoop() {
        try {
            return MasterController.doUnitTests();
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            ResultLogger.reportAsErr("MasterController.doUnitTestLoop", t);
            return false;
        }
    }

    private static boolean doTaskLoop() {
        try {
            if (!MasterController.doStartTasks()) {
                MasterController.wrapup();
                return false;
            }
            MasterController.clearEndpointBlackboards();
            if (!MasterController.doInitTasks()) {
                MasterController.wrapup();
                return false;
            }
            if (!MasterController.doTasks()) {
                MasterController.wrapup();
                return false;
            }
            if (!MasterController.doCloseTasks()) {
                MasterController.wrapup();
                return false;
            }
            MasterController.clearEndpointBlackboards();
            if (!MasterController.doEndTasks()) {
                return false;
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            ResultLogger.reportAsHang("MasterController.doTaskLoop", t);
            MasterController.wrapup();
            return false;
        }
        return true;
    }

    private static void wrapup() {
        if (MasterController.tab().booleanAt(Prms.alwaysDoEndTasks)) {
            MasterController.clearEndpointBlackboards();
            MasterController.doEndTasksForced();
        }
    }

    private static void clearEndpointBlackboards() {
        log.info("Clearing endpoint blackboards");
        AgentBlackboard.getInstance().getSharedMap().clear();
        BridgeBlackboard.getInstance().getSharedMap().clear();
        if (!TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            DistributedSystemBlackboard.getInstance().getSharedMap().clear();
        }
        GatewayHubBlackboard.getInstance().getSharedMap().clear();
        log.info("Cleared endpoint blackboards");
    }

    private static boolean runtest() {
        String masterUserDir;
        boolean passed;
        RemotePerfStatMgrImpl report;
        TestConfig tc;
        block67: {
            MasterProxy master;
            log.info("Starting hydra master controller.");
            log.info(ProcessMgr.processAndBuildInfoString());
            String configFileName = System.getProperty("configFileName");
            if (configFileName == null) {
                throw new HydraConfigException("Failed to specify configFileName");
            }
            TestConfig tcTmp = TestConfig.create();
            MasterDescription.configure(tcTmp);
            log.info("Pre-parsing hydra configuration file: " + configFileName + "...");
            try {
                ConfigParser.parseFile(configFileName, tcTmp, null);
            }
            catch (FileNotFoundException e) {
                throw new HydraConfigException("Hydra configuration file not found: " + configFileName, e);
            }
            long randomSeed = tcTmp.getRandomSeed();
            if (randomSeed == -1L) {
                randomSeed = tcTmp.generateRandomSeed();
            }
            ConfigParser.reset();
            tcTmp.destroy();
            tc = TestConfig.create();
            tc.setRandomSeed(randomSeed);
            MasterDescription.configure(tc);
            HostDescription mhd = tc.getMasterDescription().getVmDescription().getHostDescription();
            Nuker.initialize(mhd);
            Nuker.getInstance().recordPID(mhd, ProcessMgr.getProcessId());
            log.info("Parsing hydra configuration file: " + configFileName + "...");
            try {
                ConfigParser.parseFile(configFileName, tc, "latest.conf");
            }
            catch (FileNotFoundException e) {
                throw new HydraConfigException("Hydra configuration file not found: " + configFileName, e);
            }
            if (tc.getRandomSeed() != randomSeed) {
                String s = "A randomInclude file sets " + BasePrms.nameForKey(Prms.randomSeed) + "=" + tc.getRandomSeed() + ". This is not allowed.";
                throw new HydraConfigException(s);
            }
            String onlyOnPlatforms = tc.getSystemProperty("onlyOnPlatforms");
            if (!HostHelper.shouldRun(onlyOnPlatforms)) {
                String s = "Test " + configFileName + " can only run on " + onlyOnPlatforms + " and this platform is " + System.getProperty("os.name");
                throw new HydraConfigException(s);
            }
            if (TestConfig.tab().booleanAt(Prms.useFixedRandomInMaster, false)) {
                System.setProperty("hydra.useFixedRandomInMaster", "true");
            }
            if (TestConfig.tab().booleanAt(Prms.useIPv6, false)) {
                System.setProperty("java.net.preferIPv6Addresses", "true");
            }
            Log.setLogWriterLevel(MasterController.tab().stringAt(LogPrms.file_logLevel));
            tc.configure();
            String testDir = mhd.getTestDir();
            if (configFileName.startsWith(testDir)) {
                tc.setTestName(configFileName.substring(testDir.length() + 1));
            } else {
                tc.setTestName(configFileName);
            }
            tc.setTestUser(System.getProperty("user.name"));
            if (!parseOnly && TimeServerPrms.clockSkewThresholdMs() > 0L) {
                try {
                    Platform.getInstance().restartNTP();
                }
                catch (VirtualMachineError e) {
                    throw e;
                }
                catch (Throwable t) {
                    log.warning("Problem restarting NTP\n", t);
                }
            }
            if (!(parseOnly || TimeServerPrms.clockSkewThresholdMs() <= 0L && TimeServerPrms.clockSkewUpdateFrequencyMs() <= 0)) {
                TimeServer timeServer = TimeServerMgr.startTimeServer();
                tc.getMasterDescription().setTimeServerHost(timeServer.getHost());
                tc.getMasterDescription().setTimeServerPort(timeServer.getPort());
            }
            tc.postprocess();
            Registry registry = null;
            if (!parseOnly) {
                int port = PortHelper.getRandomPort();
                registry = RmiRegistryHelper.startRegistry(RMI_NAME, port);
                System.setProperty(RMI_HOST_PROPERTY, mhd.getHostName());
                System.setProperty(RMI_PORT_PROPERTY, String.valueOf(port));
            }
            if (tc.getClassNames("hydra.gemfirexd") == null) {
                tc.share();
            }
            if (tc.getClassNames("hydra.gemfirexd") != null) {
                Class[] cargs = new Class[]{TestConfig.class};
                Object[] oargs = new Object[]{tc};
                MasterController.invoke("hydra.gemfirexd.GfxdTestConfig", "configure", cargs, oargs);
            }
            log.info("Parsed the hydra configuration file.");
            if (parseOnly) {
                return true;
            }
            log.info("Creating the master proxy");
            try {
                master = new MasterProxy();
            }
            catch (RemoteException e) {
                throw new HydraRuntimeException("MasterProxy could not be created", e);
            }
            log.info("Registering the master");
            RmiRegistryHelper.bind(registry, RMI_NAME, master);
            log.info("Creating the remote performance report");
            try {
                report = new RemotePerfStatMgrImpl();
            }
            catch (RemoteException e) {
                throw new HydraRuntimeException("Could not create remote performance report", e);
            }
            log.info("Registering the performance report");
            RmiRegistryHelper.bind(registry, "RemotePerfStatMgr", report);
            try {
                GFMonMgr.start();
                if (tc.getHostAgentDescriptions().size() > 0) {
                    HostAgentMgr.startHostAgents(tc.getHostAgentDescriptions());
                }
                if (MasterController.tab().booleanAt(Prms.manageLocatorAgents)) {
                    GemFireLocatorAgentMgr.startLocatorAgents();
                }
                if (MasterController.tab().booleanAt(Prms.manageDerbyServer)) {
                    DerbyServerMgr.startDerbyServer();
                }
            }
            catch (HydraRuntimeException e) {
                ResultLogger.reportAsHang("Problem with resource startup", (Throwable)((Object)e));
                throw e;
            }
            catch (HydraTimeoutException e) {
                ResultLogger.reportAsHang("Problem with resource startup", (Throwable)((Object)e));
                throw e;
            }
            StatMonitor.start(mhd, master, tc);
            log.info("Switching to taskmaster log...");
            Log.cacheLogWriter();
            log = Log.createLogWriter("taskmasterloop", "taskmaster_" + ProcessMgr.getProcessId(), MasterController.tab().booleanAt(LogPrms.file_logging), MasterController.tab().stringAt(LogPrms.file_logLevel), MasterController.tab().intAt(LogPrms.file_maxKBPerVM));
            passed = false;
            if (tc.getUnitTests() == null) {
                log.info("=========== START TEST ===========");
                try {
                    passed = MasterController.doTaskLoop();
                }
                catch (VirtualMachineError e) {
                    throw e;
                }
                catch (Throwable t) {
                    passed = false;
                    ResultLogger.reportAsErr("MasterController.doTaskLoop", t);
                }
                log.info("============ END TEST ============");
            } else {
                log.info("=========== START UNIT TESTS ===========");
                try {
                    passed = MasterController.doUnitTestLoop();
                }
                catch (VirtualMachineError e) {
                    throw e;
                }
                catch (Throwable t) {
                    passed = false;
                    ResultLogger.reportAsErr("MasterController.doUnitTestLoop", t);
                }
                log.info("============ END UNIT TESTS ============");
            }
            try {
                Log.closeLogWriter();
                log = Log.uncacheLogWriter(tc.getMasterDescription().getName());
                log.info("...switching back to regular log");
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                passed = false;
                ResultLogger.reportAsErr("MasterController.runtest", t);
            }
            StatMonitor.stop();
            int sleepBeforeShutdownSec = MasterController.tab().intAt(Prms.sleepBeforeShutdownSec);
            if (sleepBeforeShutdownSec > 0) {
                log.info("Sleeping " + sleepBeforeShutdownSec + " seconds before shutting down test");
                MasterController.sleepForMs(1000 * sleepBeforeShutdownSec);
            }
            try {
                GFMonMgr.waitForStop();
            }
            catch (HydraTimeoutException e) {
                passed = false;
                ResultLogger.reportAsHang("Problem with WindowTester/GFMon shutdown", (Throwable)((Object)e));
                MasterController.dumpStacks(2);
            }
            if (ResultLogger.hasErrorFile()) {
                passed = false;
            }
            if (MasterController.tab().booleanAt(Prms.manageDerbyServer)) {
                DerbyServerMgr.stopDerbyServer();
            }
            masterUserDir = System.getProperty("user.dir");
            List<String> sysdirs = TestFileUtil.getSystemDirectoriesAsList(masterUserDir);
            if (ResultLogger.hasHangFile()) {
                passed = false;
                MasterController.dumpStacks(2);
                if (sysdirs != null) {
                    log.severe("Leaving system resources running");
                    if (MasterController.tab().booleanAt(Prms.removeDiskFilesAfterTest, false)) {
                        try {
                            log.severe("Removing disk files...");
                            TestFileUtil.removeDiskFilesAfterTest();
                        }
                        catch (HydraRuntimeException e) {
                            passed = false;
                            ResultLogger.reportAsHang("Problem processing hang", (Throwable)((Object)e));
                        }
                    }
                }
            } else if (sysdirs != null) {
                try {
                    if (!MasterController.tab().booleanAt(Prms.stopSystemsOnError) && ResultLogger.hasErrorFile()) {
                        passed = false;
                        ResultLogger.reportAsHang("Leaving system resources running on test error, as requested", null);
                    } else {
                        try {
                            if (MasterController.tab().booleanAt(Prms.manageLocatorAgents)) {
                                GemFireLocatorAgentMgr.stopLocatorAgentsAfterTest();
                            }
                        }
                        catch (HydraTimeoutException e) {
                            passed = false;
                            ResultLogger.reportAsHang("Problem with resource shutdown", (Throwable)((Object)e));
                            MasterController.dumpStacks(2);
                        }
                    }
                    if (MasterController.tab().booleanAt(Prms.removeDiskFilesAfterTest, false)) {
                        log.severe("Removing disk files...");
                        TestFileUtil.removeDiskFilesAfterTest();
                    }
                }
                catch (HydraRuntimeException e) {
                    passed = false;
                    ResultLogger.reportAsHang("Problem processing test error, leaving systems in current state", (Throwable)((Object)e));
                    if (!MasterController.tab().booleanAt(Prms.removeDiskFilesAfterTest, false)) break block67;
                    log.severe("Removing disk files...");
                    TestFileUtil.removeDiskFilesAfterTest();
                }
            }
        }
        if (TestFileUtil.getStatisticArchivesAsList(masterUserDir) != null) {
            log.info("Generating trim specifications file");
            report.generateTrimSpecificationsFile();
            log.info("Generating statistics specifications file");
            report.generateStatisticsSpecificationsFile();
            if (MasterController.tab().booleanAt(PerfReportPrms.generatePerformanceReport)) {
                log.info("Generating performance report");
                ResultLogger.generatePerformanceReportFile();
            } else {
                log.info("Skipping performance report");
            }
        } else {
            log.info("Skipping performance report since there are no archives");
        }
        if (tc.getHostAgentDescriptions().size() != 0) {
            HostAgentMgr.shutDownAllHostAgents();
        }
        return passed;
    }

    private static void terminate(String msg, boolean passed) {
        ResultLogger.logFinalOutcome(msg, passed);
        ResultLogger.mergeLogFiles(passed);
        FileUtil.deleteFile("in_progress.txt");
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        Nuker.getInstance().removePID(hd, ProcessMgr.getProcessId());
        if (passed) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    protected static void dumpStacksOnError(int times) {
        if (MasterController.tab().booleanAt(Prms.dumpStacksOnError)) {
            MasterController.dumpStacks(times);
        }
    }

    protected static void dumpStacks(int times) {
        for (int i = 0; i < times; ++i) {
            log.severe("Doing stack dump on all processes");
            MasterController.dumpStacks();
            if (times <= 1) continue;
            log.severe("Sleeping 5 seconds between stack dumps");
            MasterController.sleepForMs(5000);
        }
    }

    protected static void dumpStacks() {
        TestConfig tc = TestConfig.getInstance();
        log.severe("Doing stack dump on all clients (and master)");
        ClientMgr.printProcessStacks();
        if (tc.getGemFireDescriptions().size() != 0 && MasterController.tab().booleanAt(Prms.manageLocatorAgents)) {
            log.severe("Doing stack dump on all locators");
            GemFireLocatorAgentMgr.printProcessStacks();
        }
    }

    public static void main(String[] ignore) {
        try {
            FileUtil.appendToFile("in_master.txt", "Successfully spawned hydra.MasterController...\n");
            FileUtil.appendToFile("in_progress.txt", "hydra.MasterController in action...\n");
            int pid = ProcessMgr.getProcessId();
            Thread.currentThread().setName("master_" + pid);
            log = Log.createLogWriter(RMI_NAME, "Master_" + pid, "all", false);
            boolean passed = MasterController.runtest();
            if (passed) {
                String msg = "This concludes your test run.  On behalf of everyone in the GemStone Systems QA department, I'd like to thank you for using the hydra test harness.  Have a pleasant day.";
                MasterController.terminate(msg, passed);
            } else {
                String msg = "This concludes your test run.  I'm sorry to report that the test found errors. Look for details in the test and system logs.  Better luck next time.";
                MasterController.terminate(msg, passed);
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            ResultLogger.reportAsErr("MasterController.main", t);
            String msg = "This concludes your test run.  The test harness encountered an unexpected exception.  Look for details in the test and system logs.  Better luck next time.";
            MasterController.terminate(msg, false);
        }
    }

    static {
        try {
            RMISocketFactory.setSocketFactory(new RMIHydraSocketFactory());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        parseOnly = Boolean.getBoolean("parseOnly");
    }
}

