/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.JProbePrms;
import hydra.PortHelper;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class JProbeDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private String function;
    private String measurement;
    private Vector filters;
    private Vector triggers;
    private boolean useDeepTraces;
    private boolean recordFromStart;
    private boolean finalSnapshot;
    private boolean monitor;
    private boolean garbageKeep;
    private boolean trackObjects;
    private int port;

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getFunction() {
        return this.function;
    }

    private void setFunction(String function) {
        this.function = function;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    private void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public Vector getFilters() {
        return this.filters;
    }

    private void setFilters(Vector filters) {
        this.filters = filters;
    }

    private String getFilterStr() {
        Vector filters = this.getFilters();
        String filterStr = null;
        for (int i = 0; i < filters.size(); ++i) {
            String filter = (String)filters.elementAt(i);
            if (i == 0) {
                filterStr = "";
            }
            filterStr = filterStr + filter;
            if (i >= filters.size() - 1) continue;
            filterStr = filterStr + ",";
        }
        return filterStr;
    }

    public Vector getTriggers() {
        return this.triggers;
    }

    private void setTriggers(Vector triggers) {
        this.triggers = triggers;
    }

    private String getTriggerStr() {
        Vector triggers = this.getTriggers();
        String triggerStr = null;
        for (int i = 0; i < triggers.size(); ++i) {
            String trigger = (String)triggers.elementAt(i);
            if (i == 0) {
                triggerStr = "";
            }
            triggerStr = triggerStr + trigger;
            if (i >= triggers.size() - 1) continue;
            triggerStr = triggerStr + ",";
        }
        return triggerStr;
    }

    public boolean useDeepTraces() {
        return this.useDeepTraces;
    }

    private void useDeepTraces(boolean useDeepTraces) {
        this.useDeepTraces = useDeepTraces;
    }

    public boolean getRecordFromStart() {
        return this.recordFromStart;
    }

    private void setRecordFromStart(boolean recordFromStart) {
        this.recordFromStart = recordFromStart;
    }

    public boolean getFinalSnapshot() {
        return this.finalSnapshot;
    }

    private void setFinalSnapshot(boolean finalSnapshot) {
        this.finalSnapshot = finalSnapshot;
    }

    public boolean getTrackObjects() {
        return this.trackObjects;
    }

    private void setTrackObjects(boolean trackObjects) {
        this.trackObjects = trackObjects;
    }

    public boolean getMonitor() {
        return this.monitor;
    }

    private void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public boolean getGarbageKeep() {
        return this.garbageKeep;
    }

    private void setGarbageKeep(boolean garbageKeep) {
        this.garbageKeep = garbageKeep;
    }

    public int getPort() {
        return this.port;
    }

    private void setPort(int port) {
        this.port = port;
    }

    public String getCommandLine(String jprobeHome, String vmType) {
        String cmd = this.getExecutable(jprobeHome) + " ";
        Vector prms = this.getCommandLineParameters(vmType);
        for (int i = 0; i < prms.size(); ++i) {
            cmd = cmd + prms.elementAt(i) + " ";
        }
        return cmd;
    }

    public String getExecutable(String jprobeHome) {
        if (jprobeHome == null) {
            throw new HydraConfigException("Unable to build executable for JProbe description " + this.getName() + " because JPROBE is not set");
        }
        return jprobeHome + "/bin/jplauncher";
    }

    public Vector getCommandLineParameters(String vmType) {
        String trigger;
        String filter;
        Vector<String> prms = new Vector<String>();
        if (vmType != null) {
            prms.add("-" + vmType);
        }
        prms.add("-jp_java=" + System.getProperty("java.home") + "/bin/java");
        prms.add("-jp_function=" + this.getFunction());
        prms.add("-jp_snapshot_dir=" + System.getProperty("user.dir"));
        if (this.getFunction().equals("performance")) {
            prms.add("-jp_measurement=" + this.getMeasurement());
        }
        if (this.getMonitor()) {
            prms.add("-jp_socket=:" + this.getPort());
        }
        if ((filter = this.getFilterStr()) != null && !this.getFunction().equals("memory")) {
            prms.add("-jp_collect_data=" + filter);
        }
        if ((trigger = this.getTriggerStr()) != null) {
            prms.add("-jp_trigger=" + trigger);
        }
        return prms;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "port", String.valueOf(this.getPort()));
        map.put(header + "function", this.getFunction());
        map.put(header + "measurement", this.getMeasurement());
        map.put(header + "filters", this.getFilters());
        map.put(header + "triggers", this.getTriggers());
        map.put(header + "useDeepTraces", String.valueOf(this.useDeepTraces()));
        map.put(header + "garbageKeep", String.valueOf(this.getGarbageKeep()));
        map.put(header + "recordFromStart", String.valueOf(this.getRecordFromStart()));
        map.put(header + "finalSnapshot", String.valueOf(this.getFinalSnapshot()));
        map.put(header + "trackObjects", String.valueOf(this.getTrackObjects()));
        map.put(header + "monitor", String.valueOf(this.getMonitor()));
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(JProbePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            JProbeDescription jpd = new JProbeDescription();
            String name = (String)names.elementAt(i);
            jpd.setName(name);
            String function = tab.stringAtWild(JProbePrms.function, i, "performance");
            jpd.setFunction(function);
            String measurement = tab.stringAtWild(JProbePrms.measurement, i, "cpu");
            jpd.setMeasurement(measurement);
            HydraVector filters = tab.vecAtWild(JProbePrms.filters, i, new HydraVector());
            jpd.setFilters(filters);
            HydraVector triggers = tab.vecAtWild(JProbePrms.triggers, i, new HydraVector());
            jpd.setTriggers(triggers);
            boolean useDeepTraces = tab.booleanAtWild(JProbePrms.useDeepTraces, i, Boolean.TRUE);
            jpd.useDeepTraces(useDeepTraces);
            boolean garbageKeep = tab.booleanAtWild(JProbePrms.garbageKeep, i, Boolean.FALSE);
            jpd.setGarbageKeep(garbageKeep);
            boolean recordFromStart = tab.booleanAtWild(JProbePrms.recordFromStart, i, Boolean.TRUE);
            jpd.setRecordFromStart(recordFromStart);
            boolean finalSnapshot = tab.booleanAtWild(JProbePrms.finalSnapshot, i, Boolean.TRUE);
            jpd.setFinalSnapshot(finalSnapshot);
            boolean trackObjects = tab.booleanAtWild(JProbePrms.trackObjects, i, Boolean.TRUE);
            jpd.setTrackObjects(trackObjects);
            boolean monitor = tab.booleanAtWild(JProbePrms.monitor, i, Boolean.FALSE);
            jpd.setMonitor(monitor);
            int port = PortHelper.getRandomPort();
            jpd.setPort(port);
            config.addJProbeDescription(jpd);
        }
    }
}

