/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.HypericServerInstallPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class HypericServerInstallDescription
extends AbstractDescription
implements Serializable {
    private static List<String> hosts = new ArrayList<String>();
    public String name;
    public String hostDescriptionName;
    public HostDescription hostDescription;
    public String buildXmlFile;
    public String releaseNum;
    public String buildVersion;
    public String buildCopyDir;
    public String installDir;
    public String hostOS;
    public String hqServerDb;
    public String oracleDbUrl;
    public String oracleSID;
    public String oracleDbUser;
    public String oracleDbPwd;
    public String oracleAdminUser;
    public String oracleAdminPwd;
    public String mysqlDbUrl;
    public String mysqlDbUser;
    public String mysqlDbPwd;
    public String mysqlAdminUser;
    public String mysqlAdminPwd;
    public String mysqlPort;
    public String agentHost;
    public String agentServerHost;
    public String agentPort;

    @Override
    public SortedMap<String, String> toSortedMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "buildXmlFile", this.buildXmlFile);
        map.put(header + "hostName", this.hostDescriptionName);
        map.put(header + "releaseNum", this.releaseNum);
        map.put(header + "buildVersion", this.buildVersion);
        map.put(header + "buildCopyDir", this.buildCopyDir);
        map.put(header + "installDir", this.installDir);
        map.put(header + "hostOS", this.hostOS);
        map.put(header + "hqServerDb", this.hqServerDb);
        map.put(header + "oracleDbUrl", this.oracleDbUrl);
        map.put(header + "oracleDbUser", this.oracleDbUser);
        map.put(header + "oracleDbPwd", this.oracleDbPwd);
        map.put(header + "oracleAdminUser", this.oracleAdminUser);
        map.put(header + "oracleAdminPwd", this.oracleAdminPwd);
        map.put(header + "agentHost", this.agentHost);
        map.put(header + "agentServerHost", this.agentServerHost);
        map.put(header + "agentPort", this.agentPort);
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(HypericServerInstallPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            HypericServerInstallDescription hqd = HypericServerInstallDescription.createHypericServerInstallDescription(name, config, i, hosts);
            config.addHypericServerInstallDescription(hqd);
        }
    }

    private static HypericServerInstallDescription createHypericServerInstallDescription(String name, TestConfig config, int index, List<String> hosts) {
        ConfigHashtable tab = config.getParameters();
        HypericServerInstallDescription hqd = new HypericServerInstallDescription();
        hqd.setName(name);
        Long key = HypericServerInstallPrms.hostName;
        String hostName = tab.stringAtWild(key, index, null);
        if (hostName == null) {
            String s = "Missing " + BasePrms.nameForKey(key);
            throw new HydraConfigException(s);
        }
        hqd.setHostDescriptionName(hostName);
        HostDescription hd = config.getHostDescription(hostName);
        if (hd == null) {
            String s = "Undefined value in " + BasePrms.nameForKey(key) + ": " + hostName;
            throw new HydraConfigException(s);
        }
        String host = hd.getHostName();
        hqd.setHostDescription(hd);
        hosts.add(host);
        key = HypericServerInstallPrms.buildXmlFile;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null) {
            hqd.setBuildXmlFile(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.releaseNum, tab.getWild(key, index, null))) != null) {
            hqd.setReleaseNum(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.buildVersion, tab.getWild(key, index, null))) != null) {
            hqd.setBuildVersion(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.buildCopyDir, tab.getWild(key, index, null))) != null) {
            hqd.setTmpDir(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.installDir, tab.getWild(key, index, null))) != null) {
            hqd.setInstallDir(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.hostOS, tab.getWild(key, index, null))) != null) {
            hqd.setHostOS(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.hqServerDb, tab.getWild(key, index, null))) != null) {
            hqd.setHQServerDb(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleDbUrl, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUrl(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleSID, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUrl(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleDbUser, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUser(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleDbPwd, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbPwd(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleAdminUser, tab.getWild(key, index, null))) != null) {
            hqd.setOracleAdminUser(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.oracleAdminPwd, tab.getWild(key, index, null))) != null) {
            hqd.setOracleAdminPwd(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlDbUrl, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUrl(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlPort, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUrl(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlDbUser, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbUser(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlDbPwd, tab.getWild(key, index, null))) != null) {
            hqd.setOracleDbPwd(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlAdminUser, tab.getWild(key, index, null))) != null) {
            hqd.setOracleAdminUser(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.mysqlAdminPwd, tab.getWild(key, index, null))) != null) {
            hqd.setOracleAdminPwd(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.agentHost, tab.getWild(key, index, null))) != null) {
            hqd.setAgentHost(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.agentServerHost, tab.getWild(key, index, null))) != null) {
            hqd.setAgentServerHost(str);
        }
        if ((str = tab.getString(key = HypericServerInstallPrms.agentPort, tab.getWild(key, index, null))) != null) {
            hqd.setAgentPort(str);
        }
        return hqd;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setHostDescriptionName(String str) {
        this.hostDescriptionName = str;
    }

    private void setHostDescription(HostDescription hd) {
        this.hostDescription = hd;
    }

    private void setBuildXmlFile(String buildXmlFile) {
        this.buildXmlFile = buildXmlFile;
    }

    private void setReleaseNum(String releaseNum) {
        this.releaseNum = releaseNum;
    }

    private void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    private void setTmpDir(String buildCopyDir) {
        this.buildCopyDir = buildCopyDir;
    }

    private void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    private void setHostOS(String hostOS) {
        this.hostOS = hostOS;
    }

    private void setHQServerDb(String hqServerDb) {
        this.hqServerDb = hqServerDb;
    }

    private void setOracleDbUrl(String oracleDbUrl) {
        this.oracleDbUrl = oracleDbUrl;
    }

    private void setOracleDbUser(String oracleDbUser) {
        this.oracleDbUser = oracleDbUser;
    }

    private void setOracleDbPwd(String oracleDbPwd) {
        this.oracleDbPwd = oracleDbPwd;
    }

    private void setOracleAdminUser(String oracleAdminUser) {
        this.oracleAdminUser = oracleAdminUser;
    }

    private void setOracleAdminPwd(String oracleAdminPwd) {
        this.oracleAdminPwd = oracleAdminPwd;
    }

    private void setAgentHost(String agentHost) {
        this.agentHost = agentHost;
    }

    private void setAgentServerHost(String agentServerHost) {
        this.agentServerHost = agentServerHost;
    }

    private void setAgentPort(String agentPort) {
        this.agentPort = agentPort;
    }
}

