/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.EnvHelper;
import hydra.HostDescription;
import hydra.Prms;
import hydra.ProductVersionHelper;
import hydra.TestConfig;
import hydra.VmDescription;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class HostAgentDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private HostDescription hd;
    private String classPath;
    private String libPath;
    private boolean archiveStats;

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public HostDescription getHostDescription() {
        return this.hd;
    }

    protected void setHostDescription(HostDescription hd) {
        this.hd = hd;
    }

    public String getClassPath() {
        return this.classPath;
    }

    protected void setClassPath(String path) {
        this.classPath = path;
    }

    public String getLibPath() {
        return this.libPath;
    }

    protected void setLibPath(String path) {
        this.libPath = path;
    }

    public boolean getArchiveStats() {
        return this.archiveStats;
    }

    protected void setArchiveStats(boolean b) {
        this.archiveStats = b;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "hostName", this.getHostDescription().getName());
        if (this.getClassPath() != null) {
            map.put(header + "classPath", this.getClassPath());
        }
        if (this.getLibPath() != null) {
            map.put(header + "libPath", this.getLibPath());
        }
        map.put(header + "archiveStats", this.getArchiveStats());
        return map;
    }

    protected static void configure(TestConfig config) {
        for (HostDescription hd : config.getHadoopHostDescriptions().values()) {
            HostAgentDescription.configure(config, hd, true);
        }
        for (HostDescription hd : config.getHostDescriptions().values()) {
            boolean b = config.tab().booleanAt(Prms.archiveStatsForHostAgent, false);
            HostAgentDescription.configure(config, hd, b);
        }
    }

    private static void configure(TestConfig config, HostDescription hd, boolean archive) {
        String name = "hostagent_" + hd.getHostName();
        HostAgentDescription had = config.getHostAgentDescription(name);
        if (had == null) {
            had = new HostAgentDescription();
            had.setName(name);
            had.setHostDescription(hd);
            Vector<String> classPath = new Vector<String>();
            classPath.add(hd.getTestDir());
            if (hd.getExtraTestDir() != null) {
                classPath.add(hd.getExtraTestDir());
            }
            if (hd.getGemFireHome() != null) {
                classPath.add(hd.getGemFireHome() + hd.getFileSep() + "lib" + hd.getFileSep() + "snappydata-store-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + ".jar");
                classPath.add(VmDescription.getAllSnappyJars(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "snappy" + hd.getFileSep() + "jars"));
            }
            classPath.add(hd.getTestDir() + hd.getFileSep() + "junit.jar");
            classPath.add(hd.getTestDir() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "libs" + hd.getFileSep() + "snappydata-store-hydra-tests-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + "-all.jar");
            classPath.add(VmDescription.getSnappyJarPath(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep(), "snappydata-store-scala-tests*tests.jar"));
            had.setClassPath(EnvHelper.asPath(classPath, hd));
            Vector<String> libPath = new Vector<String>();
            if (hd.getGemFireHome() != null) {
                libPath.add(hd.getGemFireHome() + hd.getFileSep() + "lib");
                libPath.add(hd.getGemFireHome() + hd.getFileSep() + ".." + hd.getFileSep() + "hidden" + hd.getFileSep() + "lib");
            }
            had.setLibPath(EnvHelper.asPath(libPath, hd));
            had.setArchiveStats(archive);
            config.addHostAgentDescription(had);
        } else {
            had.getHostDescription().checkEquivalent(hd);
        }
    }
}

