/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.DiskStoreHelper;
import hydra.HDFSStoreDescription;
import hydra.HDFSStorePrms;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;

public class HDFSStoreHelper {
    private static LogWriter log;

    public static synchronized HDFSStore createHDFSStore(String hdfsStoreConfig) {
        HDFSStoreFactory factory = HDFSStoreHelper.getHDFSStoreFactory(hdfsStoreConfig);
        return HDFSStoreHelper.createHDFSStore(hdfsStoreConfig, factory);
    }

    public static synchronized HDFSStore createHDFSStore(String hdfsStoreName, HDFSStoreFactory factory) {
        if (hdfsStoreName == null) {
            throw new IllegalArgumentException("hdfsStoreName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        HDFSStore hdfsStore = CacheHelper.getCache().findHDFSStore(hdfsStoreName);
        if (hdfsStore == null) {
            DiskStore diskStore;
            HDFSStoreHelper.log("Creating HDFS store named: " + hdfsStoreName + " with attributes " + HDFSStoreHelper.hdfsStoreFactoryToString(hdfsStoreName, factory));
            String diskStoreConfig = factory.getHDFSEventQueueAttributes().getDiskStoreName();
            if (diskStoreConfig != null && (diskStore = CacheHelper.getCache().findDiskStore(diskStoreConfig)) == null) {
                DiskStoreHelper.createDiskStore(diskStoreConfig);
            }
            try {
                hdfsStore = factory.create(hdfsStoreName);
            }
            catch (IllegalStateException e) {
                throw new HydraInternalException("Should not happen", e);
            }
            HDFSStoreHelper.log("Created HDFS store named: " + hdfsStoreName);
        } else if (!HDFSStoreDescription.equals(((HDFSStoreFactoryImpl)factory).getConfigView(), hdfsStore)) {
            String desired = HDFSStoreHelper.hdfsStoreFactoryToString(hdfsStoreName, factory);
            String existing = HDFSStoreHelper.hdfsStoreToString(hdfsStore);
            String s = "HDFSStore " + hdfsStoreName + " already exists with different attributes\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
            throw new HydraRuntimeException(s);
        }
        return hdfsStore;
    }

    public static synchronized HDFSStore getHDFSStore(String hdfsStoreName) {
        if (hdfsStoreName == null) {
            throw new IllegalArgumentException("hdfsStoreName cannot be null");
        }
        return CacheHelper.getCache().findHDFSStore(hdfsStoreName);
    }

    public static String hdfsStoreToString(HDFSStore hdfsStore) {
        if (hdfsStore == null) {
            throw new IllegalArgumentException("HDFS store cannot be null");
        }
        return HDFSStoreDescription.hdfsStoreToString(hdfsStore);
    }

    public static HDFSStoreFactory getHDFSStoreFactory(String hdfsStoreConfig) {
        HDFSStoreDescription hsd = HDFSStoreHelper.getHDFSStoreDescription(hdfsStoreConfig);
        HDFSStoreFactory factory = CacheHelper.getCache().createHDFSStoreFactory();
        HDFSStoreHelper.log("Configuring HDFS store factory for config: " + hdfsStoreConfig);
        hsd.configure(factory);
        HDFSStoreHelper.log("Configured HDFS store factory: " + factory);
        return factory;
    }

    private static String hdfsStoreFactoryToString(String hdfsStoreName, HDFSStoreFactory factory) {
        if (hdfsStoreName == null) {
            throw new IllegalArgumentException("hdfsStoreName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        HDFSStore store = ((HDFSStoreFactoryImpl)factory).getConfigView();
        return HDFSStoreDescription.hdfsStoreToString(hdfsStoreName, store);
    }

    public static HDFSStoreDescription getHDFSStoreDescription(String hdfsStoreConfig) {
        if (hdfsStoreConfig == null) {
            throw new IllegalArgumentException("hdfsStoreConfig cannot be null");
        }
        HDFSStoreHelper.log("Looking up HDFS store config: " + hdfsStoreConfig);
        HDFSStoreDescription hsd = TestConfig.getInstance().getHDFSStoreDescription(hdfsStoreConfig);
        if (hsd == null) {
            String s = hdfsStoreConfig + " not found in " + BasePrms.nameForKey(HDFSStorePrms.names);
            throw new HydraRuntimeException(s);
        }
        HDFSStoreHelper.log("Looked up HDFS store config:\n" + hsd);
        return hsd;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

