/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import hydra.GemFireDescription;
import hydra.GemFireDistributionLocator;
import hydra.GemFireLocatorAgentIF;
import hydra.GemFireLocatorAgentRecord;
import hydra.GemFireVersionHelper;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterProxyIF;
import hydra.ProcessMgr;
import hydra.RmiRegistryHelper;
import hydra.TestConfig;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import util.TestHelper;

public class GemFireLocatorAgent
extends UnicastRemoteObject
implements GemFireLocatorAgentIF,
Runnable {
    public static final String LOCATOR_LOG_FILE_PREFIX = "locator_";
    public static boolean MasterManagedLocator = false;
    private static int MyPort = -1;
    private static String MyHost = null;
    private static int MyPid = -1;
    private static String MyDistributedSystem = null;
    private static String MyThreadName = null;
    private static String MySysDirName = null;
    public static MasterProxyIF Master = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(MyThreadName);
        GemFireLocatorAgentRecord lar = new GemFireLocatorAgentRecord();
        lar.setDistributedSystem(MyDistributedSystem);
        lar.setGemFireLocatorAgent(this);
        GemFireDescription gfd2 = null;
        Map<String, GemFireDescription> gfds = TestConfig.getInstance().getGemFireDescriptions();
        for (GemFireDescription gfd2 : gfds.values()) {
            if (gfd2.getDistributedSystem().equals(MyDistributedSystem)) break;
        }
        try {
            Properties props = gfd2.getDistributedSystemProperties();
            GemFireVersionHelper.setDistributedSystemId(props, gfd2.getDistributedSystemId());
            String addr = HostHelper.getHostAddress();
            if (Boolean.getBoolean("java.net.preferIPv6Addresses")) {
                props.setProperty("bind-address", addr);
                props.setProperty("server-bind-address", addr);
            }
            GemFireDistributionLocator.start(MyDistributedSystem, MyPort, props, gfd2.isServerLocator());
            try {
                Class.forName("com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable").getMethod("initTypes", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            lar.setPort(MyPort);
            lar.setHostName(MyHost);
            lar.setHostAddress(addr);
            lar.setProcessId(MyPid);
            lar.setServerLocator(gfd2.isServerLocator());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            GemFireLocatorAgent.log().severe("Failed to start the GemFireDistributionLocator\n" + TestHelper.getStackTrace(t));
            lar.setProcessId(-1);
        }
        try {
            MasterProxyIF t = Master;
            synchronized (t) {
                Master.registerGemFireLocatorAgent(lar);
            }
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException(MyThreadName + " unable to contact master", e);
        }
    }

    @Override
    public void shutDownGemFireLocatorAgent() throws RemoteException {
        GemFireLocatorAgent.log().info(MyThreadName + " shutting down at master's request.");
        GemFireLocatorAgent.log().info("Now terminating process.");
        HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
        Master.removePID(hd, MyPid);
        System.exit(0);
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    public static void main(String[] args) {
        MasterManagedLocator = true;
        MyHost = HostHelper.getLocalHost();
        MyPid = ProcessMgr.getProcessId();
        MyDistributedSystem = System.getProperty("distributedSystemName");
        MyThreadName = "locatoragent_" + MyDistributedSystem + "_" + MyHost + "_" + MyPid;
        MySysDirName = System.getProperty("user.dir") + File.separator + LOCATOR_LOG_FILE_PREFIX + MyDistributedSystem;
        Thread.currentThread().setName(MyThreadName);
        LogWriter log = Log.createLogWriter(MyThreadName, MyThreadName, "all", System.getProperty("user.dir"), true);
        log.info(ProcessMgr.processAndBuildInfoString());
        if (Master == null) {
            Master = RmiRegistryHelper.lookupMaster();
        }
        MyPort = TestConfig.getInstance().getMasterDescription().getLocatorPort(MyDistributedSystem);
        GemFireLocatorAgent agent = null;
        try {
            agent = new GemFireLocatorAgent();
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Unable to create GemFireLocatorAgent for " + MyDistributedSystem, e);
        }
        Thread t = new Thread(agent);
        t.start();
        try {
            t.join();
            List locators = Locator.getLocators();
            if (locators == null || locators.isEmpty()) {
                log.severe("no locators located");
            } else {
                InternalLocator locator = (InternalLocator)locators.iterator().next();
                locator.waitToStop();
            }
        }
        catch (InterruptedException e) {
            log.info("interrupted");
            return;
        }
    }

    protected static String getSysDirName() {
        return MySysDirName;
    }
}

