/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.LogWriterImpl;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GemFireLocatorAgent;
import hydra.GemFirePrms;
import hydra.GemFireVersionHelper;
import hydra.GsRandom;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.ProductVersionHelper;
import hydra.RemoteTestModule;
import hydra.SSLDescription;
import hydra.SecurityDescription;
import hydra.SecurityPrms;
import hydra.TestConfig;
import hydra.VmDescription;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class GemFireDescription
extends AbstractDescription
implements Serializable {
    private transient String sysDirName;
    private String name;
    private HostDescription hd;
    private boolean stopSystemAfterTest;
    private String distributedSystem;
    private List<String> remoteDistributedSystems;
    private Integer distributedSystemId;
    private String systemDir;
    private String id;
    private String logLevel;
    private Integer logFileSizeLimit;
    private Integer logDiskSpaceLimit;
    private String statisticArchiveFile;
    private Boolean statisticSamplingEnabled;
    private Integer statisticSampleRate;
    private Boolean enableTimeStatistics;
    private Integer archiveFileSizeLimit;
    private Integer archiveDiskSpaceLimit;
    private Integer ackWaitThreshold;
    private Boolean conserveSockets;
    private Boolean deltaPropagation;
    private Long socketLeaseTime;
    private Long socketBufferSize;
    private Integer asyncDistributionTimeout;
    private Integer asyncQueueTimeout;
    private Integer asyncMaxQueueSize;
    private String roles;
    private Integer maxWaitTimeForReconnect;
    private Integer maxNumReconnectTries;
    private Boolean useLocator;
    private Boolean isPeerLocator;
    private Boolean isServerLocator;
    private Boolean enableMcast;
    private String mcastAddress;
    private Integer mcastPort;
    private Integer mcastTtl;
    private Integer mcastSendBufferSize;
    private Integer mcastRecvBufferSize;
    private Integer mcastFlowControlByteAllowance;
    private Float mcastFlowControlRechargeThreshold;
    private Integer mcastFlowControlRechargeBlockMs;
    private Integer udpFragmentSize;
    private Integer udpSendBufferSize;
    private Integer udpRecvBufferSize;
    private Integer tcpPort;
    private Boolean disableTcp;
    private String membershipPortRange;
    private Integer memberTimeout;
    private Boolean enableDurableClient;
    private Integer durableClientTimeout;
    private String conflateEvents;
    private Boolean enforceUniqueHost;
    private String redundancyZone;
    private Integer ackSevereAlertThreshold;
    private Boolean enableNetworkPartitionDetection;
    private Boolean disableAutoReconnect;
    private String extraLocatorVMArgs;
    private String locatorClassPath;
    private Boolean jmxManager;
    private String jmxManagerAccessFile;
    private Boolean jmxManagerHttpPort;
    private String jmxManagerPasswordFile;
    private Boolean jmxManagerPort;
    private Boolean jmxManagerSSL;
    private Boolean jmxManagerStart;
    private String securityName;
    private SecurityDescription securityDescription;
    private String sslName;
    private SSLDescription sslDescription;
    private String offHeapMemorySize;
    private Boolean lockMemory;

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public HostDescription getHostDescription() {
        return this.hd;
    }

    private void setHostDescription(HostDescription hd) {
        this.hd = hd;
    }

    public boolean stopSystemAfterTest() {
        return this.stopSystemAfterTest;
    }

    private void setStopSystemAfterTest(boolean flag) {
        this.stopSystemAfterTest = flag;
    }

    public String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String sys) {
        this.distributedSystem = sys;
    }

    public List<String> getRemoteDistributedSystems() {
        return this.remoteDistributedSystems;
    }

    private void setRemoteDistributedSystems(List<String> systems) {
        this.remoteDistributedSystems = systems;
    }

    public Integer getDistributedSystemId() {
        return this.distributedSystemId;
    }

    private void setDistributedSystemId(Integer i) {
        this.distributedSystemId = i;
    }

    public String getSystemDirectoryStr() {
        return this.systemDir;
    }

    public File getSystemDirectory() {
        return new File(this.systemDir);
    }

    private void setSystemDirectory(String dir) {
        this.systemDir = dir;
    }

    public Integer getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    private void setAckWaitThreshold(Integer threshold) {
        this.ackWaitThreshold = threshold;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    private void setLogLevel(String level) {
        this.logLevel = level;
    }

    public Integer getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    private void setLogFileSizeLimit(Integer limit) {
        this.logFileSizeLimit = limit;
    }

    public Integer getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    private void setLogDiskSpaceLimit(Integer limit) {
        this.logDiskSpaceLimit = limit;
    }

    public String getStatisticArchiveFile() {
        return this.statisticArchiveFile;
    }

    private void setStatisticArchiveFile(String file) {
        this.statisticArchiveFile = file;
    }

    public Boolean getStatisticSamplingEnabled() {
        return this.statisticSamplingEnabled;
    }

    private void setStatisticSamplingEnabled(Boolean flag) {
        this.statisticSamplingEnabled = flag;
    }

    public Integer getStatisticSampleRate() {
        return this.statisticSampleRate;
    }

    private void setStatisticSampleRate(Integer rate) {
        this.statisticSampleRate = rate;
    }

    public Boolean getEnableTimeStatistics() {
        return this.enableTimeStatistics;
    }

    private void setEnableTimeStatistics(Boolean flag) {
        this.enableTimeStatistics = flag;
    }

    public Integer getArchiveFileSizeLimit() {
        return this.archiveFileSizeLimit;
    }

    private void setArchiveFileSizeLimit(Integer limit) {
        this.archiveFileSizeLimit = limit;
    }

    public Integer getArchiveDiskSpaceLimit() {
        return this.archiveDiskSpaceLimit;
    }

    private void setArchiveDiskSpaceLimit(Integer limit) {
        this.archiveDiskSpaceLimit = limit;
    }

    public Boolean getUseLocator() {
        return this.useLocator;
    }

    private void setUseLocator(Boolean flag) {
        this.useLocator = flag;
    }

    public Boolean isPeerLocator() {
        return this.isPeerLocator;
    }

    private void setPeerLocator(Boolean flag) {
        this.isPeerLocator = flag;
    }

    public Boolean isServerLocator() {
        return this.isServerLocator;
    }

    private void setServerLocator(Boolean flag) {
        this.isServerLocator = flag;
    }

    public Boolean getEnableMcast() {
        return this.enableMcast;
    }

    private void setEnableMcast(Boolean flag) {
        this.enableMcast = flag;
    }

    public String getMcastAddress() {
        return this.mcastAddress;
    }

    private void setMcastAddress(String addressStr) {
        this.mcastAddress = addressStr;
    }

    public Integer getMcastPort() {
        return this.mcastPort;
    }

    protected void setMcastPort(Integer port) {
        this.mcastPort = port;
    }

    public Integer getMcastTtl() {
        return this.mcastTtl;
    }

    private void setMcastTtl(Integer Ttl) {
        this.mcastTtl = Ttl;
    }

    public Integer getMcastSendBufferSize() {
        return this.mcastSendBufferSize;
    }

    private void setMcastSendBufferSize(Integer size) {
        this.mcastSendBufferSize = size;
    }

    public Integer getMcastRecvBufferSize() {
        return this.mcastRecvBufferSize;
    }

    private void setMcastRecvBufferSize(Integer size) {
        this.mcastRecvBufferSize = size;
    }

    public Integer getMcastFlowControlByteAllowance() {
        return this.mcastFlowControlByteAllowance;
    }

    private void setMcastFlowControlByteAllowance(Integer allowance) {
        this.mcastFlowControlByteAllowance = allowance;
    }

    public Float getMcastFlowControlRechargeThreshold() {
        return this.mcastFlowControlRechargeThreshold;
    }

    private void setMcastFlowControlRechargeThreshold(Float threshold) {
        this.mcastFlowControlRechargeThreshold = threshold;
    }

    public Integer getMcastFlowControlRechargeBlockMs() {
        return this.mcastFlowControlRechargeBlockMs;
    }

    private void setMcastFlowControlRechargeBlockMs(Integer ms) {
        this.mcastFlowControlRechargeBlockMs = ms;
    }

    public Integer getUdpFragmentSize() {
        return this.udpFragmentSize;
    }

    private void setUdpFragmentSize(Integer size) {
        this.udpFragmentSize = size;
    }

    public Integer getUdpSendBufferSize() {
        return this.udpSendBufferSize;
    }

    private void setUdpSendBufferSize(Integer size) {
        this.udpSendBufferSize = size;
    }

    public Integer getUdpRecvBufferSize() {
        return this.udpRecvBufferSize;
    }

    private void setUdpRecvBufferSize(Integer size) {
        this.udpRecvBufferSize = size;
    }

    public Integer getTcpPort() {
        return this.tcpPort;
    }

    protected void setTcpPort(Integer port) {
        this.tcpPort = port;
    }

    public Boolean getDisableTcp() {
        return this.disableTcp;
    }

    private void setDisableTcp(Boolean flag) {
        this.disableTcp = flag;
    }

    public String getMembershipPortRange() {
        return this.membershipPortRange;
    }

    protected void setMembershipPortRange(String range) {
        this.membershipPortRange = range;
    }

    public Integer getMemberTimeout() {
        return this.memberTimeout;
    }

    private void setMemberTimeout(Integer timeout) {
        this.memberTimeout = timeout;
    }

    public String getLocatorClassPath() {
        return this.locatorClassPath;
    }

    private void setLocatorClassPath(String path) {
        this.locatorClassPath = path;
    }

    public String getExtraLocatorVMArgs() {
        return this.extraLocatorVMArgs;
    }

    private void setExtraLocatorVMArgs(String args) {
        this.extraLocatorVMArgs = args;
    }

    public Boolean getEnableDurableClient() {
        return this.enableDurableClient;
    }

    private void setEnableDurableClient(Boolean flag) {
        this.enableDurableClient = flag;
    }

    public Integer getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    private void setDurableClientTimeout(Integer timeout) {
        this.durableClientTimeout = timeout;
    }

    public Integer getAckSevereAlertThreshold() {
        return this.ackSevereAlertThreshold;
    }

    private void setAckSevereAlertThreshold(Integer i) {
        this.ackSevereAlertThreshold = i;
    }

    public Boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    private void setEnableNetworkPartitionDetection(Boolean bool) {
        this.enableNetworkPartitionDetection = bool;
    }

    private void setDisableAutoReconnect(Boolean bool) {
        this.disableAutoReconnect = bool;
    }

    public Boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    public String getRoles() {
        return this.roles;
    }

    private void setRoles(String roles) {
        this.roles = roles;
    }

    private void setMaxWaitTimeForReconnect(Integer timeOut) {
        this.maxWaitTimeForReconnect = timeOut;
    }

    private Integer getMaxWaitTimeForReconnect() {
        return this.maxWaitTimeForReconnect;
    }

    private void setMaxNumReconnectTries(Integer maxTime) {
        this.maxNumReconnectTries = maxTime;
    }

    public Integer getMaxNumReconnectTries() {
        return this.maxNumReconnectTries;
    }

    public Boolean getConserveSockets() {
        return this.conserveSockets;
    }

    private void setConserveSockets(Boolean flag) {
        this.conserveSockets = flag;
    }

    public Boolean getDeltaPropagation() {
        return this.deltaPropagation;
    }

    private void setDeltaPropagation(Boolean flag) {
        this.deltaPropagation = flag;
    }

    public Long getSocketLeaseTime() {
        return this.socketLeaseTime;
    }

    private void setSocketLeaseTime(Long socketLeaseTime) {
        this.socketLeaseTime = socketLeaseTime;
    }

    public Long getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Long socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Integer getAsyncDistributionTimeout() {
        return this.asyncDistributionTimeout;
    }

    private void setAsyncDistributionTimeout(Integer timeout) {
        this.asyncDistributionTimeout = timeout;
    }

    public Integer getAsyncQueueTimeout() {
        return this.asyncQueueTimeout;
    }

    private void setAsyncQueueTimeout(Integer timeout) {
        this.asyncQueueTimeout = timeout;
    }

    public Integer getAsyncMaxQueueSize() {
        return this.asyncMaxQueueSize;
    }

    private void setAsyncMaxQueueSize(Integer size) {
        this.asyncMaxQueueSize = size;
    }

    private String getConflateEvents() {
        return this.conflateEvents;
    }

    private void setConflateEvents(String str) {
        this.conflateEvents = str;
    }

    public Boolean getEnforceUniqueHost() {
        return this.enforceUniqueHost;
    }

    private void setEnforceUniqueHost(Boolean bool) {
        this.enforceUniqueHost = bool;
    }

    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    private void setRedundancyZone(String str) {
        this.redundancyZone = str;
    }

    public Boolean getJMXManager() {
        return this.jmxManager;
    }

    private void setJMXManager(Boolean bool) {
        this.jmxManager = bool;
    }

    public String getJMXManagerAccessFile() {
        return this.jmxManagerAccessFile;
    }

    private void setJMXManagerAccessFile(String str) {
        this.jmxManagerAccessFile = str;
    }

    protected Boolean getJMXManagerHttpPort() {
        return this.jmxManagerHttpPort;
    }

    public String getJMXManagerPasswordFile() {
        return this.jmxManagerPasswordFile;
    }

    private void setJMXManagerPasswordFile(String str) {
        this.jmxManagerPasswordFile = str;
    }

    private void setJMXManagerHttpPort(Boolean bool) {
        this.jmxManagerHttpPort = bool;
    }

    protected Boolean getJMXManagerPort() {
        return this.jmxManagerPort;
    }

    private void setJMXManagerPort(Boolean bool) {
        this.jmxManagerPort = bool;
    }

    protected Boolean getJMXManagerSSL() {
        return this.jmxManagerSSL;
    }

    private void setJMXManagerSSL(Boolean bool) {
        this.jmxManagerSSL = bool;
    }

    public Boolean getJMXManagerStart() {
        return this.jmxManagerStart;
    }

    private void setJMXManagerStart(Boolean bool) {
        this.jmxManagerStart = bool;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    private void setSecurityName(String str) {
        this.securityName = str;
    }

    public SecurityDescription getSecurityDescription() {
        return this.securityDescription;
    }

    private void setSecurityDescription(SecurityDescription sd) {
        this.securityDescription = sd;
    }

    public String getSSLName() {
        return this.sslName;
    }

    private void setSSLName(String str) {
        this.sslName = str;
    }

    public SSLDescription getSSLDescription() {
        return this.sslDescription;
    }

    private void setSSLDescription(SSLDescription sd) {
        this.sslDescription = sd;
    }

    public String getOffHeapMemorySize() {
        return this.offHeapMemorySize;
    }

    private void setOffHeapMemorySize(String aStr) {
        this.offHeapMemorySize = aStr;
    }

    public Boolean getLockMemory() {
        return this.lockMemory;
    }

    private void setLockMemory(Boolean bool) {
        this.lockMemory = bool;
    }

    public synchronized String getSysDirName() {
        if (this.sysDirName == null) {
            this.sysDirName = GemFireLocatorAgent.MasterManagedLocator ? GemFireLocatorAgent.getSysDirName() + "_" + ProcessMgr.getProcessId() : this.getSystemDirectory() + "_" + ProcessMgr.getProcessId();
            if (!FileUtil.exists(this.sysDirName)) {
                FileUtil.mkdir(new File(this.sysDirName));
                HostDescription hd = this.getHostDescription();
                try {
                    if (GemFireLocatorAgent.MasterManagedLocator) {
                        HostDescription mhd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
                        GemFireLocatorAgent.Master.recordDir(mhd, this.name, this.sysDirName);
                    } else {
                        RemoteTestModule.Master.recordDir(hd, this.name, this.sysDirName);
                    }
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to record directory: " + this.sysDirName;
                    throw new HydraRuntimeException(s, e);
                }
            }
        }
        return this.sysDirName;
    }

    protected String getLogFileName() {
        return this.getSysDirName() + "/system.log";
    }

    public Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        RemoteTestModule client = RemoteTestModule.getCurrentThread();
        if (client != null) {
            String mn = this.name + "_" + RemoteTestModule.getMyHost() + "_" + RemoteTestModule.getMyPid();
            p.setProperty("name", mn);
        }
        if (!this.getUseLocator().booleanValue() && this.getEnableMcast().booleanValue()) {
            GemFireVersionHelper.setDistributedSystemId(p, this.distributedSystemId);
        }
        p.setProperty("log-file", this.getLogFileName());
        p.setProperty("log-level", this.logLevel);
        p.setProperty("log-file-size-limit", this.logFileSizeLimit.toString());
        p.setProperty("log-disk-space-limit", this.logDiskSpaceLimit.toString());
        p.setProperty("statistic-archive-file", this.getSysDirName() + "/" + this.statisticArchiveFile);
        p.setProperty("statistic-sampling-enabled", String.valueOf(this.statisticSamplingEnabled));
        p.setProperty("statistic-sample-rate", this.statisticSampleRate.toString());
        p.setProperty("enable-time-statistics", String.valueOf(this.enableTimeStatistics));
        p.setProperty("archive-file-size-limit", this.archiveFileSizeLimit.toString());
        p.setProperty("archive-disk-space-limit", this.archiveDiskSpaceLimit.toString());
        p.setProperty("ack-wait-threshold", this.ackWaitThreshold.toString());
        if (this.distributedSystem.equals("loner")) {
            p.setProperty("locators", "");
        } else if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            p.setProperty("locators", TestConfig.getInstance().getMasterDescription().getLocator(this.distributedSystem));
        } else {
            List endpoints = DistributedSystemHelper.getEndpoints(this.distributedSystem);
            p.setProperty("locators", DistributedSystemHelper.endpointsToString(endpoints));
        }
        if (this.remoteDistributedSystems != null) {
            GemFireVersionHelper.setRemoteLocators(p, this.remoteDistributedSystems);
        }
        if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
            String ipv6 = HostHelper.getHostAddress();
            if (ipv6 == null) {
                String s = "IPv6 address is not available for host " + this.hd.getHostName();
                throw new HydraRuntimeException(s);
            }
            p.setProperty("bind-address", ipv6);
            p.setProperty("server-bind-address", ipv6);
        }
        p.setProperty("mcast-address", this.mcastAddress);
        p.setProperty("mcast-port", this.mcastPort.toString());
        p.setProperty("mcast-ttl", this.mcastTtl.toString());
        p.setProperty("mcast-send-buffer-size", this.mcastSendBufferSize.toString());
        p.setProperty("mcast-recv-buffer-size", this.mcastRecvBufferSize.toString());
        String mcastFlowControlString = this.mcastFlowControlByteAllowance + ", " + this.mcastFlowControlRechargeThreshold + ", " + this.mcastFlowControlRechargeBlockMs;
        p.setProperty("mcast-flow-control", mcastFlowControlString);
        p.setProperty("udp-fragment-size", this.udpFragmentSize.toString());
        p.setProperty("udp-send-buffer-size", this.udpSendBufferSize.toString());
        p.setProperty("udp-recv-buffer-size", this.udpRecvBufferSize.toString());
        GemFireVersionHelper.setTcpPort(p, this.tcpPort);
        p.setProperty("disable-tcp", this.disableTcp.toString());
        GemFireVersionHelper.setMembershipPortRange(p, this.membershipPortRange);
        p.setProperty("member-timeout", this.memberTimeout.toString());
        p.setProperty("conserve-sockets", this.conserveSockets.toString());
        GemFireVersionHelper.setDeltaPropagation(p, this.deltaPropagation);
        p.setProperty("socket-lease-time", this.socketLeaseTime.toString());
        p.setProperty("socket-buffer-size", this.socketBufferSize.toString());
        p.setProperty("roles", this.roles.toString());
        p.setProperty("max-wait-time-reconnect", this.maxWaitTimeForReconnect.toString());
        p.setProperty("max-num-reconnect-tries", this.maxNumReconnectTries.toString());
        p.setProperty("async-distribution-timeout", this.asyncDistributionTimeout.toString());
        p.setProperty("async-queue-timeout", this.asyncQueueTimeout.toString());
        p.setProperty("async-max-queue-size", this.asyncMaxQueueSize.toString());
        if (client != null && this.enableDurableClient.booleanValue()) {
            p.setProperty("durable-client-id", "vm_" + RemoteTestModule.getMyVmid());
            p.setProperty("durable-client-timeout", this.durableClientTimeout.toString());
        }
        p.setProperty("conflate-events", this.conflateEvents);
        GemFireVersionHelper.setEnforceUniqueHost(p, this.enforceUniqueHost);
        if (this.redundancyZone != null) {
            GemFireVersionHelper.setRedundancyZone(p, this.redundancyZone);
        }
        p.setProperty("ack-severe-alert-threshold", this.ackSevereAlertThreshold.toString());
        p.setProperty("enable-network-partition-detection", this.enableNetworkPartitionDetection.toString());
        if (this.jmxManager != null) {
            GemFireVersionHelper.setJMXManager(p, this.jmxManager.toString());
        }
        GemFireVersionHelper.setJMXManagerAccessFile(p, this.jmxManagerAccessFile, this.hd);
        GemFireVersionHelper.setJMXManagerPasswordFile(p, this.jmxManagerPasswordFile, this.hd);
        GemFireVersionHelper.setJMXManagerPorts(p, this.jmxManagerPort, this.jmxManagerHttpPort);
        GemFireVersionHelper.setJMXManagerSSL(p, this.jmxManagerSSL.toString());
        if (this.jmxManagerSSL.booleanValue() && this.sslDescription != null) {
            this.sslDescription.setSystemProperties(this.mcastPort.toString());
        }
        GemFireVersionHelper.setJMXManagerStart(p, this.jmxManagerStart.toString());
        if (this.sslDescription != null && !GemFireLocatorAgent.MasterManagedLocator) {
            this.addProperties(this.sslDescription.getDistributedSystemProperties(), p);
            if (this.sslDescription.getSSLEnabled().booleanValue()) {
                this.sslDescription.setSystemProperties(this.mcastPort.toString());
            }
        }
        if (this.securityDescription != null && !GemFireLocatorAgent.MasterManagedLocator) {
            this.addProperties(this.securityDescription.getDistributedSystemProperties(this), p);
        }
        if (this.offHeapMemorySize != null) {
            GemFireVersionHelper.setOffHeapMemorySize(p, this.offHeapMemorySize);
        }
        p.setProperty("lock-memory", this.getLockMemory().toString());
        if (this.disableAutoReconnect != null) {
            GemFireVersionHelper.setDisableAutoReconnect(p, this.disableAutoReconnect);
        }
        return p;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "hostName", this.getHostDescription().getName());
        map.put(header + "distributedSystem", this.getDistributedSystem());
        map.put(header + "remoteDistributedSystems", this.getRemoteDistributedSystems());
        map.put(header + "distributedSystemId", this.getDistributedSystemId());
        map.put(header + "systemDir", this.getSystemDirectoryStr());
        map.put(header + "stopSystemAfterTest", String.valueOf(this.stopSystemAfterTest()));
        map.put(header + "ackWaitThreshold", this.getAckWaitThreshold());
        map.put(header + "logLevel", this.getLogLevel());
        map.put(header + "logFileSizeLimit", this.getLogFileSizeLimit());
        map.put(header + "logDiskSpaceLimit", this.getLogDiskSpaceLimit());
        map.put(header + "statisticArchiveFile", this.getStatisticArchiveFile());
        map.put(header + "statisticSamplingEnabled", this.getStatisticSamplingEnabled());
        map.put(header + "statisticSampleRate", this.getStatisticSampleRate());
        map.put(header + "enableTimeStatistics", this.getEnableTimeStatistics());
        map.put(header + "archiveFileSizeLimit", this.getArchiveFileSizeLimit());
        map.put(header + "archiveDiskSpaceLimit", this.getArchiveDiskSpaceLimit());
        map.put(header + "conserveSockets", this.getConserveSockets());
        map.put(header + "deltaPropagation", this.getDeltaPropagation());
        map.put(header + "socketLeaseTime", this.getSocketLeaseTime());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "roles", this.getRoles());
        map.put(header + "max-wait-time-reconnect", this.getMaxWaitTimeForReconnect());
        map.put(header + "max-num-reconnect-tries", this.getMaxNumReconnectTries());
        map.put(header + "useLocator", this.getUseLocator());
        map.put(header + "isPeerLocator", this.isPeerLocator());
        map.put(header + "isServerLocator", this.isServerLocator());
        map.put(header + "enableMcast", this.getEnableMcast());
        map.put(header + "mcastAddress", this.getMcastAddress());
        map.put(header + "mcastPort", this.getMcastPort());
        map.put(header + "mcastTtl", this.getMcastTtl());
        map.put(header + "mcastSendBufferSize", this.getMcastSendBufferSize());
        map.put(header + "mcastRecvBufferSize", this.getMcastRecvBufferSize());
        map.put(header + "mcastFlowControlByteAllowance", this.getMcastFlowControlByteAllowance());
        map.put(header + "mcastFlowControlRechargeThreshold", this.getMcastFlowControlRechargeThreshold());
        map.put(header + "mcastFlowControlRechargeBlockMs", this.getMcastFlowControlRechargeBlockMs());
        map.put(header + "udpFragmentSize", this.getUdpFragmentSize());
        map.put(header + "udpSendBufferSize", this.getUdpSendBufferSize());
        map.put(header + "udpRecvBufferSize", this.getUdpRecvBufferSize());
        map.put(header + "tcpPort", this.getTcpPort());
        map.put(header + "disableTcp", this.getDisableTcp());
        map.put(header + "membershipPortRange", this.getMembershipPortRange());
        map.put(header + "memberTimeout", this.getMemberTimeout());
        if (this.getLocatorClassPath() != null) {
            map.put(header + "locatorClassPath", this.getLocatorClassPath());
        }
        if (this.getExtraLocatorVMArgs() != null) {
            map.put(header + "extraLocatorVMArgs", this.getExtraLocatorVMArgs());
        }
        map.put(header + "asyncDistributionTimeout", this.getAsyncDistributionTimeout());
        map.put(header + "asyncQueueTimeout", this.getAsyncQueueTimeout());
        map.put(header + "asyncMaxQueueSize", this.getAsyncMaxQueueSize());
        map.put(header + "enableDurableClient", this.getEnableDurableClient());
        map.put(header + "durableClientTimeout", this.getDurableClientTimeout());
        map.put(header + "conflateEvents", this.getConflateEvents());
        map.put(header + "enforceUniqueHost", this.getEnforceUniqueHost());
        map.put(header + "redundancyZone", this.getRedundancyZone());
        map.put(header + "securityName", this.getSecurityName());
        if (this.getJMXManager() == null) {
            map.put(header + "jmxManager", "uses_product_default");
        } else {
            map.put(header + "jmxManager", this.getJMXManager());
        }
        map.put(header + "jmxManagerAccessFile", this.getJMXManagerAccessFile());
        if (this.getJMXManagerHttpPort().booleanValue()) {
            map.put(header + "jmxManagerHttpPort", "autogenerated");
        } else {
            map.put(header + "jmxManagerHttpPort", 0);
        }
        map.put(header + "jmxManagerPasswordFile", this.getJMXManagerPasswordFile());
        if (this.getJMXManagerPort().booleanValue()) {
            map.put(header + "jmxManagerPort", "autogenerated");
        } else {
            map.put(header + "jmxManagerPort", 0);
        }
        map.put(header + "jmxManagerSSL", this.getJMXManagerSSL());
        map.put(header + "jmxManagerStart", this.getJMXManagerStart());
        map.put(header + "sslName", this.getSSLName());
        map.put(header + "ackSevereAlertThreshold", this.getAckSevereAlertThreshold());
        map.put(header + "enableNetworkPartitionDetection", this.getEnableNetworkPartitionDetection());
        map.put(header + "disableAutoReconnect", this.getDisableAutoReconnect());
        map.put(header + "offHeapMemorySize", this.getOffHeapMemorySize());
        map.put(header + "lockMemory", this.getLockMemory());
        return map;
    }

    protected static void configure(TestConfig config) {
        String randomMcastAddress;
        ConfigHashtable tab = config.getParameters();
        GsRandom rand = new GsRandom();
        if (tab.booleanAt(Prms.useIPv6)) {
            int addr = rand.nextInt(1111, 8888);
            randomMcastAddress = "FF38::" + addr;
        } else {
            int addr1 = rand.nextInt(81, 254);
            int addr2 = rand.nextInt(1, 254);
            randomMcastAddress = "239.192." + addr1 + "." + addr2;
        }
        HydraVector names = tab.vecAt(GemFirePrms.names, new HydraVector());
        HashMap<String, Integer> distributedSystems = new HashMap<String, Integer>();
        int nextDSID = 0;
        for (int i = 0; i < names.size(); ++i) {
            String aStr;
            boolean ipv6;
            boolean allowMcastWithIPv6;
            Boolean bool;
            GemFireDescription gfd = new GemFireDescription();
            String name = (String)names.elementAt(i);
            gfd.setName(name);
            String hostName = tab.stringAtWild(GemFirePrms.hostNames, i, null);
            if (hostName == null) {
                throw new HydraConfigException("Missing " + BasePrms.nameForKey(GemFirePrms.hostNames));
            }
            HostDescription hd = config.getHostDescription(hostName);
            if (hd == null) {
                throw new HydraConfigException("Undefined value in " + BasePrms.nameForKey(GemFirePrms.hostNames) + ": " + hostName);
            }
            gfd.setHostDescription(hd);
            String distributedSystem = tab.stringAtWild(GemFirePrms.distributedSystem, i, "ds");
            if (distributedSystem.equalsIgnoreCase("loner")) {
                gfd.setDistributedSystem("loner");
                gfd.setDistributedSystemId(-1);
            } else {
                gfd.setDistributedSystem(distributedSystem);
                Integer dsid = (Integer)distributedSystems.get(distributedSystem);
                if (dsid == null) {
                    dsid = GemFireDescription.toDSID(distributedSystem);
                    if (dsid == null || distributedSystems.values().contains(dsid)) {
                        do {
                            dsid = ++nextDSID;
                        } while (distributedSystems.values().contains(dsid));
                    }
                    distributedSystems.put(distributedSystem, dsid);
                }
                gfd.setDistributedSystemId(dsid);
            }
            Long key = GemFirePrms.remoteDistributedSystems;
            HydraVector strs = tab.vecAtWild(key, i, null);
            if (strs != null) {
                Iterator it = strs.iterator();
                while (it.hasNext()) {
                    String str = tab.getString(key, it.next());
                    if (str != null && !str.equalsIgnoreCase("none")) continue;
                    it.remove();
                }
                if (strs.size() > 0) {
                    String s;
                    if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
                        s = BasePrms.nameForKey(key) + " cannot be used when " + BasePrms.nameForKey(Prms.manageLocatorAgents) + "=true.  Use hydra client-managed locators.";
                        throw new HydraConfigException(s);
                    }
                    if (gfd.getDistributedSystem().equals("loner")) {
                        s = BasePrms.nameForKey(key) + " cannot be used when " + BasePrms.nameForKey(GemFirePrms.distributedSystem) + "=" + "loner" + ".  Set remote distributed systems for loners to " + "none";
                        throw new HydraConfigException(s);
                    }
                    gfd.setRemoteDistributedSystems(strs);
                }
            }
            gfd.setSystemDirectory(hd.getResourceDir() + hd.getFileSep() + name);
            boolean stopSystemAfterTest = tab.booleanAtWild(GemFirePrms.stopSystemsAfterTest, i, Boolean.TRUE);
            gfd.setStopSystemAfterTest(stopSystemAfterTest);
            int ackWaitThreshold = tab.intAtWild(GemFirePrms.ackWaitThreshold, i, 15);
            gfd.setAckWaitThreshold(new Integer(ackWaitThreshold));
            String logLevel = tab.stringAtWild(GemFirePrms.logLevel, i, LogWriterImpl.levelToString((int)700));
            gfd.setLogLevel(logLevel);
            int logFileSizeLimit = tab.intAtWild(GemFirePrms.logFileSizeLimit, i, 0);
            gfd.setLogFileSizeLimit(new Integer(logFileSizeLimit));
            int logDiskSpaceLimit = tab.intAtWild(GemFirePrms.logDiskSpaceLimit, i, 0);
            gfd.setLogDiskSpaceLimit(new Integer(logDiskSpaceLimit));
            gfd.setStatisticArchiveFile("statArchive.gfs");
            boolean statisticSamplingEnabled = tab.booleanAtWild(GemFirePrms.statisticSamplingEnabled, i, Boolean.TRUE);
            gfd.setStatisticSamplingEnabled(statisticSamplingEnabled);
            int statisticSampleRate = tab.intAtWild(GemFirePrms.statisticSampleRate, i, 1000);
            gfd.setStatisticSampleRate(new Integer(statisticSampleRate));
            boolean enableTimeStatistics = tab.booleanAtWild(GemFirePrms.enableTimeStatistics, i, Boolean.TRUE);
            gfd.setEnableTimeStatistics(enableTimeStatistics);
            int archiveFileSizeLimit = tab.intAtWild(GemFirePrms.archiveFileSizeLimit, i, 0);
            gfd.setArchiveFileSizeLimit(new Integer(archiveFileSizeLimit));
            int archiveDiskSpaceLimit = tab.intAtWild(GemFirePrms.archiveDiskSpaceLimit, i, 0);
            gfd.setArchiveDiskSpaceLimit(new Integer(archiveDiskSpaceLimit));
            boolean conserveSockets = tab.booleanAtWild(GemFirePrms.conserveSockets, i, Boolean.TRUE);
            gfd.setConserveSockets(conserveSockets);
            gfd.setDeltaPropagation(GemFireVersionHelper.getDeltaPropagation(tab, i));
            long socketLeaseTime = tab.longAtWild(GemFirePrms.socketLeaseTime, i, 60000L);
            gfd.setSocketLeaseTime(new Long(socketLeaseTime));
            long socketBufferSize = tab.longAtWild(GemFirePrms.socketBufferSize, i, 32768L);
            gfd.setSocketBufferSize(new Long(socketBufferSize));
            String roles = tab.stringAtWild(GemFirePrms.roles, i, "");
            if (roles.equalsIgnoreCase("default") || roles.equalsIgnoreCase("none")) {
                roles = "";
            }
            gfd.setRoles(roles);
            int maxWaitTimeForReconnect = tab.intAtWild(GemFirePrms.maxWaitTimeForReconnect, i, 60000);
            gfd.setMaxWaitTimeForReconnect(new Integer(maxWaitTimeForReconnect));
            int reconnectTimes = tab.intAtWild(GemFirePrms.maxNumReconnectTries, i, 3);
            gfd.setMaxNumReconnectTries(new Integer(reconnectTimes));
            String configMcastAddress = tab.stringAtWild(GemFirePrms.mcastAddress, i, "null");
            if (configMcastAddress.equalsIgnoreCase("null")) {
                gfd.setMcastAddress(randomMcastAddress);
            } else {
                gfd.setMcastAddress(configMcastAddress);
            }
            boolean enableMcast = false;
            if (gfd.getDistributedSystem().equals("loner")) {
                gfd.setEnableMcast(Boolean.FALSE);
            } else {
                enableMcast = tab.booleanAtWild(GemFirePrms.enableMcast, i, Boolean.FALSE);
                gfd.setEnableMcast(enableMcast);
            }
            if (gfd.getDistributedSystem().equals("loner")) {
                gfd.setUseLocator(Boolean.FALSE);
            } else {
                Boolean defaultVal = null;
                if (!enableMcast) {
                    defaultVal = Boolean.TRUE;
                }
                boolean useLocator = tab.booleanAtWild(GemFirePrms.useLocator, i, defaultVal);
                gfd.setUseLocator(useLocator);
            }
            Long key2 = GemFirePrms.isPeerLocator;
            Boolean bool2 = tab.getBoolean(key2, tab.getWild(key2, i, null));
            if (bool2 == null) {
                bool2 = Boolean.TRUE;
            }
            gfd.setPeerLocator(bool2);
            key2 = GemFirePrms.isServerLocator;
            bool2 = tab.getBoolean(key2, tab.getWild(key2, i, null));
            if (bool2 == null) {
                bool2 = Boolean.TRUE;
            }
            gfd.setServerLocator(bool2);
            if (gfd.getDistributedSystem().equals("loner")) {
                gfd.setMcastPort(new Integer(0));
            } else {
                int mcastPort = 0;
                if (enableMcast) {
                    mcastPort = tab.intAtWild(GemFirePrms.mcastPort, i, 0);
                }
                gfd.setMcastPort(new Integer(mcastPort));
            }
            int mcastTtl = tab.intAtWild(GemFirePrms.mcastTtl, i, 0);
            gfd.setMcastTtl(new Integer(mcastTtl));
            int mcastSendBufferSize = tab.intAtWild(GemFirePrms.mcastSendBufferSize, i, 65535);
            gfd.setMcastSendBufferSize(new Integer(mcastSendBufferSize));
            int mcastRecvBufferSize = tab.intAtWild(GemFirePrms.mcastRecvBufferSize, i, 0x100000);
            gfd.setMcastRecvBufferSize(new Integer(mcastRecvBufferSize));
            int mcastFlowControlByteAllowance = tab.intAtWild(GemFirePrms.mcastFlowControlByteAllowance, i, DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getByteAllowance());
            gfd.setMcastFlowControlByteAllowance(new Integer(mcastFlowControlByteAllowance));
            Float mcastFlowControlRechargeThreshold = new Float(tab.stringAtWild(GemFirePrms.mcastFlowControlRechargeThreshold, i, Float.toString(DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getRechargeThreshold())));
            gfd.setMcastFlowControlRechargeThreshold(mcastFlowControlRechargeThreshold);
            int mcastFlowControlRechargeBlockMs = tab.intAtWild(GemFirePrms.mcastFlowControlRechargeBlockMs, i, DistributionConfig.DEFAULT_MCAST_FLOW_CONTROL.getRechargeBlockMs());
            gfd.setMcastFlowControlRechargeBlockMs(new Integer(mcastFlowControlRechargeBlockMs));
            int udpFragmentSize = tab.intAtWild(GemFirePrms.udpFragmentSize, i, 60000);
            gfd.setUdpFragmentSize(new Integer(udpFragmentSize));
            int udpSendBufferSize = tab.intAtWild(GemFirePrms.udpSendBufferSize, i, 65535);
            gfd.setUdpSendBufferSize(new Integer(udpSendBufferSize));
            int udpRecvBufferSize = tab.intAtWild(GemFirePrms.udpRecvBufferSize, i, 0x100000);
            gfd.setUdpRecvBufferSize(new Integer(udpRecvBufferSize));
            boolean disableTcp = tab.booleanAtWild(GemFirePrms.disableTcp, i, false);
            gfd.setDisableTcp(disableTcp);
            gfd.setTcpPort(GemFireVersionHelper.getTcpPort(tab, i));
            gfd.setMembershipPortRange(GemFireVersionHelper.getMembershipPortRange(tab, i));
            int memberTimeout = tab.intAtWild(GemFirePrms.memberTimeout, i, 5000);
            gfd.setMemberTimeout(new Integer(memberTimeout));
            HostDescription mhd = config.getMasterDescription().getVmDescription().getHostDescription();
            Vector<String> classPath = new Vector<String>();
            Vector extraLocatorClassPath = tab.vecAt(GemFirePrms.extraLocatorClassPath, null);
            if (extraLocatorClassPath != null) {
                extraLocatorClassPath = EnvHelper.expandEnvVars(extraLocatorClassPath, mhd);
                classPath.addAll(extraLocatorClassPath);
            }
            classPath.add(mhd.getTestDir());
            classPath.add(mhd.getTestDir() + mhd.getFileSep() + "junit.jar");
            if (mhd.getExtraTestDir() != null) {
                classPath.add(mhd.getExtraTestDir());
            }
            if (mhd.getGemFireHome() != null) {
                classPath.add(mhd.getGemFireHome() + mhd.getFileSep() + "lib" + mhd.getFileSep() + "snappydata-store-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + ".jar");
                classPath.add(mhd.getGemFireHome() + mhd.getFileSep() + "lib");
                classPath.add(VmDescription.getSnappyJarPath(mhd.getGemFireHome() + mhd.getFileSep() + ".." + mhd.getFileSep() + ".." + mhd.getFileSep() + ".." + mhd.getFileSep(), "snappydata-store-scala-tests*tests.jar"));
            }
            Vector expandedClassPath = EnvHelper.expandEnvVars(classPath, mhd);
            gfd.setLocatorClassPath(EnvHelper.asPath(expandedClassPath, mhd));
            String extraLocatorVMArgs = GemFirePrms.getExtraLocatorVMArgs(i);
            if (extraLocatorVMArgs != null) {
                gfd.setExtraLocatorVMArgs(extraLocatorVMArgs.trim());
            }
            int asyncDistributionTimeout = tab.intAtWild(GemFirePrms.asyncDistributionTimeout, i, 0);
            gfd.setAsyncDistributionTimeout(new Integer(asyncDistributionTimeout));
            int asyncQueueTimeout = tab.intAtWild(GemFirePrms.asyncQueueTimeout, i, 60000);
            gfd.setAsyncQueueTimeout(new Integer(asyncQueueTimeout));
            int asyncMaxQueueSize = tab.intAtWild(GemFirePrms.asyncMaxQueueSize, i, 8);
            gfd.setAsyncMaxQueueSize(new Integer(asyncMaxQueueSize));
            boolean enableDurableClient = tab.booleanAtWild(GemFirePrms.enableDurableClient, i, Boolean.FALSE);
            gfd.setEnableDurableClient(enableDurableClient);
            int durableClientTimeout = tab.intAtWild(GemFirePrms.durableClientTimeout, i, 300);
            gfd.setDurableClientTimeout(new Integer(durableClientTimeout));
            Long key3 = GemFirePrms.conflateEvents;
            String str = tab.getString(key3, tab.getWild(key3, i, null));
            if (str == null) {
                str = "server";
            }
            gfd.setConflateEvents(GemFireDescription.getConflateEvents(str, key3));
            key3 = GemFirePrms.enforceUniqueHost;
            Boolean b = tab.getBoolean(key3, tab.getWild(key3, i, null));
            if (b == null) {
                b = Boolean.FALSE;
            }
            gfd.setEnforceUniqueHost(b);
            key3 = GemFirePrms.redundancyZone;
            str = tab.getString(key3, tab.getWild(key3, i, null));
            if (str != null) {
                gfd.setRedundancyZone(str);
            }
            if ((bool = tab.getBoolean(key3 = GemFirePrms.jmxManager, tab.getWild(key3, i, null))) != null) {
                gfd.setJMXManager(bool);
            }
            if ((str = tab.getString(key3 = GemFirePrms.jmxManagerAccessFile, tab.getWild(key3, i, null))) != null) {
                gfd.setJMXManagerAccessFile(str);
            }
            if ((bool = tab.getBoolean(key3 = GemFirePrms.jmxManagerHttpPort, tab.getWild(key3, i, null))) == null) {
                bool = Boolean.FALSE;
            }
            gfd.setJMXManagerHttpPort(bool);
            key3 = GemFirePrms.jmxManagerPasswordFile;
            str = tab.getString(key3, tab.getWild(key3, i, null));
            if (str != null) {
                gfd.setJMXManagerPasswordFile(str);
            }
            if ((bool = tab.getBoolean(key3 = GemFirePrms.jmxManagerPort, tab.getWild(key3, i, null))) == null) {
                bool = Boolean.FALSE;
            }
            gfd.setJMXManagerPort(bool);
            key3 = GemFirePrms.jmxManagerSSL;
            bool = tab.getBoolean(key3, tab.getWild(key3, i, null));
            if (bool == null) {
                bool = false;
            }
            gfd.setJMXManagerSSL(bool);
            key3 = GemFirePrms.jmxManagerStart;
            bool = tab.getBoolean(key3, tab.getWild(key3, i, null));
            if (bool == null) {
                bool = false;
            }
            gfd.setJMXManagerStart(bool);
            key3 = GemFirePrms.securityName;
            str = tab.getString(key3, tab.getWild(key3, i, null));
            if (str != null && !str.equalsIgnoreCase("none")) {
                gfd.setSecurityName("SecurityDescription." + str);
                gfd.setSecurityDescription(GemFireDescription.getSecurityDescription(str, key3, config));
            }
            if ((str = tab.getString(key3 = GemFirePrms.sslName, tab.getWild(key3, i, null))) != null && !str.equalsIgnoreCase("none")) {
                gfd.setSSLName("SSLDescription." + str);
                gfd.setSSLDescription(GemFireDescription.getSSLDescription(str, key3, config));
            }
            if (!(allowMcastWithIPv6 = tab.booleanAtWild(GemFirePrms.allowMcastWithIPv6, i, Boolean.FALSE)) && (ipv6 = Boolean.getBoolean("java.net.preferIPv6Addresses")) && gfd.getEnableMcast().booleanValue()) {
                String s = "Cannot use IPv6 (" + BasePrms.nameForKey(Prms.useIPv6) + "=" + ipv6 + ") with multicast (" + BasePrms.nameForKey(GemFirePrms.enableMcast) + "=" + gfd.getEnableMcast() + ") unless explicitly allowed (" + BasePrms.nameForKey(GemFirePrms.allowMcastWithIPv6) + "=" + allowMcastWithIPv6 + ")";
                throw new HydraConfigException(s);
            }
            if (gfd.getSecurityName() != null && gfd.getMcastPort() != 0) {
                String s = "Cannot use security (" + BasePrms.nameForKey(GemFirePrms.securityName) + "=" + gfd.getSecurityName() + ") with non-zero multicast port (" + BasePrms.nameForKey(GemFirePrms.mcastPort) + "=" + gfd.getMcastPort() + ")";
                throw new HydraConfigException(s);
            }
            if (gfd.getSSLName() != null && gfd.getMcastPort() != 0) {
                String s = "Cannot use SSL (" + BasePrms.nameForKey(GemFirePrms.sslName) + "=" + gfd.getSSLName() + ") with non-zero multicast port (" + BasePrms.nameForKey(GemFirePrms.mcastPort) + "=" + gfd.getMcastPort() + ")";
                throw new HydraConfigException(s);
            }
            int ackSevereAlertThreshold = tab.intAtWild(GemFirePrms.ackSevereAlertThreshold, i, 0);
            gfd.setAckSevereAlertThreshold(new Integer(ackSevereAlertThreshold));
            boolean enableNetworkPartitionDetection = tab.booleanAtWild(GemFirePrms.enableNetworkPartitionDetection, i, false);
            gfd.setEnableNetworkPartitionDetection(enableNetworkPartitionDetection);
            Long key4 = GemFirePrms.disableAutoReconnect;
            Boolean bool3 = tab.getBoolean(key4, tab.getWild(key4, i, null));
            if (bool3 != null) {
                gfd.setDisableAutoReconnect(bool3);
            }
            if ((aStr = tab.getString(key4 = GemFirePrms.offHeapMemorySize, tab.getWild(key4, i, null))) != null) {
                gfd.setOffHeapMemorySize(aStr);
            }
            if ((bool3 = tab.getBoolean(key4 = GemFirePrms.lockMemory, tab.getWild(key4, i, null))) == null) {
                bool3 = false;
            }
            gfd.setLockMemory(bool3);
            config.addGemFireDescription(gfd);
        }
    }

    private static String getConflateEvents(String str, Long key) {
        if (str.equalsIgnoreCase("server")) {
            return "server";
        }
        if (str.equalsIgnoreCase("true")) {
            return "true";
        }
        if (str.equalsIgnoreCase("false")) {
            return "false";
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private static Integer toDSID(String dsName) {
        String dsid = dsName.substring(dsName.indexOf("_") + 1, dsName.length());
        try {
            return Integer.parseInt(dsid);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static SecurityDescription getSecurityDescription(String str, Long key, TestConfig config) {
        SecurityDescription sd = config.getSecurityDescription(str);
        if (sd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(SecurityPrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return sd;
    }
}

