/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.GatewayReceiverPrms;
import hydra.GatewaySenderPrms;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Prms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class GatewayReceiverDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List gatewayTransportFilters;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer numInstances;
    private Integer socketBufferSize;
    private Integer startPort;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getEndPort() {
        return this.endPort;
    }

    private void setEndPort(Integer i) {
        this.endPort = i;
    }

    private List getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    private void setGatewayTransportFilters(List classnames) {
        this.gatewayTransportFilters = classnames;
    }

    private Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    private void setMaximumTimeBetweenPings(Integer i) {
        this.maximumTimeBetweenPings = i;
    }

    protected Integer getNumInstances() {
        return this.numInstances;
    }

    private void setNumInstances(Integer i) {
        this.numInstances = i;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    private Integer getStartPort() {
        return this.startPort;
    }

    private void setStartPort(Integer i) {
        this.startPort = i;
    }

    protected void configure(GatewayReceiverFactory f) {
        List<GatewayTransportFilter> gtfs = this.getGatewayTransportFilterInstances();
        if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
            String ipv6 = HostHelper.getHostAddress(HostHelper.getIPv6Address());
            if (ipv6 == null) {
                String s = "IPv6 address is not available for host " + HostHelper.getLocalHost();
                throw new HydraRuntimeException(s);
            }
            f.setBindAddress(ipv6);
        }
        f.setEndPort(this.getEndPort().intValue());
        if (gtfs != null) {
            for (GatewayTransportFilter gtf : gtfs) {
                f.addGatewayTransportFilter(gtf);
            }
        }
        f.setMaximumTimeBetweenPings(this.getMaximumTimeBetweenPings().intValue());
        f.setSocketBufferSize(this.getSocketBufferSize().intValue());
        f.setStartPort(this.getStartPort().intValue());
    }

    protected static synchronized String gatewayReceiverToString(GatewayReceiver gr) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  bindAddress: " + gr.getBindAddress());
        buf.append("\n  endPort: " + gr.getEndPort());
        buf.append("\n  gatewayTransportFilters: " + GatewayReceiverDescription.gatewayTransportFiltersFor(gr.getGatewayTransportFilters()));
        buf.append("\n  host: " + gr.getHost());
        buf.append("\n  maximumTimeBetweenPings: " + gr.getMaximumTimeBetweenPings());
        buf.append("\n  port: " + gr.getPort());
        buf.append("\n  socketBufferSize: " + gr.getSocketBufferSize());
        buf.append("\n  startPort: " + gr.getStartPort());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "endPort", this.getEndPort());
        map.put(header + "gatewayTransportFilters", this.getGatewayTransportFilters());
        map.put(header + "maximumTimeBetweenPings", this.getMaximumTimeBetweenPings());
        map.put(header + "numInstances", this.getNumInstances());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        map.put(header + "startPort", this.getStartPort());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(GatewayReceiverPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewayReceiverDescription grd = GatewayReceiverDescription.createGatewayReceiverDescription(name, config, i);
            config.addGatewayReceiverDescription(grd);
        }
    }

    private static GatewayReceiverDescription createGatewayReceiverDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        GatewayReceiverDescription grd = new GatewayReceiverDescription();
        grd.setName(name);
        Long key = GatewayReceiverPrms.endPort;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 5500;
        }
        grd.setEndPort(i);
        key = GatewayReceiverPrms.gatewayTransportFilters;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str = tab.getString(key, i2.next());
                if (str != null && !str.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                grd.setGatewayTransportFilters(new ArrayList(strs));
            }
        }
        if ((i = tab.getInteger(key = GatewayReceiverPrms.maximumTimeBetweenPings, tab.getWild(key, index, null))) == null) {
            i = 60000;
        }
        grd.setMaximumTimeBetweenPings(i);
        key = GatewayReceiverPrms.numInstances;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1;
        }
        grd.setNumInstances(i);
        key = GatewayReceiverPrms.socketBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 524288;
        }
        grd.setSocketBufferSize(i);
        key = GatewayReceiverPrms.startPort;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 5000;
        }
        grd.setStartPort(i);
        return grd;
    }

    private static List gatewayTransportFiltersFor(List<GatewayTransportFilter> gtfs) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (GatewayTransportFilter gtf : gtfs) {
            classnames.add(gtf.getClass().getName());
        }
        return classnames;
    }

    private List<GatewayTransportFilter> getGatewayTransportFilterInstances() {
        List classnames = this.getGatewayTransportFilters();
        if (classnames == null) {
            return null;
        }
        Long key = GatewaySenderPrms.gatewayTransportFilters;
        ArrayList<GatewayTransportFilter> instances = new ArrayList<GatewayTransportFilter>();
        for (String classname : classnames) {
            try {
                GatewayTransportFilter gtf = (GatewayTransportFilter)GatewayReceiverDescription.getInstance(key, classname);
                instances.add(gtf);
            }
            catch (ClassCastException e) {
                String s = BasePrms.nameForKey(key) + " does not implement GatewayTransportFilter: " + classname;
                throw new HydraConfigException(s);
            }
        }
        return instances;
    }
}

