/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.BasePrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayDescription;
import hydra.GatewayHubHelper;
import hydra.GatewayPrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class GatewayHelper {
    private static LogWriter log;

    public static String gatewayToString(Gateway gateway) {
        return GatewayDescription.gatewayToString(gateway);
    }

    public static GatewayDescription getGatewayDescription(String gatewayConfig) {
        if (gatewayConfig == null) {
            throw new IllegalArgumentException("gatewayConfig cannot be null");
        }
        GatewayHelper.log("Looking up gateway config: " + gatewayConfig);
        GatewayDescription gd = TestConfig.getInstance().getGatewayDescription(gatewayConfig);
        if (gd == null) {
            String s = gatewayConfig + " not found in " + BasePrms.nameForKey(GatewayPrms.names);
            throw new HydraRuntimeException(s);
        }
        GatewayHelper.log("Looked up gateway config:\n" + gd);
        return gd;
    }

    protected static List getRandomEndpoints(String distributedSystemName, List endpoints, int numEndpoints) {
        if (distributedSystemName == null) {
            String s = "distributedSystemName cannot be null";
            throw new IllegalArgumentException(s);
        }
        String ownds = DistributedSystemHelper.getDistributedSystemName();
        if (distributedSystemName.equals(ownds)) {
            String s = "Attempt to create gateway to own distributed system: " + ownds;
            throw new IllegalArgumentException(s);
        }
        ArrayList<GatewayHubHelper.Endpoint> matchingEndpoints = new ArrayList<GatewayHubHelper.Endpoint>();
        for (GatewayHubHelper.Endpoint endpoint : endpoints) {
            if (!endpoint.getDistributedSystemName().equals(distributedSystemName)) continue;
            matchingEndpoints.add(endpoint);
        }
        if (numEndpoints > matchingEndpoints.size()) {
            String s = "Cannot find " + numEndpoints + " matching endpoints, there are only " + matchingEndpoints.size();
            throw new HydraRuntimeException(s);
        }
        int n = numEndpoints == -1 ? matchingEndpoints.size() : numEndpoints;
        Random rng = new Random(NanoTimer.getTime());
        ArrayList randomEndpoints = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int index = rng.nextInt(matchingEndpoints.size());
            randomEndpoints.add(matchingEndpoints.remove(index));
        }
        return randomEndpoints;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

