/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientDescription;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.TestConfig;
import hydra.VersionDescription;
import java.util.Vector;

public class EnvHelper {
    private static final char UNIX_FILE_SEP = '/';
    private static final char WINDOWS_FILE_SEP = '\\';
    private static final char UNIX_PATH_SEP = ':';
    private static final char WINDOWS_PATH_SEP = ';';

    protected static String getOptionalProperty(String name) {
        return System.getProperty(name);
    }

    protected static String getRequiredProperty(String name) {
        String property = EnvHelper.getOptionalProperty(name);
        if (property == null) {
            throw new HydraConfigException("No value found for property " + name);
        }
        return property;
    }

    public static String convertHostName(String host) {
        if (host.equalsIgnoreCase("localhost")) {
            return HostHelper.getLocalHost();
        }
        return host;
    }

    protected static String asPath(Vector<String> paths, HostDescription hd) {
        if (paths == null || paths.size() == 0) {
            return null;
        }
        StringBuffer pathStr = new StringBuffer();
        for (String path : paths) {
            if (pathStr.length() != 0) {
                pathStr.append(hd.getPathSep());
            }
            pathStr.append(path);
        }
        return pathStr.toString();
    }

    protected static char getPathSep(HostHelper.OSType os) {
        return os == HostHelper.OSType.unix ? (char)':' : ';';
    }

    protected static char getFileSep(HostHelper.OSType os) {
        return os == HostHelper.OSType.unix ? (char)'/' : '\\';
    }

    public static String expandEnvVars(String str) {
        return EnvHelper.expandEnvVars(str, null);
    }

    protected static Vector expandEnvVars(Vector<String> paths, HostDescription hd) {
        if (paths == null || paths.size() == 0) {
            return null;
        }
        Vector<String> expandedPaths = new Vector<String>();
        for (String path : paths) {
            String expandedPath = EnvHelper.expandEnvVars(path, hd);
            expandedPaths.addElement(expandedPath);
        }
        return expandedPaths;
    }

    public static String expandPath(String path) {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        HostDescription hd = cd.getVmDescription().getHostDescription();
        VersionDescription vd = cd.getVersionDescription();
        String jtests = hd.getTestDir();
        String userdir = System.getProperty("user.dir");
        if (vd == null) {
            return String.valueOf(path).replace("$JTESTS", jtests).replace("$PWD", userdir);
        }
        String vpath = jtests + hd.getFileSep() + ".." + hd.getFileSep() + ".." + hd.getFileSep() + "tests" + vd.getVersion() + hd.getFileSep() + "classes";
        String vstr = String.valueOf(path).replace("$JTESTS", vpath).replace("$PWD", userdir);
        if (FileUtil.exists(vstr)) {
            return vstr;
        }
        return String.valueOf(path).replace("$JTESTS", jtests).replace("$PWD", userdir);
    }

    public static String expandEnvVars(String path, HostDescription hd) {
        String str = String.valueOf(path);
        if (str.startsWith("$JAVA_HOME")) {
            String javaHome;
            String string = javaHome = hd == null ? System.getProperty("JAVA_HOME") : hd.getJavaHome();
            if (javaHome == null) {
                throw new HydraConfigException("Unable to expand $JAVA_HOME");
            }
            str = str.replace("$JAVA_HOME", javaHome);
        } else if (str.startsWith("$JTESTS")) {
            String jtests;
            String string = jtests = hd == null ? System.getProperty("JTESTS") : hd.getTestDir();
            if (jtests == null) {
                throw new HydraConfigException("Unable to expand $JTESTS");
            }
            str = str.replace("$JTESTS", jtests);
        } else if (str.startsWith("$EXTRA_JTESTS")) {
            String extra_jtests;
            String string = extra_jtests = hd == null ? System.getProperty("EXTRA_JTESTS") : hd.getExtraTestDir();
            if (extra_jtests == null) {
                throw new HydraConfigException("Unable to expand $EXTRA_JTESTS");
            }
            str = str.replace("$EXTRA_JTESTS", extra_jtests);
        } else if (str.startsWith("$HADOOP_DIST")) {
            String hadoopDist = System.getProperty("HADOOP_DIST", "/export/gcm/where/java/hadoop/hdp-2.2.0.2.0.6.0-102");
            str = str.replace("$HADOOP_DIST", hadoopDist);
        } else if (str.startsWith("$GEMFIRE")) {
            String gemfire;
            String string = gemfire = hd == null ? System.getProperty("gemfire.home") : hd.getGemFireHome();
            if (gemfire == null) {
                throw new HydraConfigException("Unable to expand $GEMFIRE");
            }
            str = str.replace("$GEMFIRE", gemfire);
        } else if (str.contains("$REGRESSION_EXTRA_PATH")) {
            String rdir = System.getProperty("REGRESSION_EXTRA_PATH");
            if (rdir == null) {
                throw new HydraConfigException("Unable to expand $REGRESSION_EXTRA_PATH");
            }
            str = str.replace("$REGRESSION_EXTRA_PATH", rdir);
        } else if (str.startsWith("$PWD")) {
            String pwd;
            String string = pwd = hd == null ? System.getProperty("user.dir") : TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription().getUserDir();
            if (pwd == null) {
                throw new HydraConfigException("Unable to expand $PWD");
            }
            str = str.replace("$PWD", pwd);
        } else if (str.startsWith("$ANT_HOME")) {
            String antHome;
            String string = antHome = hd == null ? System.getProperty("ANT_HOME") : hd.getAntHome();
            if (antHome == null) {
                throw new HydraConfigException("Unable to expand $ANT_HOME");
            }
            str = str.replace("$ANT_HOME", antHome);
        }
        if (str.contains("$USER")) {
            String user = System.getProperty("user.name");
            if (user == null) {
                throw new HydraConfigException("Unable to expand $USER");
            }
            str = str.replace("$USER", user);
        }
        return str;
    }
}

