/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HydraRuntimeException;
import hydra.RemoteTestModule;
import java.io.Serializable;
import java.rmi.RemoteException;

public class DerbyServerHelper {
    public static Endpoint getEndpoint() {
        try {
            return RemoteTestModule.Master.getDerbyServerEndpoint();
        }
        catch (RemoteException e) {
            String s = "Unable to get derby server endpoint from master";
            throw new HydraRuntimeException(s, e);
        }
    }

    public static class Endpoint
    implements Serializable {
        String host;
        int port;
        int pid;

        public Endpoint(String host, int port, int pid) {
            if (host == null) {
                throw new IllegalArgumentException("host cannot be null");
            }
            this.host = host;
            this.port = port;
            this.pid = pid;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public int getPid() {
            return this.pid;
        }

        public String toString() {
            return "host=" + this.host + " port=" + this.port + " pid=" + this.pid;
        }
    }
}

