/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import bsh.EvalError;
import bsh.Interpreter;
import com.gemstone.gemfire.LogWriter;
import hydra.AdminDescription;
import hydra.AgentDescription;
import hydra.AsyncEventQueueDescription;
import hydra.BasePrms;
import hydra.BridgeDescription;
import hydra.CacheDescription;
import hydra.ClientDescription;
import hydra.ConfigLexer;
import hydra.DiskStoreDescription;
import hydra.EnvHelper;
import hydra.Fcn;
import hydra.FileUtil;
import hydra.FixedPartitionDescription;
import hydra.GatewayDescription;
import hydra.GatewayHubDescription;
import hydra.GatewayReceiverDescription;
import hydra.GatewaySenderDescription;
import hydra.GemFireDescription;
import hydra.HadoopDescription;
import hydra.HostAgentDescription;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadSubgroup;
import hydra.HydraVector;
import hydra.JProbeDescription;
import hydra.JUnitTestTask;
import hydra.Log;
import hydra.MasterDescription;
import hydra.OneOf;
import hydra.PartitionDescription;
import hydra.Range;
import hydra.RegionDescription;
import hydra.ResourceManagerDescription;
import hydra.RobinG;
import hydra.SSLDescription;
import hydra.SecurityDescription;
import hydra.TestConfig;
import hydra.TestFileUtil;
import hydra.TestTask;
import hydra.VmDescription;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigParser {
    private static final String INCLUDE = "include";
    private static final String RANDOMINCLUDE = "randomInclude";
    private static final String INCLUDEIFPRESENT = "includeIfPresent";
    private static final String UNITTEST = "unittest";
    private static final String TESTCLASS = "testClass";
    private static final String TESTMETHOD = "testMethod";
    private static final String STARTTASK = "starttask";
    private static final String INITTASK = "inittask";
    private static final String TASK = "task";
    private static final String CLOSETASK = "closetask";
    private static final String ENDTASK = "endtask";
    private static final String TASKCLASS = "taskClass";
    private static final String TASKMETHOD = "taskMethod";
    private static final String SEQUENTIAL = "sequential";
    private static final String BATCH = "batch";
    private static final String CLIENTNAMES = "clientNames";
    private static final String RUNMODE = "runMode";
    private static final String ALWAYS = "always";
    private static final String ONCE = "once";
    private static final String DYNAMIC = "dynamic";
    private static final String MAXTIMESTORUN = "maxTimesToRun";
    private static final String MAXTHREADS = "maxThreads";
    private static final String WEIGHT = "weight";
    private static final String STARTINTERVAL = "startInterval";
    private static final String ENDINTERVAL = "endInterval";
    private static final String THREADGROUP = "threadGroup";
    private static final String THREADGROUPS = "threadGroups";
    private static final String TOTALTHREADS = "totalThreads";
    private static final String TOTALVMS = "totalVMs";
    private static final String ASSIGNMENT = "assignment";
    private static final String FCN = "fcn";
    private static final String NCF = "ncf";
    private static final String ONEOF = "oneof";
    private static final String FOENO = "foeno";
    private static final String ROBING = "robing";
    private static final String GNIBOR = "gnibor";
    private static final String RANGE = "range";
    private static final String EGNAR = "egnar";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DASH = "-";
    private static final String EQUALS = "=";
    private static final String PLUSEQUALS = "+=";
    private static final String COMMA = ",";
    private static final String SEMI = ";";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static List Nonassignments = new ArrayList();

    private ConfigParser() {
    }

    private void parse(TestConfig tc, Vector tokens) {
        Vector<String> stmt = new Vector<String>();
        ListIterator i = tokens.listIterator();
        block2: while (i.hasNext()) {
            while (i.hasNext()) {
                String token = (String)i.next();
                if (token.equals(SEMI)) {
                    if (stmt.size() <= 0) continue;
                    try {
                        String type = this.parseStmt(tc, stmt);
                        if (!type.equals(ASSIGNMENT)) {
                            String s = this.reconstruct(stmt);
                            Nonassignments.add(s);
                        }
                    }
                    catch (HydraConfigException e) {
                        e.printStackTrace();
                        throw new HydraConfigException("Malformed statement:" + this.reconstruct(stmt), (Exception)((Object)e));
                    }
                    stmt.setSize(0);
                    continue block2;
                }
                stmt.add(token);
            }
        }
        if (stmt.size() > 0) {
            throw new HydraConfigException("Missing semicolon delimiter (;) at end of statement:" + this.reconstructMostly(stmt));
        }
    }

    private String parseStmt(TestConfig tc, Vector stmt) {
        String token = (String)stmt.elementAt(0);
        if (token.equalsIgnoreCase(UNITTEST)) {
            this.parseUnitTest(tc, stmt);
            return UNITTEST;
        }
        if (token.equalsIgnoreCase(STARTTASK)) {
            this.parseStartTask(tc, stmt);
            return STARTTASK;
        }
        if (token.equalsIgnoreCase(INITTASK)) {
            this.parseInitTask(tc, stmt);
            return INITTASK;
        }
        if (token.equalsIgnoreCase(TASK)) {
            this.parseTask(tc, stmt);
            return TASK;
        }
        if (token.equalsIgnoreCase(CLOSETASK)) {
            this.parseCloseTask(tc, stmt);
            return CLOSETASK;
        }
        if (token.equalsIgnoreCase(ENDTASK)) {
            this.parseEndTask(tc, stmt);
            return ENDTASK;
        }
        if (token.equalsIgnoreCase(THREADGROUP)) {
            this.parseThreadGroup(tc, stmt);
            return THREADGROUP;
        }
        this.parseAssignment(tc, stmt);
        return ASSIGNMENT;
    }

    private TestTask parseUnitTest(Vector stmt) {
        JUnitTestTask tt = new JUnitTestTask();
        ListIterator i = stmt.listIterator();
        i.next();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TESTCLASS)) {
                this.parseTestClass(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(TESTMETHOD)) {
                this.parseTestMethod(i, tt);
                continue;
            }
            throw new HydraConfigException("Unexpected token: " + token);
        }
        if (tt.getTestClasses().size() <= 0) {
            throw new HydraConfigException("Missing testClass");
        }
        return tt;
    }

    private TestTask parseStartAndEndTask(TestConfig tc, Vector stmt) {
        TestTask tt = new TestTask();
        ListIterator i = stmt.listIterator();
        i.next();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TASKCLASS)) {
                this.parseTaskClass(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(TASKMETHOD)) {
                this.parseTaskMethod(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(CLIENTNAMES)) {
                this.parseClientNames(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(BATCH)) {
                this.parseBatch(tt);
                continue;
            }
            i.previous();
            this.parseTaskAttribute(tc, i, tt);
        }
        this.checkTarget(tt);
        return tt;
    }

    private TestTask parseInitAndCloseTask(TestConfig tc, Vector stmt) {
        TestTask tt = new TestTask();
        ListIterator i = stmt.listIterator();
        i.next();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TASKCLASS)) {
                this.parseTaskClass(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(TASKMETHOD)) {
                this.parseTaskMethod(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(THREADGROUPS)) {
                this.parseThreadGroupNames(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(SEQUENTIAL)) {
                this.parseSequential(tt);
                continue;
            }
            if (token.equalsIgnoreCase(BATCH)) {
                this.parseBatch(tt);
                continue;
            }
            if (token.equalsIgnoreCase(RUNMODE)) {
                this.parseRunMode(i, tt);
                continue;
            }
            i.previous();
            this.parseTaskAttribute(tc, i, tt);
        }
        this.checkTarget(tt);
        return tt;
    }

    private TestTask parseComplexTask(TestConfig tc, Vector stmt) {
        TestTask tt = new TestTask();
        ListIterator i = stmt.listIterator();
        i.next();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TASKCLASS)) {
                this.parseTaskClass(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(TASKMETHOD)) {
                this.parseTaskMethod(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(THREADGROUPS)) {
                this.parseThreadGroupNames(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(MAXTIMESTORUN)) {
                this.parseMaxTimesToRun(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(MAXTHREADS)) {
                this.parseMaxThreads(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(WEIGHT)) {
                this.parseWeight(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(STARTINTERVAL)) {
                this.parseStartInterval(i, tt);
                continue;
            }
            if (token.equalsIgnoreCase(ENDINTERVAL)) {
                this.parseEndInterval(i, tt);
                continue;
            }
            i.previous();
            this.parseTaskAttribute(tc, i, tt);
        }
        this.checkTarget(tt);
        return tt;
    }

    private void checkTarget(TestTask tt) {
        if (tt.getReceiver() == null) {
            throw new HydraConfigException("Missing taskClass");
        }
        if (tt.getSelector() == null) {
            throw new HydraConfigException("Missing taskMethod");
        }
    }

    private void parseTaskClass(ListIterator i, TestTask tt) {
        if (tt.getReceiver() != null) {
            throw new HydraConfigException("Attempt to set taskClass more than once");
        }
        this.parseEquals(i);
        String jid = this.parseJavaIdentifier(i);
        tt.setReceiver(jid);
    }

    private void parseTaskMethod(ListIterator i, TestTask tt) {
        if (tt.getSelector() != null) {
            throw new HydraConfigException("Attempt to set taskMethod  more than once");
        }
        this.parseEquals(i);
        String jid = this.parseJavaIdentifier(i);
        tt.setSelector(jid);
    }

    private void parseTestClass(ListIterator i, JUnitTestTask tt) {
        this.parseEquals(i);
        String jid = this.parseJavaIdentifier(i);
        tt.addTestClass(jid);
    }

    private void parseTestMethod(ListIterator i, JUnitTestTask tt) {
        this.parseEquals(i);
        String jid = this.parseJavaIdentifier(i);
        tt.addTestMethod(jid);
    }

    private void parseSequential(TestTask tt) {
        tt.setSequential(true);
    }

    private void parseBatch(TestTask tt) {
        tt.setBatch(true);
    }

    private void parseRunMode(ListIterator i, TestTask tt) {
        if (tt.getRunMode() != -1) {
            throw new HydraConfigException("Attempt to set runMode  more than once");
        }
        this.parseEquals(i);
        this.parseRunModeValue(i, tt);
    }

    private void parseRunModeValue(ListIterator i, TestTask tt) {
        block5: {
            try {
                String token = (String)i.next();
                if (token.equalsIgnoreCase(ALWAYS)) {
                    tt.setRunMode(0);
                    break block5;
                }
                if (token.equalsIgnoreCase(ONCE)) {
                    tt.setRunMode(1);
                    break block5;
                }
                if (token.equalsIgnoreCase(DYNAMIC)) {
                    tt.setRunMode(2);
                    break block5;
                }
                throw new HydraConfigException("Illegal value for runMode");
            }
            catch (NoSuchElementException e) {
                throw new HydraConfigException("Missing assigned value for runMode");
            }
        }
    }

    private void parseClientNames(ListIterator i, TestTask tt) {
        HydraVector names;
        if (tt.getClientNames() == null) {
            this.parseEquals(i);
            names = this.parseUnterminatedCommaIdentifierList(i);
            if (names.size() == 0) {
                throw new HydraConfigException("Missing assigned value(s) for clientNames");
            }
        } else {
            throw new HydraConfigException("Attempt to set clientNames more than once");
        }
        tt.setClientNames(names);
    }

    private void parseThreadGroupNames(ListIterator i, TestTask tt) {
        HydraVector names;
        if (tt.getThreadGroupNames() == null) {
            this.parseEquals(i);
            names = this.parseUnterminatedCommaIdentifierList(i);
            if (names.size() == 0) {
                throw new HydraConfigException("Missing assigned value(s) for threadGroups");
            }
        } else {
            throw new HydraConfigException("Attempt to set threadGroups more than once");
        }
        tt.setThreadGroupNames(names);
    }

    private HydraVector parseUnterminatedCommaIdentifierList(ListIterator i) {
        HydraVector list = new HydraVector();
        Object identifier = this.parseIdentifier(i);
        if (identifier instanceof String) {
            if (((String)identifier).equals(COMMA)) {
                throw new HydraConfigException("Found comma instead of identifier");
            }
            list.add(identifier);
        } else if (identifier instanceof HydraVector) {
            list.addAll((HydraVector)identifier);
        } else {
            throw new HydraInternalException("Should not happen");
        }
        while (i.hasNext()) {
            identifier = this.parseIdentifier(i);
            if (identifier instanceof String) {
                if (identifier.equals(COMMA)) {
                    identifier = this.parseIdentifier(i);
                    if (identifier.equals(COMMA)) {
                        throw new HydraConfigException("Extra comma");
                    }
                    list.add(identifier);
                    continue;
                }
                i.previous();
                break;
            }
            if (identifier instanceof HydraVector) {
                list.addAll((HydraVector)identifier);
                continue;
            }
            throw new HydraInternalException("Should not happen");
        }
        return list;
    }

    private void parseMaxTimesToRun(ListIterator i, TestTask tt) {
        if (tt.getMaxTimesToRun() != -1) {
            throw new HydraConfigException("Attempt to set maxTimesToRun more than once");
        }
        this.parseEquals(i);
        int n = this.parseInteger(i);
        tt.setMaxTimesToRun(n);
    }

    private void parseMaxThreads(ListIterator i, TestTask tt) {
        if (tt.getMaxThreads() != -1) {
            throw new HydraConfigException("Attempt to set maxThreads more than once");
        }
        this.parseEquals(i);
        int n = this.parseInteger(i);
        tt.setMaxThreads(n);
    }

    private void parseWeight(ListIterator i, TestTask tt) {
        if (tt.getWeight() != -1) {
            throw new HydraConfigException("Attempt to set weight  more than once");
        }
        this.parseEquals(i);
        int n = this.parseInteger(i);
        tt.setWeight(n);
    }

    private void parseStartInterval(ListIterator i, TestTask tt) {
        if (tt.getStartInterval() != -1) {
            throw new HydraConfigException("Attempt to set startInterval more than once");
        }
        this.parseEquals(i);
        int n = this.parseInteger(i);
        tt.setStartInterval(n);
    }

    private void parseEndInterval(ListIterator i, TestTask tt) {
        if (tt.getEndInterval() != -1) {
            throw new HydraConfigException("Attempt to set endInterval more than once");
        }
        this.parseEquals(i);
        int n = this.parseInteger(i);
        tt.setEndInterval(n);
    }

    private boolean invalidTaskAttribute(String keystr) {
        return keystr.startsWith("hydra.AdminPrms") || keystr.startsWith("hydra.AgentPrms") || keystr.startsWith("hydra.BridgePrms") || keystr.startsWith("hydra.CachePrms") || keystr.startsWith("hydra.ClientCachePrms") || keystr.startsWith("hydra.PoolPrms") || keystr.startsWith("hydra.DiskStorePrms") || keystr.startsWith("hydra.GatewayReceiverPrms") || keystr.startsWith("hydra.GatewaySenderPrms") || keystr.startsWith("hydra.AsyncEventQueuePrms") || keystr.startsWith("hydra.GatewayPrms") || keystr.startsWith("hydra.GatewayHubPrms") || keystr.startsWith("hydra.FixedPartitionPrms") || keystr.startsWith("hydra.PartitionPrms") || keystr.startsWith("hydra.ResourceManagerPrms") || keystr.startsWith("hydra.SecurityPrms") || keystr.startsWith("hydra.RegionPrms") || keystr.startsWith("hydra.ClientRegionPrms") || keystr.startsWith("hydra.VersionPrms");
    }

    private void parseTaskAttribute(TestConfig tc, ListIterator i, TestTask tt) {
        String keystr = (String)i.next();
        if (this.invalidTaskAttribute(keystr)) {
            String s = "Illegal attempt to use as task attribute: " + keystr;
            throw new HydraConfigException(s);
        }
        i.previous();
        Long key = this.parseKey(tc, i);
        if (tt.getTaskAttributes().get(key) != null) {
            throw new HydraConfigException("Attempt to set task attribute " + key + " more than once");
        }
        this.parseEquals(i);
        ListIterator valuetokens = this.getNextAttributeValueIterator(i);
        if (valuetokens == null) {
            throw new HydraConfigException("Missing value for task attribute " + key);
        }
        Object value = this.parseValue(valuetokens);
        tt.setTaskAttribute(key, value);
    }

    private ListIterator getNextAttributeValueIterator(ListIterator i) {
        Vector valuetokens = this.getNextAttributeValue(i);
        return valuetokens.size() == 0 ? null : valuetokens.listIterator();
    }

    private Vector getNextAttributeValue(ListIterator i) {
        Vector<String> valuetokens = new Vector<String>();
        if (i.hasNext()) {
            String valuetoken1 = (String)i.next();
            if (valuetoken1.equals(EQUALS) || valuetoken1.equals(PLUSEQUALS)) {
                throw new HydraConfigException("Task attribute value cannot begin with \"= or +=\"");
            }
            if (i.hasNext()) {
                String valuetoken2 = (String)i.next();
                if (valuetoken2.equals(PLUSEQUALS)) {
                    throw new HydraConfigException("Task attribute value cannot use \"+=\"");
                }
                if (valuetoken2.equals(EQUALS)) {
                    i.previous();
                    i.previous();
                } else {
                    valuetokens.add(valuetoken1);
                    i.previous();
                    valuetokens.addAll(this.getNextAttributeValue(i));
                }
            } else {
                valuetokens.add(valuetoken1);
            }
        }
        return valuetokens;
    }

    private Object parseIdentifier(ListIterator i) {
        try {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                return "unknown";
            }
            if (token.indexOf("${") != -1) {
                return "unknown";
            }
            return token;
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing identifier");
        }
    }

    private String parseNumber(ListIterator i) {
        try {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                return "999";
            }
            if (token.indexOf("${") != -1) {
                return "999";
            }
            return token;
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing numeric value");
        }
    }

    private int parseInteger(ListIterator i) {
        String token = null;
        try {
            token = (String)i.next();
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                return 999;
            }
            if (token.indexOf("${") != -1) {
                return 999;
            }
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            String s = "Attempt to set value to non-integer: " + token;
            throw new HydraConfigException(s);
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing integer value");
        }
    }

    private String parseJavaIdentifier(ListIterator i) {
        try {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                return "ignore";
            }
            if (token.indexOf("${") != -1) {
                return "ignore";
            }
            return token;
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing java identifier");
        }
    }

    private void parseEquals(ListIterator i) {
        try {
            String token = (String)i.next();
            if (!token.equals(EQUALS)) {
                throw new HydraConfigException("Missing equals (=) operator, unexpected token: " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing equals (=) operator");
        }
    }

    private String parseEqualsOrPlusEquals(ListIterator i) {
        try {
            String token = (String)i.next();
            if (token.equals(EQUALS) || token.equals(PLUSEQUALS)) {
                return token;
            }
            throw new HydraConfigException("Missing equals (=) or (+=) operator, unexpected token: " + token);
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing equals (=) or (+=) operator");
        }
    }

    private void parseComma(ListIterator i) {
        try {
            String token = (String)i.next();
            if (!token.equals(COMMA)) {
                throw new HydraConfigException("Missing comma (,) delimiter, unexpected token: " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing comma (,) delimiter");
        }
    }

    private void parseUnitTest(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseUnitTest(stmt);
        tt.setTaskType(7);
        tc.addUnitTest(tt);
    }

    private void parseStartTask(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseStartAndEndTask(tc, stmt);
        tt.setTaskType(0);
        tc.addStartTask(tt);
    }

    private void parseInitTask(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseInitAndCloseTask(tc, stmt);
        tt.setTaskType(1);
        tc.addInitTask(tt);
    }

    private void parseTask(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseComplexTask(tc, stmt);
        tt.setTaskType(3);
        tc.addTask(tt);
    }

    private void parseCloseTask(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseInitAndCloseTask(tc, stmt);
        tt.setTaskType(5);
        tc.addCloseTask(tt);
    }

    private void parseEndTask(TestConfig tc, Vector stmt) {
        TestTask tt = this.parseStartAndEndTask(tc, stmt);
        tt.setTaskType(6);
        tc.addEndTask(tt);
    }

    private void parseThreadGroup(TestConfig tc, Vector stmt) {
        HydraThreadGroup tg = this.parseThreadGroup(stmt);
        if (tg.getName().equalsIgnoreCase("default")) {
            throw new HydraConfigException("Cannot define reserved threadgroup \"default\"");
        }
        tc.addThreadGroup(tg);
    }

    private HydraThreadGroup parseThreadGroup(Vector stmt) {
        ListIterator i = stmt.listIterator();
        i.next();
        String name = this.parseJavaIdentifier(i);
        HydraThreadGroup tg = new HydraThreadGroup(name);
        this.parseThreadSubgroups(i, tg);
        return tg;
    }

    private void parseThreadSubgroups(ListIterator i, HydraThreadGroup tg) {
        this.parseThreadSubgroup(i, tg);
        while (i.hasNext()) {
            this.parseThreadSubgroup(i, tg);
        }
    }

    private void parseThreadSubgroup(ListIterator i, HydraThreadGroup tg) {
        HydraThreadSubgroup tsg = new HydraThreadSubgroup(tg.getName());
        this.parseTotalThreads(i, tsg);
        this.parseTotalVMs(i, tsg);
        this.parseClientNames(i, tsg);
        tg.addSubgroup(tsg);
    }

    private void parseTotalThreads(ListIterator i, HydraThreadSubgroup tsg) {
        if (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TOTALTHREADS)) {
                this.parseEquals(i);
                int n = this.parseInteger(i);
                if (n <= 0) {
                    throw new HydraConfigException("Illegal value for totalThreads");
                }
                tsg.setTotalThreads(n);
                return;
            }
            throw new HydraConfigException("Expected token: totalThreads Found: " + token);
        }
        throw new HydraConfigException("Missing totalThreads");
    }

    private void parseTotalVMs(ListIterator i, HydraThreadSubgroup tsg) {
        if (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(TOTALVMS)) {
                this.parseEquals(i);
                int n = this.parseInteger(i);
                if (n <= 0) {
                    throw new HydraConfigException("Illegal value for totalVMs");
                }
                tsg.setTotalVMs(n);
                return;
            }
            i.previous();
            tsg.setTotalVMs(0);
            return;
        }
        tsg.setTotalVMs(0);
    }

    private void parseClientNames(ListIterator i, HydraThreadSubgroup tsg) {
        if (i.hasNext()) {
            String token = (String)i.next();
            if (token.equalsIgnoreCase(CLIENTNAMES)) {
                this.parseEquals(i);
                HydraVector names = this.parseUnterminatedCommaIdentifierList(i);
                if (names.size() == 0) {
                    throw new HydraConfigException("Missing assigned value(s) for clientNames");
                }
                tsg.setClientNames(names);
                return;
            }
            i.previous();
            tsg.setClientNames(null);
            return;
        }
        tsg.setClientNames(null);
    }

    private void parseAssignment(TestConfig tc, Vector stmt) {
        ListIterator i = stmt.listIterator();
        Long key = this.parseKey(tc, i);
        String type = this.parseEqualsOrPlusEquals(i);
        Object value = this.parseValue(i);
        if (type.equals(EQUALS)) {
            tc.addParameter(key, value);
        } else if (type.equals(PLUSEQUALS)) {
            tc.addToParameter(key, value);
        } else {
            throw new HydraInternalException("Should not happen");
        }
    }

    private Long parseKey(TestConfig tc, ListIterator i) {
        String fullname = (String)i.next();
        StringTokenizer st = new StringTokenizer(fullname, DASH, false);
        if (st.countTokens() != 2) {
            throw new HydraConfigException("Malformed key");
        }
        String clsname = st.nextToken();
        tc.addClassName(clsname);
        return BasePrms.keyForName(fullname);
    }

    private Object parseValue(ListIterator i) {
        HydraVector listOfLists = new HydraVector();
        Object list = this.parseList(i);
        listOfLists.add(list);
        boolean vecvec = false;
        while (i.hasNext()) {
            list = this.parseCommaList(i);
            listOfLists.add(list);
            vecvec = true;
        }
        if ((listOfLists = this.dealWithListValues(listOfLists)).size() == 0) {
            throw new HydraConfigException("Malformed value");
        }
        if (listOfLists.size() == 1) {
            return listOfLists.elementAt(0);
        }
        if (vecvec) {
            for (int n = 0; n < listOfLists.size(); ++n) {
                Object obj = listOfLists.elementAt(n);
                if (obj instanceof HydraVector) continue;
                listOfLists.setElementAt(new HydraVector(obj), n);
            }
        }
        return listOfLists;
    }

    private HydraVector dealWithListValues(HydraVector list) {
        HydraVector newList = new HydraVector();
        for (Object o : list) {
            if (o instanceof HydraVector) {
                newList.add(this.dealWithListValues((HydraVector)o));
                continue;
            }
            newList.add(o);
        }
        return newList;
    }

    private Object parseList(ListIterator i) {
        HydraVector list = new HydraVector();
        while (i.hasNext()) {
            Object listelement = this.parseListElement(i);
            if (listelement.equals(EQUALS) || listelement.equals(PLUSEQUALS)) {
                throw new HydraConfigException("Found delimiter \"= or +=\" in assigned value.  To include delimiters as values, use double quotes.");
            }
            if (listelement.equals(COMMA)) {
                i.previous();
                break;
            }
            list.add(listelement);
        }
        if (list.size() == 0) {
            throw new HydraConfigException("Missing assigned value(s)");
        }
        return list.size() == 1 ? list.elementAt(0) : list;
    }

    private Object parseCommaList(ListIterator i) {
        this.parseComma(i);
        return this.parseList(i);
    }

    private Object parseListElement(ListIterator i) {
        String token = (String)i.next();
        if (token.equalsIgnoreCase(RANGE)) {
            return this.parseRange(i);
        }
        if (token.equalsIgnoreCase(ONEOF)) {
            return this.parseOneOf(i);
        }
        if (token.equalsIgnoreCase(ROBING)) {
            return this.parseRobinG(i);
        }
        if (token.equalsIgnoreCase(FCN)) {
            i.previous();
            this.parseFunction(i);
            return "ignore";
        }
        if (token.indexOf("${") != -1) {
            return "ignore";
        }
        i.previous();
        return (String)this.parseIdentifier(i);
    }

    private Range parseRange(ListIterator i) {
        double hi;
        double lo;
        String lower = this.parseNumber(i);
        String upper = this.parseNumber(i);
        try {
            lo = Double.parseDouble(lower);
        }
        catch (NumberFormatException e) {
            String s = "RANGE contains non-numeric value: " + lower;
            throw new HydraConfigException(s);
        }
        try {
            hi = Double.parseDouble(upper);
        }
        catch (NumberFormatException e) {
            String s = "RANGE contains non-numeric value: " + upper;
            throw new HydraConfigException(s);
        }
        try {
            String token = (String)i.next();
            if (!token.equalsIgnoreCase(EGNAR)) {
                throw new HydraConfigException("Unexpected token in RANGE (expected EGNAR): " + token);
            }
        }
        catch (NoSuchElementException e) {
            throw new HydraConfigException("Missing EGNAR terminator at end of RANGE");
        }
        return new Range(lo, hi);
    }

    private OneOf parseOneOf(ListIterator i) {
        String token;
        Vector<Object> vals = new Vector<Object>();
        while (i.hasNext() && !(token = (String)i.next()).equalsIgnoreCase(FOENO)) {
            if (token.equalsIgnoreCase(RANGE)) {
                vals.add(this.parseRange(i));
                continue;
            }
            if (token.equalsIgnoreCase(ONEOF)) {
                vals.add(this.parseOneOf(i));
                continue;
            }
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                vals.add("ignore");
                continue;
            }
            if (token.indexOf("${") != -1) {
                vals.add("ignore");
                continue;
            }
            vals.add(token);
        }
        if (vals.size() > 0) {
            return new OneOf(vals);
        }
        throw new HydraConfigException("ONEOF contains no values");
    }

    private RobinG parseRobinG(ListIterator i) {
        String token;
        Vector<Object> vals = new Vector<Object>();
        while (i.hasNext() && !(token = (String)i.next()).equalsIgnoreCase(GNIBOR)) {
            if (token.equalsIgnoreCase(RANGE)) {
                vals.add(this.parseRange(i));
                continue;
            }
            if (token.equalsIgnoreCase(ONEOF)) {
                vals.add(this.parseOneOf(i));
                continue;
            }
            if (token.equalsIgnoreCase(ROBING)) {
                vals.add(this.parseRobinG(i));
                continue;
            }
            if (token.equalsIgnoreCase(FCN)) {
                i.previous();
                this.parseFunction(i);
                vals.add("ignore");
                continue;
            }
            if (token.indexOf("${") != -1) {
                vals.add("ignore");
                continue;
            }
            vals.add(token);
        }
        if (vals.size() > 0) {
            return new RobinG(vals);
        }
        throw new HydraConfigException("ROBING contains no values");
    }

    private String reconstruct(Vector stmt) {
        return this.reconstructMostly(stmt) + SEMI;
    }

    private String reconstructMostly(Vector stmt) {
        StringBuffer buf = new StringBuffer(100);
        ListIterator i = stmt.listIterator();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (token.indexOf(SPACE) != -1) {
                buf.append("\"").append(token).append("\"");
            } else if (token.indexOf(EQUALS) != -1) {
                if (token.equals(EQUALS) || token.equals(PLUSEQUALS)) {
                    buf.append(token);
                } else {
                    buf.append("\"").append(token).append("\"");
                }
            } else {
                buf.append(token);
            }
            if (!i.hasNext()) continue;
            buf.append(SPACE);
        }
        return buf.toString();
    }

    private Vector tokenize(String fn, TestConfig tc, String localConf) throws FileNotFoundException {
        ConfigParser.log().info("PASS 1a: getText: " + fn);
        String pass1 = this.getText(fn);
        if (localConf != null) {
            ConfigParser.log().info("PASS 1b: getText: " + localConf);
            pass1 = pass1 + this.getText(localConf);
        }
        ConfigParser.log().info("PASS 2: getTokens: " + fn);
        Vector pass2 = ConfigLexer.tokenize(pass1);
        ConfigParser.log().info("PASS 3: expandSystemProperties: " + fn);
        Vector pass3 = this.expandSystemProperties(tc, pass2);
        ConfigParser.log().info("PASS 4: expandFunctions: " + fn);
        Vector pass4 = this.expandFunctions(tc, pass3);
        ConfigParser.log().info("PASS 5: expandIncludes: " + fn);
        Vector pass5 = this.expandIncludes(tc, pass4);
        return pass5;
    }

    private String getText(String fn) throws FileNotFoundException {
        if (fn.indexOf("${") != -1) {
            return "";
        }
        try {
            return FileUtil.getText(fn);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            String s = "Error reading hydra configuration file " + fn;
            throw new HydraRuntimeException(s);
        }
    }

    private Vector expandSystemProperties(TestConfig tc, Vector tokens) {
        Vector<String> expandedTokens = new Vector<String>();
        if (tokens != null) {
            ListIterator i = tokens.listIterator();
            while (i.hasNext()) {
                String token = (String)i.next();
                expandedTokens.add(this.expandSystemProperties(tc, token));
            }
        }
        return expandedTokens;
    }

    private String expandSystemProperties(TestConfig tc, String token) {
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator i = new StringCharacterIterator(token);
        while (i.current() != '\uffff') {
            char c = i.current();
            block0 : switch (c) {
                case '$': {
                    char cc = i.next();
                    switch (cc) {
                        case '{': {
                            this.gobbleProperty(tc, i, buf, false);
                            break block0;
                        }
                    }
                    buf.append(c);
                    buf.append(cc);
                    break;
                }
                default: {
                    if (c == '\uffff') break;
                    buf.append(c);
                }
            }
            i.next();
        }
        return buf.toString();
    }

    private String gobbleProperty(TestConfig tc, StringCharacterIterator i, StringBuffer buf, boolean nested) {
        StringBuffer propKey = new StringBuffer();
        block7: while (i.current() != '\uffff') {
            char c = i.next();
            switch (c) {
                case '$': {
                    char cc = i.next();
                    switch (cc) {
                        case '{': {
                            String nestedPropVal = this.gobbleProperty(tc, i, buf, true);
                            propKey.append(nestedPropVal);
                            continue block7;
                        }
                    }
                    buf.append(c);
                    buf.append(cc);
                    continue block7;
                }
                case '}': {
                    String propVal = System.getProperty(propKey.toString());
                    if (propVal == null) {
                        String s = "No system property set for " + propKey;
                        throw new HydraConfigException(s);
                    }
                    if (!nested) {
                        buf.append(propVal);
                    }
                    tc.addSystemProperty(propKey.toString(), propVal);
                    return propVal.toString();
                }
            }
            if (c == '\uffff') continue;
            propKey.append(c);
        }
        throw new HydraConfigException("Incomplete system property: " + propKey);
    }

    private Vector expandFunctions(TestConfig tc, Vector tokens) {
        Vector<String> expandedTokens = new Vector<String>();
        if (tokens != null) {
            ListIterator i = tokens.listIterator();
            while (i.hasNext()) {
                String token = (String)i.next();
                if (token.equalsIgnoreCase(FCN)) {
                    i.previous();
                    expandedTokens.addAll(this.expandFunction(i));
                    continue;
                }
                expandedTokens.add(token);
            }
        }
        return expandedTokens;
    }

    private Vector expandFunction(ListIterator i) {
        Vector tokens = this.parseFunction(i);
        String result = this.evaluateFunction(tokens);
        return ConfigLexer.tokenize(result);
    }

    private Vector parseFunction(ListIterator i) {
        Vector<String> tokens = new Vector<String>();
        String token = (String)i.next();
        if (!token.equalsIgnoreCase(FCN)) {
            String s = "Expected the fcn keyword: " + token;
            throw new HydraInternalException(s);
        }
        while (i.hasNext() && !(token = (String)i.next()).equalsIgnoreCase(NCF)) {
            tokens.add(token);
        }
        if (tokens.size() == 0) {
            String s = "FCN is empty";
            throw new HydraConfigException(s);
        }
        return tokens;
    }

    private String evaluateFunction(Vector tokens) {
        Object o;
        Fcn fcn = new Fcn(tokens);
        String fcnstr = fcn.toBeanshellString();
        Interpreter interpreter = new Interpreter();
        try {
            o = interpreter.eval(fcnstr);
        }
        catch (EvalError e) {
            String s = "Unable to evaluate beanshell function: " + fcnstr;
            throw new HydraConfigException(s, (Exception)((Object)e));
        }
        String result = o.toString();
        return result;
    }

    private Vector expandIncludes(TestConfig tc, Vector tokens) throws FileNotFoundException {
        Vector<String> expandedTokens = new Vector<String>();
        if (tokens != null) {
            ListIterator i = tokens.listIterator();
            while (i.hasNext()) {
                String token = (String)i.next();
                if (token.equalsIgnoreCase(INCLUDE)) {
                    i.previous();
                    if (token.indexOf("${") == -1) {
                        expandedTokens.addAll(this.expandInclude(i, tc, true));
                        continue;
                    }
                    expandedTokens.add(INCLUDE);
                    expandedTokens.add(this.parseInclude(i));
                    expandedTokens.add(SEMI);
                    continue;
                }
                if (token.equalsIgnoreCase(RANDOMINCLUDE) && tc.getRandomSeed() != -1L && tc.getParameters().getRandGen().nextBoolean()) {
                    i.previous();
                    if (token.indexOf("${") == -1) {
                        expandedTokens.addAll(this.expandRandomInclude(i, tc, true));
                        continue;
                    }
                    expandedTokens.add(INCLUDE);
                    expandedTokens.add(this.parseRandomInclude(i));
                    expandedTokens.add(SEMI);
                    continue;
                }
                if (token.equalsIgnoreCase(RANDOMINCLUDE)) {
                    i.previous();
                    if (token.indexOf("${") != -1) continue;
                    this.expandRandomInclude(i, tc, true);
                    continue;
                }
                if (token.equalsIgnoreCase(INCLUDEIFPRESENT)) {
                    i.previous();
                    if (token.indexOf("${") == -1) {
                        expandedTokens.addAll(this.expandInclude(i, tc, false));
                        continue;
                    }
                    expandedTokens.add(INCLUDE);
                    expandedTokens.add(this.parseInclude(i));
                    expandedTokens.add(SEMI);
                    continue;
                }
                expandedTokens.add(token);
            }
        }
        return expandedTokens;
    }

    private Vector expandInclude(ListIterator i, TestConfig tc, boolean required) throws FileNotFoundException {
        String fn = this.parseInclude(i);
        fn = EnvHelper.expandEnvVars(fn, tc.getMasterDescription().getVmDescription().getHostDescription());
        try {
            return this.tokenize(fn, tc, null);
        }
        catch (FileNotFoundException e) {
            if (required) {
                throw e;
            }
            return new Vector();
        }
    }

    private Vector expandRandomInclude(ListIterator i, TestConfig tc, boolean required) throws FileNotFoundException {
        String fn = this.parseRandomInclude(i);
        fn = EnvHelper.expandEnvVars(fn, tc.getMasterDescription().getVmDescription().getHostDescription());
        try {
            return this.tokenize(fn, tc, null);
        }
        catch (FileNotFoundException e) {
            if (required) {
                throw e;
            }
            return new Vector();
        }
    }

    private String parseInclude(ListIterator i) {
        Vector<String> tokens = new Vector<String>();
        String token = (String)i.next();
        if (!token.equalsIgnoreCase(INCLUDE)) {
            String s = "Expected the include keyword: " + token;
            throw new HydraInternalException(s);
        }
        while (i.hasNext() && !(token = (String)i.next()).equals(SEMI)) {
            tokens.add(token);
        }
        if (tokens.size() == 0) {
            String s = "INCLUDE is empty";
            throw new HydraConfigException(s);
        }
        if (tokens.size() == 1) {
            return (String)tokens.get(0);
        }
        String s = "Missing ; at end of statement: include" + tokens.get(0);
        throw new HydraConfigException(s);
    }

    private String parseRandomInclude(ListIterator i) {
        Vector<String> tokens = new Vector<String>();
        String token = (String)i.next();
        if (!token.equalsIgnoreCase(RANDOMINCLUDE)) {
            String s = "Expected the randomInclude keyword: " + token;
            throw new HydraInternalException(s);
        }
        while (i.hasNext() && !(token = (String)i.next()).equals(SEMI)) {
            tokens.add(token);
        }
        if (tokens.size() == 0) {
            String s = "RANDOMINCLUDE is empty";
            throw new HydraConfigException(s);
        }
        if (tokens.size() == 1) {
            return (String)tokens.get(0);
        }
        String s = "Missing ; at end of statement: randomInclude" + tokens.get(0);
        throw new HydraConfigException(s);
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    protected static void reset() {
        Nonassignments = new ArrayList();
    }

    private static void writeStmtsToFile(TestConfig tc, String fn) {
        StringBuffer buf = new StringBuffer();
        for (String stmt : Nonassignments) {
            buf.append(stmt).append(NEWLINE);
        }
        SortedMap assignments = TestConfig.tab().toSortedMap(true);
        for (String key : assignments.keySet()) {
            String val = (String)assignments.get(key);
            String stmt = key + SPACE + EQUALS + SPACE + val + SEMI;
            buf.append(stmt).append(NEWLINE);
        }
        FileUtil.writeToFile(fn, buf.toString());
    }

    private static void parseFileMultiPass(String fn, TestConfig tc) throws FileNotFoundException {
        ConfigParser.log().info("Parsing configuration file: " + fn);
        ConfigParser parser = new ConfigParser();
        String localConf = FileUtil.fileExists("local.conf") ? "local.conf" : null;
        Vector tokens = parser.tokenize(fn, tc, localConf);
        parser.parse(tc, tokens);
        ConfigParser.log().info("Parsed configuration file: " + fn);
    }

    public static void parseFile(String fn, TestConfig tc, String outfn) throws FileNotFoundException {
        ConfigParser.parseFileMultiPass(fn, tc);
        if (outfn != null) {
            ConfigParser.writeStmtsToFile(tc, outfn);
        }
    }

    private static void parseConfigFile(String configFileName, boolean print) {
        TestConfig tc = TestConfig.create();
        tc.setRandomSeed(tc.generateRandomSeed());
        MasterDescription.configure(tc);
        int index = configFileName.indexOf(".conf");
        if (index != -1) {
            String propFileName = configFileName.substring(0, index) + ".prop";
            try {
                FileInputStream fis = new FileInputStream(propFileName);
                Properties p = new Properties();
                p.load(fis);
                Enumeration<?> names = p.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    System.setProperty(name, p.getProperty(name));
                }
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                String s = "Unable to load test properties from " + propFileName;
                throw new HydraConfigException(s);
            }
        }
        ConfigParser.log().info("Parsing hydra configuration file: " + configFileName + "...");
        try {
            ConfigParser.parseFile(configFileName, tc, "latest.conf");
        }
        catch (FileNotFoundException e) {
            throw new HydraConfigException("Hydra configuration file not found: " + configFileName, e);
        }
        HostDescription.configure(tc);
        HadoopDescription.configure(tc);
        JProbeDescription.configure(tc);
        SSLDescription.configure(tc);
        SecurityDescription.configure(tc);
        GemFireDescription.configure(tc);
        VmDescription.configure(tc);
        HostAgentDescription.configure(tc);
        AdminDescription.configure(tc);
        AgentDescription.configure(tc);
        ClientDescription.configure(tc);
        DiskStoreDescription.configure(tc);
        BridgeDescription.configure(tc);
        FixedPartitionDescription.configure(tc);
        PartitionDescription.configure(tc);
        RegionDescription.configure(tc);
        ResourceManagerDescription.configure(tc);
        CacheDescription.configure(tc);
        GatewayReceiverDescription.configure(tc);
        GatewaySenderDescription.configure(tc);
        AsyncEventQueueDescription.configure(tc);
        GatewayDescription.configure(tc);
        GatewayHubDescription.configure(tc);
        String testDir = tc.getMasterDescription().getVmDescription().getHostDescription().getTestDir();
        if (configFileName.startsWith(testDir)) {
            tc.setTestName(configFileName.substring(testDir.length() + 1));
        } else {
            tc.setTestName(configFileName);
        }
        tc.setTestUser(System.getProperty("user.name"));
        tc.postprocess();
        if (print) {
            System.out.println(tc);
        }
        TestConfig.destroy();
    }

    private static void parseConfigFiles() {
        ConfigParser.log().info("Validating hydra configuration files...");
        List configFiles = TestFileUtil.getConfigFiles();
        for (File configFile : configFiles) {
            try {
                ConfigParser.log().info("Validating " + configFile);
                ConfigParser.parseConfigFile(configFile.toString(), false);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable e) {
                String s = "While parsing \"" + configFile + "\": " + e;
                throw new HydraConfigException(s, e);
            }
        }
        ConfigParser.log().info("Done validating hydra configuration files");
    }

    public static void main(String[] args) {
        Log.createLogWriter("parser", "fine");
        if (args.length == 0) {
            ConfigParser.parseConfigFiles();
        } else if (args.length == 1) {
            String configFileName = args[0];
            ConfigParser.parseConfigFile(configFileName, true);
        } else {
            throw new HydraRuntimeException("Usage: hydra.ConfigParser [configFile]");
        }
    }
}

