/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.ComplexTaskScheduler;
import hydra.TestConfig;
import java.util.Vector;

public class ComplexSerialTaskScheduler
extends ComplexTaskScheduler {
    public ComplexSerialTaskScheduler(String name, Vector tasks, String purpose, long totalTaskTimeSec) {
        super(name, tasks, purpose, totalTaskTimeSec);
    }

    @Override
    protected boolean executeTasks() {
        long now;
        int count;
        this.initializeTaskTimes();
        do {
            int i;
            ClientRecord client;
            Vector<ClientRecord> clients = new Vector<ClientRecord>();
            now = System.currentTimeMillis();
            for (ClientVmRecord vm : this.vms.values()) {
                if (vm.isDynamic()) continue;
                for (ClientRecord client2 : vm.getClients().values()) {
                    if (!this.hasTask(client2, now)) continue;
                    clients.add(client2);
                }
            }
            count = clients.size();
            if (count == 0 || !this.schedule(client = (ClientRecord)clients.get(i = TestConfig.tab().getRandGen().nextInt(0, count - 1)), now = System.currentTimeMillis(), this)) continue;
            now = this.waitForClientToFinish(client);
        } while (!this.terminateScheduling(count, now));
        this.log.info(this.name + " terminating scheduling because " + this.termination);
        this.waitForDynamicThreadsToFinish();
        return this.schedulerResult();
    }
}

