/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ClientNameTaskScheduler;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.TestTask;
import java.util.Vector;

public class ClientNameLockStepTaskScheduler
extends ClientNameTaskScheduler {
    public ClientNameLockStepTaskScheduler(String name, Vector tasks, String purpose) {
        super(name, tasks, purpose);
    }

    @Override
    protected boolean executeTasks() {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TestTask task = (TestTask)this.tasks.get(i);
            this.schedule(task);
            if (!this.executedNormally()) break;
        }
        return this.schedulerResult();
    }

    private void schedule(TestTask task) {
        Vector<ClientRecord> clients = new Vector<ClientRecord>();
        long now = System.currentTimeMillis();
        for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                if (!this.schedule(client, task, now)) continue;
                clients.add(client);
            }
        }
        this.waitForClientsToFinish(clients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule(ClientRecord client, TestTask task, long now) {
        if (task.getClientNames().contains(client.vm().getClientName())) {
            client.setBusy(true);
            client.setTask(task);
            client.setStartTime(now);
            TestTask testTask = task;
            synchronized (testTask) {
                task.incrementNumTimesInUse();
            }
            this.assignTask(client, task);
            return true;
        }
        return false;
    }
}

