/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.BridgePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class BridgeDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer capacity;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private String evictionPolicy;
    private String[] groups;
    private Long loadPollInterval;
    private String loadProbe;
    private Integer maxConnections;
    private Integer maxThreads;
    private Integer maximumMessageCount;
    private Integer maximumTimeBetweenPings;
    private Integer messageTimeToLive;
    private Integer socketBufferSize;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getCapacity() {
        return this.capacity;
    }

    private void setCapacity(Integer i) {
        this.capacity = i;
    }

    private String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    private void setEvictionPolicy(String str) {
        this.evictionPolicy = str;
    }

    protected String[] getGroups() {
        return this.groups;
    }

    private void setGroups(String[] s) {
        this.groups = s;
    }

    public Long getLoadPollInterval() {
        return this.loadPollInterval;
    }

    public void setLoadPollInterval(Long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    public String getLoadProbe() {
        return this.loadProbe;
    }

    public void setLoadProbe(String loadProbe) {
        this.loadProbe = loadProbe;
    }

    private Integer getMaxConnections() {
        return this.maxConnections;
    }

    private void setMaxConnections(Integer i) {
        this.maxConnections = i;
    }

    private Integer getMaxThreads() {
        return this.maxThreads;
    }

    private void setMaxThreads(Integer i) {
        this.maxThreads = i;
    }

    private Integer getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    private void setMaximumMessageCount(Integer i) {
        this.maximumMessageCount = i;
    }

    private Integer getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    private void setMaximumTimeBetweenPings(Integer i) {
        this.maximumTimeBetweenPings = i;
    }

    private Integer getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    private void setMessageTimeToLive(Integer i) {
        this.messageTimeToLive = i;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    protected void configure(CacheServer c, int port) {
        ClientSubscriptionConfig csg = c.getClientSubscriptionConfig();
        csg.setCapacity(this.getCapacity().intValue());
        if (this.getDiskStoreDescription() != null) {
            csg.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        csg.setEvictionPolicy(this.getEvictionPolicy());
        c.setGroups(this.getGroups());
        c.setLoadPollInterval(this.getLoadPollInterval().longValue());
        c.setLoadProbe(this.getLoadProbe(this.getLoadProbe()));
        c.setMaxConnections(this.getMaxConnections().intValue());
        c.setMaxThreads(this.getMaxThreads().intValue());
        c.setMaximumMessageCount(this.getMaximumMessageCount().intValue());
        c.setMaximumTimeBetweenPings(this.getMaximumTimeBetweenPings().intValue());
        c.setMessageTimeToLive(this.getMessageTimeToLive().intValue());
        c.setPort(port);
        c.setSocketBufferSize(this.getSocketBufferSize().intValue());
    }

    private ServerLoadProbe getLoadProbe(String probeClass) {
        try {
            return (ServerLoadProbe)BridgeDescription.getInstance(BridgePrms.loadProbe, probeClass);
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(BridgePrms.loadProbe) + " does not implement ServerLoadProbe: " + probeClass;
            throw new HydraConfigException(s);
        }
    }

    protected static synchronized String bridgeServerToString(CacheServer c) {
        StringBuffer buf = new StringBuffer();
        ClientSubscriptionConfig csg = c.getClientSubscriptionConfig();
        buf.append("\n  capacity: " + csg.getCapacity());
        buf.append("\n  diskStoreName: " + csg.getDiskStoreName());
        buf.append("\n  evictionPolicy: " + csg.getEvictionPolicy());
        buf.append("\n  groups: " + Arrays.asList(c.getGroups()));
        buf.append("\n  loadPollInterval: " + c.getLoadPollInterval());
        buf.append("\n  loadProbe: " + c.getLoadProbe());
        buf.append("\n  maxConnections: " + c.getMaxConnections());
        buf.append("\n  maxThreads: " + c.getMaxThreads());
        buf.append("\n  maximumMessageCount: " + c.getMaximumMessageCount());
        buf.append("\n  maximumTimeBetweenPings: " + c.getMaximumTimeBetweenPings());
        buf.append("\n  messageTimeToLive: " + c.getMessageTimeToLive());
        buf.append("\n  port: " + c.getPort());
        buf.append("\n  socketBufferSize: " + c.getSocketBufferSize());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "capacity", this.getCapacity());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "evictionPolicy", this.getEvictionPolicy());
        map.put(header + "groups", Arrays.asList(this.getGroups()));
        map.put(header + "loadPollInterval", this.getLoadPollInterval());
        map.put(header + "loadProbe", this.getLoadProbe());
        map.put(header + "maxConnections", this.getMaxConnections());
        map.put(header + "maxThreads", this.getMaxThreads());
        map.put(header + "maximumMessageCount", this.getMaximumMessageCount());
        map.put(header + "maximumTimeBetweenPings", this.getMaximumTimeBetweenPings());
        map.put(header + "messageTimeToLive", this.getMessageTimeToLive());
        map.put(header + "port", "autogenerated");
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(BridgePrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            BridgeDescription bd = BridgeDescription.createBridgeDescription(name, config, i);
            config.addBridgeDescription(bd);
        }
    }

    private static BridgeDescription createBridgeDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        BridgeDescription bd = new BridgeDescription();
        bd.setName(name);
        Long key = BridgePrms.capacity;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(1);
        }
        bd.setCapacity(i);
        key = BridgePrms.diskStoreName;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            bd.setDiskStoreDescription(BridgeDescription.getDiskStoreDescription(str, key, config));
            bd.setDiskStoreName("DiskStoreDescription." + str);
        }
        str = (str = tab.getString(key = BridgePrms.evictionPolicy, tab.getWild(key, index, null))) == null ? "none" : BridgeDescription.getEvictionPolicy(str, key);
        bd.setEvictionPolicy(str);
        key = BridgePrms.groups;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str2 = tab.getString(key, i2.next());
                if (str2 != null) continue;
                i2.remove();
            }
        }
        if (strs == null || strs.size() == 0) {
            bd.setGroups(CacheServer.DEFAULT_GROUPS);
        } else {
            String[] stray = new String[strs.size()];
            for (int i3 = 0; i3 < strs.size(); ++i3) {
                stray[i3] = (String)strs.get(i3);
            }
            bd.setGroups(stray);
        }
        key = BridgePrms.loadPollInterval;
        Long l = tab.getLong(key, tab.getWild(key, index, null));
        if (l == null) {
            l = new Long(5000L);
        }
        bd.setLoadPollInterval(l);
        key = BridgePrms.loadProbe;
        String s = tab.getString(key, tab.getWild(key, index, null));
        if (s == null) {
            s = CacheServer.DEFAULT_LOAD_PROBE.getClass().getName();
        }
        bd.setLoadProbe(s);
        key = BridgePrms.maxConnections;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(800);
        }
        bd.setMaxConnections(i);
        key = BridgePrms.maxThreads;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(0);
        }
        bd.setMaxThreads(i);
        key = BridgePrms.maximumMessageCount;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(230000);
        }
        bd.setMaximumMessageCount(i);
        key = BridgePrms.maximumTimeBetweenPings;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(60000);
        }
        bd.setMaximumTimeBetweenPings(i);
        key = BridgePrms.messageTimeToLive;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(180);
        }
        bd.setMessageTimeToLive(i);
        key = BridgePrms.socketBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(32768);
        }
        bd.setSocketBufferSize(i);
        if (bd.getDiskStoreName() == null && bd.getEvictionPolicy() != "none") {
            String s2 = BasePrms.nameForKey(BridgePrms.evictionPolicy) + " (" + bd.getEvictionPolicy() + ") requires a " + BasePrms.nameForKey(BridgePrms.diskStoreName);
            throw new HydraRuntimeException(s2);
        }
        return bd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private static String getEvictionPolicy(String str, Long key) {
        if (str.equalsIgnoreCase("entry") || str.equalsIgnoreCase("entries")) {
            return "entry";
        }
        if (str.equalsIgnoreCase("mem") || str.equalsIgnoreCase("memory")) {
            return "mem";
        }
        if (str.equalsIgnoreCase("none")) {
            return "none";
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }
}

