/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BootstrapperProxyIF;
import java.rmi.Naming;
import java.util.Arrays;

public class BootstrapperClient {
    public static void main(String[] args) {
        if (args.length < 2) {
            BootstrapperClient.err("Usage: hydra.BootstrapperClient bootstrapperURL command [args]");
        }
        String url = args[0];
        String[] cmd = new String[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            cmd[i] = args[i + 1];
        }
        System.out.println("Executing " + Arrays.asList(cmd) + " at " + url);
        BootstrapperProxyIF bootstrapper = BootstrapperClient.lookup(url);
        if (bootstrapper == null) {
            BootstrapperClient.err("Unable to find bootstrapper at " + url);
        }
        String output = null;
        try {
            output = cmd.length == 1 ? bootstrapper.fgexec(cmd[0], 120) : bootstrapper.fgexec(cmd, 120);
            if (output != null && output.length() > 0) {
                System.out.println(output);
            }
        }
        catch (Throwable t) {
            if (output != null && output.length() > 0) {
                System.out.println(output);
            }
            BootstrapperClient.err("Unable to run command.  See also bootstrapper log at " + url, t);
        }
        System.out.println("Executed " + Arrays.asList(cmd) + " at " + url);
    }

    private static BootstrapperProxyIF lookup(String url) {
        System.out.println("Looking up bootstrapper at " + url);
        try {
            return (BootstrapperProxyIF)Naming.lookup(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void err(String msg) {
        BootstrapperClient.err(msg, null);
    }

    private static void err(String msg, Throwable t) {
        System.out.println(msg);
        if (t != null) {
            t.printStackTrace();
        }
        System.exit(1);
    }
}

