/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientMgr;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.ComplexTaskScheduler;
import hydra.DynamicActionException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.MethExecutorResult;
import hydra.RemoteTestModuleIF;
import hydra.ResultLogger;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TaskScheduler;
import hydra.TestTask;
import hydra.TestTaskResult;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class BaseTaskScheduler
implements TaskScheduler {
    private static final String SCHEDULING_MSG = "Scheduler waiting for idle clients with eligible tasks...";
    private static final String BLOCKING_MSG = "Waiting for dynamic client VM actions to complete...";
    protected String name;
    protected Map vms;
    protected Vector tasks;
    protected String purpose;
    protected boolean haltIfBadResult;
    protected boolean disconnect = true;
    private long maxResultWaitSec;
    private long maxResultWaitMs;
    private int tsid = -1;
    private static int nextTsid = 0;
    private long lastschedulingreporttime = 0L;
    private long lastwaitingreporttime = 0L;
    private long maxwaitingreporttime = 0L;
    private long lastblockingreporttime = 0L;
    protected String termination;
    protected LogWriter log;
    private static Map TaskSchedulers = new HashMap();
    private static Object TerminationLock = new Object();
    private static volatile boolean HadFatalTaskError = false;
    private static volatile boolean ExceededMaxResultWaitSec = false;
    private static volatile boolean HadStatMonitorError = false;
    private static volatile boolean HadDynamicActionError = false;
    private static volatile boolean HadDynamicActionHang = false;

    public BaseTaskScheduler(String name, Vector tasks, String purpose) {
        this.name = name;
        this.tasks = tasks;
        this.purpose = purpose;
        this.tsid = BaseTaskScheduler.nextTsid();
        this.log = Log.getLogWriter();
        BaseTaskScheduler.addTaskScheduler(this.tsid, this);
    }

    @Override
    public void createClients(Map cds, Map tgs) {
        this.log.info("Creating the client vms for " + this.name);
        this.vms = ClientMgr.createClients(cds.values(), tgs);
        this.log.info("Created the client vms for " + this.name + ": " + this.vms.values());
    }

    @Override
    public void startClients() {
        if (this.vms == null) {
            throw new HydraInternalException("no client vms found");
        }
        this.log.info("Starting the client vms for " + this.name + ": " + this.vms.values());
        try {
            ClientMgr.startClients(this.purpose, this.vms);
            ClientMgr.waitForClientsToRegister(this.vms);
        }
        catch (HydraTimeoutException e) {
            ResultLogger.reportHang("Timeout starting clients for " + this.name, (Throwable)((Object)e));
            throw e;
        }
        this.log.info("Started the client vms for " + this.name + ": " + this.vms.values());
    }

    @Override
    public void startClientsForced() {
        HadFatalTaskError = false;
        ExceededMaxResultWaitSec = false;
        HadStatMonitorError = false;
        HadDynamicActionError = false;
        HadDynamicActionHang = false;
        this.startClients();
    }

    @Override
    public void stopClients() {
        if (this.vms == null) {
            throw new HydraInternalException("no client vms found");
        }
        try {
            if (ExceededMaxResultWaitSec || HadDynamicActionHang) {
                String s = "Possible hung clients for " + this.name + ". Leaving the client vms running so they can be investigated.";
                this.log.severe(s);
                ClientMgr.runClientShutdownHooks(this.vms);
            } else if (HadFatalTaskError || HadDynamicActionError || HadStatMonitorError) {
                MasterController.dumpStacksOnError(2);
                this.log.info("Stopping the client vms for " + this.name + ": " + this.vms.values());
                ClientMgr.stopClients(this.vms, false, true);
                ClientMgr.waitForClientsToDie(this.vms);
                this.log.info("Stopped the client vms for " + this.name + ": " + this.vms.values());
            } else {
                this.log.info("Disconnecting and stopping the client vms for " + this.name + ": " + this.vms.values());
                ClientMgr.stopClients(this.vms, this.disconnect, false);
                ClientMgr.waitForClientsToDie(this.vms);
                this.log.info("Disconnected and stopped the client vms for " + this.name + ": " + this.vms.values());
            }
        }
        catch (HydraTimeoutException e) {
            ResultLogger.reportHang("Timeout stopping clients for " + this.name, (Throwable)((Object)e));
            throw e;
        }
        finally {
            this.vms = null;
        }
    }

    @Override
    public boolean executeTasks(boolean haltIfBadResult, long maxResultWaitSec) {
        if (this.vms == null) {
            this.vms = ClientMgr.getClientVms();
        }
        this.initExecutionParameters(haltIfBadResult, maxResultWaitSec);
        this.initClientRuntime();
        return this.executeTasks();
    }

    protected void initExecutionParameters(boolean haltIfBadResult, long maxResultWaitSec) {
        this.haltIfBadResult = haltIfBadResult;
        this.maxResultWaitSec = maxResultWaitSec;
        this.maxResultWaitMs = maxResultWaitSec * 1000L;
    }

    protected void initClientRuntime() {
        int count = 0;
        for (ClientVmRecord vm : this.vms.values()) {
            for (ClientRecord client : vm.getClients().values()) {
                client.initRuntime();
                ++count;
            }
        }
        if (this.tasks != null) {
            this.log.info("Executing " + this.tasks.size() + " " + this.name + " on " + count + " clients");
        }
    }

    protected abstract boolean executeTasks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TaskScheduler getTaskScheduler(int tsid) {
        Map map = TaskSchedulers;
        synchronized (map) {
            TaskScheduler ts = (TaskScheduler)TaskSchedulers.get(new Integer(tsid));
            if (ts == null) {
                throw new HydraInternalException("No scheduler " + tsid);
            }
            return ts;
        }
    }

    protected int getTsid() {
        return this.tsid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTaskScheduler(int tsid, TaskScheduler ts) {
        Map map = TaskSchedulers;
        synchronized (map) {
            Integer i = new Integer(tsid);
            if (TaskSchedulers.get(i) != null) {
                throw new HydraInternalException("Duplicate tsid: " + tsid);
            }
            TaskSchedulers.put(i, ts);
        }
    }

    protected Map getVms() {
        return this.vms;
    }

    protected ClientVmRecord getVm(Integer vmid) {
        ClientVmRecord vm = (ClientVmRecord)this.vms.get(vmid);
        if (vm == null) {
            throw new HydraInternalException("No client vm_" + vmid + " in " + this.name + " scheduler " + this.tsid);
        }
        return vm;
    }

    protected void assignTask(ClientRecord client, TestTask task) {
        this.log.info("Assigning " + task.toShortString() + " to " + client);
        RemoteTestModuleIF rem = client.getTestModule();
        try {
            rem.executeTask(this.tsid, task.getTaskType(), task.getTaskIndex());
        }
        catch (RemoteException e) {
            String reason = client + " unable to execute: " + task;
            throw new HydraRuntimeException(reason, e);
        }
    }

    protected long waitForClientsToFinish() {
        long now;
        boolean finished;
        for (ClientVmRecord clientVmRecord : this.vms.values()) {
        }
        this.lastwaitingreporttime = 0L;
        do {
            finished = true;
            now = System.currentTimeMillis();
            for (ClientVmRecord vm : this.vms.values()) {
                for (ClientRecord client : vm.getClients().values()) {
                    finished = finished && this.isFinished(client, now);
                }
            }
        } while (!finished);
        return now;
    }

    protected long waitForClientsToFinish(Vector clients) {
        long now;
        boolean finished;
        this.lastwaitingreporttime = 0L;
        do {
            finished = true;
            now = System.currentTimeMillis();
            for (ClientRecord client : clients) {
                finished = finished && this.isFinished(client, now);
            }
        } while (!finished);
        return now;
    }

    protected long waitForClientToFinish(ClientRecord client) {
        long now;
        boolean finished;
        this.lastwaitingreporttime = 0L;
        while (!(finished = this.isFinished(client, now = System.currentTimeMillis()))) {
        }
        return now;
    }

    protected boolean isFinished(ClientRecord client, long now) {
        if (!client.isBusy() || this.hadFatalTaskErrorAndHaltOrder() || this.hadStatMonitorError() || this.hadDynamicActionError() || this.hadDynamicActionHang() || this.exceededMaxResultWaitSec(client, now)) {
            return true;
        }
        this.printWaitingReport(now);
        this.pauseWaiting();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHadFatalTaskError() {
        Object object = TerminationLock;
        synchronized (object) {
            if (HadFatalTaskError) {
                return;
            }
            HadFatalTaskError = true;
        }
        this.setTermination("a client had a fatal task error");
    }

    protected boolean hadFatalTaskErrorAndHaltOrder() {
        return this.haltIfBadResult && HadFatalTaskError;
    }

    protected static void setStatMonitorError(Throwable t) {
        HadStatMonitorError = true;
        String msg = null;
        msg = t.getMessage() == null ? "Statistics monitoring error: " + t.getClass().getName() : "Statistics monitoring error: " + t.getMessage();
        ResultLogger.reportErr(msg, t);
    }

    protected boolean hadStatMonitorError() {
        if (HadStatMonitorError) {
            this.setTermination("a monitored condition was violated or the statistics monitor had a fatal error");
            return true;
        }
        return false;
    }

    protected static void processDynamicActionError(Throwable t) {
        if (t instanceof HydraTimeoutException) {
            BaseTaskScheduler.setDynamicActionHang(t);
        } else if (t instanceof DynamicActionException) {
            BaseTaskScheduler.setDynamicActionError(t);
        } else {
            DynamicActionException e = null;
            e = t.getMessage() == null ? new DynamicActionException("got a " + t.getClass().getName(), t) : new DynamicActionException(t.getMessage(), t);
            BaseTaskScheduler.setDynamicActionError((Throwable)((Object)e));
        }
    }

    protected static void setDynamicActionError(Throwable t) {
        HadDynamicActionError = true;
        String msg = null;
        msg = t.getMessage() == null ? "Problem during dynamic action: " + t.getClass().getName() : "Problem during dynamic action: " + t.getMessage();
        ResultLogger.reportErr(msg, t);
    }

    protected static void setDynamicActionHang(Throwable t) {
        HadDynamicActionHang = true;
        String msg = null;
        msg = t.getMessage() == null ? "Timeout during dynamic action: " + t.getClass().getName() : "Timeout during dynamic action: " + t.getMessage();
        ResultLogger.reportHang(msg, t);
    }

    protected boolean hadDynamicActionError() {
        if (HadDynamicActionError) {
            this.setTermination("a dynamic action had a fatal error");
            return true;
        }
        return false;
    }

    protected boolean hadDynamicActionHang() {
        if (HadDynamicActionHang) {
            this.setTermination("a dynamic action timed out");
            return true;
        }
        return false;
    }

    protected boolean exceededMaxResultWaitSec(long now) {
        if (ExceededMaxResultWaitSec) {
            return true;
        }
        for (ClientVmRecord vm : this.vms.values()) {
            Collection<ClientRecord> clients = vm.getClients().values();
            if (!this.exceededMaxResultWaitSec(clients, now)) continue;
            return true;
        }
        return false;
    }

    protected boolean exceededMaxResultWaitSec(Collection clients, long now) {
        boolean hung = false;
        if (ExceededMaxResultWaitSec) {
            return true;
        }
        for (ClientRecord client : clients) {
            if (!this.exceededMaxResultWaitSec(client, now)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exceededMaxResultWaitSec(ClientRecord client, long now) {
        if (client.isBusy() && now - client.getStartTime() > this.maxResultWaitMs) {
            ClientRecord clientRecord = client;
            synchronized (clientRecord) {
                if (client.isBusy()) {
                    this.setExceededMaxResultWaitSec(client);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setExceededMaxResultWaitSec(ClientRecord client) {
        Object object = TerminationLock;
        synchronized (object) {
            if (ExceededMaxResultWaitSec) {
                return true;
            }
            ExceededMaxResultWaitSec = true;
        }
        String msg = "a client exceeded max result wait sec: " + this.maxResultWaitSec;
        this.setTermination(msg);
        TestTask task = client.getTask();
        task.logHangResult(client, msg);
        ClientMgr.printProcessStacks(client.vm());
        return true;
    }

    protected synchronized void setTermination(String reason) {
        this.termination = this.termination == null ? reason : this.termination + " then " + reason;
    }

    protected boolean executedNormallyOrNoHaltOrder() {
        return !this.hadFatalTaskErrorAndHaltOrder() && !ExceededMaxResultWaitSec && !HadStatMonitorError && !HadDynamicActionError && !HadDynamicActionHang;
    }

    protected boolean executedNormally() {
        return !HadFatalTaskError && !ExceededMaxResultWaitSec && !HadStatMonitorError && !HadDynamicActionError && !HadDynamicActionHang;
    }

    protected boolean schedulerResult() {
        boolean passed = this.executedNormally();
        if (passed) {
            if (this.termination == null) {
                this.log.info(this.name + " terminating normally after tasks completed");
            } else {
                this.log.info(this.name + " terminating normally after " + this.termination);
            }
        } else {
            this.log.severe(this.name + " terminating abnormally after " + this.termination);
        }
        return passed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reportResult(int tsid, int vmid, int tid, TestTaskResult result) {
        try {
            ClientVmRecord vm = ClientMgr.getClientVm(vmid);
            ClientRecord client = vm.getClient(tid);
            BaseTaskScheduler ts = (BaseTaskScheduler)BaseTaskScheduler.getTaskScheduler(tsid);
            if (result.getResult() instanceof HydraTimeoutException) {
                MasterController.dumpStacks(2);
            }
            ClientRecord clientRecord = client;
            synchronized (clientRecord) {
                TestTask task = client.getTask();
                if (client.isBusy()) {
                    Object o = result.getResult();
                    if (o instanceof StopSchedulingOrder && task.acceptsStopSchedulingOrder()) {
                        ComplexTaskScheduler cts = (ComplexTaskScheduler)ts;
                        cts.receiveStopSchedulingOrder();
                    } else if (o instanceof StopSchedulingTaskOnClientOrder && task.acceptsStopSchedulingTaskOnClientOrder()) {
                        task.receiveStopSchedulingTaskOnClientOrder(client);
                    }
                    if (result.getErrorStatus()) {
                        ts.setHadFatalTaskError();
                        client.setError();
                    }
                    TestTask testTask = task;
                    synchronized (testTask) {
                        task.addElapsedTime(result.getElapsedTime());
                        task.updateEndTimes(System.currentTimeMillis());
                        task.decrementNumTimesInUse();
                        task.incrementNumTimesRun();
                    }
                    client.setBusy(false);
                    if (o instanceof HydraTimeoutException) {
                        task.logHangResult(client, result);
                    } else {
                        task.logTaskResult(client, result);
                    }
                } else {
                    String s = client + " already reported the result for " + task;
                    Log.getLogWriter().severe(s);
                }
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            BaseTaskScheduler.processDynamicActionError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fakeKillResults(ClientVmRecord vm) {
        int tsid = -1;
        Map map = TaskSchedulers;
        synchronized (map) {
            for (TaskScheduler ts : TaskSchedulers.values()) {
                if (!(ts instanceof ComplexTaskScheduler)) continue;
                ComplexTaskScheduler cts = (ComplexTaskScheduler)ts;
                if (cts.getVms().values().contains(vm)) {
                    tsid = cts.getTsid();
                    break;
                }
                throw new HydraInternalException(cts + " does not contain " + vm);
            }
        }
        if (tsid < 0) {
            throw new HydraInternalException("No ComplexTaskScheduler found");
        }
        String msg = "Intentionally killed";
        for (ClientRecord client : vm.getClients().values()) {
            if (!client.isBusy()) continue;
            long elapsedTime = System.currentTimeMillis() - client.getStartTime();
            TestTaskResult result = new TestTaskResult(new MethExecutorResult(msg), elapsedTime);
            BaseTaskScheduler.reportResult(tsid, vm.getVmid(), client.getTid(), result);
        }
    }

    protected void printSchedulingReport(long now) {
        if (this.lastschedulingreporttime == 0L) {
            this.lastschedulingreporttime = now;
        } else if (now - this.lastschedulingreporttime > 15000L) {
            this.log.info(SCHEDULING_MSG);
            this.lastschedulingreporttime = now;
        }
    }

    protected void pauseScheduling() {
        MasterController.sleepForMs(200);
    }

    protected void printWaitingReport(long now) {
        if (this.lastwaitingreporttime == 0L) {
            this.maxwaitingreporttime = now + this.maxResultWaitMs;
            this.lastwaitingreporttime = now;
        } else if (now - this.lastwaitingreporttime > 15000L) {
            long remaining = (this.maxwaitingreporttime - now) / 1000L;
            String msg = "Waiting " + remaining + " seconds for clients to finish current tasks...";
            this.log.info(msg);
            this.lastwaitingreporttime = now;
        }
    }

    protected void pauseWaiting() {
        MasterController.sleepForMs(2000);
    }

    protected void printBlockingReport(long now) {
        if (this.lastblockingreporttime == 0L) {
            this.lastblockingreporttime = now;
        } else if (now - this.lastblockingreporttime > 15000L) {
            this.log.info(BLOCKING_MSG);
            this.lastblockingreporttime = now;
        }
    }

    protected void pauseBlocking() {
        MasterController.sleepForMs(2000);
    }

    @Override
    public void printReport() {
        StringBuffer buf = new StringBuffer(500);
        buf.append("TASK REPORT.....");
        if (this.tasks == null) {
            buf.append("no " + this.name + " found");
        } else {
            for (TestTask task : this.tasks) {
                buf.append("\n\n").append(task.toString()).append("\n");
                buf.append("Number of times assigned: ").append(task.getNumTimesRun());
                String stats = task.getElapsedTimes().printStatsAsTimes();
                if (stats == null) continue;
                buf.append("\n").append(stats);
            }
        }
        this.log.info(buf.toString());
    }

    private static synchronized int nextTsid() {
        return ++nextTsid;
    }
}

