/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.ConfigHashtable;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.CRC32;

public class BasePrms {
    public static final String NONE = "none";
    public static final String DEFAULT = "default";
    private static Hashtable keymap = new Hashtable();
    private static Hashtable namemap = new Hashtable();
    protected static String DASH = "-";

    protected static void setValues(Class cls) {
        String classname = cls.getName();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldname = fields[i].getName();
            int m = fields[i].getModifiers();
            if (!Modifier.isPublic(m) || Modifier.isFinal(m)) continue;
            try {
                String fullname = classname + DASH + fieldname;
                CRC32 checksum = new CRC32();
                checksum.update(fullname.getBytes());
                Long val = new Long(checksum.getValue());
                fields[i].setAccessible(true);
                fields[i].set(val, val);
                keymap.put(val, fullname);
                namemap.put(fullname, val);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new HydraRuntimeException("Error accessing field: " + fields[i], e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new HydraRuntimeException("Error accessing field", e);
            }
        }
    }

    public static String nameForKey(Long key) {
        String name = (String)keymap.get(key);
        if (name == null) {
            throw new HydraInternalException("No map entry for key: " + key);
        }
        return name;
    }

    public static Long keyForName(String name) {
        Long key = (Long)namemap.get(name);
        if (key == null) {
            StringTokenizer st = new StringTokenizer(name, DASH, false);
            String classname = st.nextToken();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = Class.forName(classname, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new HydraConfigException("No map entry for name: " + name, e);
            }
            key = (Long)namemap.get(name);
            if (key == null) {
                throw new HydraConfigException("No map entry for name: " + name);
            }
        }
        return key;
    }

    public static void dumpKeys() {
        Log.getLogWriter().info("Dumping parameter map by request...");
        Enumeration keys = keymap.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            String name = (String)keymap.get(key);
            Log.getLogWriter().info("KEY:" + BasePrms.keyForName(name) + "\tNAME:" + BasePrms.nameForKey(key));
        }
        Log.getLogWriter().info("...end parameter map");
    }

    public static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    public static ConfigHashtable tasktab() {
        return TestConfig.tasktab();
    }
}

