/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import hydra.AsyncEventQueueDescription;
import hydra.AsyncEventQueuePrms;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.DiskStoreHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.util.Set;

public class AsyncEventQueueHelper {
    private static LogWriter log = Log.getLogWriter();

    public static synchronized AsyncEventQueue createAndStartAsyncEventQueue(String asyncEventQueueConfig) {
        AsyncEventQueue queue = AsyncEventQueueHelper.getAsyncEventQueue(asyncEventQueueConfig);
        if (queue == null) {
            Cache cache = CacheHelper.getCache();
            if (cache == null) {
                String s = "Cache has not been created yet";
                throw new HydraRuntimeException(s);
            }
            AsyncEventQueueDescription aeqd = AsyncEventQueueHelper.getAsyncEventQueueDescription(asyncEventQueueConfig);
            DiskStoreHelper.createDiskStore(aeqd.getDiskStoreDescription().getName());
            queue = AsyncEventQueueHelper.createAsyncEventQueue(aeqd, cache);
        }
        return queue;
    }

    private static AsyncEventQueue createAsyncEventQueue(AsyncEventQueueDescription aeqd, Cache cache) {
        AsyncEventQueueFactory f = cache.createAsyncEventQueueFactory();
        log.info("Configuring async event queue factory");
        aeqd.configure(f);
        log.info("Configured async event queue factory " + f);
        log.info("Creating and starting async event queue " + aeqd.getName());
        AsyncEventQueue queue = f.create(aeqd.getName(), aeqd.getAsyncEventListenerInstance());
        log.info("Created and started async event queue: " + AsyncEventQueueHelper.asyncEventQueueToString(queue));
        return queue;
    }

    public static Set<AsyncEventQueue> getAsyncEventQueues() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            return null;
        }
        Set queues = cache.getAsyncEventQueues();
        return queues == null || queues.size() == 0 ? null : queues;
    }

    public static AsyncEventQueue getAsyncEventQueue(String queueID) {
        Set<AsyncEventQueue> queues = AsyncEventQueueHelper.getAsyncEventQueues();
        if (queues != null) {
            for (AsyncEventQueue queue : queues) {
                if (!queue.getId().equals(queueID)) continue;
                return queue;
            }
        }
        return null;
    }

    public static String asyncEventQueueToString(AsyncEventQueue aeq) {
        return AsyncEventQueueDescription.asyncEventQueueToString(aeq);
    }

    public static AsyncEventQueueDescription getAsyncEventQueueDescription(String asyncEventQueueConfig) {
        if (asyncEventQueueConfig == null) {
            throw new IllegalArgumentException("asyncEventQueueConfig cannot be null");
        }
        log.info("Looking up async event queue config: " + asyncEventQueueConfig);
        AsyncEventQueueDescription aeqd = TestConfig.getInstance().getAsyncEventQueueDescription(asyncEventQueueConfig);
        if (aeqd == null) {
            String s = asyncEventQueueConfig + " not found in " + BasePrms.nameForKey(AsyncEventQueuePrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up async event queue config:\n" + aeqd);
        return aeqd;
    }
}

