/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import hydra.AbstractDescription;
import hydra.AdminPrms;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.SSLDescription;
import hydra.TestConfig;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class AdminDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Integer ackSevereAlertThreshold;
    private Integer ackWaitThreshold;
    private Boolean disableTcp;
    private String distributedSystem;
    private Boolean emailNotificationEnabled;
    private String emailNotificationFrom;
    private String emailNotificationHost;
    private String emailNotificationToList;
    private Boolean enableNetworkPartitionDetection;
    private Boolean disableAutoReconnect;
    private GemFireDescription gemfireDescription;
    private String locators;
    private Integer logDiskSpaceLimit;
    private String logFile;
    private Integer logFileSizeLimit;
    private String logLevel;
    private String mcastAddress;
    private Integer mcastPort;
    private Integer memberTimeout;
    private Integer refreshInterval;
    private String remoteCommand;
    private String sslName;
    private SSLDescription sslDescription;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getAckSevereAlertThreshold() {
        return this.ackSevereAlertThreshold;
    }

    private void setAckSevereAlertThreshold(Integer i) {
        this.ackSevereAlertThreshold = i;
    }

    private Integer getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    private void setAckWaitThreshold(Integer i) {
        this.ackWaitThreshold = i;
    }

    public Boolean getDisableTcp() {
        return this.disableTcp;
    }

    private void setDisableTcp(Boolean b) {
        this.disableTcp = b;
    }

    protected String getDistributedSystem() {
        return this.distributedSystem;
    }

    private void setDistributedSystem(String str) {
        this.distributedSystem = str;
    }

    public Boolean getEmailNotificationEnabled() {
        return this.emailNotificationEnabled;
    }

    private void setEmailNotificationEnabled(Boolean b) {
        this.emailNotificationEnabled = b;
    }

    public String getEmailNotificationFrom() {
        return this.emailNotificationFrom;
    }

    private void setEmailNotificationFrom(String emailID) {
        this.emailNotificationFrom = emailID;
    }

    public String getEmailNotificationHost() {
        return this.emailNotificationHost;
    }

    private void setEmailNotificationHost(String hostName) {
        this.emailNotificationHost = hostName;
    }

    public String getEmailNotificationToList() {
        return this.emailNotificationToList;
    }

    private void setEmailNotificationToList(String emailIDs) {
        this.emailNotificationToList = emailIDs;
    }

    public Boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    private void setEnableNetworkPartitionDetection(Boolean b) {
        this.enableNetworkPartitionDetection = b;
    }

    public Boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    private void setDisableAutoReconnect(Boolean disableAutoReconnect) {
        this.disableAutoReconnect = disableAutoReconnect;
    }

    private GemFireDescription getGemFireDescription() {
        return this.gemfireDescription;
    }

    private void setGemFireDescription(GemFireDescription gfd) {
        this.gemfireDescription = gfd;
    }

    private String getLocators() {
        if (this.locators == null) {
            String locs = null;
            if (this.getGemFireDescription().getUseLocator().booleanValue()) {
                if (this.distributedSystem.equals("loner")) {
                    locs = "";
                } else if (TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
                    locs = TestConfig.getInstance().getMasterDescription().getLocator(this.distributedSystem);
                } else {
                    List endpoints = DistributedSystemHelper.getEndpoints(this.distributedSystem);
                    locs = DistributedSystemHelper.endpointsToString(endpoints);
                }
            } else {
                locs = "";
            }
            this.locators = locs;
        }
        return this.locators;
    }

    private Integer getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    private void setLogDiskSpaceLimit(Integer i) {
        this.logDiskSpaceLimit = i;
    }

    private synchronized String getLogFile() {
        if (this.logFile == null) {
            HostDescription hd = TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription();
            String dirname = hd.getUserDir() + File.separator + "vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "_" + HostHelper.getLocalHost() + "_" + RemoteTestModule.getMyPid() + "_admin";
            File dir = new File(dirname);
            String fullname = dir.getAbsolutePath();
            try {
                FileUtil.mkdir(dir);
                try {
                    RemoteTestModule.Master.recordDir(hd, this.getGemFireDescription().getName(), fullname);
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to record directory: " + dir;
                    throw new HydraRuntimeException(s, e);
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Error e) {
                String s = "Unable to create directory: " + dir;
                throw new HydraRuntimeException(s);
            }
            this.logFile = dirname + File.separator + "system.log";
        }
        return this.logFile;
    }

    private Integer getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    private void setLogFileSizeLimit(Integer i) {
        this.logFileSizeLimit = i;
    }

    private String getLogLevel() {
        return this.logLevel;
    }

    private void setLogLevel(String str) {
        this.logLevel = str;
    }

    private String getMcastAddress() {
        return this.mcastAddress;
    }

    private void setMcastAddress(String str) {
        this.mcastAddress = str;
    }

    private Integer getMcastPort() {
        if (this.mcastPort == null) {
            Map<String, GemFireDescription> gfds = TestConfig.getInstance().getGemFireDescriptions();
            for (GemFireDescription gfd : gfds.values()) {
                if (!gfd.getDistributedSystem().equals(this.distributedSystem)) continue;
                this.mcastPort = gfd.getMcastPort();
                break;
            }
        }
        return this.mcastPort;
    }

    private Integer getMemberTimeout() {
        return this.memberTimeout;
    }

    private void setMemberTimeout(Integer i) {
        this.memberTimeout = i;
    }

    private Integer getRefreshInterval() {
        return this.refreshInterval;
    }

    private void setRefreshInterval(Integer i) {
        this.refreshInterval = i;
    }

    private String getRemoteCommand() {
        return this.remoteCommand;
    }

    private void setRemoteCommand(String str) {
        this.remoteCommand = str;
    }

    public String getSSLName() {
        return this.sslName;
    }

    private void setSSLName(String str) {
        this.sslName = str;
    }

    private SSLDescription getSSLDescription() {
        return this.sslDescription;
    }

    private void setSSLDescription(SSLDescription sd) {
        this.sslDescription = sd;
    }

    public void configure(DistributedSystemConfig d) {
        d.setAckSevereAlertThreshold(this.getAckSevereAlertThreshold().intValue());
        d.setAckWaitThreshold(this.getAckWaitThreshold().intValue());
        if (TestConfig.tab().booleanAt(Prms.useIPv6)) {
            String ipv6 = HostHelper.getHostAddress(HostHelper.getIPv6Address());
            if (ipv6 == null) {
                String s = "IPv6 address is not available for host " + this.getGemFireDescription().getHostDescription().getHostName();
                throw new HydraRuntimeException(s);
            }
            d.setBindAddress(ipv6);
            d.setServerBindAddress(ipv6);
        }
        d.setDisableTcp(this.getDisableTcp().booleanValue());
        d.setEnableNetworkPartitionDetection(this.getEnableNetworkPartitionDetection().booleanValue());
        Boolean b = this.getDisableAutoReconnect();
        if (b != null) {
            d.setDisableAutoReconnect(b.booleanValue());
        }
        d.setLocators(this.getLocators());
        d.setLogDiskSpaceLimit(this.getLogDiskSpaceLimit().intValue());
        d.setLogFile(this.getLogFile());
        d.setLogFileSizeLimit(this.getLogFileSizeLimit().intValue());
        d.setLogLevel(this.getLogLevel());
        d.setMcastAddress(this.getMcastAddress());
        d.setMcastPort(this.getMcastPort().intValue());
        d.setMemberTimeout(this.getMemberTimeout().intValue());
        d.setRefreshInterval(this.getRefreshInterval().intValue());
        d.setRemoteCommand(this.getRemoteCommand());
        SSLDescription sd = this.getSSLDescription();
        if (sd != null && sd.getSSLEnabled().booleanValue()) {
            d.setSSLCiphers(sd.getSSLCiphers());
            d.setSSLEnabled(sd.getSSLEnabled().booleanValue());
            d.setSSLProtocols(sd.getSSLProtocols());
            d.setSSLAuthenticationRequired(sd.getSSLRequireAuthentication().booleanValue());
            String s = "gemfire.";
            System.setProperty(s + "ssl-ciphers", sd.getSSLCiphers());
            System.setProperty(s + "ssl-enabled", sd.getSSLEnabled().toString());
            System.setProperty(s + "ssl-protocols", sd.getSSLProtocols());
            System.setProperty(s + "ssl-require-authentication", sd.getSSLRequireAuthentication().toString());
        }
    }

    protected static synchronized String adminToString(DistributedSystemConfig d) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n  ackSevereAlertThreshold: " + d.getAckSevereAlertThreshold());
        buf.append("\n  ackWaitThreshold: " + d.getAckWaitThreshold());
        buf.append("\n  bindAddress: " + d.getBindAddress());
        buf.append("\n  disableTcp: " + d.getDisableTcp());
        buf.append("\n  enableNetworkPartitionDetection: " + d.getEnableNetworkPartitionDetection());
        buf.append("\n  locators: " + d.getLocators());
        buf.append("\n  logDiskSpaceLimit: " + d.getLogDiskSpaceLimit());
        buf.append("\n  logFile: " + d.getLogFile());
        buf.append("\n  logFileSizeLimit: " + d.getLogFileSizeLimit());
        buf.append("\n  logLevel: " + d.getLogLevel());
        buf.append("\n  mcastAddress: " + d.getMcastAddress());
        buf.append("\n  mcastPort: " + d.getMcastPort());
        buf.append("\n  memberTimeout: " + d.getMemberTimeout());
        buf.append("\n  refreshInterval: " + d.getRefreshInterval());
        buf.append("\n  remoteCommand: " + d.getRemoteCommand());
        buf.append("\n  serverBindAddress: " + d.getServerBindAddress());
        buf.append("\n  sslCiphers: " + d.getSSLCiphers());
        buf.append("\n  sslEnabled: " + d.isSSLEnabled());
        buf.append("\n  sslProtocols: " + d.getSSLProtocols());
        buf.append("\n  sslRequireAuthentication: " + d.isSSLAuthenticationRequired());
        buf.append("\n  systemId: " + d.getSystemId());
        buf.append("\n  systemName: " + d.getSystemName());
        return buf.toString();
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "ackSevereAlertThreshold", this.getAckSevereAlertThreshold());
        map.put(header + "ackWaitThreshold", this.getAckWaitThreshold());
        map.put(header + "disableTcp", this.getDisableTcp());
        map.put(header + "emailNotificationEnabled", this.getEmailNotificationEnabled());
        map.put(header + "emailNotificationFrom", this.getEmailNotificationFrom());
        map.put(header + "emailNotificationHost", this.getEmailNotificationHost());
        map.put(header + "emailNotificationToList", this.getEmailNotificationToList());
        map.put(header + "enableNetworkPartitionDetection", this.getEnableNetworkPartitionDetection());
        map.put(header + "disableAutoReconnect", this.getDisableAutoReconnect());
        map.put(header + "locators", "autogenerated");
        map.put(header + "logDiskSpaceLimit", this.getLogDiskSpaceLimit());
        map.put(header + "logFile", "autogenerated: same path as test directory");
        map.put(header + "logFileSizeLimit", this.getLogFileSizeLimit());
        map.put(header + "logLevel", this.getLogLevel());
        map.put(header + "mcastAddress", this.getMcastAddress());
        map.put(header + "mcastPort", "inherited from distributed system");
        map.put(header + "memberTimeout", this.getMemberTimeout());
        map.put(header + "refreshInterval", this.getRefreshInterval());
        map.put(header + "remoteCommand", this.getRemoteCommand());
        map.put(header + "sslName", this.getSSLName());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(AdminPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            AdminDescription ad = AdminDescription.createAdminDescription(name, config, i);
            config.addAdminDescription(ad);
        }
    }

    private static AdminDescription createAdminDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        AdminDescription ad = new AdminDescription();
        ad.setName(name);
        Long key = AdminPrms.distributedSystem;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            String s = BasePrms.nameForKey(key) + " is a required field and has no default value";
            throw new HydraConfigException(s);
        }
        if (str.equals("loner")) {
            String s = BasePrms.nameForKey(key) + " cannot be a " + "loner";
            throw new HydraConfigException(s);
        }
        ad.setDistributedSystem(str);
        GemFireDescription gfd = AdminDescription.getGemFireDescription(str, key, config);
        ad.setGemFireDescription(gfd);
        key = AdminPrms.ackSevereAlertThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = ad.getGemFireDescription().getAckSevereAlertThreshold();
        }
        ad.setAckSevereAlertThreshold(i);
        key = AdminPrms.ackWaitThreshold;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = ad.getGemFireDescription().getAckWaitThreshold();
        }
        ad.setAckWaitThreshold(i);
        Boolean bool = ad.getGemFireDescription().getDisableTcp();
        ad.setDisableTcp(bool);
        key = AdminPrms.emailNotificationEnabled;
        Boolean bool2 = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool2 == null) {
            bool2 = false;
        }
        ad.setEmailNotificationEnabled(bool2);
        key = AdminPrms.emailNotificationFrom;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "";
            str = "";
        }
        ad.setEmailNotificationFrom(str);
        key = AdminPrms.emailNotificationHost;
        str = tab.getString(key, tab.getWild(key, index, null));
        str = str == null ? "" : AdminDescription.getEmailNotificationHost(str, key);
        ad.setEmailNotificationHost(str);
        key = AdminPrms.emailNotificationToList;
        str = null;
        Vector v = tab.getVector(key, tab.getWild(key, index, null));
        str = v == null ? "" : AdminDescription.getEmailNotificationToList(v);
        ad.setEmailNotificationToList(str);
        key = AdminPrms.enableNetworkPartitionDetection;
        bool2 = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool2 == null) {
            bool2 = ad.getGemFireDescription().getEnableNetworkPartitionDetection();
        }
        ad.setEnableNetworkPartitionDetection(bool2);
        key = AdminPrms.disableAutoReconnect;
        bool2 = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool2 == null) {
            bool2 = ad.getGemFireDescription().getDisableAutoReconnect();
        }
        ad.setDisableAutoReconnect(bool2);
        key = AdminPrms.logDiskSpaceLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(0);
        }
        ad.setLogDiskSpaceLimit(i);
        key = AdminPrms.logFileSizeLimit;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(0);
        }
        ad.setLogFileSizeLimit(i);
        key = AdminPrms.logLevel;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "config";
        }
        ad.setLogLevel(str);
        key = AdminPrms.memberTimeout;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = ad.getGemFireDescription().getMemberTimeout();
        }
        ad.setMemberTimeout(i);
        String str2 = ad.getGemFireDescription().getMcastAddress();
        ad.setMcastAddress(str2);
        key = AdminPrms.refreshInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 15;
        }
        ad.setRefreshInterval(i);
        key = AdminPrms.remoteCommand;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str == null) {
            str = "rsh -n {HOST} {CMD}";
        }
        ad.setRemoteCommand(str);
        key = AdminPrms.sslName;
        str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            ad.setSSLName("SSLDescription." + str);
            ad.setSSLDescription(AdminDescription.getSSLDescription(str, key, config));
        }
        return ad;
    }

    private static String getEmailNotificationHost(String str, Long key) {
        String host = EnvHelper.convertHostName(str);
        return HostHelper.getCanonicalHostName(host);
    }

    public static String getEmailNotificationToList(Vector v) {
        String str = "";
        for (int i = 0; i < v.size(); ++i) {
            if (i > 0) {
                str = str + ",";
            }
            str = str + v.get(i);
        }
        return str;
    }

    private static GemFireDescription getGemFireDescription(String str, Long key, TestConfig config) {
        Map<String, GemFireDescription> gfds = config.getGemFireDescriptions();
        for (GemFireDescription gfd : gfds.values()) {
            if (!gfd.getDistributedSystem().equals(str)) continue;
            return gfd;
        }
        String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(GemFirePrms.names) + ": " + str;
        throw new HydraConfigException(s);
    }
}

