/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import cq.CQUtil;
import hct.HctPrms;
import hct.ha.HAClientQueueBB;
import hct.ha.HAClientQueuePrms;
import hct.ha.Validator;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Iterator;
import util.TestException;
import util.TestHelper;

public class HAClientQueue {
    protected static PoolImpl mypool;
    protected static final String REGION_NAME;
    private static final String ARBITRARY_KEY = "AK1324Aasdfkkjhhcpwe";
    public static volatile boolean lastKeyReceived;
    public static final String DEFAULT_DELAY_FOR_DISPATCHER_START = "100000";

    public static void initCacheServer() {
        if (TestConfig.tab().booleanAt(HAClientQueuePrms.delayDispatcherStart, false)) {
            CacheClientProxy.isSlowStartForTesting = true;
            long delayMilis = TestConfig.tab().longAt(HAClientQueuePrms.delayDispatcherStartMilis, Long.valueOf(DEFAULT_DELAY_FOR_DISPATCHER_START));
            System.setProperty("slowStartTimeForTesting", String.valueOf(delayMilis));
            Log.getLogWriter().info("Configured the test with delayed start for message dispatcher with delay time " + delayMilis + " milis.");
        }
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        int numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
        }
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheClient() {
        Class<HAClientQueue> clazz = HAClientQueue.class;
        synchronized (HAClientQueue.class) {
            if (CacheHelper.getCache() == null) {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
                int numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    mypool = ClientHelper.getPool(region);
                    try {
                        if (TestConfig.tab().booleanAt(HctPrms.receiveValuesAsInvalidates)) {
                            Log.getLogWriter().info("Registering Interest for invalidates.");
                            region.registerInterestRegex(".*", false, false);
                            continue;
                        }
                        region.registerInterest((Object)"ALL_KEYS");
                        continue;
                    }
                    catch (CacheWriterException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void sendClientReadyForEvents() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            throw new TestException("Cache is null");
        }
        cache.readyForEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCacheClientWithConflation() {
        Class<HAClientQueue> clazz = HAClientQueue.class;
        synchronized (HAClientQueue.class) {
            if (CacheHelper.getCache() == null) {
                Cache cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
                int numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    mypool = ClientHelper.getPool(region);
                    Log.getLogWriter().info("The primary server endpoint is " + mypool.getPrimaryName());
                    try {
                        region.registerInterest((Object)"ALL_KEYS");
                        continue;
                    }
                    catch (CacheWriterException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCQClient() {
        Class<HAClientQueue> clazz = HAClientQueue.class;
        synchronized (HAClientQueue.class) {
            if (CacheHelper.getCache() == null) {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
                CQUtil.initialize();
                CQUtil.initializeCQService();
                int numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
                for (int i = 0; i < numOfRegion; ++i) {
                    Region region = RegionHelper.createRegion(REGION_NAME + i, ConfigPrms.getRegionConfig());
                    CQUtil.registerCQ(region);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void registerInterestOnArbitraryKey() {
        Region region = RegionHelper.getRegion(REGION_NAME + 0);
        region.registerInterest((Object)ARBITRARY_KEY);
        Log.getLogWriter().info("registered interest for ARBITRARY_KEY : AK1324Aasdfkkjhhcpwe");
    }

    public static void unregisterInterestOnArbitraryKey() {
        Region region = RegionHelper.getRegion(REGION_NAME + 0);
        region.unregisterInterest((Object)ARBITRARY_KEY);
        Log.getLogWriter().info("unregistered interest for ARBITRARY_KEY : AK1324Aasdfkkjhhcpwe");
    }

    public static void waitForLastKeyReceivedAtClient() {
        long maxWaitTime = 200000L;
        long start = System.currentTimeMillis();
        while (!lastKeyReceived) {
            if (System.currentTimeMillis() - start > maxWaitTime) {
                throw new TestException("last_key was not received in " + maxWaitTime + " milliseconds, could not proceed for further validation");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                Log.getLogWriter().info("waitForLastKeyReceivedAtClient : interrupted while waiting for validation");
            }
        }
        Validator.checkBlackBoardForException();
    }

    public static void verifyDataInRegion() {
        if (TestConfig.tab().booleanAt(HAClientQueuePrms.putLastKey, false)) {
            HAClientQueue.waitForLastKeyReceivedAtClient();
        }
        Cache cache = CacheFactory.getAnyInstance();
        int numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = cache.getRegion("/" + REGION_NAME + i);
            Log.getLogWriter().info("Validating the keys of the Region " + region.getFullPath() + " ...");
            if (region.isEmpty()) {
                throw new TestException(" Region has no entries to validate ");
            }
            Iterator iterator = region.entrySet(false).iterator();
            Region.Entry entry = null;
            Object key = null;
            Object value = null;
            while (iterator.hasNext()) {
                entry = (Region.Entry)iterator.next();
                key = entry.getKey();
                value = entry.getValue();
                if (value != null) {
                    if (HAClientQueueBB.getBB().getSharedMap().get(key) != null) {
                        if (HAClientQueueBB.getBB().getSharedMap().get(key).equals(value)) continue;
                        throw new TestException(" expected value to be " + HAClientQueueBB.getBB().getSharedMap().get(key) + " for key " + key + " but is " + value);
                    }
                    throw new TestException(" expected value to be present in the shared map but it is not for key " + key);
                }
                if (HAClientQueueBB.getBB().getSharedMap().get(key) == null) continue;
                throw new TestException(" expected value to be null but it is not so for key " + key);
            }
        }
    }

    public static void killClient() {
        int serverReconnectTime = 20000;
        try {
            MasterController.sleepForMs(5000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, serverReconnectTime);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    static {
        REGION_NAME = TestConfig.tab().stringAt(HctPrms.regionName);
        lastKeyReceived = false;
    }
}

