/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import cq.CQUtil;
import hct.BBoard;
import hct.HctPrms;
import hct.UniversalMembershipListener;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import objects.ConfigurableObject;
import objects.SizedString;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.NameFactory;
import util.PRObserver;
import util.TestException;

public class HierCache {
    static ConfigHashtable conftab = TestConfig.tab();
    static LogWriter logger = Log.getLogWriter();
    static GsRandom rand = new GsRandom();
    static String regionName = conftab.stringAt(HctPrms.regionName);
    static long killInterval = conftab.longAt(HctPrms.killInterval);
    static int numClients = -1;
    static boolean toggleKill = conftab.booleanAt(HctPrms.toggleKill);
    static boolean allowDisconnect = conftab.booleanAt(HctPrms.allowDisconnect, false);
    static boolean killServer = true;
    static BBoard bb = BBoard.getInstance();
    static int jp_count;
    static List endpoints;
    static BridgeHelper.Endpoint endpointToggle;
    static int nameCount;

    public static void initServerRegion() {
        Region aRegion;
        BridgeMembershipListener membershipListener;
        PRObserver.installObserverHook();
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        UniversalMembershipListener uListener = HctPrms.getUniversalMembershipListener();
        if (uListener != null) {
            try {
                DistributedSystemConfig dsConfig = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)DistributedSystemHelper.getDistributedSystem(), null);
                AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)dsConfig);
                Log.getLogWriter().info("initServerRegion: registering UniversalMembershipListener " + (Object)((Object)uListener) + " with AdminDS " + adminDS + " with config " + dsConfig);
                uListener.registerMembershipListener(adminDS);
            }
            catch (AdminException ae) {
                throw new TestException("Could not register UniversalMembershipListener " + (Object)((Object)ae));
            }
        }
        if ((membershipListener = HctPrms.getMembershipListener(HctPrms.serverMembershipListener)) != null) {
            BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)membershipListener);
            Log.getLogWriter().info("Registered BridgeMembershipListener " + membershipListener);
        }
        if ((aRegion = RegionHelper.createRegion(regionName, ConfigPrms.getRegionConfig())).getAttributes().getDataPolicy().withPartitioning() && aRegion.getAttributes().getPartitionAttributes().getRedundantCopies() > 0) {
            Log.getLogWriter().info("Recovery is expected in this test if data stores are stopped");
            BBoard.getInstance().getSharedMap().put("expectRecovery", new Boolean(true));
        }
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static void initEdgeRegion() {
        PoolImpl pool;
        BridgeMembershipListener membershipListener;
        boolean isPureJava = Boolean.getBoolean("gemfire.pureJavaMode");
        Log.getLogWriter().info("Initializing cache, pureJava is " + isPureJava + "...");
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        UniversalMembershipListener uListener = HctPrms.getUniversalMembershipListener();
        if (uListener != null) {
            try {
                DistributedSystemConfig dsConfig = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)DistributedSystemHelper.getDistributedSystem(), null);
                AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)dsConfig);
                Log.getLogWriter().info("initEdgeRegion: registering UniversalMembershipListener " + (Object)((Object)uListener) + " with AdminDS " + adminDS + " with config " + dsConfig);
                uListener.registerMembershipListener(adminDS);
            }
            catch (AdminException ae) {
                throw new TestException("Could not register UniversalMembershipListener " + (Object)((Object)ae));
            }
        }
        if ((membershipListener = HctPrms.getMembershipListener(HctPrms.edgeMembershipListener)) != null) {
            BridgeMembership.registerBridgeMembershipListener((BridgeMembershipListener)membershipListener);
            Log.getLogWriter().info("Registered BridgeMembershipListener " + membershipListener);
        }
        Region region = RegionHelper.createRegion(regionName, ConfigPrms.getRegionConfig());
        if (conftab.booleanAt(HctPrms.receiveValuesAsInvalidates) && (pool = ClientHelper.getPool(region)).getSubscriptionEnabled()) {
            Log.getLogWriter().info("Registering Interest for invalidates.");
            region.registerInterestRegex(".*", false, false);
        }
        CQUtil.initialize();
        CQUtil.initializeCQService();
        CQUtil.registerCQ(region);
    }

    public static void acquireThreadLocalConnection() {
        LocalRegion aRegion = (LocalRegion)RegionHelper.getRegion(regionName);
        PoolImpl pool = ClientHelper.getPool((Region)aRegion);
        Connection conn = pool.acquireConnection();
        pool.setThreadLocalConnection(conn);
    }

    public static void clearMembershipCounters() {
        BBoard.getInstance().zeroAllCounters();
    }

    public static synchronized int getNumClients() {
        if (numClients == -1) {
            int totalVMs = TestConfig.getInstance().getTotalVMs();
            int bridgeVMs = BridgeHelper.getEndpoints().size();
            numClients = totalVMs - bridgeVMs;
            Log.getLogWriter().info("numBridgeServers = " + bridgeVMs);
            Log.getLogWriter().info("numEdgeClients = " + numClients);
        }
        return numClients;
    }

    public static boolean startSnapshot() {
        return true;
    }

    public static boolean endSnapshot() {
        return true;
    }

    private static void doGet() {
        long nextKey;
        int numHits = conftab.intAt(HctPrms.hitsPerMiss);
        boolean debug = conftab.booleanAt(HctPrms.debug);
        long maxKeys = conftab.intAt(HctPrms.maxKeys, -1);
        Region aRegion = RegionHelper.getRegion(regionName);
        String name = NameFactory.getNextPositiveObjectName();
        if (maxKeys > 0L && (nextKey = NameFactory.getCounterForName(name)) >= maxKeys) {
            throw new StopSchedulingOrder("maxKeys (" + maxKeys + ") reached");
        }
        if (debug) {
            logger.info("doGet: requesting name " + name + " " + (numHits + 1) + " times");
        }
        Object first = null;
        String data = null;
        for (int n = 0; n < numHits + 1; ++n) {
            try {
                long start = System.currentTimeMillis();
                Object got = null;
                try {
                    got = aRegion.get((Object)name);
                }
                catch (CacheLoaderException e) {
                    String message = e.getMessage();
                    Log.getLogWriter().info("CacheLoaderException " + (Object)((Object)e) + " expected, continuing test");
                    if (message.indexOf("com.gemstone.gemfire.cache.CacheClosedException") > 0) {
                        MasterController.sleepForMs(500);
                        break;
                    }
                }
                catch (CancelException e) {
                    Log.getLogWriter().info("CancelException " + (Object)((Object)e) + " expected, continuing test");
                    MasterController.sleepForMs(500);
                    break;
                }
                if (got == null) {
                    throw new HydraRuntimeException("Could not get object with name: " + name);
                }
                if (n == 0) {
                    long end = System.currentTimeMillis();
                    if (debug) {
                        logger.info("Elapsed time on cache miss: " + (end - start));
                    }
                    first = got;
                    if (!HierCache.dataCheck(name, got)) {
                        if (got.getClass().getName().startsWith("[B")) {
                            data = new String((byte[])got);
                        }
                        throw new HydraRuntimeException("ERROR: unexpected data on cache miss for key: " + name + "--\n" + first);
                    }
                } else if (got.getClass().getName().startsWith("[B")) {
                    if (!Arrays.equals((byte[])got, (byte[])first)) {
                        data = new String((byte[])got);
                        throw new HydraRuntimeException("ERROR: unexpected data on cache hit for key: " + name + "--\n" + data);
                    }
                } else if (!got.equals(first)) {
                    throw new HydraRuntimeException("ERROR: unexpected data on cache hit for key: " + name + "--\n" + got);
                }
                MasterController.sleepForMs(conftab.intAt(HctPrms.getIntervalMs));
                continue;
            }
            catch (Exception e) {
                throw new TestException(HierCache.getStackTrace(e));
            }
        }
    }

    private static boolean dataCheck(Object name, Object got) {
        String objtype = got.getClass().getName();
        String key = (String)name;
        int index = Integer.parseInt(key.substring(key.indexOf(95) + 1));
        if (objtype.startsWith("[B")) {
            String data = new String((byte[])got);
            SizedString.validate(index, data);
            return true;
        }
        if (objtype.equals("java.lang.String")) {
            String data = (String)got;
            if (conftab.booleanAt(HctPrms.debug)) {
                logger.info("DEBUG: Got value " + got + " for key " + key);
            }
            if (data.startsWith("**")) {
                return data.startsWith("***" + name + "***");
            }
            SizedString.validate(index, data);
        } else {
            ((ConfigurableObject)got).validate(index);
        }
        return true;
    }

    public static void doGetBatch() {
        long pureJavaErrorCase = BBoard.getInstance().getSharedCounters().read(BBoard.PureJavaErrorCase);
        if (pureJavaErrorCase != 0L) {
            throw new StopSchedulingOrder("Detected pure java error case; expected error");
        }
        int num = conftab.intAt(HctPrms.getBatchSize);
        for (int n = 0; n < num; ++n) {
            HierCache.doGet();
        }
        Region aRegion = RegionHelper.getRegion(regionName);
        ClientHelper.release(aRegion);
    }

    public static boolean initBlackboard() {
        bb.getSharedMap().put("lastKillTime", new Long(0L));
        Long val = (Long)bb.getSharedMap().get("lastKillTime");
        return val != null && val == 0L;
    }

    public static synchronized void killSomething() throws ClientVmNotFoundException {
        Set active;
        BridgeHelper.Endpoint endpoint;
        PRObserver.initialize();
        String thing = conftab.stringAt(HctPrms.whatToKill);
        Region region = RegionHelper.getRegion(regionName);
        boolean doChecks = true;
        long now = System.currentTimeMillis();
        Long lastKill = (Long)bb.getSharedMap().get("lastKillTime");
        long diff = now - lastKill;
        if (diff < killInterval) {
            logger.info("No kill executed");
            return;
        }
        bb.getSharedMap().put("lastKillTime", new Long(now));
        if (!ClientHelper.getPool(region).getThreadLocalConnections()) {
            logger.info("Setting doChecks to FALSE for non-Sticky load balancing or kill of CacheServer's GemFire system");
            doChecks = false;
        }
        if (toggleKill) {
            if (endpointToggle.equals(HierCache.getEndpoint(0))) {
                endpointToggle = HierCache.getEndpoint(1);
            } else if (endpointToggle.equals(HierCache.getEndpoint(1))) {
                endpointToggle = HierCache.getEndpoint(0);
            }
            endpoint = endpointToggle;
        } else {
            int index = rand.nextInt(HierCache.getEndpoints().size() - 1);
            endpoint = HierCache.getEndpoint(index);
        }
        logger.info("Server chosen for kill: " + endpoint);
        HierCache.killComponent(thing, endpoint);
        int sleepSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        logger.info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        try {
            HierCache.doGet();
        }
        catch (StopSchedulingOrder sso) {
            throw sso;
        }
        catch (Exception x) {
            throw new HydraRuntimeException("Error in doGet after killing cache server", x);
        }
        ServerLocation server = new ServerLocation(endpoint.getHost(), endpoint.getPort());
        if (doChecks && (active = ClientHelper.getActiveServers(region)).contains(server)) {
            logger.info("ERROR: Killed server " + server + " found in Active Server List: " + active);
        }
        HierCache.restartComponent(thing, endpoint);
        int sleepMs = ClientHelper.getRetryInterval(region) + 1000;
        logger.info("Sleeping for " + sleepMs + " ms");
        MasterController.sleepForMs(sleepMs);
        try {
            HierCache.doGet();
        }
        catch (StopSchedulingOrder sso) {
            throw sso;
        }
        catch (Exception x) {
            throw new HydraRuntimeException("Error in doGet after reviving cache server", x);
        }
        if (doChecks && !(active = ClientHelper.getActiveServers(region)).contains(server)) {
            logger.info("ERROR: Restarted server " + server + " not in Active Server List: " + active);
        }
    }

    private static void killComponent(String comp, BridgeHelper.Endpoint endpoint) throws ClientVmNotFoundException {
        if (comp.equals("cacheserver")) {
            if (allowDisconnect) {
                int index = rand.nextInt(0, 1);
                killServer = index != 0;
            }
            ClientVmInfo target = new ClientVmInfo(endpoint);
            if (killServer) {
                ClientVmMgr.stop("Killing cache server", -21, -31, target);
                long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerCrashedEvents, HierCache.getNumClients());
                Log.getLogWriter().info("After incrementing, BBoard.expectedServerCrashedEvents = " + count);
            } else {
                ClientVmMgr.stop("Stopping cache server", -22, -31, target);
                long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerCrashedEvents, HierCache.getNumClients());
                Log.getLogWriter().info("After incrementing, BBoard.expectedServerCrashedEvents = " + count);
            }
            return;
        }
        if (comp.equals("serverDB")) {
            Region aRegion = RegionHelper.getRegion(regionName);
            try {
                Object got = aRegion.get((Object)"disableDatabase");
                if (got == null) {
                    logger.info("Could not get object for name: disableDatabase (expected)");
                }
            }
            catch (Exception e) {
                logger.info("Got CacheException when disabling database");
            }
            return;
        }
        logger.info("ERROR in killComponent - unknown argument: " + comp);
        throw new HydraRuntimeException("error in killComponent");
    }

    public static void stopServers() throws ClientVmNotFoundException {
        MasterController.sleepForMs(30000);
        for (int i = 0; i < HierCache.getEndpoints().size() - 1; ++i) {
            ClientVmInfo target = new ClientVmInfo(HierCache.getEndpoint(i));
            ClientVmMgr.stop("Stopping cache server", -22, -31, target);
            MasterController.sleepForMs(30000);
        }
    }

    public static void restartComponent(String comp, BridgeHelper.Endpoint endpoint) throws ClientVmNotFoundException {
        if (comp.equals("cacheserver")) {
            ClientVmInfo target = new ClientVmInfo(endpoint);
            ClientVmMgr.start("Restarting cache server", target);
            Object value = BBoard.getInstance().getSharedMap().get("expectRecovery");
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                PRObserver.waitForRebalRecov(target, 1, 1, null, null, false);
            }
            long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerJoinedEvents, HierCache.getNumClients());
            Log.getLogWriter().info("After restarting server and incrementing, BBoard.expectedServerJoinedEvents = " + count);
            count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientJoinedEvents, HierCache.getNumClients());
            Log.getLogWriter().info("After incrementing, BBoard.expectedClientJoinedEvents = " + count);
            return;
        }
        if (comp.equals("serverDB")) {
            Region aRegion = RegionHelper.getRegion(regionName);
            try {
                Object got = aRegion.get((Object)"enableDatabase");
                if (got == null) {
                    logger.info("Could not get object for name: enableDatabase");
                }
            }
            catch (Exception e) {
                logger.info("Got CacheException when enabling database");
            }
            return;
        }
        logger.info("ERROR in restartComponent - unknown argument: " + comp);
        throw new HydraRuntimeException("error in restartComponent");
    }

    public static void recycleClientConnection() {
        if (DistributedSystemHelper.getDistributedSystem() == null) {
            return;
        }
        CacheHelper.closeCache();
        DistributedSystemHelper.disconnect();
        long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientDepartedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientDepartedEvents = " + count);
        MasterController.sleepForMs(5000);
        BridgeMembershipListener[] allListeners = BridgeMembership.getBridgeMembershipListeners();
        if (allListeners.length != 1) {
            throw new TestException("Expected 1 BridgeMembershipListener, but found " + allListeners.length + "\n BridgeMembershipListeners =  " + allListeners);
        }
        BridgeMembershipListener membershipListener = allListeners[0];
        BridgeMembership.unregisterBridgeMembershipListener((BridgeMembershipListener)membershipListener);
        HierCache.initEdgeRegion();
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientJoinedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientJoinedEvents = " + count);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerJoinedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After recycling client cache and incrementing, BBoard.expectedServerJoinedEvents = " + count);
    }

    public static synchronized void killClientVm() throws ClientVmNotFoundException {
        long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientCrashedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientCrashedEvents = " + count);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientJoinedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientJoinedEvents = " + count);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerJoinedEvents, HierCache.getEndpoints().size());
        Log.getLogWriter().info("After killing client VM and incrementing, BBoard.expectedServerJoinedEvents = " + count);
        try {
            ClientVmMgr.stop("killing myself", -21, -30);
        }
        catch (ClientVmNotFoundException ex) {
            throw new HydraRuntimeException("I should always be able to kill myself", ex);
        }
    }

    public static void validateMembershipEvents() {
        MasterController.sleepForMs(60000);
        BBoard.getInstance().print();
        long expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedServerCrashedEvents);
        long actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualServerCrashedEvents);
        if (expected != actual) {
            throw new TestException("Expected " + expected + " serverCrashedEvents, but actual = " + actual);
        }
        expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedServerDepartedEvents);
        if (expected != (actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualServerDepartedEvents))) {
            throw new TestException("Expected " + expected + " serverDepartedEvents, but actual = " + actual);
        }
        expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedServerJoinedEvents);
        if (expected != (actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualServerJoinedEvents))) {
            throw new TestException("Expected " + expected + " serverJoinedEvents, but actual = " + actual);
        }
        expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedClientCrashedEvents);
        if (expected != (actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualClientCrashedEvents))) {
            throw new TestException("Expected " + expected + " clientCrashedEvents, but actual = " + actual);
        }
        expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedClientDepartedEvents);
        if (expected != (actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualClientDepartedEvents))) {
            throw new TestException("Expected " + expected + " clientDepartedEvents, but actual = " + actual);
        }
        expected = BBoard.getInstance().getSharedCounters().read(BBoard.expectedClientJoinedEvents);
        if (expected != (actual = BBoard.getInstance().getSharedCounters().read(BBoard.actualClientJoinedEvents))) {
            throw new TestException("Expected " + expected + " clientJoinedEvents, but actual = " + actual);
        }
    }

    public static void reportAverages() {
        long pureJavaErrorCase = BBoard.getInstance().getSharedCounters().read(BBoard.PureJavaErrorCase);
        if (pureJavaErrorCase != 0L) {
            throw new StopSchedulingOrder("Detected pure java error case; expected error");
        }
        String loadTimeSpec = "edge* ClientStats * getTime filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        String loadsSpec = "edge* ClientStats * gets filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        String getTimeSpec = "edge* CachePerfStats cachePerfStats getTime filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        String getsSpec = "edge* CachePerfStats cachePerfStats gets filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        String bridgeGetTimeSpec = "bridgegemfire1 CachePerfStats cachePerfStats getTime filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        String bridgeGetsSpec = "bridgegemfire1 CachePerfStats cachePerfStats gets filter=none ops=max combine=combineAcrossArchives trimspec=untrimmed";
        double edgeAvgLoad = (double)(HierCache.getMaxStat(loadTimeSpec) / HierCache.getMaxStat(loadsSpec)) / 1000000.0;
        double edgeAvgGet = (double)(HierCache.getMaxStat(getTimeSpec) / HierCache.getMaxStat(getsSpec)) / 1000000.0;
        double serverAvgGet = (double)(HierCache.getMaxStat(bridgeGetTimeSpec) / HierCache.getMaxStat(bridgeGetsSpec)) / 1000000.0;
        logger.info("\n  Server avg get time:  " + serverAvgGet + " ms\n  Edge avg load time:  " + edgeAvgLoad + " ms\n  Edge avg get time:  " + edgeAvgGet + " ms\n\n  Load latency: " + (edgeAvgLoad - serverAvgGet) + " ms\n  Get latency: " + (edgeAvgGet - serverAvgGet) + " ms");
    }

    private static long getMaxStat(String statSpecString) {
        List statVals = PerfStatMgr.getInstance().readStatistics(statSpecString);
        if (statVals == null) {
            throw new HydraRuntimeException("No statistic found for: " + statSpecString);
        }
        PerfStatValue psv = (PerfStatValue)statVals.get(0);
        long max = (long)psv.getMax();
        return max;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter sw = new StringWriter();
        aThrowable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    private static BridgeHelper.Endpoint getEndpoint(int i) {
        return (BridgeHelper.Endpoint)HierCache.getEndpoints().get(i);
    }

    private static synchronized List getEndpoints() {
        if (endpoints == null) {
            endpoints = BridgeHelper.getEndpoints();
            endpointToggle = (BridgeHelper.Endpoint)endpoints.get(0);
        }
        return endpoints;
    }

    static {
        nameCount = 0;
    }
}

