/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import cq.CQUtil;
import delta.DeltaValueHolder;
import getInitialImage.InitImagePrms;
import hct.BridgeNotifyBB;
import hct.BridgeNotifyPrms;
import hct.KeyListListener;
import hct.SingleKeyListener;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import util.BaseValueHolder;
import util.CacheBB;
import util.EventCountersBB;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;
import util.ValueHolderPrms;
import vsphere.vijava.VIJavaPrms;
import vsphere.vijava.VMotionTestBase;

public class BridgeNotify {
    protected static BridgeNotify bridgeClient;
    protected boolean isSerialExecution;
    protected boolean useTransactions;
    public boolean isCarefulValidation = false;
    protected int numKeysInTest = TestConfig.tab().intAt(BridgeNotifyPrms.numKeys, 100);
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected RandomValues randomValues = null;
    protected ArrayList originalKeyList = new ArrayList();
    protected static boolean isVMotionEnabled;
    protected static final String REGION_NAME = "myRegion";
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int REGION_CLOSE_OPERATION = 8;
    protected static final int CLEAR_OPERATION = 9;
    protected static final int DESTROY_CREATE_OPERATION = 10;
    protected static final int CACHE_CLOSE_OPERATION = 11;
    protected static final int KILL_VM_OPERATION = 12;
    protected static final int PUTALL_ADD_OPERATION = 13;
    protected static final int PUTALL_UPDATE_OPERATION = 14;
    protected static final int PUT_IF_ABSENT_OPERATION = 15;
    protected static final int REMOVE_OPERATION = 16;
    protected static final int REPLACE_OPERATION = 17;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    static final String objectType;

    public static void initBridgeServer() {
        isVMotionEnabled = TestConfig.tab().booleanAt(VIJavaPrms.vMotionEnabled, false);
        if (isVMotionEnabled) {
            VMotionTestBase.setvMotionDuringRegisterInterest();
        }
        PRObserver.installObserverHook();
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Region aRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        if (aRegion.getAttributes().getDataPolicy().withPartitioning() && aRegion.getAttributes().getPartitionAttributes().getRedundantCopies() > 0) {
            Log.getLogWriter().info("Recovery is expected in this test if data stores are stopped");
            BridgeNotifyBB.getBB().getSharedMap().put("expectRecovery", new Boolean(true));
        }
        CacheServer server = BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static void stopBridgeServer() {
        BridgeHelper.stopBridgeServer();
        CacheHelper.closeCache();
    }

    public static void initBridgeServerWithXml() {
        String cacheXmlFile = System.getProperty("user.dir") + "/" + System.getProperty("clientName") + ".xml";
        DistributedSystemHelper.connectWithXml(cacheXmlFile);
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), ConfigPrms.getRegionConfig(), ConfigPrms.getBridgeConfig(), ConfigPrms.getPoolConfig(), cacheXmlFile);
        Cache cache = CacheHelper.createCacheFromXml(cacheXmlFile);
        Region region = RegionHelper.getRegion(REGION_NAME);
        Log.getLogWriter().info("Created region myRegion with region attributes " + RegionHelper.regionAttributesToString(region.getAttributes()));
    }

    public static synchronized void HydraTask_initialize() {
        if (bridgeClient == null) {
            bridgeClient = new BridgeNotify();
            bridgeClient.initialize();
        }
    }

    public static void clearEventCounters() {
        EventCountersBB.getBB().zeroAllCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        this.useTransactions = InitImagePrms.useTransactions();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.randomValues = new RandomValues();
        ArrayList<String> oddKeys = new ArrayList<String>();
        ArrayList<String> evenKeys = new ArrayList<String>();
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            this.originalKeyList.add(key);
            if (i % 2 == 0) {
                evenKeys.add(key);
                continue;
            }
            oddKeys.add(key);
        }
        Class<BridgeNotify> clazz = BridgeNotify.class;
        synchronized (BridgeNotify.class) {
            if (CacheHelper.getCache() == null) {
                CacheHelper.createCache(ConfigPrms.getCacheConfig());
                AttributesFactory factory = RegionHelper.getAttributesFactory(ConfigPrms.getRegionConfig());
                CacheListener myListener = BridgeNotifyPrms.getClientListener();
                if (myListener != null) {
                    factory.setCacheListener(myListener);
                }
                Region aRegion = RegionHelper.createRegion(REGION_NAME, factory);
                CQUtil.initialize();
                CQUtil.initializeCQService();
                this.registerInterest(aRegion, myListener, oddKeys, evenKeys);
                BridgeNotifyBB.getBB().getSharedCounters().incrementAndRead(BridgeNotifyBB.NUM_LISTENERS);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerInterest(Region aRegion, CacheListener myListener, ArrayList oddKeys, ArrayList evenKeys) {
        String clientInterest = TestConfig.tasktab().stringAt(BridgeNotifyPrms.clientInterest, TestConfig.tab().stringAt(BridgeNotifyPrms.clientInterest, null));
        String query = "select distinct * from " + aRegion.getFullPath();
        boolean receiveValuesAsInvalidates = false;
        try {
            if (clientInterest.equalsIgnoreCase("allKeys")) {
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in ALL_KEYS");
            } else if (clientInterest.equalsIgnoreCase("singleKey")) {
                long maxNames = NameFactory.getPositiveNameCounter();
                String myKey = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
                query = "SELECT DISTINCT itr.value FROM " + aRegion.getFullPath() + ".entries itr where itr.key = '" + myKey + "'";
                ((SingleKeyListener)myListener).setSingleKey(myKey);
                aRegion.registerInterest((Object)myKey, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in a singleKey " + myKey);
                Class<BridgeNotifyBB> clazz = BridgeNotifyBB.class;
                synchronized (BridgeNotifyBB.class) {
                    List registeredKeys = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED);
                    registeredKeys.add(myKey);
                    BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.SINGLE_KEYS_REGISTERED, registeredKeys);
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    int numEntries = aRegion.keys().size();
                    if (numEntries != 1) {
                        throw new TestException("Registered interest in key, " + myKey + " and upon return from registerInterest, my local cache has " + numEntries + " keys");
                    }
                }
            } else if (clientInterest.equalsIgnoreCase("evenKeys")) {
                ((KeyListListener)myListener).setKeyList(evenKeys);
                aRegion.registerInterest((Object)evenKeys, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in KeyList " + evenKeys);
                int numEntries = aRegion.keys().size();
                if (numEntries != evenKeys.size()) {
                    throw new TestException("Registered interest in keyList with " + evenKeys.size() + " but after registerInterest, my local cache has " + numEntries + " keys");
                }
            } else if (clientInterest.equalsIgnoreCase("oddKeys")) {
                ((KeyListListener)myListener).setKeyList(oddKeys);
                aRegion.registerInterest((Object)oddKeys, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in KeyList " + oddKeys);
                int numEntries = aRegion.keys().size();
                if (numEntries != oddKeys.size()) {
                    throw new TestException("Registered interest in keyList with " + oddKeys.size() + " but after registerInterest, my local cache has " + numEntries + " keys");
                }
            } else if (clientInterest.equalsIgnoreCase("noInterest")) {
                Log.getLogWriter().info("Not registering interest in any keys");
            } else if (clientInterest.equalsIgnoreCase("receiveValuesAsInvalidates")) {
                aRegion.registerInterestRegex(".*", false, false);
                receiveValuesAsInvalidates = true;
                Log.getLogWriter().info("Registered interest to receiveValuesAsInvalidates");
            } else {
                throw new TestException("Invalid clientInterest " + clientInterest);
            }
            {
                Log.getLogWriter().info("Setting BridgeNotifyBB.RECEIVE_VALUES_AS_INVALIDATES to :" + receiveValuesAsInvalidates + " on BridgeNotifyBB");
                BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.RECEIVE_VALUES_AS_INVALIDATES, new Boolean(receiveValuesAsInvalidates));
            }
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        {
            CQUtil.registerCQ(aRegion);
            return;
        }
    }

    public static void HydraTask_populateRegion() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.populateRegion(rootRegion);
    }

    protected void populateRegion(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            String name = NameFactory.getNextPositiveObjectName();
            BaseValueHolder anObj = this.createObject(name, new RandomValues());
            aRegion.put((Object)name, (Object)anObj);
        }
        MasterController.sleepForMs(60000);
    }

    public static void HydraTask_getEntriesFromServer() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.getEntriesFromServer(rootRegion);
    }

    protected void getEntriesFromServer(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            String name = NameFactory.getObjectNameForCounter(i);
            try {
                aRegion.get((Object)name, (Object)"ignore afterCreate on get()");
                continue;
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Retrieved " + aRegion.keys().size() + " entries for region " + aRegion.getName());
    }

    public static void HydraTask_doEntryOperations() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.doEntryOperations(rootRegion);
    }

    protected void doEntryOperations(Region aRegion) {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            BridgeNotify.logExecutionNumber();
        }
        do {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(0));
            boolean rolledback = false;
            if (this.useTransactions) {
                TxHelper.begin();
            }
            try {
                int whichOp = this.getOperation(BridgeNotifyPrms.entryOperations, false);
                switch (whichOp) {
                    case 1: {
                        this.addObject(aRegion, true);
                        break;
                    }
                    case 13: {
                        this.addObjectViaPutAll(aRegion, true);
                        break;
                    }
                    case 3: {
                        this.invalidateObject(aRegion, false);
                        break;
                    }
                    case 4: {
                        this.destroyObject(aRegion, false);
                        break;
                    }
                    case 10: {
                        this.destroyAndCreateObject(aRegion, false);
                        break;
                    }
                    case 2: {
                        this.updateObject(aRegion);
                        break;
                    }
                    case 14: {
                        this.updateObjectViaPutAll(aRegion);
                        break;
                    }
                    case 5: {
                        this.readObject(aRegion);
                        break;
                    }
                    case 6: {
                        this.invalidateObject(aRegion, true);
                        break;
                    }
                    case 7: {
                        this.destroyObject(aRegion, true);
                        break;
                    }
                    case 8: {
                        this.closeRegion(aRegion);
                        break;
                    }
                    case 11: {
                        this.closeCache();
                        break;
                    }
                    case 12: {
                        this.killVM();
                        break;
                    }
                    case 15: {
                        this.putIfAbsent(aRegion, true);
                        break;
                    }
                    case 16: {
                        this.remove(aRegion);
                        break;
                    }
                    case 17: {
                        this.replace(aRegion);
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!this.useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + ".  " + TestHelper.getStackTrace(e));
            }
            if (!this.useTransactions || rolledback) continue;
            try {
                TxHelper.commit();
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
            }
            catch (TransactionDataRebalancedException e) {
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + ".  " + TestHelper.getStackTrace(e));
            }
            catch (TransactionInDoubtException e) {
                Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
            }
            catch (CommitConflictException e) {
                Log.getLogWriter().info("Caught CommitConflictException. Expected with concurrent execution, continuing test.");
            }
            if (!this.isSerialExecution) continue;
            TestHelper.checkForEventError(EventCountersBB.getBB());
            this.checkEventCounters();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        this.releaseThreadLocal(aRegion);
    }

    protected void releaseThreadLocal(Region aRegion) {
        ClientHelper.release(aRegion);
    }

    protected void query(Region aRegion, Object key, BaseValueHolder expectedValue) {
        if (TxHelper.exists()) {
            return;
        }
        SelectResults results = this.query(aRegion, key);
        if (this.isSerialExecution) {
            if (results.size() == 0) {
                if (expectedValue != null) {
                    throw new TestException("ExpectedValue = <" + expectedValue + ">, but query ResultSet was empty");
                }
                Log.getLogWriter().info("Successful validation of empty result set (null)");
            } else {
                BaseValueHolder result = (BaseValueHolder)results.asList().get(0);
                if (!result.equals(expectedValue)) {
                    throw new TestException("Expected value of " + key + " to be <" + expectedValue + "> but query returned <" + result + ">");
                }
                Log.getLogWriter().info("Successful validation of query results");
            }
        }
    }

    protected SelectResults query(Region aRegion, Object key) {
        String queryString = "SELECT DISTINCT itr.value FROM " + aRegion.getFullPath() + ".entries itr where itr.key = '" + key + "'";
        SelectResults results = null;
        try {
            results = aRegion.query(queryString);
            Log.getLogWriter().info("Query for Object <" + key + "> returned <" + results + ">");
        }
        catch (QueryInvocationTargetException te) {
            if (this.isSerialExecution) {
                throw new TestException("Caught exception " + TestHelper.getStackTrace(te) + " during RemoteQuery execution");
            }
            Log.getLogWriter().info("Caught QueryInvocationTargetException, expected during concurrent execution with failover, continuing execution");
        }
        catch (Exception e) {
            throw new TestException("Caught exception " + TestHelper.getStackTrace(e) + " during RemoteQuery execution");
        }
        return results;
    }

    protected void addObject(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectName();
        this.addObject(aRegion, name, logAddition);
    }

    protected void addObjectViaPutAll(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectName();
        this.addObjectViaPutAll(aRegion, name, logAddition);
    }

    protected void addObject(Region aRegion, String name, boolean logAddition) {
        List singleKeyList;
        Object anObj = this.getObjectToAdd(name);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        aRegion.put((Object)name, anObj, (Object)callback);
        long numPut = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CREATE", BridgeNotifyBB.NUM_CREATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)anObj);
    }

    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        List singleKeyList;
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + name + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath() + ".");
        }
        aRegion.putIfAbsent((Object)name, anObj);
        long numPut = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CREATE", BridgeNotifyBB.NUM_CREATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)anObj);
    }

    protected void addObjectViaPutAll(Region aRegion, String name, boolean logAddition) {
        List singleKeyList;
        Object anObj = this.getObjectToAdd(name);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(name, anObj);
        if (logAddition) {
            Log.getLogWriter().info("addObjectViaPutAll: calling putall for name " + name + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
        }
        aRegion.putAll(map);
        long numPut = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_PUTALL_CREATE", BridgeNotifyBB.NUM_PUTALL_CREATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)anObj);
    }

    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        List singleKeyList;
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Object name = null;
        for (Object potentialKey : aSet) {
            if (!aRegion.containsValueForKey(potentialKey)) continue;
            name = potentialKey;
            break;
        }
        if (name == null) {
            Log.getLogWriter().info("invalidateObject: No entries with value in region");
            return;
        }
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            long l;
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    l = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_LOCAL_INVALIDATE", BridgeNotifyBB.NUM_LOCAL_INVALIDATE);
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    l = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_INVALIDATE", BridgeNotifyBB.NUM_INVALIDATE);
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, null);
    }

    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        List singleKeyList;
        try {
            long l;
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                l = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_LOCAL_DESTROY", BridgeNotifyBB.NUM_LOCAL_DESTROY);
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                l = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_DESTROY", BridgeNotifyBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        catch (BridgeWriterException bwe) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(bwe));
            }
            Throwable cause = bwe.getCause();
            if (cause == null) {
                throw new TestException(TestHelper.getStackTrace(bwe));
            }
            if (cause.toString().startsWith("com.gemstone.gemfire.cache.EntryNotFoundException")) {
                Log.getLogWriter().info("Caught " + (Object)((Object)bwe) + " (expected with concurrent execution); continuing with test");
            }
            throw new TestException(TestHelper.getStackTrace(bwe));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, null);
    }

    protected void remove(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("remove: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            Object oldVal = aRegion.get(name);
            this.remove(aRegion, name, oldVal);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void remove(Region aRegion, Object name, Object oldVal) {
        boolean removed = false;
        try {
            Log.getLogWriter().info("remove: removing " + name + " with previous value " + oldVal + ".");
            removed = aRegion.remove(name, oldVal);
            Log.getLogWriter().info("remove: done removing " + name);
            if (removed) {
                long l = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_DESTROY", BridgeNotifyBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException("remove caught Unexpected Exception " + (Object)((Object)e) + "\n" + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
        if (removed) {
            List singleKeyList;
            int numExpectedEvents = 1;
            if (this.originalKeyList.contains(name)) {
                ++numExpectedEvents;
            }
            if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
                ++numExpectedEvents;
            }
            BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
            this.query(aRegion, name, null);
        }
    }

    protected void destroyAndCreateObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        String name = null;
        try {
            name = (String)iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
            if (TxHelper.exists()) {
                TxHelper.commit();
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (this.useTransactions) {
            TxHelper.begin();
        }
        this.addObject(aRegion, name, true);
    }

    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = null;
        for (Object potentialKey : aSet) {
            if (!aRegion.containsValueForKey(potentialKey)) continue;
            name = potentialKey;
            break;
        }
        if (name == null) {
            Log.getLogWriter().info("updateObject: No entries with value in region");
            return;
        }
        this.updateObject(aRegion, name);
    }

    protected void replace(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("replace: No names in region");
            return;
        }
        Object name = null;
        for (Object potentialKey : aSet) {
            if (!aRegion.containsValueForKey(potentialKey)) continue;
            name = potentialKey;
            break;
        }
        if (name == null) {
            Log.getLogWriter().info("updateObject: No entries with value in region");
            return;
        }
        this.replace(aRegion, name);
    }

    protected void replace(Region aRegion, Object name) {
        List singleKeyList;
        boolean replaced = false;
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException("replace caught unexpected Exception " + (Object)((Object)e) + "\n" + TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException("replace caught unexpected Exception " + (Object)((Object)e) + "\n" + TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ".");
            replaced = aRegion.replace(name, anObj, newObj);
        } else {
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + ".");
            Object returnVal = aRegion.replace(name, newObj);
            if (returnVal != null) {
                replaced = true;
            }
        }
        Log.getLogWriter().info("Done with call to replace");
        long numUpdate = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_UPDATE", BridgeNotifyBB.NUM_UPDATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)newObj);
    }

    protected void updateObjectViaPutAll(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = null;
        for (Object potentialKey : aSet) {
            if (!aRegion.containsValueForKey(potentialKey)) continue;
            name = potentialKey;
            break;
        }
        if (name == null) {
            Log.getLogWriter().info("updateObject: No entries with value in region");
            return;
        }
        this.updateObjectViaPutAll(aRegion, name);
    }

    protected void updateObject(Region aRegion, Object name) {
        List singleKeyList;
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
        aRegion.put(name, newObj, (Object)callback);
        Log.getLogWriter().info("Done with call to put (update)");
        long numUpdate = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_UPDATE", BridgeNotifyBB.NUM_UPDATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)newObj);
    }

    protected void updateObjectViaPutAll(Region aRegion, Object name) {
        List singleKeyList;
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(name, newObj);
        Log.getLogWriter().info("updateObjectViaPutAll: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj));
        aRegion.putAll(map);
        Log.getLogWriter().info("Done with call to putall (update)");
        long numUpdate = BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_PUTALL_UPDATE", BridgeNotifyBB.NUM_PUTALL_UPDATE);
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.numListeners, new Integer(numExpectedEvents));
        this.query(aRegion, name, (BaseValueHolder)newObj);
    }

    protected void readObject(Region aRegion) {
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            Object anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        this.query(aRegion, name);
    }

    public static void HydraTask_createAllKeys() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.createAllKeys(rootRegion);
    }

    public static void HydraTask_createAllKeysViaPutAll() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.createAllKeysViaPutAll(rootRegion);
    }

    protected void createAllKeys(Region aRegion) {
        String name;
        int i;
        for (i = 1; i <= this.numKeysInTest; ++i) {
            name = NameFactory.getObjectNameForCounter(i);
            aRegion.localDestroy((Object)name, (Object)"ignore localDestroy");
        }
        for (i = 1; i <= this.numKeysInTest; ++i) {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            name = NameFactory.getObjectNameForCounter(i);
            this.addObject(aRegion, name, true);
            this.checkEventCounters();
        }
    }

    protected void createAllKeysViaPutAll(Region aRegion) {
        String name;
        int i;
        for (i = 1; i <= this.numKeysInTest; ++i) {
            name = NameFactory.getObjectNameForCounter(i);
            aRegion.localDestroy((Object)name, (Object)"ignore localDestroy");
        }
        for (i = 1; i <= this.numKeysInTest; ++i) {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            name = NameFactory.getObjectNameForCounter(i);
            this.addObjectViaPutAll(aRegion, name, true);
            this.checkEventCounters();
        }
    }

    public static void HydraTask_updateAllKeys() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.updateAllKeys(rootRegion);
    }

    public static void HydraTask_updateAllKeysViaPutAll() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.updateAllKeysViaPutAll(rootRegion);
    }

    protected void updateAllKeys(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            String name = NameFactory.getObjectNameForCounter(i);
            this.updateObject(aRegion, name);
            this.checkEventCounters();
        }
    }

    protected void updateAllKeysViaPutAll(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            String name = NameFactory.getObjectNameForCounter(i);
            this.updateObjectViaPutAll(aRegion, name);
            this.checkEventCounters();
        }
    }

    public static void HydraTask_destroyAllKeys() {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        bridgeClient.destroyAllKeys(rootRegion);
    }

    protected void destroyAllKeys(Region aRegion) {
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            String name = NameFactory.getObjectNameForCounter(i);
            this.destroyObject(aRegion, name, false);
            this.checkEventCounters();
        }
    }

    protected void checkEventCounters() {
        throw new TestException("checkEventCounters must be implemented in a subclass");
    }

    protected Object getObjectToAdd(String name) {
        BaseValueHolder anObj = this.createObject(name, this.randomValues);
        return anObj;
    }

    protected Object getUpdateObject(String name) {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        BaseValueHolder anObj = null;
        BaseValueHolder newObj = null;
        try {
            anObj = (BaseValueHolder)rootRegion.get((Object)name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        newObj = anObj == null ? this.createObject(name, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected int getNumVMsWithListeners() {
        throw new TestException("getNumVMsWithListeners must be implemented in a subclass");
    }

    public static void HydraTask_printBB() throws Throwable {
        CacheBB.getBB().print();
        BridgeNotifyBB.getBB().print();
        EventCountersBB.getBB().print();
        TestHelper.checkForEventError(EventCountersBB.getBB());
    }

    public static void HydraTask_endTask() throws Throwable {
        TestHelper.checkForEventError(EventCountersBB.getBB());
        CacheBB.getBB().print();
        BridgeNotifyBB.getBB().print();
        EventCountersBB.getBB().print();
        bridgeClient = new BridgeNotify();
        bridgeClient.initialize();
        StringBuffer errStr = new StringBuffer();
        try {
            bridgeClient.checkEventCounters();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            Log.getLogWriter().info(e.toString());
            errStr.append(e.toString());
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        TestHelper.checkForEventError(EventCountersBB.getBB());
    }

    protected int getOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("putalladd")) {
                op = 13;
            } else if (operation.equals("putallupdate")) {
                op = 14;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equals("close")) {
                op = 8;
            } else if (operation.equals("clear")) {
                op = 9;
            } else if (operation.equals("destroyCreate")) {
                op = 10;
            } else if (operation.equals("cacheClose")) {
                op = 11;
            } else if (operation.equals("killVM")) {
                op = 12;
            } else if (operation.equals("putIfAbsent")) {
                op = 15;
            } else if (operation.equals("remove")) {
                op = 16;
            } else if (operation.equals("replace")) {
                op = 17;
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (disallowLocalEntryOps && (op == 6 || op == 7));
        return op;
    }

    protected static void logExecutionNumber() {
        long exeNum = BridgeNotifyBB.getBB().getSharedCounters().incrementAndRead(BridgeNotifyBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void verifyObjectInvalidated(Region aRegion, Object key) {
        Object entryValue;
        Object entryKey;
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (!containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) == null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned null\n");
        }
        if (!(entryKey = entry.getKey()).equals(key)) {
            errStr.append("getEntry.getKey() " + entryKey + " does not equal key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entryValue = entry.getValue()) != null) {
            errStr.append("Expected getEntry.getValue() " + TestHelper.toString(entryValue) + " to be null.\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void verifyObjectDestroyed(Region aRegion, Object key) {
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) != null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned was non-null; getKey is " + entry.getKey() + ", value is " + TestHelper.toString(entry.getValue()) + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static void HydraTask_validateEventsReceived() {
        bridgeClient.validateEventsReceived();
    }

    protected void validateEventsReceived() {
        Log.getLogWriter().info("invoked validateEventReceived()");
    }

    public static void HydraTask_recycleServer() throws ClientVmNotFoundException {
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        for (int i = 0; i < endpoints.size() - 1; ++i) {
            PRObserver.installObserverHook();
            PRObserver.initialize();
            BridgeHelper.Endpoint endpoint = endpoints.get(i);
            ClientVmInfo target = new ClientVmInfo(endpoint);
            ClientVmMgr.stop("HydraTask_recycleServer: " + endpoint, -22, -31, target);
            MasterController.sleepForMs(5000);
            ClientVmMgr.start("HydraTask_recycleServer, restarting", target);
            Object value = BridgeNotifyBB.getBB().getSharedMap().get("expectRecovery");
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            PRObserver.waitForRebalRecov(target, 1, 1, null, null, false);
        }
    }

    protected void closeRegion(Region aRegion) {
        Log.getLogWriter().info("closeRegion : closing region  " + aRegion.getFullPath());
        BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CLOSE", BridgeNotifyBB.NUM_CLOSE);
        int expectedSize = aRegion.entries(true).size();
        aRegion.close();
        Region newRegion = this.initRegion();
        int actualSize = newRegion.entries(true).size();
        if (actualSize != expectedSize) {
            String errStr = "Actual size " + actualSize + " of region " + aRegion.getFullPath() + " is not equal to expected size " + expectedSize;
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Expected size  : " + expectedSize + " Actual size : " + actualSize);
    }

    protected void closeCache() {
        Log.getLogWriter().info("closing Cache");
        BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CLOSE", BridgeNotifyBB.NUM_CLOSE);
        Region oldRegion = CacheHelper.getCache().getRegion("/myRegion");
        int expectedSize = oldRegion.entries(true).size();
        CacheHelper.closeCache();
        this.initialize();
        BridgeNotifyBB.getBB().getSharedCounters().decrementAndRead(BridgeNotifyBB.NUM_LISTENERS);
        Region newRegion = CacheHelper.getCache().getRegion("/myRegion");
        int actualSize = newRegion.entries(true).size();
        if (actualSize != expectedSize) {
            String errStr = "Actual size " + actualSize + " of region " + newRegion.getFullPath() + " is not equal to expected size " + expectedSize;
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Expected size  : " + expectedSize + " Actual size : " + actualSize);
    }

    protected void killVM() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Region initRegion() {
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.randomValues = new RandomValues();
        ArrayList<String> oddKeys = new ArrayList<String>();
        ArrayList<String> evenKeys = new ArrayList<String>();
        for (int i = 1; i <= this.numKeysInTest; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            this.originalKeyList.add(key);
            if (i % 2 == 0) {
                evenKeys.add(key);
                continue;
            }
            oddKeys.add(key);
        }
        Region aRegion = null;
        Class<BridgeNotify> clazz = BridgeNotify.class;
        synchronized (BridgeNotify.class) {
            if (CacheHelper.getCache() != null) {
                AttributesFactory factory = RegionHelper.getAttributesFactory(ConfigPrms.getRegionConfig());
                CacheListener myListener = BridgeNotifyPrms.getClientListener();
                if (myListener != null) {
                    factory.setCacheListener(myListener);
                }
                aRegion = RegionHelper.createRegion(REGION_NAME, factory);
                this.registerInterest(aRegion, myListener, oddKeys, evenKeys);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return aRegion;
        }
    }

    protected BaseValueHolder createObject(Object key, RandomValues rdmVal) {
        if (objectType.equals("delta.DeltaValueHolder")) {
            return new DeltaValueHolder((String)key, rdmVal);
        }
        return new ValueHolder((String)key, rdmVal);
    }

    static {
        objectType = TestConfig.tab().stringAt(ValueHolderPrms.objectType, "util.ValueHolder");
    }
}

