/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import event.EventBB;
import event.EventPrms;
import event.EventTest;
import hydra.CacheHelper;
import hydra.ClientPrms;
import hydra.ConfigPrms;
import hydra.GatewayHubHelper;
import hydra.GemFirePrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import util.BaseValueHolder;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class WBCLEventTest
extends EventTest {
    public Region rootRegion;

    public static void startGatewayHubTask() {
        ((WBCLEventTest)eventTest).startGatewayHub(ConfigPrms.getGatewayConfig());
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addWBCLGateway(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new WBCLEventTest();
            ((WBCLEventTest)eventTest).initialize();
        }
    }

    @Override
    protected void initialize() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        this.rootRegion = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        ((WBCLEventTest)eventTest).createGatewayHub();
        this.useTransactions = EventPrms.useTransactions();
        this.isSerialExecution = EventBB.isSerialExecution();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                this.numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            this.numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        Log.getLogWriter().info("numVMs is " + this.numVMs);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.maxRegions = TestConfig.tab().intAt(EventPrms.maxRegions, -1);
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, -1);
        this.randomValues = new RandomValues();
        this.isListenerTest = false;
        this.useCounters = this.isSerialExecution;
    }

    public static void HydraTask_doEntryOperations() {
        ((WBCLEventTest)eventTest).doEntryOperations();
    }

    public void doEntryOperations() {
        ((WBCLEventTest)eventTest).doEntryOperations(this.rootRegion);
    }

    @Override
    protected Object getUpdateObject(String name) {
        BaseValueHolder anObj = null;
        BaseValueHolder newObj = null;
        try {
            anObj = (BaseValueHolder)this.rootRegion.get((Object)name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        newObj = anObj == null ? new ValueHolder(name, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    public static void HydraTask_checkForEventErrors() {
        TestHelper.checkForEventError(EventBB.getBB());
    }
}

