/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAccessException;
import com.gemstone.gemfire.cache.RegionDistributionException;
import com.gemstone.gemfire.cache.RegionRoleException;
import com.gemstone.gemfire.distributed.Role;
import event.EventTest;
import hydra.Log;
import hydra.MasterController;
import java.util.Set;
import roles.RolesBB;
import util.CacheUtil;
import util.TestException;

public class ReliabilityEventTest
extends EventTest {
    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new ReliabilityEventTest();
            eventTest.initialize();
        }
    }

    public static void HydraTask_doEntryOperations() {
        Region rootRegion = null;
        do {
            rootRegion = CacheUtil.getCache().getRegion(ReliabilityEventTest.eventTest.regionName);
            MasterController.sleepForMs(3000);
        } while (rootRegion == null);
        eventTest.doEntryOperations(rootRegion);
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        try {
            super.addObject(aRegion, aBoolean);
        }
        catch (RegionRoleException e) {
            this.handleRegionRoleException(e);
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        try {
            super.invalidateObject(aRegion, isLocalInvalidate);
        }
        catch (RegionRoleException e) {
            this.handleRegionRoleException(e);
        }
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        try {
            super.destroyObject(aRegion, isLocalDestroy);
        }
        catch (RegionRoleException e) {
            this.handleRegionRoleException(e);
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        try {
            super.updateObject(aRegion);
        }
        catch (RegionRoleException e) {
            this.handleRegionRoleException(e);
        }
    }

    @Override
    protected void readObject(Region aRegion) {
        try {
            super.readObject(aRegion);
        }
        catch (RegionRoleException e) {
            this.handleRegionRoleException(e);
        }
    }

    protected void handleRegionRoleException(RegionRoleException e) {
        long count;
        String eName = null;
        Set missingRoles = null;
        if (e instanceof RegionDistributionException) {
            eName = "RegionDistributionException";
            missingRoles = ((RegionDistributionException)e).getFailedRoles();
            count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.regionDistributionExceptions);
            Log.getLogWriter().info("After incrementing counter, regionDistributionExceptions = " + count);
        } else if (e instanceof RegionAccessException) {
            eName = "RegionAccessException";
            missingRoles = ((RegionAccessException)e).getMissingRoles();
            count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.regionAccessExceptions);
            Log.getLogWriter().info("After incrementing counter, regionAccessExceptions = " + count);
        } else {
            throw new TestException("RegionRoleException: " + (Object)((Object)e) + " not supported by ReliabilityEventTest");
        }
        for (Role aRole : missingRoles) {
            if (aRole.getName().equals("server")) continue;
            throw new TestException(eName + " reports role " + aRole.getName() + " missing, but we only expect the role of server to be lost/gained");
        }
        Boolean regionAvailable = (Boolean)RolesBB.getBB().getSharedMap().get(RolesBB.RegionAvailablePrefix + System.getProperty("clientName"));
        if (regionAvailable == null || regionAvailable.equals(Boolean.FALSE)) {
            Log.getLogWriter().fine("caught " + eName + (Object)((Object)e) + " expected with current role loss; continuing test");
        }
    }
}

