/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionEvent;
import event.EventBB;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.OperationCountersBB;
import util.TestException;
import util.TestHelper;

public class OperationListener
extends AbstractListener
implements CacheListener,
Declarable {
    private boolean isCarefulValidation;

    public OperationListener() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
    }

    public OperationListener(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        if (!event.getOperation().isCreate()) {
            this.throwException("afterCreate invoked, but Operation.isCreate() returns false");
        }
        if (!event.getOperation().equals(Operation.SEARCH_CREATE)) {
            this.incrementAfterCreateCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        }
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        if (!event.getOperation().isDestroy()) {
            this.throwException("afterDestroy invoked, but Operation.isDestroy() returns false");
        }
        this.incrementAfterDestroyCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        if (!event.getOperation().isInvalidate()) {
            this.throwException("afterInvalidate invoked, but Operation.isInvalidate() returns false");
        }
        this.incrementAfterInvalidateCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        if (!event.getOperation().isUpdate()) {
            this.throwException("afterUpdate invoked, but Operation.isUpdate() returns false");
        }
        this.incrementAfterUpdateCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        if (!event.getOperation().isRegionDestroy()) {
            this.throwException("afterRegionDestroy invoked, but Operation.isRegionDestroy() returns false");
        }
        if (!event.getOperation().isClose()) {
            this.incrementAfterRegionDestroyCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        }
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        if (!event.getOperation().isRegionInvalidate()) {
            this.throwException("afterRegionInvalidate invoked, but Operation.isRegionInvalidate() returns false");
        }
        this.incrementAfterRegionInvalidateCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        if (event.getOperation() != Operation.REGION_CREATE) {
            this.throwException("afterRegionCreate invoked, but Operation.isRegionCreate() returns false");
        }
        this.incrementAfterRegionCreateCounters(event.getOperation(), (Blackboard)OperationCountersBB.getBB());
        this.verifyOperationMethods(event);
        this.checkVM();
    }

    public void close() {
        this.logCall("close", null);
        OperationCountersBB.getBB().getSharedCounters().increment(OperationCountersBB.numClose);
        this.checkVM();
    }

    protected void verifyOperationMethods(EntryEvent event) {
        Operation op = event.getOperation();
        if (!op.isEntry()) {
            this.throwException("Operation.isEntry() for EntryEvent returns false");
        }
        if (event.isDistributed() != op.isDistributed()) {
            this.throwException("event.isDistributed(" + event.isDistributed() + ") != op.isDistributed(" + op.isDistributed() + ")");
        }
        if (event.isExpiration() != op.isExpiration()) {
            this.throwException("event.isExpiration(" + event.isExpiration() + ") != op.isExpiration(" + op.isExpiration() + ")");
        }
        if (event.isLoad() != op.isLoad()) {
            this.throwException("event.isLoad(" + event.isLoad() + ") != op.isLoad(" + op.isLoad() + ")");
        }
        if (event.isLocalLoad() != op.isLocalLoad()) {
            this.throwException("event.isLocalLoad(" + event.isLocalLoad() + ") != op.isLocalLoad(" + op.isLocalLoad() + ")");
        }
        if (event.isNetLoad() != op.isNetLoad()) {
            this.throwException("event.isNetLoad(" + event.isNetLoad() + ") != op.isNetLoad(" + op.isNetLoad() + ")");
        }
        if (event.isNetSearch() != op.isNetSearch()) {
            this.throwException("event.isNetSearch(" + event.isNetSearch() + ") != op.isNetSearch(" + op.isNetSearch() + ")");
        }
    }

    protected void verifyOperationMethods(RegionEvent event) {
        Operation op = event.getOperation();
        if (!op.isRegion()) {
            this.throwException("Operation.isRegion() for RegionEvent returns false");
        }
        if (op.isRegionDestroy() || op.isRegionInvalidate()) {
            if (event.isDistributed() != op.isDistributed()) {
                this.throwException("event.isDistributed(" + event.isDistributed() + ") != op.isDistributed(" + op.isDistributed() + ")");
            }
            if (event.isExpiration() != op.isExpiration()) {
                this.throwException("event.isExpiration(" + event.isExpiration() + ") != op.isExpiration(" + op.isExpiration() + ")");
            }
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected event to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            SharedMap aMap = EventBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

