/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import event.EventBB;
import event.EventPrms;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;

public class ETListener
extends AbstractListener
implements CacheListener,
Declarable {
    protected boolean isCarefulValidation;
    private boolean useTransactions;

    public ETListener() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
        this.useTransactions = tab.booleanAt(EventPrms.useTransactions, false);
    }

    public ETListener(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        if (!event.getOperation().equals(Operation.SEARCH_CREATE)) {
            this.incrementAfterCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        }
        this.checkVM();
        String key = (String)event.getKey();
        if (!key.equals("invalidateMe")) {
            this.checkCallback((CacheEvent)event, "Create event originated in pid ");
        }
        this.validateProxyEventBehavior(event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.incrementAfterDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Destroy event originated in pid ");
        this.validateProxyEventBehavior(event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.incrementAfterInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Invalidate event originated in pid ");
        this.validateProxyEventBehavior(event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.incrementAfterUpdateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Update event originated in pid ");
        this.validateProxyEventBehavior(event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        if (!event.getOperation().isClose()) {
            this.incrementAfterRegionDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
            this.checkCallback((CacheEvent)event, "Region destroy event originated in pid ");
        }
        this.checkVM();
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.incrementAfterRegionInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Region invalidate event originated in pid ");
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        this.incrementAfterRegionCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
        this.incrementAfterRegionLiveCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void close() {
        this.logCall("close", null);
        EventCountersBB.getBB().getSharedCounters().increment(EventCountersBB.numClose);
        this.checkVM();
    }

    protected void validateProxyEventBehavior(EntryEvent event) {
        DataPolicy dataPolicy = null;
        try {
            dataPolicy = event.getRegion().getAttributes().getDataPolicy();
        }
        catch (RegionDestroyedException e) {
            if (this.isCarefulValidation) {
                this.throwException("Listener caught RegionDestroyedException while processing event " + event);
            }
            return;
        }
        catch (CancelException e) {
            return;
        }
        if (dataPolicy.isEmpty()) {
            if (event.isOriginRemote()) {
                if (!event.isOldValueAvailable() && event.getOldValue() != null) {
                    this.throwException("Listener detected remote Event with getOldValue = " + event.getOldValue() + " with DataPolicy " + dataPolicy + ".  Expected getOldValue null when event.isOldValueAvailable() is false");
                }
            } else if (!this.useTransactions && event.getOldValue() != null) {
                this.throwException("Listener detected local Event with getOldValue = " + event.getOldValue() + " with DataPolicy " + dataPolicy + " expected getOldValue = null");
            }
        }
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected event to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            SharedMap aMap = EventBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    protected void checkCallback(CacheEvent event, String expectedCallbackPrefix) {
        if (event.isOriginRemote()) {
            return;
        }
        if (event.getOperation().equals(Operation.SEARCH_CREATE)) {
            return;
        }
        String callbackObj = (String)event.getCallbackArgument();
        if (this.isCarefulValidation) {
            if (callbackObj == null) {
                String errStr = "Callback object is " + TestHelper.toString(callbackObj);
                SharedMap aMap = EventBB.getBB().getSharedMap();
                aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
                throw new TestException(errStr);
            }
            if (!callbackObj.startsWith(expectedCallbackPrefix)) {
                String errStr = "Expected " + expectedCallbackPrefix + ", but callback object is " + TestHelper.toString(callbackObj);
                SharedMap aMap = EventBB.getBB().getSharedMap();
                aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
                Log.getLogWriter().info(errStr);
                throw new TestException(errStr);
            }
        }
        if (callbackObj != null) {
            String memberIdString = "memberId=";
            int index = callbackObj.indexOf(memberIdString, 0);
            if (index > 0) {
                index += memberIdString.length();
                memberIdString = callbackObj.substring(index);
                Log.getLogWriter().info("memberId from callbackObj = <" + memberIdString + "> memberId from event = <" + event.getDistributedMember() + ">");
                if (!memberIdString.equals(event.getDistributedMember().toString())) {
                    String errStr = "Expected <" + event.getDistributedMember() + ">, but callback object contains <" + memberIdString + ">";
                    SharedMap aMap = EventBB.getBB().getSharedMap();
                    aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
                    Log.getLogWriter().info(errStr);
                    throw new TestException(errStr);
                }
            }
            int myPID = ProcessMgr.getProcessId();
            String tmpCallbackObj = callbackObj + " ";
            boolean eventProducedInThisVM = tmpCallbackObj.indexOf("pid " + myPID + " ") >= 0;
            boolean isRemote = event.isOriginRemote();
            if (isRemote == eventProducedInThisVM) {
                String errStr = "Unexpected event.isOriginRemote() = " + isRemote + ", myPID = " + myPID + ", callbackObj showing origination VM = " + callbackObj;
                SharedMap aMap = EventBB.getBB().getSharedMap();
                aMap.put(TestHelper.EVENT_ERROR_KEY, errStr);
                Log.getLogWriter().info(errStr);
                throw new TestException(errStr);
            }
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

