/*
 * Decompiled with CFR 0.152.
 */
package dunit.eclipse;

import batterytest.greplogs.SuspectGrepOutputStream;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.concurrent.CDL;
import com.gemstone.gemfire.internal.concurrent.CFactory;
import dunit.DUnitEnv;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.eclipse.EclipseDUnitEnv;
import dunit.eclipse.FakeMaster;
import dunit.eclipse.FakeRemoteTestModule;
import dunit.eclipse.ProcessManager;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.RemoteTestModuleIF;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import org.junit.Assert;

public class DUnitLauncher {
    private static final String LAUNCHED_PROPERTY = "gemfire.DUnitLauncher.LAUNCHED";
    static final String VM_NUM_PARAM = "gemfire.DUnitLauncher.VM_NUM";
    static final String RMI_PORT_PARAM = "gemfire.DUnitLauncher.RMI_PORT";
    private static final int NUM_VMS = Integer.getInteger("dunit.num.vms", 4);
    static final String MASTER_PARAM = "DUNIT_MASTER";
    private static final long STARTUP_TIMEOUT = 30000L;
    public static final String DUNIT_DIR = "dunit";
    public static final String LOG_LEVEL = "fine";
    private static final File OUTPUT_FILE = new File("dunit_output.log");
    public static final String WORKSPACE_DIR_PARAM = "WORKSPACE_DIR";
    private static boolean isLaunched = false;
    static int locatorPort;
    private static SuspectGrepOutputStream suspectGrepper;

    private DUnitLauncher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchIfNeeded() {
        if (System.getProperties().contains(VM_NUM_PARAM)) {
            return;
        }
        try {
            TestConfig.getInstance();
        }
        catch (Exception e) {
            try {
                Class<DUnitLauncher> clazz = DUnitLauncher.class;
                synchronized (DUnitLauncher.class) {
                    if (!DUnitLauncher.isLaunched()) {
                        System.err.println("redirecting output to " + OUTPUT_FILE);
                        System.setOut(new PrintStream(OUTPUT_FILE));
                        DUnitLauncher.launch();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("Unable to launch dunit VMS", e2);
            }
        }
    }

    public static boolean isLaunched() {
        return isLaunched;
    }

    public static String getLocatorString() {
        return "localhost[" + locatorPort + "]";
    }

    private static void launch() throws URISyntaxException, AlreadyBoundException, IOException, InterruptedException, NotBoundException {
        LogWriter log = Log.createLogWriter("dunit-master", LOG_LEVEL);
        locatorPort = AvailablePortHelper.getRandomAvailableTCPPort();
        int namingPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Registry registry = LocateRegistry.createRegistry(namingPort);
        Master master = new Master();
        registry.bind(MASTER_PARAM, master);
        final ProcessManager processManager = new ProcessManager(NUM_VMS + 1, namingPort);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                processManager.killVMs();
            }
        });
        processManager.launchVMs();
        if (!master.waitForVMs(30000L)) {
            throw new RuntimeException("VMs did not start up with 30 seconds");
        }
        EclipseDUnitHost host = new EclipseDUnitHost(InetAddress.getLocalHost().getCanonicalHostName(), NUM_VMS);
        host.init(registry);
        DUnitLauncher.initSystemProperties(log);
        DUnitLauncher.startLocator(registry);
    }

    public static Properties getDistributedSystemProperties() {
        Properties p = new Properties();
        p.setProperty("locators", DUnitLauncher.getLocatorString());
        p.setProperty("mcast-port", "0");
        p.setProperty("log-level", LOG_LEVEL);
        return p;
    }

    private static void startLocator(Registry registry) throws IOException, NotBoundException {
        RemoteTestModuleIF remote = (RemoteTestModuleIF)registry.lookup("vm" + NUM_VMS);
        final File locatorLogFile = new File("locator-" + locatorPort + ".log");
        remote.executeMethodOnObject(new SerializableCallable(){

            public Object call() throws IOException {
                Properties p = DUnitLauncher.getDistributedSystemProperties();
                p.setProperty("jmx-manager", "false");
                Locator.startLocatorAndDS((int)locatorPort, (File)locatorLogFile, (Properties)p);
                return null;
            }
        }, "call");
    }

    public static void initSystemProperties(LogWriter log) {
        System.setProperty("gemfireName", "gemfire1");
        String workspaceDir = System.getProperty(WORKSPACE_DIR_PARAM);
        workspaceDir = workspaceDir == null ? new File(".").getAbsolutePath() : workspaceDir;
        System.setProperty("JTESTS", workspaceDir + "/tests");
        System.setProperty("EXTRA_JTESTS", workspaceDir + "/gemfirexd/GemFireXDTests");
        System.out.println("Using JTESTS is set to " + System.getProperty("JTESTS"));
        System.setProperty("gf.ldap.server", "ldap");
        System.setProperty("gf.ldap.basedn", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com");
        isLaunched = true;
        RemoteTestModule.Master = new FakeMaster();
        DUnitEnv.set(new EclipseDUnitEnv());
        suspectGrepper = new SuspectGrepOutputStream(System.out, "STDOUT", 5, DUNIT_DIR, Charset.defaultCharset());
        System.setOut(new PrintStream(suspectGrepper));
    }

    public static void checkForSuspectStrings() {
        String suspectString;
        if (suspectGrepper != null && (suspectString = suspectGrepper.getAndClearSuspects()) != null) {
            Assert.fail((String)("Suspicious strings were written to the log during this run. Fix the strings or use DistributedTestCase.addExpectedException to ignore.\n " + suspectString));
        }
    }

    private static class EclipseDUnitHost
    extends Host {
        private static final long serialVersionUID = -8034165624503666383L;
        private int numVms;

        public EclipseDUnitHost(String hostName, int numVms) {
            super(hostName);
            this.numVms = numVms;
        }

        public void init(Registry registry) throws AccessException, RemoteException, NotBoundException {
            for (int i = 0; i < this.numVms; ++i) {
                RemoteTestModuleIF remote = (RemoteTestModuleIF)registry.lookup("vm" + i);
                this.addVM(i, "vm" + i, remote);
            }
            this.addVM(this.numVms, "vm" + this.numVms, new FakeRemoteTestModule(Log.getLogWriter()));
            this.addLocator(this.numVms + 1, "vm" + this.numVms + 1, (RemoteTestModuleIF)registry.lookup("vm" + NUM_VMS));
            EclipseDUnitHost.addHost(this);
        }

        @Override
        public int getVMCount() {
            return super.getVMCount() - 1;
        }
    }

    public static class Master
    extends UnicastRemoteObject
    implements MasterRemote {
        private static final long serialVersionUID = 1178600200232603119L;
        private CDL latch = CFactory.createCDL((int)(DUnitLauncher.access$000() + 1));

        @Override
        public int getLocatorPort() throws RemoteException {
            return locatorPort;
        }

        @Override
        public void signalVMReady() {
            this.latch.countDown();
        }

        public boolean waitForVMs(long timeout) throws InterruptedException {
            return this.latch.await(timeout);
        }

        @Override
        public void ping() {
        }
    }

    public static interface MasterRemote
    extends Remote {
        public int getLocatorPort() throws RemoteException;

        public void signalVMReady() throws RemoteException;

        public void ping() throws RemoteException;
    }
}

