/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.NanoTimer;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import util.CacheUtil;

public class SyncArrayListWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        List obj = Collections.synchronizedList(new ArrayList());
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        List obj = (List)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.SyncArrayListReads);
    }

    @Override
    protected Object update(Object obj) {
        List newobj = (List)obj;
        newobj.add(String.valueOf(NanoTimer.getTime()));
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.SyncArrayListUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        List obj = (List)CacheUtil.get(region, info.getName());
        if ((long)obj.size() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

