/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import dlock.DLockPrms;
import dlock.DLockUtil;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.Serializable;
import util.CacheUtil;

public class SimpleDLockClient {
    private static Cache TheCache;
    private static Region TheRegion;
    private static final String ROOT_REGION_NAME = "DLockRegion";

    public static synchronized void createCacheTask() {
        if (TheCache == null) {
            TheCache = CacheUtil.createCache();
            RegionAttributes ratts = SimpleDLockClient.getRegionAttributes();
            TheRegion = CacheUtil.createRegion(ROOT_REGION_NAME, ratts);
        }
    }

    private static RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        Scope scope = DLockPrms.getScope();
        factory.setScope(scope);
        Log.getLogWriter().info("Setting scope to " + scope);
        RegionAttributes ratts = factory.createRegionAttributes();
        return ratts;
    }

    public static synchronized void closeCacheTask() {
        if (TheCache != null) {
            CacheUtil.closeCache();
            TheCache = null;
            TheRegion = null;
        }
    }

    public static void lockObj() {
        SimpleDLockClient client = new SimpleDLockClient();
        client.lockObjWork();
    }

    private void lockObjWork() {
        int counter;
        SerializableObject obj = new SerializableObject();
        String myClientName = RemoteTestModule.getMyClientName();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String key = new String("Object_" + tid);
        CacheUtil.put(TheRegion, key, obj);
        int numTimesToEnterLock = SimpleDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
        Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
        SimpleDLockClient.log().info("locking " + key + " " + obj);
        for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
            DLockUtil.getLock(key);
        }
        SimpleDLockClient.log().info("locked " + key + " " + obj);
        MasterController.sleepForMs(2000);
        SimpleDLockClient.log().info("unlocking " + key + " " + obj);
        for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
            DLockUtil.unlock(key);
        }
        SimpleDLockClient.log().info("unlocked " + key + " " + obj);
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    public static class SerializableObject
    implements Serializable {
    }
}

