/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import dlock.DLockBlackboard;
import hydra.DistributedConnectionMgr;
import hydra.Log;
import hydra.TestConfig;
import util.TestException;
import util.TestHelperPrms;

public class DLSCreateDestroy {
    protected static final String LOCK_SERVICE_PREFIX = "MyLockService_";

    public static void HydraTask_CreateDestroy() {
        DLSCreateDestroy testInstance = new DLSCreateDestroy();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            testInstance.doCreateDestroy();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    private void doCreateDestroy() {
        DistributedSystem dSystem = DistributedConnectionMgr.connect();
        if (dSystem == null) {
            throw new TestException("DistributedSystem is " + dSystem);
        }
        int destroyPercent = 10;
        int numDLS = 10;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, numDLS);
        String lockServiceName = LOCK_SERVICE_PREFIX + randInt;
        Log.getLogWriter().info("Getting DistributedLockService with name " + lockServiceName);
        DistributedLockService dls = DistributedLockService.getServiceNamed((String)lockServiceName);
        long attempts = 0L;
        while (dls == null) {
            try {
                Log.getLogWriter().info("Creating DistributedLockService with name " + lockServiceName);
                dls = DistributedLockService.create((String)lockServiceName, (DistributedSystem)dSystem);
                Log.getLogWriter().info("Created " + dls);
            }
            catch (IllegalArgumentException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while creating dls " + ex);
                dls = DistributedLockService.getServiceNamed((String)lockServiceName);
            }
            if (++attempts <= 100L) continue;
            throw new TestException("Could not get dls for " + lockServiceName + " in 100 attempts");
        }
        try {
            String objectToLock = "LockFor-" + lockServiceName + "_" + DLockBlackboard.getInstance().getSharedCounters().incrementAndRead(DLockBlackboard.LockNameIndex);
            Log.getLogWriter().info("Locking object " + objectToLock + " in " + dls);
            boolean gotLock = dls.lock((Object)objectToLock, -1L, -1L);
            Log.getLogWriter().info("Using " + dls + ", got lock " + gotLock);
            if (!gotLock) {
                throw new TestException("Didn't get lock: " + gotLock);
            }
        }
        catch (CancelException ex) {
            Log.getLogWriter().info("Got expected Exception: Caught while getting lock " + (Object)((Object)ex));
        }
        catch (IllegalStateException ex) {
            if (((DLockService)dls).isDestroyed()) {
                Log.getLogWriter().info("Got expected Exception: Caught while getting lock " + ex);
            }
            throw ex;
        }
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= destroyPercent) {
            try {
                Log.getLogWriter().info("Freeing resource for " + dls);
                dls.freeResources((Object)lockServiceName);
            }
            catch (IllegalArgumentException ex) {
                String errStr = ex.toString();
                if (errStr.indexOf("Service named " + lockServiceName + " not created") >= 0) {
                    Log.getLogWriter().info("Got expected Exception: Caught while destroying " + ex);
                }
                throw ex;
            }
            catch (CancelException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while destroying " + (Object)((Object)ex));
            }
            catch (IllegalStateException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while destroying " + ex);
            }
        }
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= destroyPercent) {
            try {
                Log.getLogWriter().info("Destroying " + dls);
                DistributedLockService.destroy((String)lockServiceName);
                Log.getLogWriter().info("Destroyed " + dls);
            }
            catch (IllegalArgumentException ex) {
                String errStr = ex.toString();
                if (errStr.indexOf("Service named " + lockServiceName + " not created") >= 0) {
                    Log.getLogWriter().info("Got expected Exception: Caught while destroying " + ex);
                }
                throw ex;
            }
            catch (CancelException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while destroying " + (Object)((Object)ex));
            }
            catch (IllegalStateException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while destroying " + ex);
            }
        }
    }
}

