/*
 * Decompiled with CFR 0.152.
 */
package diskReg.oplogs;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.TestHelperForHydraTests;
import diskReg.DiskRegPrms;
import diskReg.DiskRegUtil;
import diskReg.oplogs.DiskBB;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.NameFactory;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class DiskRegRecoveryFromOplogsTest {
    static DiskRegRecoveryFromOplogsTest testInstance;
    private static RegionAttributes attr;
    private static Cache cache;
    static Region diskRegion;
    static String regionName;
    protected static final int DISK_FOR_PERSIST = 1;
    protected static final int DISK_FOR_OVRFLW_PERSIST = 2;
    protected static final String INIT_REGION_SIZE = "initial region size";
    protected int numVMsToStop;
    static volatile int putKeyInt;
    static Object putLock;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new DiskRegRecoveryFromOplogsTest();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        try {
            if (cache == null || cache.isClosed()) {
                cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            }
            TestHelperForHydraTests.setIssueCallbacksOfCacheObserver(true);
            attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            this.createDiskRegion();
            boolean populateCache = TestConfig.tab().booleanAt(MapPrms.populateCache, false);
            if (populateCache) {
                this.addInBatches();
                int sizeInCurrentVm = diskRegion.size();
                Integer sizeInt = (Integer)DiskBB.getBB().getSharedMap().get(INIT_REGION_SIZE);
                int sizeInAnotherVM = 0;
                if (sizeInt != null) {
                    sizeInAnotherVM = sizeInt;
                }
                if (sizeInAnotherVM == 0 || sizeInCurrentVm < sizeInAnotherVM) {
                    DiskBB.getBB().getSharedMap().put(INIT_REGION_SIZE, new Integer(sizeInCurrentVm));
                }
                Log.getLogWriter().info("DiskRegion is initialized with " + sizeInCurrentVm + " entries");
            }
            this.numVMsToStop = TestConfig.tab().intAt(MapPrms.numVMsToStop, 1);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void createDiskRegion() {
        try {
            diskRegion = RegionHelper.createRegion(regionName, attr);
            Log.getLogWriter().info("diskRegion size after recovery is: " + diskRegion.size());
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void HydraTask_addEntries() {
        testInstance.addInBatches();
        int endTestOnNumKeysInRegion = TestConfig.tab().intAt(DiskRegPrms.endTestOnNumKeysInRegion, -1);
        try {
            if (endTestOnNumKeysInRegion > -1) {
                int numKeys = diskRegion.keySet().size();
                Log.getLogWriter().info("Current numKeys is " + numKeys + ", endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
                if (numKeys >= endTestOnNumKeysInRegion) {
                    throw new StopSchedulingTaskOnClientOrder("Workload based test has " + numKeys + " keys in region, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
                }
            }
        }
        catch (CancelException cclex) {
            Log.getLogWriter().info("CancelException may occur in concurrent environment - continuing with test: " + (Object)((Object)cclex));
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException may occur in concurrent environment - continuing with test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInBatches() {
        try {
            long limit = TestConfig.tab().longAt(MapPrms.timeForPutOperation);
            String key = null;
            Object val = null;
            Object returnObj = null;
            String objectType = MapPrms.getObjectType();
            long startTime = System.currentTimeMillis();
            do {
                Object object = putLock;
                synchronized (object) {
                    key = NameFactory.getNextPositiveObjectName();
                    putKeyInt = (int)NameFactory.getCounterForName(key);
                    val = ObjectHelper.createObject(objectType, putKeyInt);
                }
                diskRegion.put((Object)key, val);
                DiskBB.getBB();
                DiskBB.incrementCounter("DiskBB.NUM_PUT ", DiskBB.NUM_PUT);
            } while (System.currentTimeMillis() - startTime < limit);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException may occur in concurrent environment - continuing with test");
            Log.getLogWriter().info("recovering region");
            this.recoverRegion();
        }
        catch (CancelException cclex) {
            Log.getLogWriter().info("CancelException may occur in concurrent environment - continuing with test: " + (Object)((Object)cclex));
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void HydraTask_closeRegion() {
        testInstance.closeRegion();
    }

    protected void closeRegion() {
        try {
            diskRegion.close();
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException may occur in concurrent environment - continuing with test");
            Log.getLogWriter().info("recovering region");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected synchronized void recoverRegion() {
        try {
            if (diskRegion == null || diskRegion.isDestroyed()) {
                diskRegion = cache.createRegion(regionName, attr);
                Log.getLogWriter().info("created region: " + diskRegion);
            }
        }
        catch (RegionExistsException rex) {
            Log.getLogWriter().info("RegionExistsException may occur in concurrent environment - continuing with test");
        }
        catch (CancelException cclex) {
            Log.getLogWriter().info("CancelException may occur in concurrent environment - continuing with test: " + (Object)((Object)cclex));
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_closeTask() {
        if (testInstance != null) {
            testInstance.validateRegionAfterRecovery();
            testInstance.closeCache();
            testInstance = null;
        }
    }

    protected void validateRegion() {
        try {
            if (cache != null || !cache.isClosed()) {
                if (diskRegion.isDestroyed()) {
                    this.reinitialize();
                }
                int numOfEntries = (int)DiskBB.getBB().getSharedCounters().read(DiskBB.NUM_PUT);
                int diskRegSize = diskRegion.size();
                int nameFactoryCntr = (int)NameFactory.getPositiveNameCounter();
                if (!MapPrms.getCloseCacheDuringGii()) {
                    if (nameFactoryCntr - numOfEntries < nameFactoryCntr - diskRegSize) {
                        throw new TestException("Region recovery failure. Number of puts happened are: " + numOfEntries + ". But Region size is: " + diskRegSize);
                    }
                } else {
                    Integer minRegSize = (Integer)DiskBB.getBB().getSharedMap().get(INIT_REGION_SIZE);
                    if (minRegSize != null) {
                        numOfEntries = minRegSize;
                    }
                    if (Log.getLogWriter().fineEnabled()) {
                        Log.getLogWriter().info("diskRegSize: " + diskRegSize + ". numOfEntries " + numOfEntries);
                    }
                    if (diskRegSize < numOfEntries) {
                        throw new TestException("Region recovery failure. Min. number of puts happened are: " + numOfEntries + ". But Region size is: " + diskRegSize);
                    }
                }
                Set keySet = diskRegion.keySet();
                for (Object key : keySet) {
                    int keyInt = (int)NameFactory.getCounterForName(key);
                    Object value = diskRegion.get(key);
                    ObjectHelper.validate(keyInt, value);
                }
                Log.getLogWriter().info("Region recovery is successful");
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected synchronized void closeCache() {
        try {
            if (cache != null || !cache.isClosed()) {
                CacheHelper.closeCache();
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_crashVM() {
        testInstance.crashVM();
        if (MapPrms.getCloseCacheDuringGii()) {
            testInstance.reinitialize();
        }
    }

    protected void crashVM() {
        try {
            Log.getLogWriter().info("In crashVM ...");
            Vector otherVmIds = ClientVmMgr.getOtherClientVmids();
            for (int i = 0; i < otherVmIds.size(); ++i) {
                DiskBB.getBB().getSharedCounters().zero(DiskBB.VmReinitializedCounter);
                DiskBB.getBB().getSharedCounters().zero(DiskBB.VmRestartedCounter);
                ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
                ArrayList<String> stopModeList = new ArrayList<String>();
                Integer vmID = (Integer)otherVmIds.get(i);
                ClientVmInfo targetVm = new ClientVmInfo(vmID, null, null);
                vmList.add(targetVm);
                stopModeList.add("mean_kill");
                otherVmIds.remove(i);
                for (int j = 1; j < this.numVMsToStop; ++j) {
                    int randInt = TestConfig.tab().getRandGen().nextInt(0, otherVmIds.size() - 1);
                    vmID = (Integer)otherVmIds.get(randInt);
                    targetVm = new ClientVmInfo(vmID, null, null);
                    vmList.add(targetVm);
                    stopModeList.add("mean_kill");
                    otherVmIds.remove(randInt);
                }
                Log.getLogWriter().info("numVMsToStop is " + this.numVMsToStop + ", stopping " + vmList);
                List threadList = StopStartVMs.stopStartAsync(vmList, stopModeList);
                if (MapPrms.getCloseCacheDuringGii()) {
                    TestHelper.waitForCounter(DiskBB.getBB(), "DiskBB.VmRestartedCounter", DiskBB.VmRestartedCounter, 1L, false, 120000L);
                    Log.getLogWriter().info("Closing cache for gii");
                    cache.close();
                    Log.getLogWriter().info("Closed cache");
                }
                testInstance.reinitialize();
                StopStartVMs.joinStopStart(vmList, threadList);
            }
            Thread.sleep(2000L);
            Log.getLogWriter().info("Done crashing and restarting vms");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_Reinitialize() {
        if (testInstance == null) {
            testInstance = new DiskRegRecoveryFromOplogsTest();
            long counter = DiskBB.getBB().getSharedCounters().incrementAndRead(DiskBB.VmRestartedCounter);
            Log.getLogWriter().info("VmRestartedCounter is now " + counter);
            testInstance.reinitialize();
            counter = DiskBB.getBB().getSharedCounters().incrementAndRead(DiskBB.VmReinitializedCounter);
            Log.getLogWriter().info("VmReinitializedCounter is now " + counter);
        }
    }

    protected void reinitialize() {
        try {
            if (cache == null || cache.isClosed()) {
                cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            }
            attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            if (MapPrms.getCloseCacheDuringGii()) {
                InitialImageOperation.slowImageProcessing = 1;
            }
            this.createDiskRegion();
            this.numVMsToStop = TestConfig.tab().intAt(MapPrms.numVMsToStop, 1);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void validateRegionAfterRecovery() {
        try {
            this.validateRegion();
            int regionSize = diskRegion.size();
            Log.getLogWriter().info("regionSize: " + regionSize);
            int evictionLimit = 0;
            int regionType = 0;
            boolean persistentReplicate = attr.getDataPolicy().isPersistentReplicate();
            evictionLimit = attr.getEvictionAttributes().getMaximum();
            if (persistentReplicate) {
                regionType = evictionLimit <= 0 ? 1 : 2;
            }
            switch (regionType) {
                case 1: {
                    int numEntriesWrittenToDisk = (int)DiskRegUtil.getNumEntriesWrittenToDisk(diskRegion);
                    int numEntriesInVm = (int)DiskRegUtil.getNumEntriesInVM(diskRegion);
                    int numEntriesOverflownToDisk = (int)DiskRegUtil.getNumOverflowOnDisk(diskRegion);
                    int numRecoveredEntriesFromDisk = (int)DiskRegUtil.getRecoveredEntryCount(diskRegion);
                    Log.getLogWriter().info("numEntriesWrittenToDisk: " + numEntriesWrittenToDisk);
                    Log.getLogWriter().info("numEntriesInVm: " + numEntriesInVm);
                    Log.getLogWriter().info("numEntriesOverflownToDisk: " + numEntriesOverflownToDisk);
                    Log.getLogWriter().info("numRecoveredEntriesFromDisk: " + numRecoveredEntriesFromDisk);
                    if (numEntriesWrittenToDisk != regionSize - numRecoveredEntriesFromDisk) {
                        throw new TestException("After region recovery, numEntriesWrittenToDisk is not equal to numEntriesInVm for persistent_replicate region");
                    }
                    if (numEntriesOverflownToDisk != 0) {
                        throw new TestException("After region recovery, numEntriesOverflownToDisk is not zero for persistent_replicate region");
                    }
                    Log.getLogWriter().info("Done with verification of statistics after region recovery for region type:- DISK_FOR_PERSIST");
                    break;
                }
                case 2: {
                    int numEntriesWrittenToDisk = (int)DiskRegUtil.getNumEntriesWrittenToDisk(diskRegion);
                    int numEntriesInVm = (int)DiskRegUtil.getNumEntriesInVM(diskRegion);
                    int numEntriesOverflownToDisk = (int)DiskRegUtil.getNumOverflowOnDisk(diskRegion);
                    int numRecoveredEntriesFromDisk = (int)DiskRegUtil.getRecoveredEntryCount(diskRegion);
                    Log.getLogWriter().info("numEntriesWrittenToDisk: " + numEntriesWrittenToDisk);
                    Log.getLogWriter().info("numEntriesInVm: " + numEntriesInVm);
                    Log.getLogWriter().info("numEntriesOverflownToDisk: " + numEntriesOverflownToDisk);
                    Log.getLogWriter().info("numRecoveredEntriesFromDisk: " + numRecoveredEntriesFromDisk);
                    Log.getLogWriter().info("Done with verification of statistics after region recovery for region type:- DISK_FOR_OVRFLW_PERSIST");
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    static {
        diskRegion = null;
        putKeyInt = 0;
        putLock = "put";
    }
}

