/*
 * Decompiled with CFR 0.152.
 */
package diskRecovery;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.persistence.ConflictingPersistentDataException;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.cache.snapshot.CacheSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotFilter;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.internal.cache.persistence.PersistenceObserverHolder;
import com.gemstone.gemfire.pdx.PdxInstance;
import diskRecovery.RecoveryBB;
import diskRecovery.RecoveryPrms;
import diskRecovery.RecoveryTest;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.DiskStoreHelper;
import hydra.DiskStorePrms;
import hydra.GsRandom;
import hydra.HostHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import pdx.PdxTest;
import snapshot.SnapshotPrms;
import util.AdminHelper;
import util.BaseValueHolder;
import util.CliHelperPrms;
import util.DeclarativeGenerator;
import util.NameFactory;
import util.PRObserver;
import util.PersistenceUtil;
import util.RandomValues;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class RecoveryTestVersionHelper {
    public static void setRandomDiskStore(RegionAttributes baseAttr, AttributesFactory attrFac, List<String> diskStoreNames, GsRandom rand) {
        if (baseAttr.getDiskStoreName() != null && baseAttr.getDiskStoreName().equals("notUsed")) {
            String diskStoreName = diskStoreNames.get(rand.nextInt(1, diskStoreNames.size() - 1));
            if (diskStoreName.equals("unused")) {
                throw new TestException("Error in test, diskStoreName is " + diskStoreName);
            }
            Log.getLogWriter().info("Test is setting diskStoreName to " + diskStoreName);
            attrFac.setDiskStoreName(diskStoreName);
        }
    }

    public static String createDiskStore(RegionAttributes attr) {
        String diskDirsStr = "";
        Log.getLogWriter().info("DiskStore name in attributes is " + attr.getDiskStoreName());
        if (attr.getDiskStoreName() != null && !attr.getDiskStoreName().equals("notUsed")) {
            File[] diskDirs;
            Log.getLogWriter().info("Creating diskStore " + attr.getDiskStoreName());
            DiskStoreFactory dsFactory = DiskStoreHelper.getDiskStoreFactory(attr.getDiskStoreName());
            dsFactory.create(attr.getDiskStoreName());
            for (File diskDir : diskDirs = CacheHelper.getCache().findDiskStore(attr.getDiskStoreName()).getDiskDirs()) {
                diskDirsStr = diskDirsStr + diskDir.getName() + " ";
            }
            diskDirsStr = " with disk dirs " + diskDirsStr;
        }
        return "disk store name is " + attr.getDiskStoreName() + " " + diskDirsStr;
    }

    public static void logDiskStore(Region aRegion, StringBuffer aStr) {
        if (aRegion.getAttributes().getDiskStoreName() != null) {
            aStr.append(" diskStoreName " + aRegion.getAttributes().getDiskStoreName());
        }
    }

    public static void installPersistenceObserver() {
        PersistenceObserverHolder.PersistenceObserver observer = RecoveryPrms.getPersistenceObserver();
        if (observer == null) {
            Log.getLogWriter().info("No PersistenceObserver was specified");
        } else {
            Log.getLogWriter().info("Installing " + observer.getClass().getName());
            PersistenceObserverHolder.setInstance((PersistenceObserverHolder.PersistenceObserver)observer);
        }
    }

    public static synchronized void HydraTask_initializeExpectException() throws Throwable {
        if (RecoveryTest.testInstance == null) {
            RecoveryTest.testInstance = new RecoveryTest();
            int numRootRegions = RecoveryPrms.getNumRootRegions();
            int numSubregions = RecoveryPrms.getNumSubregions();
            int hierDepth = RecoveryPrms.getRegionHierarchyDepth();
            if (numSubregions != 0 || hierDepth != 1) {
                throw new TestException("Unable to handle subregions in this test");
            }
            CacheHelper.createCache("cache1");
            String regionConfigName = TestConfig.tasktab().stringAt(RecoveryPrms.regionConfigNames, TestConfig.tab().stringAt(RecoveryPrms.regionConfigNames, null));
            String createdRegions = "";
            for (int i = 1; i <= numRootRegions; ++i) {
                try {
                    String regionName = "Region_" + i;
                    createdRegions = createdRegions + RegionHelper.createRegion(regionName, regionConfigName).getFullPath() + " ";
                    continue;
                }
                catch (ConflictingPersistentDataException e) {
                    Log.getLogWriter().info("Caught expected exception " + TestHelper.getStackTrace(e));
                }
            }
            if (createdRegions.length() > 0) {
                throw new TestException("Expected to get " + ConflictingPersistentDataException.class.getName() + " on region creation, but the following regions were successfully created: " + createdRegions);
            }
        }
    }

    protected static void verifyWaiting(ClientVmInfo expectedWaitingForMember, List<ClientVmInfo> membersWaiting) {
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        boolean conditionPreviouslyMet = false;
        while (true) {
            try {
                Set waitingForMembers = adminDS.getMissingPersistentMembers();
                Log.getLogWriter().info("System is waiting for " + waitingForMembers.size() + " member(s); " + waitingForMembers + ", test is expecting the system to be waiting for member with vmID " + expectedWaitingForMember.getVmid());
                TreeSet<String> vmsWaitingFor = new TreeSet<String>();
                for (PersistentID id : waitingForMembers) {
                    String diskDirWaitingFor = id.getDirectory();
                    String searchStr = "vm_";
                    int index = diskDirWaitingFor.indexOf(searchStr) + searchStr.length();
                    int index2 = diskDirWaitingFor.indexOf("_", index);
                    String vmIdStr = diskDirWaitingFor.substring(index, index2);
                    vmsWaitingFor.add(vmIdStr);
                }
                if (vmsWaitingFor.size() == 1) {
                    String singleVmWaitingFor = (String)vmsWaitingFor.iterator().next();
                    if (singleVmWaitingFor.equals(expectedWaitingForMember.getVmid().toString())) {
                        Log.getLogWriter().info("System is waiting for expected member " + waitingForMembers);
                        if (conditionPreviouslyMet) {
                            RecoveryTestVersionHelper.verifyMissingDiskStoresCommandLineTool(waitingForMembers);
                            Log.getLogWriter().info("Verified that the system is waiting on vm ID " + expectedWaitingForMember.getVmid() + "; system is waiting for vm with ID " + singleVmWaitingFor);
                            return;
                        }
                        conditionPreviouslyMet = true;
                        Log.getLogWriter().info("Sleeping for 180 seconds to make sure the member the system is waiting for does not change");
                        MasterController.sleepForMs(180000);
                    } else {
                        Log.getLogWriter().info("System is not waiting for the expected member " + expectedWaitingForMember.getVmid());
                        conditionPreviouslyMet = false;
                    }
                } else {
                    Log.getLogWriter().info("System is not waiting for the expected member " + expectedWaitingForMember.getVmid());
                    conditionPreviouslyMet = false;
                }
            }
            catch (AdminException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            MasterController.sleepForMs(2000);
        }
    }

    private static void verifyMissingDiskStoresCommandLineTool(Set<PersistentID> expected) {
        if (HostHelper.isWindows() && !CliHelperPrms.getUseCli()) {
            Log.getLogWriter().info("To avoid bug 42432, not running list-missing-disk-stores command line tool");
            return;
        }
        String result = PersistenceUtil.runListMissingDiskStores();
        ArrayList<String> actualDiskIds = new ArrayList<String>();
        String[] tokens = result.split("\n");
        if (CliHelperPrms.getUseCli()) {
            for (String line : tokens) {
                if (line.indexOf("vm_") < 0) continue;
                String[] lineTokens = line.split("[\\s]+");
                actualDiskIds.add(lineTokens[0]);
            }
        } else {
            for (String line : tokens) {
                Matcher matcher = PersistenceUtil.DISK_STORE_ID.matcher(line);
                if (!matcher.matches()) continue;
                actualDiskIds.add(matcher.group(1));
            }
        }
        ArrayList<String> expectedDiskDirs = new ArrayList<String>();
        for (PersistentID id : expected) {
            expectedDiskDirs.add(id.getUUID().toString());
        }
        ArrayList missing = new ArrayList(expectedDiskDirs);
        ArrayList extra = new ArrayList(actualDiskIds);
        missing.removeAll(actualDiskIds);
        extra.removeAll(expectedDiskDirs);
        if (missing.size() > 0) {
            throw new TestException("The following DiskStore IDs were expected in the result of list or show missing-disk-stores command line tool: " + missing + ", result of command line tool is " + result);
        }
        if (extra.size() > 0) {
            throw new TestException("The following unexpected DiskStore IDs were returned from list or show missing-disk-stores command line tool: " + extra + ", expected " + expected);
        }
        Log.getLogWriter().info("list or show missing-disk-stores command returned expected results");
    }

    public static void forceRecovery(boolean doValidation) {
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        try {
            Set waitingForMembers = adminDS.getMissingPersistentMembers();
            if (doValidation) {
                RecoveryTestVersionHelper.verifyMissingDiskStoresCommandLineTool(waitingForMembers);
            }
            for (PersistentID persistId : waitingForMembers) {
                boolean revokeWithCommandLineTool = TestConfig.tab().getRandGen().nextBoolean();
                if (HostHelper.isWindows()) {
                    revokeWithCommandLineTool = false;
                }
                if (CliHelperPrms.getUseCli()) {
                    revokeWithCommandLineTool = true;
                }
                if (revokeWithCommandLineTool) {
                    PersistenceUtil.runRevokeMissingDiskStore(persistId);
                    continue;
                }
                Log.getLogWriter().info("Revoking PersistentID " + persistId);
                adminDS.revokePersistentMember(persistId.getUUID());
            }
        }
        catch (AdminException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static boolean withPersistence(Region aRegion) {
        return aRegion.getAttributes().getDataPolicy().withPersistence();
    }

    public static synchronized void removeDiskFiles() {
        File[] listing;
        String prefix = "vm_" + RemoteTestModule.getMyVmid() + "_";
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (File aFile : listing = currDir.listFiles()) {
            File[] diskFiles;
            String fileName = aFile.getName();
            if (!fileName.startsWith(prefix) || !fileName.contains("disk_") || !aFile.isDirectory() || (diskFiles = aFile.listFiles()) == null) continue;
            for (File diskFile : diskFiles) {
                Log.getLogWriter().info("Working to delete file:" + diskFile.getAbsolutePath());
                if (!diskFile.exists()) continue;
                boolean result = diskFile.delete();
                Log.getLogWriter().info("File delete result: " + result);
                if (!result) {
                    Log.getLogWriter().info("After 'failed' delete, Does file still exist (delete)? " + diskFile.exists());
                }
                Log.getLogWriter().info("Removed " + diskFile.getAbsolutePath());
            }
        }
    }

    public static void doOperationsShutDownAll(RecoveryTest testInstance) throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        try {
            testInstance.doOperations(minTaskGranularityMS);
        }
        catch (CacheClosedException e) {
            boolean shutDownAllInProgress = (Boolean)RecoveryBB.getBB().getSharedMap().get("shutDownAllKey");
            if (shutDownAllInProgress) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + "; continuing test");
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (DistributedSystemDisconnectedException e) {
            boolean shutDownAllInProgress = (Boolean)RecoveryBB.getBB().getSharedMap().get("shutDownAllKey");
            if (shutDownAllInProgress) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + "; continuing test");
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void doOperationsHA(RecoveryTest testInstance) throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        try {
            testInstance.doOperations(minTaskGranularityMS);
        }
        catch (CacheClosedException e) {
            boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
            if (thisVMReceivedNiceKill) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + "; continuing test");
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (DistributedSystemDisconnectedException e) {
            boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
            if (thisVMReceivedNiceKill) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + "; continuing test");
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (RegionDestroyedException e) {
            boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
            if (thisVMReceivedNiceKill) {
                Log.getLogWriter().info("Caught expected exception " + (Object)((Object)e) + "; continuing test");
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void handleOpsExceptionDuringShutDownAll(Exception e) {
        if (!(e instanceof CacheClosedException) && !(e instanceof DistributedSystemDisconnectedException)) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Caught expected " + e + " during shutDownAllMembers; continuing test");
    }

    public static void installPRObserver() {
        PRObserver.installObserverHook();
    }

    public static void initPRObserver() {
        PRObserver.initialize();
    }

    public static AttributesFactory setDiskStoreIfNeeded(String regionConfigName) {
        AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfigName);
        RegionDescription desc = RegionHelper.getRegionDescription(regionConfigName);
        EvictionAttributes evAttr = desc.getEvictionAttributes();
        if (desc.getDataPolicy().withPersistence() || evAttr != null && evAttr.getAction().isOverflowToDisk()) {
            HydraVector diskStoreNames = TestConfig.tab().vecAt(DiskStorePrms.names);
            factory.setDiskStoreName((String)diskStoreNames.get(TestConfig.tab().getRandGen().nextInt(1, diskStoreNames.size() - 1)));
        }
        return factory;
    }

    public static void handleOpsException(Exception e) {
        if (e instanceof CacheClosedException || e instanceof DistributedSystemDisconnectedException) {
            boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
            if (!thisVMReceivedNiceKill) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } else {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Caught expected exception " + e + "; continuing test");
    }

    public static synchronized void createXmlFile() {
        String bbKey = null;
        String clientName = RemoteTestModule.getMyClientName();
        String fileName = RecoveryTest.getXmlFileName(RemoteTestModule.getMyVmid());
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        if (clientName.indexOf("oldVersion") >= 0) {
            bbKey = "oldVersionXmlFile";
        } else if (clientName.indexOf("newVersion") >= 0) {
            bbKey = "newVersionXmlFile";
        }
        DeclarativeGenerator.createDeclarativeXml(fileName, RecoveryTest.theCache, false, true);
        if (bbKey != null) {
            String xmlFilePath;
            File xmlFile = new File(fileName);
            try {
                xmlFilePath = xmlFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            RecoveryBB.getBB().getSharedMap().put(bbKey, xmlFilePath);
        }
    }

    public static void initPdxClassLoader() {
        PdxTest.initClassLoader();
    }

    public static BaseValueHolder getVersionedValueHolder(String valueClassName, String key, RandomValues randomValues) {
        return PdxTest.getVersionedValueHolder(valueClassName, key, randomValues);
    }

    public static boolean instanceOfPdxInstance(Object value) {
        return value instanceof PdxInstance;
    }

    public static BaseValueHolder toValueHolder(Object value) {
        return PdxTest.toValueHolder(value);
    }

    private static SnapshotFilter getSnapshotFilter() {
        int i = TestConfig.tab().getRandGen().nextInt(0, 2);
        Object filter = new KeySnapshotFilter();
        if (i == 2) {
            filter = new ValueSnapshotFilter();
        } else if (i == 3) {
            filter = new ValueTypeSnapshotFilter();
        }
        Log.getLogWriter().info("getSnapshotFilter returning instance of " + filter.getClass().getName());
        return filter;
    }

    protected static void snapshotResponder(RecoveryTest testInstance) throws Exception {
        long pausing = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing);
        if (pausing > 0L) {
            long leader;
            if (((Boolean)RecoveryTest.threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("Thread has paused");
            } else {
                Log.getLogWriter().info("This thread is pausing");
                RecoveryTest.threadIsPaused.set(new Boolean(true));
                RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.pausing);
            }
            long writeSnapshot = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.writeSnapshot);
            if (writeSnapshot > 0L && (leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader)) == 1L) {
                Log.getLogWriter().info("This thread is the leader; it will write the snapshot");
                testInstance.writeSnapshot(true);
                long executionNumber = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber);
                if (SnapshotPrms.useFilterOnExport() || SnapshotPrms.useFilterOnImport()) {
                    HashMap allRegionsSnapshot = new HashMap();
                    int numToCreate = SnapshotPrms.numFilterObjects();
                    for (Region aRegion : testInstance.allRegions) {
                        for (int i = 1; i <= numToCreate; ++i) {
                            String key = "FilterObject_" + i;
                            String value = "object to be filtered via snapshot.save() or snapshot.load(): this should never be a value in the cache once snapshot restored";
                            aRegion.put((Object)key, (Object)value);
                        }
                    }
                    Log.getLogWriter().info("Wrote " + numToCreate + " FilterObject entries to each region");
                }
                CacheSnapshotService snapshot = CacheHelper.getCache().getSnapshotService();
                SnapshotOptions options = snapshot.createOptions();
                if (SnapshotPrms.useFilterOnExport()) {
                    options.setFilter(RecoveryTestVersionHelper.getSnapshotFilter());
                }
                String currDirName = System.getProperty("user.dir");
                String snapshotDirName = currDirName + File.separator + "cacheSnapshotDir_" + executionNumber;
                Log.getLogWriter().info("Starting cacheSnapshot to " + snapshotDirName);
                snapshot.save(new File(snapshotDirName), SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                Log.getLogWriter().info("Completed cacheSnapshot to " + snapshotDirName);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            MasterController.sleepForMs(5000);
        } else {
            long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            long minTaskGranularityMS = minTaskGranularitySec * 1000L;
            testInstance.doOperations(minTaskGranularityMS);
        }
    }

    protected static void importAndVerify(RecoveryTest testInstance) {
        long counter = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.importSnapshot);
        if (counter == 1L) {
            Log.getLogWriter().info("This thread is the leader; it will import the snapshot");
            long executionNumber = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber);
            String currDirName = System.getProperty("user.dir");
            String snapshotDirName = currDirName + File.separator + "cacheSnapshotDir_" + executionNumber;
            CacheSnapshotService snapshot = CacheHelper.getCache().getSnapshotService();
            long startTime = System.currentTimeMillis();
            try {
                if (SnapshotPrms.useFilterOnImport()) {
                    SnapshotOptions options = snapshot.createOptions();
                    options.setFilter(RecoveryTestVersionHelper.getSnapshotFilter());
                    File dir = new File(snapshotDirName);
                    File[] files = dir.listFiles();
                    StringBuffer aStr = new StringBuffer();
                    aStr.append("Invoking snapshot.load() with files:\n");
                    for (int i = 0; i < files.length; ++i) {
                        aStr.append("   " + files[i] + "\n");
                    }
                    aStr.append("Options.getFilter() = " + options.getFilter().getClass().getName());
                    Log.getLogWriter().info(aStr.toString());
                    snapshot.load(files, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                } else {
                    Log.getLogWriter().info("Starting CacheSnapshotService.load() from " + snapshotDirName);
                    snapshot.load(new File(snapshotDirName), SnapshotOptions.SnapshotFormat.GEMFIRE);
                }
            }
            catch (IOException ioe) {
                throw new TestException("Caught " + ioe + " while importing region snapshot from " + snapshotDirName + " " + TestHelper.getStackTrace(ioe));
            }
            catch (ClassNotFoundException e) {
                throw new TestException("Caught " + e + " while importing region snapshot from " + snapshotDirName + " " + TestHelper.getStackTrace(e));
            }
            long endTime = System.currentTimeMillis();
            Log.getLogWriter().info("CacheSnapshotService.load() of " + snapshotDirName + " took " + (endTime - startTime) + " ms.");
            Log.getLogWriter().info(testInstance.regionHierarchyToString());
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotImported);
        } else {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotImported", RecoveryBB.snapshotImported, 1L, true, -1L, 2000L);
            testInstance.verifyFromSnapshot();
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
        }
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads() - 1, true, -1L, 2000L);
    }

    protected static void performBackup() {
        long execution = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber);
        File backupDir = RecoveryTestVersionHelper.createBackupDir(execution);
        File baselineDir = execution > 1L ? RecoveryTestVersionHelper.getBackupDir(execution - 1L) : null;
        try {
            BackupStatus backupStatus = AdminHelper.getAdminDistributedSystem().backupAllMembers(backupDir, baselineDir);
        }
        catch (AdminException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static File getBackupDir(long counter) {
        File backupDir = new File("backup_" + counter);
        if (!backupDir.exists()) {
            throw new TestException("getBackupDir: Backup directory " + backupDir.getName() + " does not exist.");
        }
        File[] files = backupDir.listFiles();
        if (null == files || files.length != 1) {
            throw new TestException("getBackupDir: Backup directory " + backupDir.getName() + " is malformed or is not a directory");
        }
        return files[0];
    }

    private static File createBackupDir(long backup) {
        File file = new File("backup_" + backup);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static class ValueTypeSnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = false;
            Object value = entry.getValue();
            if (value instanceof ValueHolder) {
                accepted = true;
            }
            return accepted;
        }
    }

    public static class ValueSnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = true;
            Object value = entry.getValue();
            if (value instanceof String && ((String)value).startsWith("object to be filtered")) {
                accepted = false;
            }
            return accepted;
        }
    }

    public static class KeySnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = false;
            String key = (String)entry.getKey();
            if (key.startsWith(NameFactory.OBJECT_NAME_PREFIX)) {
                accepted = true;
            }
            return accepted;
        }
    }
}

