/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.DeltaSerializationException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import delta.BadDeltaObject;
import delta.DeltaObject;
import delta.DeltaObserver;
import delta.DeltaPropagationBB;
import delta.DeltaPropagationPrms;
import delta.DeltaTestAlertListener;
import delta.DeltaValueHolder;
import delta.PretendSizer;
import diskReg.DiskRegUtil;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GemFirePrms;
import hydra.GsRandom;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegUtil;
import util.AdminHelperPrms;
import util.BaseValueHolder;
import util.MethodCoordinator;
import util.NameFactory;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;

public class DeltaTest {
    public static DeltaTest testInstance;
    protected static final String redundantCopiesKey = "RedundantCopies";
    protected static final String toDeltaKey = "toDeltaCallsForVmID_";
    protected static final String fromDeltaKey = "fromDeltaCallsForVmID_";
    protected static final String hasDeltaKey = "hasDeltaCallsForVmID_";
    protected static final String updatedKeysKey = "updatedKeysVmID_";
    protected static final String updatedKeysWithDeltaKey = "updatedKeysWithDeltaVmID_";
    protected static final String updatedKeysNotDistKey = "updatedKeysNotDistVmID_";
    protected static final String regionSnapshotKey = "regionSnapshotVmID";
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    public boolean isBridgeConfiguration;
    public boolean isBridgeClient;
    protected int numThreadsInClients;
    public Region aRegion;
    public HydraThreadLocal uniqueKeyIndex = new HydraThreadLocal();
    protected boolean isSerialExecution;
    protected boolean highAvailability;
    protected int upperThreshold;
    protected int lowerThreshold;
    protected boolean uniqueKeys = false;
    protected int numQueriesPerClientVM;
    protected int secondsToRun;
    protected boolean cacheIsClosed;
    protected boolean disconnected;
    protected int numThreadsInThisVM = 0;
    protected int numFieldsToModify = 0;
    protected List<Region> multiRegionList = new ArrayList<Region>();
    protected List updatedKeys = new ArrayList();
    protected List updatedKeysWithDelta = new ArrayList();
    protected List updatedKeysNotDistributed = new ArrayList();
    protected int numberOfCycles = 0;
    protected int redundantCopies = 0;
    protected Map regionSnapshot;
    protected long before_stat_entriesInVM = -1L;
    protected long before_stat_numOverflowOnDisk = -1L;
    protected long before_numBytesInThisVM = -1L;
    protected long before_stat_lruEvictions = 0L;
    protected Map<String, Integer> beforeMap = new HashMap<String, Integer>();
    protected Set<String> before_inVMSet = new HashSet<String>();
    protected Set<String> before_onDiskSet = new HashSet<String>();
    protected String opKey = "operationKey";
    protected String currentKeyListKey = "keyList";
    protected List<Long> overageHistory = new ArrayList<Long>();
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_MODIFY_VALUE = 9;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String fullDistribution = "Full distribution";
    protected static volatile MethodCoordinator concVerifyCoordinator;

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new DeltaTest();
            DeltaTest.testInstance.aRegion = testInstance.initializeRegion(DeltaPropagationPrms.getRegionPrmsName());
            testInstance.initializeInstance();
            if (DeltaTest.testInstance.isBridgeConfiguration) {
                DeltaTest.testInstance.isBridgeClient = true;
                DeltaTest.registerInterest(DeltaTest.testInstance.aRegion);
            }
        }
        DeltaTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new DeltaTest();
            DeltaTest.testInstance.aRegion = testInstance.initializeRegion(DeltaPropagationPrms.getRegionPrmsName());
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            DeltaTest.testInstance.isBridgeClient = false;
        }
        DeltaTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public Region initializeRegion(String regDescriptName) {
        CacheHelper.createCache("cache1");
        AttributesFactory factory = RegionHelper.getAttributesFactory(regDescriptName);
        RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        if (prAttr != null) {
            PartitionAttributesFactory prFactory = new PartitionAttributesFactory(prAttr);
            this.redundantCopies = (Integer)DeltaPropagationBB.getBB().getSharedMap().get(redundantCopiesKey);
            prFactory.setRedundantCopies(this.redundantCopies);
            factory.setPartitionAttributes(prFactory.create());
        }
        String regionName = TestConfig.tab().stringAt(RegionPrms.regionName);
        Region aReg = RegionHelper.createRegion(regionName, factory);
        Log.getLogWriter().info("After creating " + aReg.getFullPath() + ", region is size " + aReg.size());
        if (InitImagePrms.useTransactions()) {
            TxHelper.setTransactionManager();
        }
        return aReg;
    }

    public void initializeInstance() {
        Integer anInt = Integer.getInteger("numThreads");
        if (anInt != null) {
            this.numThreadsInThisVM = anInt;
        }
        this.numThreadsInClients = TestHelper.getNumThreads();
        this.isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        this.highAvailability = TestConfig.tab().booleanAt(DeltaPropagationPrms.highAvailability, false);
        this.numberOfCycles = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfCycles, 10);
        this.upperThreshold = TestConfig.tab().intAt(DeltaPropagationPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(DeltaPropagationPrms.lowerThreshold, -1);
        this.numOpsPerTask = TestConfig.tab().intAt(DeltaPropagationPrms.numOpsPerTask, Integer.MAX_VALUE);
        this.uniqueKeys = TestConfig.tab().booleanAt(DeltaPropagationPrms.useUniqueKeys, false);
        this.secondsToRun = TestConfig.tab().intAt(DeltaPropagationPrms.secondsToRun, 1800);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
        this.regionSnapshot = Collections.synchronizedMap(new HashMap());
        DeltaPropagationBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
        DeltaPropagationBB.getBB().getSharedMap().put(BadDeltaObject.testCaseKey, new Integer(0));
        if (this.aRegion != null) {
            DeltaObject.cloningEnabled = this.aRegion.getAttributes().getCloningEnabled();
        }
        DeltaValueHolder.logCalls = true;
    }

    public static synchronized void HydraTask_initMultiRegions() {
        if (testInstance == null) {
            testInstance = new DeltaTest();
            CacheHelper.createCache("cache1");
            boolean deltaPropagation = TestConfig.tab().booleanAt(GemFirePrms.deltaPropagation, true);
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("replicateReg"));
            if (DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.ConcurrentLeader) == 1L) {
                if (!deltaPropagation) {
                    DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("partitionedRegAccessor"));
                }
                DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("emptyReg"));
            } else {
                if (!deltaPropagation) {
                    DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("partitionedRegDataStore"));
                }
                DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("normalReg"));
            }
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("persistentRepReg"));
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("preloadedReg"));
            testInstance.initializeInstance();
            if (DeltaTest.testInstance.isBridgeConfiguration) {
                DeltaTest.testInstance.isBridgeClient = true;
                DeltaTest.registerInterest(DeltaTest.testInstance.aRegion);
            }
        }
        DeltaTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initMultiRegionsForClients() {
        if (testInstance == null) {
            testInstance = new DeltaTest();
            CacheHelper.createCache("cache1");
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("client_replicateReg"));
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("client_normalReg"));
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("client_partitionedReg"));
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("client_persistentRepReg"));
            DeltaTest.testInstance.multiRegionList.add(RegionHelper.createRegion("client_preloadedReg"));
            testInstance.initializeInstance();
            if (DeltaTest.testInstance.isBridgeConfiguration) {
                DeltaTest.testInstance.isBridgeClient = true;
                DeltaTest.registerInterest(DeltaTest.testInstance.aRegion);
            }
        }
        DeltaTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_doRROpsAndVerify() {
        if (DeltaTest.testInstance.numThreadsInThisVM != 1) {
            throw new TestException("Test configuration problem; serial test should have 1 thread per vm");
        }
        try {
            testInstance.doRROpsAndVerify();
        }
        finally {
            if (DeltaTest.testInstance.isBridgeClient) {
                ClientHelper.release(DeltaTest.testInstance.aRegion);
            }
        }
        DeltaTest.checkForError();
    }

    public static void HydraTask_doConcOpsAndVerify() {
        testInstance.doConcOpsAndVerify();
        DeltaTest.checkForError();
    }

    public static void HydraTask_doConcOps() {
        testInstance.doEntryOperations(DeltaTest.testInstance.aRegion);
        DeltaTest.checkForError();
    }

    public static void HydraTask_doConcOpsWithMultiRegions() {
        for (int i = 0; i < DeltaTest.testInstance.multiRegionList.size(); ++i) {
            Log.getLogWriter().info("Beginning operations for " + DeltaTest.testInstance.multiRegionList.get(i).getFullPath());
            testInstance.doEntryOperations(DeltaTest.testInstance.multiRegionList.get(i));
        }
        DeltaTest.checkForError();
    }

    public static void HydraTask_HADoEntryOps() {
        testInstance.HADoEntryOps();
        DeltaTest.checkForError();
    }

    public static void HydraTask_HAController() {
        testInstance.HAController();
        DeltaTest.checkForError();
    }

    public static void HydraTask_loadBadDeltaToUpperThreshold() {
        int logIntervalMS = 10000;
        long lastLogTime = System.currentTimeMillis();
        int upperThreshold = TestConfig.tab().intAt(DeltaPropagationPrms.upperThreshold);
        Log.getLogWriter().info("Loading region to size " + upperThreshold + ", current region size is " + DeltaTest.testInstance.aRegion.size());
        while (DeltaTest.testInstance.aRegion.size() < upperThreshold) {
            if (System.currentTimeMillis() - lastLogTime >= (long)logIntervalMS) {
                Log.getLogWriter().info("Loading region to size " + upperThreshold + ", current region size is " + DeltaTest.testInstance.aRegion.size());
                lastLogTime = System.currentTimeMillis();
            }
            Object key = testInstance.getNewKey();
            BadDeltaObject anObj = new BadDeltaObject(NameFactory.getCounterForName(key), 1, 0, 1);
            anObj.extra = key;
            DeltaTest.testInstance.aRegion.create(key, (Object)anObj);
            DeltaTest.logPRMembers(DeltaTest.testInstance.aRegion, key);
        }
        String aStr = "Finished loadToUpperThreshold, " + DeltaTest.testInstance.aRegion.getFullPath() + " is size " + DeltaTest.testInstance.aRegion.size();
        Log.getLogWriter().info(aStr);
    }

    public static void HydraTask_loadToUpperThreshold() {
        testInstance.loadToUpperThreshold(DeltaTest.testInstance.aRegion);
    }

    public static void HydraTask_evictionTestLoad() {
        testInstance.evictionTestLoad(DeltaTest.testInstance.aRegion);
    }

    public static void HydraTask_loadMultiRegToUpperThreshold() {
        int doneCount = 0;
        for (int i = 0; i < DeltaTest.testInstance.multiRegionList.size(); ++i) {
            try {
                testInstance.loadToUpperThreshold(DeltaTest.testInstance.multiRegionList.get(i));
                continue;
            }
            catch (StopSchedulingOrder order) {
                Log.getLogWriter().info("Done filling " + DeltaTest.testInstance.multiRegionList.get(i).getFullPath());
                ++doneCount;
            }
        }
        if (doneCount == DeltaTest.testInstance.multiRegionList.size()) {
            throw new StopSchedulingOrder("All regions have been filled");
        }
    }

    public static void HydraTask_recordLoadToBB() {
        testInstance.recordLoadToBB();
    }

    public static void HydraTask_initRedundantCopies() {
        String copies = TestConfig.tab().stringAt(DeltaPropagationPrms.redundantCopies);
        if (copies.equalsIgnoreCase("zero")) {
            DeltaPropagationBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(0));
        } else if (copies.equalsIgnoreCase("nonZero")) {
            int value = TestConfig.tab().getRandGen().nextInt(1, 3);
            DeltaPropagationBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(value));
        } else {
            try {
                int value = Integer.valueOf(copies);
                DeltaPropagationBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(value));
            }
            catch (NumberFormatException e) {
                throw new TestException("Unknown RecovDelayPrms.redundantCopies setting: " + copies);
            }
        }
    }

    public static void HydraTask_verifyNoDeltaCalls() {
        int thisVmId = RemoteTestModule.getMyVmid();
        DeltaTest.verifyDeltaCalls(thisVmId, DeltaObserver.getToDeltaKeys(), "to", new ArrayList());
        DeltaTest.verifyDeltaCalls(thisVmId, DeltaObserver.getFromDeltaKeys(), "from", new ArrayList());
        DeltaTest.verifyDeltaCalls(thisVmId, DeltaObserver.getHasDeltaKeys(), "has", new ArrayList());
    }

    public static void HydraTask_badDeltaController() {
        DeltaTest.logExecutionNumber();
        long exeNum = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.ExecutionNumber);
        int specificTestCase = TestConfig.tab().intAt(DeltaPropagationPrms.testCase, -1);
        int firstTestCase = 0;
        int lastTestCase = 0;
        if (specificTestCase != -1) {
            firstTestCase = specificTestCase;
            lastTestCase = specificTestCase;
        } else {
            firstTestCase = 1;
            lastTestCase = 11;
        }
        int currentTestCase = 0;
        if (exeNum == 1L) {
            DeltaPropagationBB.getBB().getSharedMap().put("BadDeltaStartVmID", RemoteTestModule.getMyVmid());
            currentTestCase = firstTestCase;
        } else {
            currentTestCase = (Integer)DeltaPropagationBB.getBB().getSharedMap().get(BadDeltaObject.testCaseKey);
            int startingVmId = (Integer)DeltaPropagationBB.getBB().getSharedMap().get("BadDeltaStartVmID");
            if (startingVmId == RemoteTestModule.getMyVmid() && ++currentTestCase > lastTestCase) {
                throw new StopSchedulingOrder("Test has completed");
            }
        }
        if (currentTestCase == 3 && (!DeltaTest.testInstance.isBridgeConfiguration || DeltaTest.testInstance.isBridgeConfiguration && !DeltaTest.testInstance.isBridgeClient)) {
            return;
        }
        testInstance.badDeltaController(currentTestCase);
    }

    public static void HydraTask_doMixedTest() {
        for (Object key : DeltaTest.testInstance.aRegion.keySet()) {
            Object value = DeltaTest.testInstance.aRegion.get(key);
            if (value instanceof Delta) {
                ValueHolder nonDeltaObject = new ValueHolder();
                nonDeltaObject.myValue = "non-delta object for key " + key;
                Log.getLogWriter().info("Putting key " + key + ", value is " + nonDeltaObject);
                DeltaTest.testInstance.aRegion.put(key, (Object)nonDeltaObject);
                continue;
            }
            DeltaObject anObj = new DeltaObject(NameFactory.getCounterForName(key), 1, 0, 1);
            anObj.extra = key;
            testInstance.modifyDeltaObject(anObj);
            Log.getLogWriter().info("Putting key " + key + ", value is " + anObj.toStringFull());
            try {
                DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
            }
            catch (ClassCastException e) {
                Log.getLogWriter().info("Caught expected " + TestHelper.getStackTrace(e) + " for key " + key);
            }
            catch (ServerOperationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ClassCastException) {
                    Log.getLogWriter().info("Caught expected " + TestHelper.getStackTrace(e) + " + for key " + key);
                    continue;
                }
                Log.getLogWriter().info("Throwing...");
                throw e;
            }
        }
    }

    public static void HydraTask_doSerialRREvictionTest() {
        testInstance.doSerialRREvictionTest();
    }

    public static void HydraTask_checkMemLRULevelForPR() {
        testInstance.checkMemLRULevelForPR();
    }

    public static void HydraTask_checkOverageHistory() {
        testInstance.checkOverageHistory();
    }

    protected void doRROpsAndVerify() {
        DeltaTest.logExecutionNumber();
        long roundPosition = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundPosition);
        Log.getLogWriter().info("In doRROpsAndVerify, roundPosition is " + roundPosition);
        this.regionSnapshot = (Map)DeltaPropagationBB.getBB().getSharedMap().get("RegionSnapshot");
        long roundNumber = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.RoundNumber);
        if (roundPosition == (long)this.numThreadsInClients) {
            if (roundNumber % 2L == 1L) {
                Log.getLogWriter().info("In doRROpsAndVerify, last in round, round to write to bb");
                this.writeDeltaInfoToBlackboard();
                DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.RoundPosition);
            } else {
                Log.getLogWriter().info("In doRROpsAndVerify, last in round, round to verify (then become first in round and do ops)");
                this.verifyRegionContents(this.regionSnapshot);
                this.verifyDeltaBehavior();
                DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.RoundPosition);
                roundPosition = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundPosition);
            }
        }
        if (roundPosition == 1L) {
            roundNumber = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundNumber);
            Log.getLogWriter().info("In doRROpsAndVerify, first in round, round number " + roundNumber);
            if (roundNumber % 2L == 1L) {
                int cycleNumber = (int)((roundNumber + 1L) / 2L);
                Log.getLogWriter().info("Starting cycle number: " + cycleNumber);
                if (cycleNumber > this.numberOfCycles) {
                    throw new StopSchedulingOrder("Completed " + (cycleNumber - 1) + " cycles");
                }
                Log.getLogWriter().info("Round to do ops and write to blackboard");
                this.clear();
                this.doEntryOperations(this.aRegion);
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + this.regionSnapshot.size() + ": " + this.regionSnapshot);
                DeltaPropagationBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
                this.writeDeltaInfoToBlackboard();
            } else {
                Log.getLogWriter().info("Round to verify");
                this.verifyRegionContents(this.regionSnapshot);
                this.verifyDeltaBehavior();
                this.clear();
            }
        } else if (roundPosition != (long)this.numThreadsInClients) {
            if (roundNumber % 2L == 1L) {
                Log.getLogWriter().info("In doRROpsAndVerify, neither first nor last, round to write to bb");
                this.writeDeltaInfoToBlackboard();
            } else {
                Log.getLogWriter().info("In doRROpsAndVerify, neither first nor last, round to verify");
                this.regionSnapshot = (Map)DeltaPropagationBB.getBB().getSharedMap().get("RegionSnapshot");
                this.verifyRegionContents(this.regionSnapshot);
                this.verifyDeltaBehavior();
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConcOpsAndVerify() {
        concVerifyCoordinator = new MethodCoordinator(DeltaTest.class.getName(), "concVerify");
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.ConcurrentLeader);
        this.clear();
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.SyncUp);
        long counter = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.ReadyToBegin);
        if (counter == 1L) {
            DeltaTest.logExecutionNumber();
        }
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.ReadyToBegin", DeltaPropagationBB.ReadyToBegin, this.numThreadsInClients, true, -1L, 1000L);
        this.checkForLastIteration();
        Log.getLogWriter().info("Zeroing ShapshotWritten");
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.SnapshotWritten);
        this.doEntryOperations(this.aRegion);
        Log.getLogWriter().info("Zeroing FinishedVerify");
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.FinishedVerify);
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.Pausing);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.Pausing", DeltaPropagationBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing ReadyToBegin");
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.ReadyToBegin);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        this.writeDeltaInfoToBlackboard();
        DeltaTest deltaTest = this;
        synchronized (deltaTest) {
            DeltaPropagationBB.getBB().getSharedMap().put(regionSnapshotKey + RemoteTestModule.getMyVmid(), this.regionSnapshot);
        }
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.SyncUp);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.SyncUp", DeltaPropagationBB.SyncUp, this.numThreadsInClients, true, -1L, 5000L);
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.FinishedVerify);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.FinishedVerify", DeltaPropagationBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        Log.getLogWriter().info("Zeroing Pausing");
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.Pausing);
        counter = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.ExecutionNumber));
        }
    }

    protected void HAController() {
        boolean stopServers;
        DeltaTest.logExecutionNumber();
        concVerifyCoordinator = new MethodCoordinator(DeltaTest.class.getName(), "concVerify");
        this.checkForLastIteration();
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.ExceptionCounter);
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.ConcurrentLeader);
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.Reinitialized);
        boolean bl = stopServers = this.isBridgeClient || !this.isBridgeClient && TestConfig.tab().getRandGen().nextInt(1, 100) <= 60;
        if (stopServers) {
            int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "bridge");
            List vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            StopStartVMs.stopStartVMs(vmList, stopModeList);
        } else {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("Closing the cache...");
                this.cacheIsClosed = true;
                CacheHelper.closeCache();
            } else {
                Log.getLogWriter().info("Disconnecting from the distributed system...");
                this.disconnected = true;
                DistributedSystemHelper.disconnect();
            }
            TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.ExceptionCounter", DeltaPropagationBB.ExceptionCounter, this.numThreadsInThisVM - 1, true, -1L, 1000L);
            Log.getLogWriter().info("Recreating the region...");
            DeltaTest.testInstance.aRegion = testInstance.initializeRegion("serverRegion");
            Log.getLogWriter().info("Done recreating the region...");
            BridgeHelper.startBridgeServer("bridge");
            DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.Reinitialized);
        }
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.SnapshotWritten);
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.FinishedVerify);
        this.cacheIsClosed = false;
        this.disconnected = false;
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.Pausing);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.Pausing", DeltaPropagationBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.SyncUp);
        if (this.isBridgeConfiguration) {
            SilenceListener.waitForSilence(30L, 5000L);
        }
        concVerifyCoordinator.executeOnce(this, new Object[0]);
        if (!concVerifyCoordinator.methodWasExecuted()) {
            throw new TestException("Test problem: concVerify did not execute");
        }
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.FinishedVerify);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.FinishedVerify", DeltaPropagationBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
        DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.Pausing);
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.SyncUp);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.SyncUp", DeltaPropagationBB.SyncUp, this.numThreadsInClients, true, -1L, 1000L);
        long counter = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num HAController executions is " + DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.ExecutionNumber));
        }
    }

    protected void HADoEntryOps() {
        this.checkForLastIteration();
        try {
            testInstance.doEntryOperations(DeltaTest.testInstance.aRegion);
            if (DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.Pausing) > 0L) {
                DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.Pausing);
                TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.Pausing", DeltaPropagationBB.Pausing, this.numThreadsInClients, true, -1L, 5000L);
                if (this.isBridgeConfiguration) {
                    SilenceListener.waitForSilence(30L, 5000L);
                }
                concVerifyCoordinator.executeOnce(this, new Object[0]);
                if (!concVerifyCoordinator.methodWasExecuted()) {
                    throw new TestException("Test problem: concVerify did not execute");
                }
                DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.FinishedVerify);
                TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.FinishedVerify", DeltaPropagationBB.FinishedVerify, this.numThreadsInClients, true, -1L, 5000L);
                DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.Pausing);
                concVerifyCoordinator = new MethodCoordinator(DeltaTest.class.getName(), "concVerify");
                DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.SyncUp);
                TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.SyncUp", DeltaPropagationBB.SyncUp, this.numThreadsInClients, true, -1L, 1000L);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void doEntryOperations(Region aReg) {
        Log.getLogWriter().info("In doEntryOperations with " + aReg.getFullPath());
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        boolean useTransactions = InitImagePrms.useTransactions();
        do {
            int whichOp = 0;
            whichOp = this.isBridgeConfiguration ? (this.isBridgeClient ? this.getOperation(DeltaPropagationPrms.clientEntryOperations) : this.getOperation(DeltaPropagationPrms.serverEntryOperations)) : this.getOperation(DeltaPropagationPrms.entryOperations);
            int size = aReg.size();
            if (size >= this.upperThreshold) {
                whichOp = this.getOperation(DeltaPropagationPrms.upperThresholdOperations);
            } else if (size <= this.lowerThreshold) {
                whichOp = this.getOperation(DeltaPropagationPrms.lowerThresholdOperations);
            }
            boolean rolledback = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            try {
                switch (whichOp) {
                    case 1: {
                        this.addEntry(aReg);
                        break;
                    }
                    case 3: {
                        this.invalidateEntry(aReg, false);
                        break;
                    }
                    case 2: {
                        this.destroyEntry(aReg, false);
                        break;
                    }
                    case 6: {
                        this.updateEntry(aReg);
                        break;
                    }
                    case 7: {
                        this.getKey(aReg);
                        break;
                    }
                    case 8: {
                        this.getNewKey(aReg);
                        break;
                    }
                    case 5: {
                        this.invalidateEntry(aReg, true);
                        break;
                    }
                    case 4: {
                        this.destroyEntry(aReg, true);
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            catch (TransactionDataRebalancedException e) {
                if (!useTransactions) {
                    throw new TestException("Unexpected Exception " + (Object)((Object)e) + ".  " + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                Log.getLogWriter().info("Rolling back transaction.");
                try {
                    TxHelper.rollback();
                    Log.getLogWriter().info("Done Rolling back Transaction");
                }
                catch (TransactionException te) {
                    Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                }
                rolledback = true;
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                }
                catch (CommitConflictException e) {
                    Log.getLogWriter().info("Caught CommitConflictException. Expected with concurrent execution, continuing test.");
                }
            }
            Log.getLogWriter().info("Completed op " + ++numOps + " for this task, region size is " + aReg.size());
            DeltaTest.checkForError();
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS && numOps < this.numOpsPerTask);
        Log.getLogWriter().info("Done in doEntryOperations with " + aReg.getFullPath() + ", completed " + numOps + " ops in " + (System.currentTimeMillis() - startTime) + " millis");
    }

    protected void loadToUpperThreshold(Region aReg) {
        int logIntervalMS = 10000;
        long startTime = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        Log.getLogWriter().info("Loading region to size " + this.upperThreshold + ", current region size is " + aReg.size());
        while (aReg.size() < this.upperThreshold) {
            if (System.currentTimeMillis() - lastLogTime >= (long)logIntervalMS) {
                Log.getLogWriter().info("Loading region to size " + this.upperThreshold + ", current region size is " + aReg.size());
                lastLogTime = System.currentTimeMillis();
            }
            this.addEntry(aReg);
            long numUpdates = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
            if (numUpdates > 0L) {
                throw new TestException("After loading with creates, test detected " + numUpdates + " update events, but expected only create events");
            }
            if (System.currentTimeMillis() - startTime < this.minTaskGranularityMS) continue;
            break;
        }
        DeltaTest.HydraTask_verifyNoDeltaCalls();
        if (aReg.size() >= this.upperThreshold) {
            String aStr = "Finished loadToUpperThreshold, " + aReg.getFullPath() + " is size " + aReg.size();
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
    }

    protected void evictionTestLoad(Region aReg) {
        int logIntervalMS = 10000;
        long startTime = System.currentTimeMillis();
        long lastLogTime = System.currentTimeMillis();
        Log.getLogWriter().info("Loading region to size " + this.upperThreshold + ", current region size is " + aReg.size());
        while (aReg.size() < this.upperThreshold) {
            if (System.currentTimeMillis() - lastLogTime >= (long)logIntervalMS) {
                Log.getLogWriter().info("Loading region to size " + this.upperThreshold + ", current region size is " + aReg.size());
                lastLogTime = System.currentTimeMillis();
            }
            this.addNewValue();
            if (System.currentTimeMillis() - startTime < this.minTaskGranularityMS) continue;
        }
        if (aReg.size() >= this.upperThreshold) {
            String aStr = "Finished loadToUpperThreshold, " + aReg.getFullPath() + " is size " + aReg.size();
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
    }

    protected void recordLoadToBB() {
        long concurrentLeader = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.ConcurrentLeader);
        if (concurrentLeader == 1L) {
            if (this.isBridgeConfiguration) {
                SilenceListener.waitForSilence(30L, 5000L);
            }
            Log.getLogWriter().info("Recording region to blackbloard...");
            this.regionSnapshot = new HashMap();
            for (Object key : this.aRegion.keys()) {
                DeltaObject value = (DeltaObject)this.aRegion.get(key);
                this.regionSnapshot.put(key, value.copy());
            }
            Log.getLogWriter().info("Writing regionSnapshot to blackboard, snapshot size is " + this.regionSnapshot.size() + ": " + this.regionSnapshot);
            DeltaPropagationBB.getBB().getSharedMap().put("RegionSnapshot", this.regionSnapshot);
        }
    }

    protected Object addEntry(Region aReg) {
        Object key = this.getNewKey();
        DeltaObject anObj = new DeltaObject(NameFactory.getCounterForName(key), 1, 0, 1);
        anObj.extra = key;
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        try {
            Log.getLogWriter().info("operation for " + key + ", addEntry: calling create for key " + key + ", object " + anObj.toStringFull() + " cacheWriterParam is " + callback + ", region is " + aReg.getFullPath());
            aReg.create(key, (Object)anObj, (Object)callback);
            DeltaTest.logPRMembers(aReg, key);
            Log.getLogWriter().info("operation for " + key + ", addEntry: done creating key " + key);
        }
        catch (EntryExistsException e) {
            if (this.isSerialExecution || this.uniqueKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
        }
        if (this.isSerialExecution || this.uniqueKeys) {
            this.regionSnapshot.put(key, anObj.copy());
        }
        return key;
    }

    protected void invalidateEntry(Region aReg, boolean isLocalInvalidate) {
        int beforeSize = aReg.size();
        Object key = DeltaTest.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            if (this.isSerialExecution && beforeSize != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + beforeSize);
            }
            Log.getLogWriter().info("invalidateEntry: No keys in region");
            return;
        }
        boolean containsKey = aReg.containsKey(key);
        boolean containsValueForKey = aReg.containsValueForKey(key);
        Log.getLogWriter().info("containsKey for " + key + ": " + containsKey);
        Log.getLogWriter().info("containsValueForKey for " + key + ": " + containsValueForKey);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aReg.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: local invalidate for " + key);
                    aReg.localInvalidate(key);
                    Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", invalidateEntry: invalidating key " + key + " callback is " + callback);
                aReg.invalidate(key, (Object)callback);
                Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("operation for " + key + ", invalidateEntry: invalidating key " + key);
                aReg.invalidate(key);
                Log.getLogWriter().info("operation for " + key + ", invalidateEntry: done invalidating key " + key);
            }
            if (this.isSerialExecution || this.uniqueKeys) {
                this.regionSnapshot.put(key, null);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution || this.uniqueKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aReg, boolean isLocalDestroy) {
        Object key = DeltaTest.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aReg.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("destroyEntry: No keys in region");
            return;
        }
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: local destroy for " + key + " callback is " + callback);
                    aReg.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: local destroy for " + key);
                    aReg.localDestroy(key);
                    Log.getLogWriter().info("operation for " + key + ", destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", destroyEntry: destroying key " + key + " callback is " + callback);
                aReg.destroy(key, (Object)callback);
                Log.getLogWriter().info("operation for " + key + ", destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("operation for " + key + ", destroyEntry: destroying key " + key);
                aReg.destroy(key);
                Log.getLogWriter().info("operation for " + key + ", destroyEntry: done destroying key " + key);
            }
            if (this.isSerialExecution || this.uniqueKeys) {
                this.regionSnapshot.remove(key);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isSerialExecution || this.uniqueKeys) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aReg) {
        DeltaObject previousObj;
        Object key = DeltaTest.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aReg.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            Log.getLogWriter().info("updateEntry: No keys in region");
            return;
        }
        DeltaObject anObj = previousObj = (DeltaObject)aReg.get(key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (previousObj == null) {
            Log.getLogWriter().info("Unable to modify value for key " + key + " because it was previously invalidated");
            anObj = new DeltaObject(NameFactory.getCounterForName(key), 1, 0, 1);
            anObj.extra = key;
            callback = fullDistribution;
            this.trackUpdate(aReg, key, false);
        } else {
            boolean deltaBooleansSet = this.modifyDeltaObject(anObj);
            this.trackUpdate(aReg, key, deltaBooleansSet);
            if (!deltaBooleansSet) {
                callback = fullDistribution;
            }
        }
        Log.getLogWriter().info("operation for " + key + ", updateEntry: replacing key " + key + " with " + anObj.toStringFull() + ", callback is " + callback);
        Object returnVal = aReg.put(key, (Object)anObj, (Object)callback);
        Log.getLogWriter().info("operation for " + key + ", updateEntry: Done with call to put (update), returnVal is " + returnVal);
        if (this.isSerialExecution || this.uniqueKeys) {
            this.regionSnapshot.put(key, anObj.copy());
        }
    }

    protected void getKey(Region aReg) {
        Object key = DeltaTest.getExistingKey(aReg, this.uniqueKeys, this.numThreadsInClients);
        if (key == null) {
            int size = aReg.size();
            if (this.isSerialExecution && size != 0) {
                throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
            }
            this.getNewKey(aReg);
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        try {
            DeltaObject anObj;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", getKey: getting key " + key + ", callback is " + callback);
                anObj = (DeltaObject)aReg.get(key, (Object)callback);
                Log.getLogWriter().info("operation for " + key + ", getKey: got value for key " + key + ": " + (anObj == null ? "null" : anObj.toStringFull()));
            } else {
                Log.getLogWriter().info("operation for " + key + ", getKey: getting key " + key);
                anObj = (DeltaObject)aReg.get(key);
                Log.getLogWriter().info("operation for " + key + ", getKey: got value for key " + key + ": " + (anObj == null ? "null" : anObj.toStringFull()));
            }
            if (this.isSerialExecution || this.uniqueKeys) {
                if (anObj == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, anObj.copy());
                }
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void getNewKey(Region aReg) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        try {
            DeltaObject anObj;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: getting new key " + key + ", callback is " + callback);
                anObj = (DeltaObject)aReg.get(key, (Object)callback);
            } else {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: getting new key " + key);
                anObj = (DeltaObject)aReg.get(key);
            }
            if (anObj == null) {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: done getting value for new key " + key + ": " + anObj);
            } else {
                Log.getLogWriter().info("operation for " + key + ", getNewKey: done getting value for new key " + key + ": " + anObj.toStringFull());
            }
            if (this.isSerialExecution || this.uniqueKeys) {
                if (anObj == null) {
                    this.regionSnapshot.put(key, null);
                } else {
                    this.regionSnapshot.put(key, anObj.copy());
                }
            }
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected Object getNewKey() {
        if (this.uniqueKeys) {
            int anInt = (Integer)this.uniqueKeyIndex.get();
            this.uniqueKeyIndex.set(new Integer(anInt += this.numThreadsInClients));
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    protected static void logExecutionNumber() {
        long exeNum = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected static void registerInterest(Region aRegion) {
        Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
    }

    protected void badDeltaController(int testCase) {
        Object key = this.getKeyForBadDeltaTest();
        DeltaPropagationBB.getBB().getSharedMap().put(BadDeltaObject.testCaseKey, new Integer(testCase));
        Log.getLogWriter().info("Test intends to cause bad delta: " + BadDeltaObject.testCaseToString(testCase));
        BadDeltaObject originalObj = (BadDeltaObject)this.aRegion.get(key);
        Log.getLogWriter().info("For key " + key + ", get returned " + originalObj.toStringFull());
        BadDeltaObject anObj = (BadDeltaObject)originalObj.copy();
        Log.getLogWriter().info("Modifying BadDeltaObject " + anObj.toStringFull());
        anObj.reset();
        ++anObj.aPrimitiveLong;
        anObj.aPrimitiveLongChanged = true;
        Log.getLogWriter().info("Putting " + key + " with modified BadDeltaObject, BadDeltaObject.aPrimitiveLong modified, object is now " + anObj.toStringFull());
        switch (testCase) {
            case 10: 
            case 11: {
                try {
                    DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
                    this.handleBadDeltaSuccessfulUpdate(testCase, IOException.class, key, anObj);
                    this.verifyValue(key, anObj);
                }
                catch (Throwable error) {
                    this.handleBadDeltaException(IOException.class, error, testCase == 11);
                    this.verifyValue(key, originalObj);
                }
                MasterController.sleepForMs(3500);
                this.verifyNoUpdates();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                try {
                    DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
                    this.handleBadDeltaSuccessfulUpdate(testCase, ArrayIndexOutOfBoundsException.class, key, anObj);
                    this.verifyValue(key, anObj);
                }
                catch (Throwable error) {
                    this.handleBadDeltaException(ArrayIndexOutOfBoundsException.class, error, testCase == 3);
                    this.verifyValue(key, originalObj);
                }
                MasterController.sleepForMs(3500);
                this.verifyNoUpdates();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                try {
                    DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
                    this.handleBadDeltaSuccessfulUpdate(testCase, AssertionError.class, key, anObj);
                    this.verifyValue(key, anObj);
                }
                catch (Throwable error) {
                    this.handleBadDeltaException(AssertionError.class, error, testCase == 6);
                    String errStr = TestHelper.getStackTrace(error);
                    if (errStr.indexOf("Causing an error in hasDelta") < 0 && errStr.indexOf("Causing an error in toDelta") < 0 && errStr.indexOf("Causing an error in fromDelta") < 0) {
                        throw new TestException("Got " + error + " but expected AssertionError thrown from a delta call; " + TestHelper.getStackTrace(error));
                    }
                    this.verifyValue(key, originalObj);
                }
                MasterController.sleepForMs(3500);
                this.verifyNoUpdates();
                break;
            }
            case 7: 
            case 8: {
                try {
                    DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
                    this.handleBadDeltaSuccessfulUpdate(testCase, EOFException.class, key, anObj);
                    this.verifyValue(key, anObj);
                }
                catch (Throwable error) {
                    this.handleBadDeltaException(EOFException.class, error, true);
                    this.verifyValue(key, originalObj);
                }
                MasterController.sleepForMs(3500);
                this.verifyNoUpdates();
                break;
            }
            case 9: {
                DeltaTest.testInstance.aRegion.put(key, (Object)anObj);
                int numVMs = TestHelper.getNumVMs();
                if (TestConfig.tab().stringAt(AdminHelperPrms.alertListener, null) != null) {
                    --numVMs;
                }
                TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.NUM_UPDATE", DeltaPropagationBB.NUM_UPDATE, numVMs, true, -1L, 2000L);
                DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.NUM_UPDATE);
                this.verifyValue(key, anObj);
                break;
            }
            default: {
                throw new TestException("Unknown test case " + testCase);
            }
        }
        DeltaTest.checkForError();
    }

    protected Object getKeyForBadDeltaTest() {
        if (this.aRegion.getAttributes().getDataPolicy().withPartitioning() && this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies() == 0 && !this.isBridgeConfiguration) {
            DistributedMember thisMember = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
            ArrayList aList = new ArrayList(this.aRegion.keySet());
            while (aList.size() > 0) {
                int index = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
                Object key = aList.get(index);
                DistributedMember member = PartitionRegionHelper.getPrimaryMemberForKey((Region)this.aRegion, key);
                if (!member.equals(thisMember)) {
                    return key;
                }
                aList.remove(index);
            }
            throw new TestException("Test error; could not find a suitable key for testing bad delta");
        }
        ArrayList aList = new ArrayList(this.aRegion.keySet());
        return aList.get(TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1));
    }

    protected void handleBadDeltaException(Class expected, Throwable got, boolean expectedIsFromRemoteVM) {
        if (got instanceof TestException) {
            throw (TestException)got;
        }
        if (expectedIsFromRemoteVM) {
            if (this.isBridgeClient) {
                if (got.getClass() == ServerOperationException.class || got.getClass() == ServerConnectivityException.class) {
                    Throwable cause = got.getCause();
                    if (cause.getClass() != expected && (cause.getClass() != DeltaSerializationException.class || cause.getCause() == null || cause.getCause().getClass() != expected)) {
                        throw new TestException("Expected " + got.getClass().getName() + " with cause " + expected.getName() + " but got " + TestHelper.getStackTrace(got));
                    }
                    Log.getLogWriter().info("Test caught expected " + TestHelper.getStackTrace(got) + "; continuing test");
                    return;
                }
                throw new TestException("Expected " + ServerOperationException.class.getName() + " with cause " + expected.getName() + " but got " + TestHelper.getStackTrace(got));
            }
            if (got instanceof DeltaSerializationException && got.getCause().getClass() == expected) {
                Log.getLogWriter().info("Test caught expected " + TestHelper.getStackTrace(got) + "; continuing test");
                return;
            }
        }
        if (got.getClass() != expected && (got.getClass() != DeltaSerializationException.class || got.getCause() == null || got.getCause().getClass() != expected)) {
            throw new TestException("Expected " + expected.getName() + " but got " + TestHelper.getStackTrace(got));
        }
        Log.getLogWriter().info("Test caught expected " + TestHelper.getStackTrace(got) + "; continuing test");
    }

    protected void handleBadDeltaSuccessfulUpdate(int badDeltaTestCase, Class expectedExceptionClass, Object key, BadDeltaObject value) {
        boolean isBadDeltaWarningCase = this.isBadDeltaWarningCase(badDeltaTestCase);
        if (isBadDeltaWarningCase) {
            Log.getLogWriter().info("This is a bad delta warning case");
            DeltaTestAlertListener.waitForWarning();
            DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.NUM_UPDATE);
            DeltaTestAlertListener.clearAlerts();
            BadDeltaObject got = (BadDeltaObject)this.aRegion.get(key);
            if (!value.equals(got)) {
                throw new TestException("Expected value in region " + got.toStringFull() + " to be equal to updated value " + value.toStringFull());
            }
        } else {
            throw new TestException("Bug 40721 or 40716; Expected " + expectedExceptionClass.getName() + ", but put completed without an exception");
        }
    }

    protected void concVerify() {
        if (DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.ConcurrentLeader) == 1L) {
            Log.getLogWriter().info("In concVerify, this thread is the concurrent leader");
            HashMap snapshot = new HashMap();
            Log.getLogWriter().info("This thread is the concurrentLeader, creating region snapshot...");
            Map sharedMap = DeltaPropagationBB.getBB().getSharedMap().getMap();
            for (String key : sharedMap.keySet()) {
                if (!key.startsWith(regionSnapshotKey)) continue;
                Map value = (Map)sharedMap.get(key);
                snapshot.putAll(value);
            }
            Log.getLogWriter().info("Done creating region snapshot with " + snapshot.size() + " entries; " + DeltaObject.toStringAbbreviated(snapshot));
            DeltaPropagationBB.getBB().getSharedMap().put("RegionSnapshot", snapshot);
            long snapshotWritten = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.SnapshotWritten);
            Log.getLogWriter().info("Incremented SnapshotWritten, now is " + snapshotWritten);
        } else {
            Log.getLogWriter().info("In concVerify, this thread is waiting for the concurrent leader to write the snapshot");
            TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.SnapshotWritten", DeltaPropagationBB.SnapshotWritten, 1L, true, -1L, 2000L);
            Map snapshot = (Map)DeltaPropagationBB.getBB().getSharedMap().get("RegionSnapshot");
            this.verifyRegionContents(snapshot);
        }
        this.verifyDeltaBehavior();
    }

    private static List[] getInconsistencies(List expected, List actual) {
        ArrayList unexpected = new ArrayList(actual);
        for (Object element : expected) {
            unexpected.remove(element);
        }
        ArrayList missing = new ArrayList(expected);
        for (Object element : actual) {
            missing.remove(element);
        }
        return new List[]{unexpected, missing};
    }

    protected void verifyRegionContents(Map expected) {
        String tmpStr;
        Log.getLogWriter().info("Verifying contents of " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
        Set regionKeySet = this.aRegion.keySet();
        int regionSize = this.aRegion.size();
        int regionKeySetSize = regionKeySet.size();
        Log.getLogWriter().info("regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        if (regionSize != regionKeySetSize) {
            throw new TestException("Inconsistent sizes: regionSize is " + regionSize + " regionKeySetSize is " + regionKeySetSize);
        }
        Set snapshotKeySet = expected.keySet();
        HashSet unexpectedInRegion = new HashSet(regionKeySet);
        HashSet missingInRegion = new HashSet(snapshotKeySet);
        unexpectedInRegion.removeAll(snapshotKeySet);
        missingInRegion.removeAll(regionKeySet);
        Log.getLogWriter().info("Found " + unexpectedInRegion.size() + " unexpected entries and " + missingInRegion.size() + " missing entries");
        StringBuffer aStr = new StringBuffer();
        if (this.aRegion.size() != expected.size()) {
            aStr.append("Expected " + this.aRegion.getFullPath() + " to be size " + expected.size() + ", but it is size " + this.aRegion.size());
            Log.getLogWriter().info(aStr.toString());
        }
        if (unexpectedInRegion.size() > 0) {
            tmpStr = "Found the following " + unexpectedInRegion.size() + " unexpected keys in " + this.aRegion.getFullPath() + ": " + unexpectedInRegion;
            Log.getLogWriter().info(tmpStr.toString());
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        if (missingInRegion.size() > 0) {
            tmpStr = "The following " + missingInRegion.size() + " keys were missing from " + this.aRegion.getFullPath() + ": " + missingInRegion;
            Log.getLogWriter().info(tmpStr);
            if (aStr.length() > 0) {
                aStr.append("\n");
            }
            aStr.append(tmpStr);
        }
        for (Object key : this.aRegion.keySet()) {
            DeltaObject deltaObjInRegion = (DeltaObject)this.aRegion.get(key);
            DeltaObject deltaObjInSnapshot = (DeltaObject)expected.get(key);
            if (deltaObjInRegion == null) {
                if (deltaObjInSnapshot == null) continue;
                aStr.append("For key " + key + ", expected " + deltaObjInRegion + " to be " + deltaObjInSnapshot.toStringFull() + "\n");
                continue;
            }
            if (deltaObjInRegion.equals(deltaObjInSnapshot)) continue;
            aStr.append("For key " + key + ", expected " + deltaObjInRegion.toStringFull() + " to be equal to snapshot value " + (deltaObjInSnapshot == null ? "null" : deltaObjInSnapshot.toStringFull()) + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Done verifying contents of " + this.aRegion.getFullPath() + ", size is " + this.aRegion.size());
    }

    protected void writeDeltaInfoToBlackboard() {
        int myVmID = RemoteTestModule.getMyVmid();
        String key = toDeltaKey + myVmID;
        List value = DeltaObserver.getToDeltaKeys();
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
        key = fromDeltaKey + myVmID;
        value = DeltaObserver.getFromDeltaKeys();
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
        key = hasDeltaKey + myVmID;
        value = DeltaObserver.getHasDeltaKeys();
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
        key = updatedKeysKey + myVmID;
        value = this.updatedKeys;
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
        key = updatedKeysWithDeltaKey + myVmID;
        value = this.updatedKeysWithDelta;
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
        key = updatedKeysNotDistKey + myVmID;
        value = this.updatedKeysNotDistributed;
        DeltaPropagationBB.getBB().getSharedMap().put(key, value);
        Log.getLogWriter().info("Wrote to bb, key " + key + ", value " + DeltaTest.keysToString(value));
    }

    protected void clear() {
        Log.getLogWriter().info("Calling clear for DeltaTest tracking...");
        DeltaObserver.clear();
        this.updatedKeys = new ArrayList();
        this.updatedKeysWithDelta = new ArrayList();
        this.updatedKeysNotDistributed = new ArrayList();
    }

    protected void verifyDeltaBehavior() {
        int thisVmID = RemoteTestModule.getMyVmid();
        Map bbMap = DeltaPropagationBB.getBB().getSharedMap().getMap();
        ArrayList updatedDistributedKeys = new ArrayList(this.updatedKeysWithDelta);
        for (Object element : this.updatedKeysNotDistributed) {
            updatedDistributedKeys.remove(element);
        }
        List toDeltaKeys = (List)bbMap.get(toDeltaKey + thisVmID);
        List fromDeltaKeys = (List)bbMap.get(fromDeltaKey + thisVmID);
        DeltaTest.verifyDeltaCalls(thisVmID, toDeltaKeys, "to", updatedDistributedKeys);
        Iterator it = bbMap.keySet().iterator();
        ArrayList union = new ArrayList();
        while (it.hasNext()) {
            int vmID;
            String key = (String)it.next();
            if (!key.startsWith(updatedKeysWithDeltaKey) || (vmID = Integer.valueOf(key.substring(key.indexOf("_") + 1, key.length())).intValue()) == thisVmID) continue;
            List otherUpdatedKeysWithDelta = (List)bbMap.get(key);
            ArrayList otherUpdatedDistributedKeys = new ArrayList(otherUpdatedKeysWithDelta);
            for (Object element : this.updatedKeysNotDistributed) {
                otherUpdatedDistributedKeys.remove(element);
            }
            union.addAll(otherUpdatedDistributedKeys);
        }
        Log.getLogWriter().info("Gathered updated (and distributed) keys from all vms other than this one: " + DeltaTest.keysToString(union));
        if (this.aRegion.getAttributes().getDataPolicy().withPartitioning()) {
            if (this.aRegion.getAttributes().getPartitionAttributes().getLocalMaxMemory() == 0) {
                DeltaTest.verifyDeltaCalls(thisVmID, fromDeltaKeys, "from", new ArrayList());
            } else {
                DistributedMember thisMember = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
                ArrayList updatedKeysRedundant = new ArrayList();
                if (this.updatedKeysWithDelta.size() != 0) {
                    for (int i = 0; i < this.updatedKeysWithDelta.size(); ++i) {
                        Object key = this.updatedKeysWithDelta.get(i);
                        Set redundantMembers = PartitionRegionHelper.getRedundantMembersForKey((Region)this.aRegion, key);
                        if (!redundantMembers.contains(thisMember)) continue;
                        updatedKeysRedundant.add(key);
                    }
                    if (this.isSerialExecution) {
                        DeltaTest.verifyDeltaCalls(thisVmID, fromDeltaKeys, "from", updatedKeysRedundant);
                    }
                }
                ArrayList keysInThisVM = new ArrayList();
                if (union.size() != 0) {
                    for (int i = 0; i < union.size(); ++i) {
                        Object key = union.get(i);
                        Set aSet = PartitionRegionHelper.getAllMembersForKey((Region)this.aRegion, key);
                        if (!aSet.contains(thisMember)) continue;
                        keysInThisVM.add(key);
                    }
                    if (this.isSerialExecution) {
                        DeltaTest.verifyDeltaCalls(thisVmID, fromDeltaKeys, "from", keysInThisVM);
                    }
                }
                if (!this.isSerialExecution) {
                    ArrayList expectedFromDeltaKeys = new ArrayList();
                    expectedFromDeltaKeys.addAll(updatedKeysRedundant);
                    expectedFromDeltaKeys.addAll(keysInThisVM);
                    DeltaTest.verifyDeltaCalls(thisVmID, fromDeltaKeys, "from", expectedFromDeltaKeys);
                }
            }
            ParRegUtil.verifyPRMetaData(this.aRegion);
            ParRegUtil.verifyPrimaries(this.aRegion, this.redundantCopies);
            ParRegUtil.verifyBucketCopies(this.aRegion, this.redundantCopies);
        } else {
            DeltaTest.verifyDeltaCalls(thisVmID, fromDeltaKeys, "from", union);
        }
    }

    protected static void verifyDeltaCalls(int vmID, List deltaKeys, String whichDelta, List expectedKeys) {
        Log.getLogWriter().info("In verifyDeltaCalls for " + whichDelta + "Delta for vmID " + vmID + ", expected keys: " + DeltaTest.keysToString(expectedKeys) + "\n, " + whichDelta + "Delta keys: " + DeltaTest.keysToString(deltaKeys));
        List[] tmp = DeltaTest.getInconsistencies(expectedKeys, deltaKeys);
        List unexpectedDeltaKeys = tmp[0];
        List missingDeltaKeys = tmp[1];
        StringBuffer aStr = new StringBuffer();
        if (unexpectedDeltaKeys.size() != 0) {
            aStr.append("Delta." + whichDelta + "Delta was unexpectedly called in vm id " + vmID + " on the values of the following updated keys: " + DeltaTest.keysToString(unexpectedDeltaKeys));
        } else {
            Log.getLogWriter().info("Found no unexpected " + whichDelta + "Delta calls in vm " + vmID);
        }
        if (missingDeltaKeys.size() != 0) {
            aStr.append("Delta." + whichDelta + "Delta was not called in vm id " + vmID + " on the values of the following updated keys: " + DeltaTest.keysToString(missingDeltaKeys));
        } else {
            Log.getLogWriter().info("Found no missing " + whichDelta + "Delta calls in vm " + vmID);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr);
        }
    }

    protected void verifyNoUpdates() {
        long counter = DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE);
        Log.getLogWriter().info("NUM_UPDATES is " + counter);
        if (counter != 0L) {
            throw new TestException("Bug 40747 Expected failed update, but afterUpdate was invoked, NUM_UPDATE is " + counter);
        }
    }

    public void doSerialRREvictionTest() {
        DeltaTest.logExecutionNumber();
        long numThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long roundPosition = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundPosition);
        Log.getLogWriter().info("In doSerialRREvictionTest, roundPosition is " + roundPosition);
        if (roundPosition == numThreads) {
            Log.getLogWriter().info("In doSerialRREvictionTest, last in round");
            this.verifyEviction();
            DeltaPropagationBB.getBB().getSharedCounters().zero(DeltaPropagationBB.RoundPosition);
            roundPosition = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundPosition);
        }
        if (roundPosition == 1L) {
            long roundNumber = DeltaPropagationBB.getBB().getSharedCounters().incrementAndRead(DeltaPropagationBB.RoundNumber);
            Log.getLogWriter().info("In doSerialRREvictionTest, first in round, round number " + roundNumber);
            this.doEvictionTestOps();
            this.verifyEviction();
        } else if (roundPosition != numThreads) {
            Log.getLogWriter().info("In doSerialRREvictionTest, neither first nor last");
            this.verifyEviction();
        }
    }

    protected void doEvictionTestOps() {
        ArrayList<String> currentKeys = (ArrayList<String>)DeltaPropagationBB.getBB().getSharedMap().get(this.currentKeyListKey);
        if (currentKeys == null) {
            currentKeys = new ArrayList<String>();
        }
        ArrayList keysAvailableThisTask = new ArrayList(currentKeys);
        int numOpsPerTask = TestConfig.tab().intAt(DeltaPropagationPrms.numOpsPerTask);
        for (int i = 1; i <= numOpsPerTask; ++i) {
            String key;
            int size = this.aRegion.size();
            String operation = null;
            operation = size <= this.lowerThreshold ? TestConfig.tab().stringAt(DeltaPropagationPrms.lowerThresholdOperations) : (size > this.upperThreshold ? TestConfig.tab().stringAt(DeltaPropagationPrms.upperThresholdOperations) : TestConfig.tab().stringAt(DeltaPropagationPrms.entryOperations));
            Log.getLogWriter().info(this.aRegion.getFullPath() + " is size " + size + ", operation is " + operation);
            if (operation.equals("add")) {
                String key2 = this.addNewValue();
                DeltaPropagationBB.getBB().getSharedMap().put(this.opKey, new Object[]{"add", key2});
                currentKeys.add(key2);
                continue;
            }
            if (operation.equals("update")) {
                Object[] tmp = this.updateDeltaValueHolder(keysAvailableThisTask);
                key = (String)tmp[0];
                Integer previousPayloadSize = (Integer)tmp[1];
                DeltaPropagationBB.getBB().getSharedMap().put(this.opKey, new Object[]{"update", key, previousPayloadSize});
                keysAvailableThisTask.remove(key);
                continue;
            }
            if (operation.equals("destroy")) {
                int index = TestConfig.tab().getRandGen().nextInt(0, keysAvailableThisTask.size() - 1);
                key = (String)keysAvailableThisTask.get(index);
                Log.getLogWriter().info("Destroying key " + key);
                this.aRegion.destroy((Object)key);
                Log.getLogWriter().info("Done destroying key " + key);
                currentKeys.remove(key);
                keysAvailableThisTask.remove(key);
                continue;
            }
            if (operation.equals("getNew")) {
                String key3 = (String)this.getNewKey();
                Log.getLogWriter().info("Getting new key " + key3);
                Object value = this.aRegion.get((Object)key3);
                Log.getLogWriter().info("Done getting new key " + key3 + " value is " + TestHelper.toString(value));
                currentKeys.add(key3);
                continue;
            }
            if (operation.equals("invalidate")) {
                int index = TestConfig.tab().getRandGen().nextInt(0, keysAvailableThisTask.size() - 1);
                key = (String)keysAvailableThisTask.get(index);
                Log.getLogWriter().info("Invalidating " + key);
                this.aRegion.invalidate((Object)key);
                Log.getLogWriter().info("Done invalidating " + key);
                keysAvailableThisTask.remove(key);
                continue;
            }
            throw new TestException("Test does not support operation " + operation);
        }
        Log.getLogWriter().info("Completed " + numOpsPerTask + " operations this task");
        DeltaPropagationBB.getBB().getSharedMap().put(this.currentKeyListKey, currentKeys);
    }

    protected String addNewValue() {
        String key = (String)this.getNewKey();
        String valueClass = DeltaPropagationPrms.getValueClass();
        try {
            Class<?> cls = Class.forName(valueClass);
            BaseValueHolder value = (BaseValueHolder)cls.newInstance();
            value.myValue = DeltaPropagationPrms.getPretendSize();
            value.extraObject = new byte[DeltaPropagationPrms.getPayloadSize()];
            Log.getLogWriter().info("Adding new key " + key + ", value is " + TestHelper.toString(value));
            this.aRegion.put((Object)key, (Object)value);
            Log.getLogWriter().info("Done adding new key " + key + ", value is " + TestHelper.toString(value));
            return key;
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected Object[] updateDeltaValueHolder(List currentKeyList) {
        int index = TestConfig.tab().getRandGen().nextInt(0, currentKeyList.size() - 1);
        String key = (String)currentKeyList.get(index);
        Object value = this.aRegion.get((Object)key);
        if (value instanceof BaseValueHolder) {
            BaseValueHolder dvh = (BaseValueHolder)value;
            int previousPayloadSize = ((byte[])dvh.extraObject).length;
            Log.getLogWriter().info("Updating " + key + " with previous value " + TestHelper.toString(dvh));
            dvh.myValue = DeltaPropagationPrms.getPretendSize();
            dvh.extraObject = new byte[DeltaPropagationPrms.getPayloadSize()];
            this.aRegion.put((Object)key, (Object)dvh);
            Log.getLogWriter().info("Done updating " + key + ", value is now " + TestHelper.toString(dvh));
            return new Object[]{key, previousPayloadSize};
        }
        if (value == null) {
            String valueClass = DeltaPropagationPrms.getValueClass();
            try {
                Class<?> cls = Class.forName(valueClass);
                BaseValueHolder vh = (BaseValueHolder)cls.newInstance();
                vh.myValue = DeltaPropagationPrms.getPretendSize();
                vh.extraObject = new byte[DeltaPropagationPrms.getPayloadSize()];
                Log.getLogWriter().info("Adding new key " + key + ", value is " + TestHelper.toString(vh));
                this.aRegion.put((Object)key, (Object)vh);
                Log.getLogWriter().info("Done adding new key " + key + ", value is " + TestHelper.toString(vh));
                return new Object[]{key, null};
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        throw new TestException("Value for key " + key + " is " + value + " but expected a DeltaValueHolder");
    }

    protected void verifyEviction() {
        if (this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm().isLRUMemory()) {
            if (!this.aRegion.getAttributes().getDataPolicy().withPartitioning()) {
                throw new TestException("Test validation not supported for " + this.aRegion.getAttributes().getDataPolicy());
            }
        } else {
            throw new TestException("Test validation not supported for " + this.aRegion.getAttributes().getEvictionAttributes().getAlgorithm());
        }
        long numBytesInVM = this.checkMemLRULevelForPR();
        this.saveEvictionStats(numBytesInVM);
    }

    protected void saveEvictionStats(long numBytesInVM) {
        this.before_stat_entriesInVM = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumEntriesInVM();
        this.before_stat_numOverflowOnDisk = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumOverflowOnDisk();
        this.before_numBytesInThisVM = numBytesInVM;
        this.before_stat_lruEvictions = ((LocalRegion)this.aRegion).getEvictionController().getLRUHelper().getStats().getEvictions();
        Log.getLogWriter().info("Set before values to:\nbefore_stat_entriesInVM: " + this.before_stat_entriesInVM + "\nbefore_stat_numOverflowOnDisk: " + this.before_stat_numOverflowOnDisk + "\nbefore_numBytesInThisVM: " + this.before_numBytesInThisVM + "\nbefore_lruEvictions: " + this.before_stat_lruEvictions);
    }

    protected void checkEviction() {
        Object actualValueInVM;
        Object[] operationArr = (Object[])DeltaPropagationBB.getBB().getSharedMap().get(this.opKey);
        int memLRULimitMB = this.aRegion.getAttributes().getEvictionAttributes().getMaximum();
        int memLRULimitBytes = memLRULimitMB * 1024 * 1024;
        String operation = (String)operationArr[0];
        String key = (String)operationArr[1];
        boolean keyHostedInThisVM = this.thisVMHostsKey(this.aRegion, key);
        Object valueInVM = DiskRegUtil.getValueInVM(this.aRegion, key);
        try {
            actualValueInVM = ((LocalRegion)this.aRegion).getValueInVM((Object)key);
        }
        catch (EntryNotFoundException e) {
            actualValueInVM = null;
        }
        Object valueOnDisk = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
        long stat_entriesInVM = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumEntriesInVM();
        long stat_numOverflowOnDisk = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumOverflowOnDisk();
        long stat_lruEvictions = ((LocalRegion)this.aRegion).getEvictionController().getLRUHelper().getStats().getEvictions();
        PretendSizer sizer = new PretendSizer();
        Log.getLogWriter().info("Checking eviction for operation " + operation + " and key " + key + "\nvalueInVM (real object): " + TestHelper.toString(valueInVM) + "\nvalueInVM (actual): " + (actualValueInVM == null ? "null" : actualValueInVM.getClass().getName()) + "\nvalueOnDisk: " + TestHelper.toString(valueOnDisk) + "\nkey is hosted in this VM: " + keyHostedInThisVM + "\nbefore entriesInVM: " + this.before_stat_entriesInVM + "\nbefore numOverflowOnDisk: " + this.before_stat_numOverflowOnDisk + "\nbefore lruEvictions: " + this.before_stat_lruEvictions + "\nnow entriesInVM: " + stat_entriesInVM + "\nnow numOverflowOnDisk: " + stat_numOverflowOnDisk + "\nnow lruEvictions: " + stat_lruEvictions + "\nmemLRULimit (mb): " + memLRULimitMB + "\nmemLRULimitBytes: " + memLRULimitBytes);
        if (!keyHostedInThisVM) {
            if (valueInVM != null || valueOnDisk != null) {
                throw new TestException("Key " + key + " is not hosted in this vm according to PartitionedRegionHelper, but valueInVM is " + TestHelper.toString(valueInVM) + ", and value on disk is " + TestHelper.toString(valueOnDisk));
            }
            if (this.before_stat_lruEvictions != stat_lruEvictions) {
                throw new TestException("Key " + key + " is not hosted in this vm so expected no eviction  but stats after the operation have changed: before entriesInVM is " + this.before_stat_entriesInVM + ", before numOverflowOnDisk is " + this.before_stat_numOverflowOnDisk + ", after entriesInVM is " + stat_entriesInVM + ", after numOverflowOnDisk " + stat_numOverflowOnDisk);
            }
            return;
        }
        int nowSizeOfObject = 0;
        if (actualValueInVM instanceof BaseValueHolder) {
            nowSizeOfObject = sizer.getSize(actualValueInVM);
        } else if (actualValueInVM instanceof CachedDeserializable) {
            ((CachedDeserializable)actualValueInVM).getSizeInBytes();
        } else {
            throw new TestException("Test does not currently handle " + actualValueInVM.getClass().getName());
        }
        int beforeSizeOfObject = this.beforeMap.get(key);
        this.beforeMap.put(key, new Integer(nowSizeOfObject));
        int netSizeChange = nowSizeOfObject - beforeSizeOfObject;
        long newVMSize = this.before_numBytesInThisVM + (long)netSizeChange;
        Log.getLogWriter().info("Before, value for key " + key + " had size " + beforeSizeOfObject + ", now size is " + nowSizeOfObject + ", net change is " + netSizeChange + ", new vm size in bytes is " + newVMSize);
        if (newVMSize >= (long)memLRULimitBytes) {
            if (stat_lruEvictions > this.before_stat_lruEvictions) {
                throw new TestException("Eviction should have occurred but didn't");
            }
            Log.getLogWriter().info("Eviction occurred as expected");
        } else {
            if (stat_lruEvictions != this.before_stat_lruEvictions) {
                throw new TestException("No eviction was expected but stats after the operation have changed: before lruEvictions was " + this.before_stat_lruEvictions + ", now lruEvictions is " + stat_lruEvictions);
            }
            Log.getLogWriter().info("No eviction occurred as expected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long checkMemLRULevelForPR() {
        if (this.aRegion.getAttributes().getDataPolicy().withPartitioning() && this.aRegion.getAttributes().getPartitionAttributes().getLocalMaxMemory() == 0) {
            Log.getLogWriter().info("Not checking memLRU levels, this vm is an accessor");
            return 0L;
        }
        int memLRULimitMB = this.aRegion.getAttributes().getEvictionAttributes().getMaximum();
        int memLRULimitBytes = memLRULimitMB * 1024 * 1024;
        long stat_entriesInVM = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumEntriesInVM();
        long stat_numOverflowOnDisk = ((PartitionedRegion)this.aRegion).getDiskRegionStats().getNumOverflowOnDisk();
        long stat_totalEntriesFromStats = stat_entriesInVM + stat_numOverflowOnDisk;
        long stat_lruEvictions = ((LocalRegion)this.aRegion).getEvictionController().getLRUHelper().getStats().getEvictions();
        long stat_byteCount = ((LocalRegion)this.aRegion).getEvictionController().getLRUHelper().getStats().getCounter();
        Log.getLogWriter().info("Stat entriesInVM: " + stat_entriesInVM + "\nstat numOverflowOnDisk: " + stat_numOverflowOnDisk + "\nstat totalEntriesFromStats: " + stat_totalEntriesFromStats + "\nstat lruEvictions: " + stat_lruEvictions + "\nstat byteCount: " + stat_byteCount + "\nmemLRU limit (mb): " + memLRULimitMB + "\nmemLRU limit (bytes): " + memLRULimitBytes);
        PretendSizer sizer = new PretendSizer();
        long highestKeyIndex = NameFactory.getPositiveNameCounter();
        long totalBytesInThisVM = 0L;
        int count_numEntriesInVM = 0;
        int count_numEntriesOnDisk = 0;
        HashSet<String> onDiskSet = new HashSet<String>();
        HashSet<String> inVMSet = new HashSet<String>();
        int perEntryOverhead = ((PartitionedRegion)this.aRegion).getPerEntryLRUOverhead();
        int cdOverhead = CachedDeserializableFactory.overhead();
        Log.getLogWriter().info("perEntryOverhead is " + perEntryOverhead);
        Log.getLogWriter().info("Analyzing " + highestKeyIndex + " entries...");
        int i = 1;
        while ((long)i <= highestKeyIndex) {
            String key = NameFactory.getObjectNameForCounter(i);
            Object valueInVM = DiskRegUtil.getValueInVM(this.aRegion, key);
            Object actualValueInVM = null;
            Object cdForm = null;
            try {
                actualValueInVM = ((LocalRegion)this.aRegion).getValueInVM((Object)key);
                if (actualValueInVM instanceof CachedDeserializable) {
                    cdForm = ((CachedDeserializable)actualValueInVM).getValue();
                }
            }
            catch (EntryNotFoundException e) {
                actualValueInVM = null;
            }
            Object valueOnDisk = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
            Log.getLogWriter().info("For key " + key + ", valueInVM is " + TestHelper.toString(valueInVM) + ", actualValueInVM is " + TestHelper.toString(actualValueInVM) + ", CachedDeserializable form is " + TestHelper.toString(cdForm) + "\n, valueOnDisk is " + TestHelper.toString(valueOnDisk));
            if (valueInVM != null && valueOnDisk != null) {
                boolean valuesEqual = valueInVM.equals(valueOnDisk);
                throw new TestException("For key " + key + ", value in VM is " + TestHelper.toString(valueInVM) + " and value on disk is " + TestHelper.toString(valueOnDisk) + "; do not expect value to be both in vm and on disk; actualValueInVM is " + actualValueInVM.getClass().getName() + " valueInVM and valueOnDisk are equal: " + valuesEqual);
            }
            if (valueInVM != null) {
                inVMSet.add(key);
                ++count_numEntriesInVM;
                int sizeOfObject = 0;
                String sizeParts = null;
                if (actualValueInVM instanceof BaseValueHolder) {
                    sizeOfObject = sizer.getSize(actualValueInVM);
                    sizeParts = "full value, size from sizer: 10";
                } else if (actualValueInVM instanceof CachedDeserializable) {
                    if (cdForm instanceof byte[]) {
                        sizeOfObject = ((CachedDeserializable)actualValueInVM).getSizeInBytes();
                        sizeParts = "CachedDeserializable in byte form, getSizeInBytes() " + sizeOfObject;
                    } else {
                        if (!(cdForm instanceof BaseValueHolder)) throw new TestException("Test currently does not handle CachedDeserializable.getValue() " + TestHelper.toString(cdForm));
                        int sizerValue = sizer.getSize(cdForm);
                        sizeOfObject = sizerValue + cdOverhead;
                        sizeParts = "CachedDeserializable in full object form, sizer " + sizerValue + ", CachedDeserializableFactory overhead " + cdOverhead;
                    }
                } else {
                    if (!(actualValueInVM instanceof Token.Invalid)) throw new TestException("Test does not currently handle " + actualValueInVM.getClass().getName());
                    sizeParts = "Token.invalid, size 0";
                }
                int keySize = TestHelper.calculateStringSize(key);
                int totalSize = sizeOfObject + keySize + perEntryOverhead;
                Log.getLogWriter().info(key + " total size " + totalSize + " (" + sizeParts + " keySize " + keySize + ", entry overhead " + perEntryOverhead);
                totalBytesInThisVM += (long)totalSize;
            } else if (valueOnDisk != null) {
                onDiskSet.add(key);
                ++count_numEntriesOnDisk;
                int keySize = TestHelper.calculateStringSize(key);
                Log.getLogWriter().info(key + " size is " + keySize + ", value is on disk, entry overhead " + perEntryOverhead);
                totalBytesInThisVM += (long)(keySize + perEntryOverhead);
            }
            ++i;
        }
        HashSet newInVM = new HashSet(inVMSet);
        newInVM.removeAll(this.before_inVMSet);
        HashSet newOnDisk = new HashSet(onDiskSet);
        newOnDisk.removeAll(this.before_onDiskSet);
        int count_totalEntries = count_numEntriesInVM + count_numEntriesOnDisk;
        Log.getLogWriter().info("Counted " + count_numEntriesInVM + " entries in vm\nCounted " + count_numEntriesOnDisk + " entries on disk\nTotal entries: " + count_totalEntries + "\nBytes in vm: " + totalBytesInThisVM + "\nNew in vm: " + newInVM + "\nNew on disk: " + newOnDisk);
        this.before_onDiskSet = onDiskSet;
        this.before_inVMSet = inVMSet;
        if (stat_entriesInVM != (long)count_numEntriesInVM) {
            throw new TestException("Number of entries in vm from stats is " + stat_entriesInVM + " and number of entries determined by test is " + count_numEntriesInVM);
        }
        if (stat_numOverflowOnDisk != (long)count_numEntriesOnDisk) {
            throw new TestException("Number of entries on disk from stats is " + stat_numOverflowOnDisk + " and number of entries determined by test is " + count_numEntriesOnDisk);
        }
        if (stat_byteCount != totalBytesInThisVM) {
            throw new TestException("Test determined there are " + totalBytesInThisVM + " bytes in this vm, but stat byteCount is " + stat_byteCount);
        }
        long overage = totalBytesInThisVM - (long)memLRULimitBytes;
        this.overageHistory.add(overage);
        if (totalBytesInThisVM > (long)memLRULimitBytes) {
            Log.getLogWriter().info("Possibly bug 41952, total bytes in vm " + totalBytesInThisVM + " exceeded memLRU limit of " + memLRULimitBytes + "; vm is over the limit by " + overage + " bytes");
            return totalBytesInThisVM;
        } else {
            Log.getLogWriter().info("Bytes in vm " + totalBytesInThisVM + " are less than the memLRU limit of " + memLRULimitBytes + "; under by " + ((long)memLRULimitBytes - totalBytesInThisVM) + " bytes");
        }
        return totalBytesInThisVM;
    }

    protected void checkOverageHistory() {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Number of bytes over or under limit for this vm's history:\n");
        int count = 0;
        long maxOverage = Long.MIN_VALUE;
        for (long overage : this.overageHistory) {
            if (overage > 0L) {
                aStr.append(" OVER " + overage + ";");
            } else {
                aStr.append(" under " + overage + ";");
            }
            if (++count == 8) {
                aStr.append("\n");
                count = 0;
            }
            maxOverage = Math.max(maxOverage, overage);
        }
        Log.getLogWriter().info(aStr.toString());
        long threshold = 5000L;
        if (maxOverage > threshold) {
            throw new TestException("Over the memLRU limit by " + maxOverage + " bytes");
        }
    }

    protected boolean thisVMHostsKey(Region aReg, Object key) {
        Set redundantMembers = PartitionRegionHelper.getRedundantMembersForKey((Region)aReg, (Object)key);
        DistributedMember primaryMember = PartitionRegionHelper.getPrimaryMemberForKey((Region)this.aRegion, (Object)key);
        Log.getLogWriter().info("For key " + key + " in region " + aReg.getFullPath() + " primaryMember: " + primaryMember + " redundantMembers: " + redundantMembers);
        for (DistributedMember dm : redundantMembers) {
            if (dm.getProcessId() != RemoteTestModule.MyPid) continue;
            return true;
        }
        return primaryMember.getProcessId() == RemoteTestModule.MyPid;
    }

    protected void verifyValue(Object key, BadDeltaObject expectedValue) {
        BadDeltaObject valueInVM = null;
        if (this.aRegion.getAttributes().getDataPolicy().withPartitioning()) {
            Set aSet;
            if (this.aRegion.getAttributes().getPartitionAttributes().getLocalMaxMemory() != 0 && (aSet = PartitionRegionHelper.getAllMembersForKey((Region)this.aRegion, (Object)key)).contains(CacheHelper.getCache().getDistributedSystem().getDistributedMember())) {
                valueInVM = (BadDeltaObject)DiskRegUtil.getValueInVM(this.aRegion, key);
            }
        } else {
            valueInVM = (BadDeltaObject)DiskRegUtil.getValueInVM(this.aRegion, key);
        }
        BadDeltaObject getValue = (BadDeltaObject)this.aRegion.get(key);
        Log.getLogWriter().info("valueInVM for key " + key + " is " + (valueInVM == null ? valueInVM : valueInVM.toStringFull()));
        Log.getLogWriter().info("get value for key " + key + " is " + (getValue == null ? getValue : getValue.toStringFull()));
        if (valueInVM != null && !valueInVM.equals(getValue)) {
            throw new TestException("ValueInVM " + valueInVM.toStringFull() + " is not equal to value from get" + (getValue == null ? getValue : getValue.toStringFull()));
        }
        if (!expectedValue.equals(getValue)) {
            throw new TestException("Expected value for key " + key + " to be " + expectedValue.toStringFull() + ", but it is " + (getValue == null ? getValue : getValue.toStringFull()));
        }
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    public static Object getExistingKey(Region aRegion, boolean uniqueKeys, int numThreads) {
        ArrayList keyList = new ArrayList();
        keyList.addAll(aRegion.keySet());
        if (keyList.size() == 0) {
            return null;
        }
        GsRandom rand = TestConfig.tab().getRandGen();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        while (keyList.size() != 0) {
            int randInt = rand.nextInt(0, keyList.size() - 1);
            Object key = keyList.get(randInt);
            if (uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads == (long)myTid) {
                    return key;
                }
            } else {
                return key;
            }
            keyList.remove(randInt);
        }
        return null;
    }

    protected void checkForLastIteration() {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = DeltaPropagationBB.getBB().getSharedMap().get("TaskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            DeltaPropagationBB.getBB().getSharedMap().put("TaskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(this.secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + this.secondsToRun + " seconds; time remaining is " + ((long)this.secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleException(Exception anExcept) {
        boolean disconnectError;
        boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
        String errStr = anExcept.toString();
        Throwable causedBy = anExcept.getCause();
        if (causedBy != null) {
            errStr = errStr + causedBy.toString();
        }
        boolean bl = disconnectError = errStr.indexOf("This connection to a distributed system has been disconnected") >= 0 || errStr.indexOf("System is disconnecting") >= 0;
        if (anExcept instanceof CancelException) {
            if (!(thisVMReceivedNiceKill || this.cacheIsClosed || this.disconnected)) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof IllegalStateException) {
            if (disconnectError) {
                if (!this.disconnected && !thisVMReceivedNiceKill) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            } else {
                if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
                if (errStr.indexOf("Proxy not properly initialized") < 0) {
                    throw new TestException(TestHelper.getStackTrace(anExcept));
                }
            }
        } else if (anExcept instanceof CacheLoaderException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeLoader has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else if (anExcept instanceof BridgeWriterException) {
            if (!this.isBridgeConfiguration || !thisVMReceivedNiceKill) throw new TestException(TestHelper.getStackTrace(anExcept));
            if (anExcept.toString().indexOf("The BridgeWriter has been closed") < 0) {
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        } else {
            if (!(anExcept instanceof NullPointerException)) throw new TestException("Got unexpected exception " + TestHelper.getStackTrace(anExcept));
            String stackStr = TestHelper.getStackTrace(anExcept);
            if (stackStr.indexOf("DeltaObject.<init>") < 0) {
                throw new TestException(stackStr);
            }
        }
        Log.getLogWriter().info("Caught " + anExcept + "; expected, continuing test");
        DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.ExceptionCounter);
        TestHelper.waitForCounter(DeltaPropagationBB.getBB(), "DeltaPropagationBB.Reinitialized", DeltaPropagationBB.Reinitialized, 1L, true, -1L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean modifyDeltaObject(DeltaObject anObj) {
        ArrayList<String> fieldsToModify = new ArrayList<String>();
        fieldsToModify.add("aPrimitiveLong");
        fieldsToModify.add("aPrimitiveInt");
        fieldsToModify.add("aPrimitiveShort");
        fieldsToModify.add("aPrimitiveFloat");
        fieldsToModify.add("aPrimitiveDouble");
        fieldsToModify.add("aPrimitiveByte");
        fieldsToModify.add("aPrimitiveChar");
        fieldsToModify.add("aPrimitiveBoolean");
        fieldsToModify.add("aByteArray");
        fieldsToModify.add("aString");
        this.numFieldsToModify = this.numFieldsToModify % fieldsToModify.size() + 1;
        while (fieldsToModify.size() > this.numFieldsToModify) {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, fieldsToModify.size() - 1);
            fieldsToModify.remove(randInt);
        }
        int value = TestConfig.tab().getRandGen().nextInt(1, 100);
        boolean setDeltaBooleans = value <= 80;
        Log.getLogWriter().info("Modifying the following " + this.numFieldsToModify + " fields: " + fieldsToModify + " in " + anObj.toStringFull() + "; setting delta booleans: " + setDeltaBooleans);
        DeltaObject deltaObject = anObj;
        synchronized (deltaObject) {
            if (fieldsToModify.contains("aPrimitiveLong")) {
                ++anObj.aPrimitiveLong;
                if (setDeltaBooleans) {
                    anObj.aPrimitiveLongChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveInt")) {
                ++anObj.aPrimitiveInt;
                if (setDeltaBooleans) {
                    anObj.aPrimitiveIntChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveShort")) {
                anObj.aPrimitiveShort = (short)(anObj.aPrimitiveShort + 1);
                if (setDeltaBooleans) {
                    anObj.aPrimitiveShortChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveFloat")) {
                anObj.aPrimitiveFloat += 1.0f;
                if (setDeltaBooleans) {
                    anObj.aPrimitiveFloatChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveDouble")) {
                anObj.aPrimitiveDouble += 1.0;
                if (setDeltaBooleans) {
                    anObj.aPrimitiveDoubleChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveByte")) {
                anObj.aPrimitiveByte = (byte)(anObj.aPrimitiveByte + 1);
                if (setDeltaBooleans) {
                    anObj.aPrimitiveByteChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveChar")) {
                anObj.aPrimitiveChar = (char)((byte)anObj.aPrimitiveChar + 1);
                if (setDeltaBooleans) {
                    anObj.aPrimitiveCharChanged = true;
                }
            }
            if (fieldsToModify.contains("aPrimitiveBoolean")) {
                boolean bl = anObj.aPrimitiveBoolean = !anObj.aPrimitiveBoolean;
                if (setDeltaBooleans) {
                    anObj.aPrimitiveBooleanChanged = true;
                }
            }
            if (fieldsToModify.contains("aByteArray")) {
                anObj.aByteArray = new byte[anObj.aByteArray.length + 1];
                if (setDeltaBooleans) {
                    anObj.aByteArrayChanged = true;
                }
            }
            if (fieldsToModify.contains("aString")) {
                anObj.aString = "" + (Integer.valueOf(anObj.aString) + 1);
                if (setDeltaBooleans) {
                    anObj.aStringChanged = true;
                }
            }
        }
        Log.getLogWriter().info("Done modifying, DeltaObject is now " + anObj.toStringFull());
        return setDeltaBooleans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackUpdate(Region aReg, Object key, boolean isDeltaDistribution) {
        List list = this.updatedKeys;
        synchronized (list) {
            this.updatedKeys.add(key);
            Log.getLogWriter().info("Added " + key + " to list of keys being updated");
        }
        if (isDeltaDistribution) {
            Set aSet;
            list = this.updatedKeysWithDelta;
            synchronized (list) {
                this.updatedKeysWithDelta.add(key);
                Log.getLogWriter().info("Added " + key + " to list of keys being updated with delta distribution");
            }
            if ((this.isSerialExecution || this.uniqueKeys) && aReg.getAttributes().getDataPolicy().withPartitioning() && (aSet = PartitionRegionHelper.getAllMembersForKey((Region)aReg, (Object)key)).contains(CacheHelper.getCache().getDistributedSystem().getDistributedMember()) && this.redundantCopies == 0 && !this.isBridgeConfiguration) {
                List list2 = this.updatedKeysNotDistributed;
                synchronized (list2) {
                    this.updatedKeysNotDistributed.add(key);
                    Log.getLogWriter().info("Added " + key + " to list of updated keys not distributed");
                }
            }
        }
    }

    protected static void checkForError() {
        Object error = DeltaPropagationBB.getBB().getSharedMap().get("Error");
        if (error != null) {
            throw new TestException(error.toString());
        }
    }

    protected static String keysToString(Collection listOfKeys) {
        int keysPerLine = 10;
        StringBuffer aStr = new StringBuffer();
        int currNumber = 0;
        for (Object key : listOfKeys) {
            aStr.append(key);
            if (++currNumber == 10) {
                aStr.append("\n");
                currNumber = 0;
                continue;
            }
            aStr.append(" ");
        }
        return aStr.toString();
    }

    protected boolean isBadDeltaWarningCase(int testCase) {
        boolean badDeltaCausesRemoteException;
        boolean bl = badDeltaCausesRemoteException = testCase == 3 || testCase == 6 || testCase == 11 || testCase == 7 || testCase == 8;
        if (!badDeltaCausesRemoteException) {
            return false;
        }
        if (this.isBridgeConfiguration && !this.isBridgeClient) {
            if (this.aRegion.getAttributes().getDataPolicy().withPartitioning()) {
                int rc = this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
                return rc == 0;
            }
            int numServers = TestConfig.tab().intAt(DeltaPropagationPrms.numServers);
            return numServers == 1;
        }
        return false;
    }

    public static void logPRMembers(Region reg, Object key) {
        if (reg.getAttributes().getDataPolicy().withPartitioning()) {
            Log.getLogWriter().info("For key " + key + " in region " + reg.getFullPath() + " primaryMember: " + PartitionRegionHelper.getPrimaryMemberForKey((Region)reg, (Object)key) + " redundantMembers: " + PartitionRegionHelper.getRedundantMembersForKey((Region)reg, (Object)key));
        }
    }

    static {
        concVerifyCoordinator = new MethodCoordinator(DeltaTest.class.getName(), "concVerify");
    }
}

