/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import delta.DeltaDurableClientValidationListener;
import delta.DeltaPropagation;
import delta.DeltaPropagationBB;
import delta.DeltaPropagationPrms;
import hct.BBoard;
import hct.HctPrms;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import query.QueryPrms;

public class DeltaCache {
    static ConfigHashtable conftab = TestConfig.tab();
    static LogWriter logger = Log.getLogWriter();
    static BBoard bb = BBoard.getInstance();
    static String regionName = conftab.stringAt(HctPrms.regionName);
    static long killInterval = conftab.longAt(HctPrms.killInterval);
    static GsRandom rand = new GsRandom();
    static int numClients = -1;

    public static synchronized void killServer() throws ClientVmNotFoundException {
        Long lastKill;
        Region aRegion = null;
        if (TestConfig.tab().booleanAt(QueryPrms.regionForRemoteOQL, false)) {
            aRegion = RegionHelper.getRegion(regionName);
        } else {
            int numRegion = TestConfig.tab().intAt(DeltaPropagationPrms.regionRange, 1) - 1;
            aRegion = RegionHelper.getRegion(regionName + numRegion);
        }
        Assert.assertNotNull((Object)aRegion);
        Set active = ClientHelper.getActiveServers(aRegion);
        int minServersRequiredAlive = TestConfig.tab().intAt(DeltaPropagationPrms.minServersRequiredAlive, 3);
        if (active.size() < minServersRequiredAlive) {
            logger.info("No kill executed , a minimum of " + minServersRequiredAlive + " servers have to be kept alive");
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - (lastKill = (Long)bb.getSharedMap().get("lastKillTime"));
        if (diff < killInterval) {
            logger.info("No kill executed");
            return;
        }
        bb.getSharedMap().put("lastKillTime", new Long(now));
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        int index = rand.nextInt(endpoints.size() - 1);
        BridgeHelper.Endpoint endpoint = endpoints.get(index);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        target = ClientVmMgr.stop("Killing random cache server", -21, -31, target);
        Log.getLogWriter().info("Server Killed : " + target);
        long count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerCrashedEvents, DeltaCache.getNumClients());
        Log.getLogWriter().info("After incrementing, BBoard.expectedServerCrashedEvents = " + count);
        int sleepSec = TestConfig.tab().intAt(HctPrms.restartWaitSec);
        logger.info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        active = ClientHelper.getActiveServers(aRegion);
        ServerLocation server = new ServerLocation(endpoint.getHost(), endpoint.getPort());
        if (active.contains(server)) {
            logger.info("ERROR: Killed server " + server + " found in Active Server List: " + active);
        }
        ClientVmMgr.start("Restarting the cache server", target);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedServerJoinedEvents, DeltaCache.getNumClients());
        Log.getLogWriter().info("After incrementing, BBoard.expectedServerJoinedEvents = " + count);
        count = BBoard.getInstance().getSharedCounters().add(BBoard.expectedClientJoinedEvents, endpoints.size());
        Log.getLogWriter().info("After incrementing, BBoard.expectedClientJoinedEvents = " + count);
        int sleepMs = ClientHelper.getRetryInterval(aRegion) + 1000;
        logger.info("Sleeping for " + sleepMs + " ms");
        MasterController.sleepForMs(sleepMs);
        active = ClientHelper.getActiveServers(aRegion);
        if (!active.contains(server)) {
            logger.info("ERROR: Restarted server " + server + " not in Active Server List: " + active);
        }
    }

    public static synchronized int getNumClients() {
        if (numClients == -1) {
            int totalVMs = TestConfig.getInstance().getTotalVMs();
            int bridgeVMs = BridgeHelper.getEndpoints().size();
            numClients = totalVMs - bridgeVMs;
            Log.getLogWriter().info("numBridgeServers = " + bridgeVMs);
            Log.getLogWriter().info("numEdgeClients = " + numClients);
        }
        return numClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killClient() {
        Log.getLogWriter().info(" VM Durable Client Id is " + DeltaPropagation.VmDurableId);
        DeltaPropagationBB.getBB().getSharedMap().put(DeltaPropagation.VmDurableId, "true");
        try {
            MasterController.sleepForMs(5000);
            Object object = DeltaDurableClientValidationListener.latestValues;
            synchronized (object) {
                DeltaPropagationBB.getBB().getSharedMap().put(DeltaPropagation.VmDurableId + "keyValueMap", DeltaDurableClientValidationListener.durableKeyMap);
            }
            object = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }
}

