/*
 * Decompiled with CFR 0.152.
 */
package cq;

import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import cq.CQGatherListener;
import cq.CQHistory;
import cq.CQHistoryListener;
import cq.CQTest;
import cq.CQUtil;
import cq.CQUtilBB;
import cq.CQUtilPrms;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.QueryObject;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class CQKnownKeysTest {
    protected static CQKnownKeysTest testInstance;
    protected static final String REGION_NAME = "TestRegion";
    protected int numNewKeys;
    protected KeyIntervals keyIntervals;
    protected int totalNumKeys;
    protected Region aRegion;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected boolean isBridgeConfiguration;
    protected boolean isBridgeClient;
    protected CQTest CQTestInstance;
    protected HydraThreadLocal uniqueKeyIndex = new HydraThreadLocal();
    protected Map queryMap;
    protected int queryDepth;
    protected QueryService qService;
    protected static final String VmIDStr = "VmId_";
    protected static boolean CQsOn;
    protected boolean sleepBetweenOps = false;
    protected final int SLEEP_BETWEEN_OPS_MILLIS = 50;
    protected static int verifyRegionContentsIndex;
    protected static StringBuffer verifyRegionContentsErrStr;
    protected static boolean verifyRegionContentsCompleted;
    protected static Iterator verifyQueryIterator;
    protected static int verifyQueryCount;
    protected static final int INVALIDATE = 1;
    protected static final int LOCAL_INVALIDATE = 2;
    protected static final int DESTROY = 3;
    protected static final int LOCAL_DESTROY = 4;
    protected static final int UPDATE_EXISTING_KEY = 5;
    protected static final int GET = 6;
    protected static final int ADD_NEW_KEY = 7;
    protected static final int FIRST_OP = 1;
    protected static final int LAST_OP = 7;
    protected static final int[] operations;

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new CQKnownKeysTest();
            testInstance.initializeClient(true);
        }
        CQKnownKeysTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeClientWithoutStartingCQs() {
        if (testInstance == null) {
            testInstance = new CQKnownKeysTest();
            testInstance.initializeClient(false);
        }
        CQKnownKeysTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_initCombineTest() {
        CQKnownKeysTest.testInstance.sleepBetweenOps = true;
    }

    private void initializeClient(boolean startCQsRunning) {
        this.initializeRegion("clientRegion");
        this.initializeInstance();
        if (this.isBridgeConfiguration) {
            this.isBridgeClient = true;
            CQKnownKeysTest.registerInterest(CQKnownKeysTest.testInstance.aRegion);
            if (CQsOn) {
                this.CQTestInstance.initializeQueryService();
                this.CQTestInstance.queryMap = this.queryMap = CQKnownKeysTest.testInstance.CQTestInstance.generateQueries(this.queryDepth);
                this.CQTestInstance.aRegion = this.aRegion;
                if (startCQsRunning) {
                    this.CQTestInstance.initializeCQs();
                }
            } else {
                Log.getLogWriter().info("Not creating CQs because CQUtilPrms.CQsOn is " + CQsOn);
            }
        }
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new CQKnownKeysTest();
            testInstance.initializeRegion("serverRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            CQKnownKeysTest.testInstance.isBridgeClient = false;
        }
        CQKnownKeysTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    protected void initializeRegion(String regDescriptName) {
        block2: {
            CacheHelper.createCache("cache1");
            String key = VmIDStr + RemoteTestModule.getMyVmid();
            String xmlFile = key + ".xml";
            try {
                CacheHelper.generateCacheXmlFile("cache1", regDescriptName, xmlFile);
            }
            catch (HydraRuntimeException e) {
                if (e.toString().indexOf("Cache XML file was already created") >= 0) break block2;
                throw new TestException(TestHelper.getStackTrace((Throwable)((Object)e)));
            }
        }
        this.aRegion = RegionHelper.createRegion(regDescriptName);
    }

    public void initializeInstance() {
        this.numNewKeys = TestConfig.tab().intAt(CQUtilPrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)CQUtilBB.getBB().getSharedMap().get(CQUtilBB.KeyIntervals);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        this.minTaskGranularityMS = -1L;
        if (this.minTaskGranularitySec != -1L) {
            this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        }
        this.queryDepth = TestConfig.tab().intAt(CQUtilPrms.queryDepth, 1);
        HydraVector bridgeNames = TestConfig.tab().vecAt(BridgePrms.names, null);
        this.isBridgeConfiguration = bridgeNames != null;
        CQsOn = TestConfig.tab().booleanAt(CQUtilPrms.CQsOn, true);
        this.CQTestInstance = new CQTest();
        this.CQTestInstance.initializeInstance();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
    }

    public static synchronized void StartTask_initialize() {
        int numKeys = TestConfig.tab().intAt(CQUtilPrms.numKeys);
        KeyIntervals intervals = new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006}, numKeys);
        CQUtilBB.getBB().getSharedMap().put(CQUtilBB.KeyIntervals, intervals);
        Log.getLogWriter().info("Created keyIntervals: " + intervals);
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        sc.setIfLarger(CQUtilBB.LASTKEY_INVALIDATE, intervals.getFirstKey(1001) - 1);
        sc.setIfLarger(CQUtilBB.LASTKEY_LOCAL_INVALIDATE, intervals.getFirstKey(1002) - 1);
        sc.setIfLarger(CQUtilBB.LASTKEY_DESTROY, intervals.getFirstKey(1003) - 1);
        sc.setIfLarger(CQUtilBB.LASTKEY_LOCAL_DESTROY, intervals.getFirstKey(1004) - 1);
        sc.setIfLarger(CQUtilBB.LASTKEY_UPDATE_EXISTING_KEY, intervals.getFirstKey(1005) - 1);
        sc.setIfLarger(CQUtilBB.LASTKEY_GET, intervals.getFirstKey(1006) - 1);
        CQUtilBB.getBB().printSharedMap();
        CQUtilBB.getBB().printSharedCounters();
    }

    public static void HydraTask_loadRegion() {
        testInstance.loadRegion();
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 8);
        availableOps.clear(2);
        availableOps.clear(4);
        testInstance.doOps(availableOps);
        if (availableOps.cardinality() == 0) {
            CQUtilBB.getBB().getSharedCounters().increment(CQUtilBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_waitForSilence() {
        SilenceListener.waitForSilence(30L, 1000L);
        CQGatherListener.waitForSilence(30L, 1000L);
    }

    public static void HydraTask_startCQsRunning() {
        testInstance.startCQsWithHistory();
        throw new StopSchedulingTaskOnClientOrder("CQs are running");
    }

    public static void HydraTask_verifyRegionContents() {
        CQUtilBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        testInstance.verifyRegionContents();
    }

    public static void HydraTask_verifyQueries() {
        if (CQsOn) {
            if (verifyQueryIterator == null) {
                CQKnownKeysTest.testInstance.CQTestInstance.regionSnapshot = new HashMap(CQKnownKeysTest.testInstance.aRegion);
                verifyQueryIterator = CQKnownKeysTest.testInstance.queryMap.keySet().iterator();
            }
            if (!verifyQueryIterator.hasNext()) {
                String aStr = "Done verifying " + verifyQueryCount + " queries";
                Log.getLogWriter().info(aStr);
                verifyQueryIterator = null;
                verifyQueryCount = 0;
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
        } else {
            String aStr = "Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn;
            Log.getLogWriter().info(aStr);
            throw new StopSchedulingTaskOnClientOrder(aStr);
        }
        String cqName = (String)verifyQueryIterator.next();
        Log.getLogWriter().info("Verifying query " + ++verifyQueryCount + " out of " + CQKnownKeysTest.testInstance.queryMap.size() + " with name " + cqName);
        CQKnownKeysTest.testInstance.CQTestInstance.verifyQuery(cqName);
    }

    public static void HydraTask_verifyQueriesCombine() {
        testInstance.verifyQueriesCombine();
    }

    public void loadRegion() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        do {
            long shouldAddCount;
            if ((shouldAddCount = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + sc.read(CQUtilBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate + ", region size is " + this.aRegion.size();
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            QueryObject value = this.getValueToAdd(key);
            value.extra = key;
            Log.getLogWriter().info("Creating with put, key " + key + ", value " + value.toStringFull());
            this.aRegion.put((Object)key, (Object)value);
            sc.increment(CQUtilBB.NUM_ORIGINAL_KEYS_CREATED);
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " out of " + numKeysToCreate + " entries into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        } while (this.minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public void doOps(BitSet availableOps) {
        boolean useTransactions = InitImagePrms.useTransactions();
        while (availableOps.cardinality() != 0) {
            int whichOp = this.getOp(availableOps, operations.length);
            boolean doneWithOps = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            switch (whichOp) {
                case 7: {
                    doneWithOps = this.addNewKey();
                    break;
                }
                case 1: {
                    doneWithOps = this.invalidate();
                    break;
                }
                case 3: {
                    doneWithOps = this.destroy();
                    break;
                }
                case 5: {
                    doneWithOps = this.updateExistingKey();
                    break;
                }
                case 6: {
                    doneWithOps = this.get();
                    break;
                }
                case 2: {
                    doneWithOps = this.localInvalidate();
                    break;
                }
                case 4: {
                    doneWithOps = this.localDestroy();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
            if (useTransactions) {
                try {
                    TxHelper.commit();
                }
                catch (CommitConflictException e) {
                    throw new TestException("Unexpected CommitConflictException " + TestHelper.getStackTrace(e));
                }
            }
            if (doneWithOps) {
                Log.getLogWriter().info("Done with operation " + whichOp);
                availableOps.clear(whichOp);
            }
            if (!this.sleepBetweenOps) continue;
            Log.getLogWriter().info("Sleeping between ops for 50 millis");
            MasterController.sleepForMs(50);
        }
    }

    protected boolean addNewKey() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long numNewKeysCreated = sc.incrementAndRead(CQUtilBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKey");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        this.checkContainsValueForKey(key, false, "before addNewKey");
        QueryObject value = new QueryObject(NameFactory.getCounterForName(key), 1, -1, this.queryDepth);
        value.extra = key;
        Log.getLogWriter().info("Adding new key " + key + " with put");
        this.aRegion.put((Object)key, (Object)value);
        Log.getLogWriter().info("Done adding new key " + key + " with put, num remaining: " + ((long)this.numNewKeys - numNewKeysCreated));
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected boolean updateExistingKey() {
        long nextKey = CQUtilBB.getBB().getSharedCounters().incrementAndRead(CQUtilBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        QueryObject existingValue = (QueryObject)this.aRegion.get((Object)key);
        if (existingValue == null) {
            throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
        }
        QueryObject newValue = existingValue.modifyWithNewInstance(5, 0, true);
        newValue.extra = key;
        if (existingValue.aPrimitiveLong < 0L) {
            throw new TestException("Trying to update a key which was already updated: " + existingValue.toStringFull());
        }
        Log.getLogWriter().info("Updating existing key " + key + " with value " + TestHelper.toString(newValue));
        this.aRegion.put((Object)key, (Object)newValue);
        Log.getLogWriter().info("Done updating existing key " + key + " with value " + TestHelper.toString(newValue) + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1005) - nextKey));
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    protected boolean localInvalidate() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long nextKey = sc.incrementAndRead(CQUtilBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Locally invalidating " + key);
        try {
            this.checkContainsValueForKey(key, true, "before localInvalidate");
            this.aRegion.localInvalidate((Object)key);
            Log.getLogWriter().info("Done locally invalidating " + key + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1002) - nextKey));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    protected boolean invalidate() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long nextKey = sc.incrementAndRead(CQUtilBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Invalidating " + key);
        this.checkContainsValueForKey(key, true, "before invalidate");
        try {
            this.aRegion.invalidate((Object)key);
            Log.getLogWriter().info("Done invalidating " + key + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1001) - nextKey));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    protected boolean localDestroy() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long nextKey = sc.incrementAndRead(CQUtilBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Locally destroying " + key);
        this.checkContainsValueForKey(key, true, "before localDestroy");
        try {
            this.aRegion.localDestroy((Object)key);
            Log.getLogWriter().info("Done locally destroying " + key + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1004) - nextKey));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    protected boolean destroy() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long nextKey = sc.incrementAndRead(CQUtilBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Destroying " + key);
        this.checkContainsValueForKey(key, true, "before destroy");
        try {
            this.aRegion.destroy((Object)key);
            Log.getLogWriter().info("Done Destroying " + key + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1003) - nextKey));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    protected boolean get() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long nextKey = sc.incrementAndRead(CQUtilBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Getting " + key);
        try {
            Object existingValue = this.aRegion.get((Object)key);
            Log.getLogWriter().info("Done getting " + key + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1006) - nextKey));
            if (existingValue == null) {
                throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    public void verifyRegionContents() {
        long LOG_INTERVAL_MILLIS = 10000L;
        if (verifyRegionContentsCompleted) {
            throw new TestException("Test configuration problem; already verified region contents, cannot call this task again without resetting batch variables");
        }
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        long size = this.aRegion.size();
        boolean first = true;
        int numKeysToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        while (verifyRegionContentsIndex < numKeysToCheck) {
            ++verifyRegionContentsIndex;
            if (first) {
                Log.getLogWriter().info("In verifyRegionContents, region has " + size + " keys; starting verify at verifyRegionContentsIndex " + verifyRegionContentsIndex + "; verifying key names with indexes through (and including) " + numKeysToCheck);
                first = false;
            }
            if (verifyRegionContentsIndex == 1 && (long)this.totalNumKeys != size) {
                String tmpStr = "Expected region size to be " + this.totalNumKeys + ", but it is size " + size;
                Log.getLogWriter().info(tmpStr);
                verifyRegionContentsErrStr.append(tmpStr + "\n");
            }
            String key = NameFactory.getObjectNameForCounter(verifyRegionContentsIndex);
            try {
                Object value;
                if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1000) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1000) || verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1006) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1006)) {
                    this.checkContainsKey(key, true, "key was untouched");
                    this.checkContainsValueForKey(key, true, "key was untouched");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1001) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1001)) {
                    this.checkContainsKey(key, true, "key was invalidated");
                    this.checkContainsValueForKey(key, false, "key was invalidated");
                } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1002) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1002)) {
                    this.checkContainsKey(key, true, "key was locally invalidated");
                    this.checkContainsValueForKey(key, true, "key was locally invalidated");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1003) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1003)) {
                    this.checkContainsKey(key, false, "key was destroyed");
                    this.checkContainsValueForKey(key, false, "key was destroyed");
                } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1004) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1004)) {
                    this.checkContainsKey(key, true, "key was locally destroyed");
                    this.checkContainsValueForKey(key, true, "key was locally destroyed");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (verifyRegionContentsIndex >= this.keyIntervals.getFirstKey(1005) && verifyRegionContentsIndex <= this.keyIntervals.getLastKey(1005)) {
                    this.checkContainsKey(key, true, "key was updated");
                    this.checkContainsValueForKey(key, true, "key was updated");
                    value = this.aRegion.get((Object)key);
                    this.checkUpdatedValue(key, value);
                } else if (verifyRegionContentsIndex > this.keyIntervals.getNumKeys()) {
                    this.checkContainsKey(key, true, "key was new");
                    this.checkContainsValueForKey(key, true, "key was new");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                }
            }
            catch (TestException e) {
                Log.getLogWriter().info(TestHelper.getStackTrace(e));
                verifyRegionContentsErrStr.append(e.getMessage() + "\n");
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                Log.getLogWriter().info("Verified key " + verifyRegionContentsIndex + " out of " + this.totalNumKeys);
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime < minTaskGranularityMS) continue;
            Log.getLogWriter().info("In HydraTask_verifyRegionContents, returning before completing verify because of task granularity (this task must be batched to complete); last key verified is " + key);
            return;
        }
        verifyRegionContentsCompleted = true;
        if (verifyRegionContentsErrStr.length() > 0) {
            throw new TestException(verifyRegionContentsErrStr.toString());
        }
        String aStr = "In HydraTask_verifyRegionContents, verified " + verifyRegionContentsIndex + " keys/values";
        Log.getLogWriter().info(aStr);
        throw new StopSchedulingTaskOnClientOrder(aStr);
    }

    protected void checkContainsKey(Object key, boolean expected, String logStr) {
        boolean containsKey = this.aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey + ": " + logStr);
        }
    }

    protected void checkContainsValueForKey(Object key, boolean expected, String logStr) {
        boolean containsValue = this.aRegion.containsValueForKey(key);
        if (containsValue != expected) {
            throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue + ": " + logStr);
        }
    }

    protected void checkValue(Object key, Object value) {
        if (value instanceof QueryObject) {
            QueryObject qo = (QueryObject)value;
            long keyCounter = NameFactory.getCounterForName(key);
            if (keyCounter != qo.aPrimitiveLong) {
                throw new TestException("Inconsistent QueryObject for key " + key + ":" + qo.toStringFull());
            }
        } else {
            throw new TestException("For key " + key + ", expected value " + TestHelper.toString(value) + " to be a QueryObject");
        }
    }

    protected void checkUpdatedValue(Object key, Object value) {
        if (value instanceof QueryObject) {
            QueryObject qo = (QueryObject)value;
            long keyCounter = NameFactory.getCounterForName(key);
            if (qo.aPrimitiveLong > 0L) {
                throw new TestException("Expected QueryObject for key " + key + " to contain negative values (indicating it was updated), but the value for this key is " + qo.toStringFull());
            }
        } else {
            throw new TestException("Expected value " + TestHelper.toString(value) + " to be a QueryObject");
        }
    }

    private void verifyQueriesCombine() {
        if (CQsOn) {
            CQKnownKeysTest.testInstance.CQTestInstance.regionSnapshot = new HashMap(CQKnownKeysTest.testInstance.aRegion);
            this.verifyQueryResultsCombine();
        } else {
            Log.getLogWriter().info("Skipping verification of queries because CQUtilPrms.CQsOn is " + CQsOn);
        }
    }

    protected void verifyQueryResultsCombine() {
        Log.getLogWriter().info("In verifyQueryResultsCombine");
        Iterator it = this.queryMap.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String tmpStr;
            String cqName = (String)it.next();
            Log.getLogWriter().info("Verifying query " + ++count + " out of " + this.queryMap.size() + " with name " + cqName);
            CqQuery cq = this.qService.getCq(cqName);
            String queryStr = cq.getQueryString();
            String readableQueryStr = CQTest.getReadableQueryString(queryStr);
            CQHistory history = CQHistoryListener.getCQHistory(cqName);
            Map combinedMap = history.getCombinedResults();
            ArrayList combinedList = new ArrayList(combinedMap.values());
            List expectedResults = this.CQTestInstance.getExpectedResults(queryStr);
            ArrayList missingInCombined = new ArrayList(expectedResults);
            ArrayList unexpectedInCombined = new ArrayList(combinedList);
            unexpectedInCombined.removeAll(expectedResults);
            missingInCombined.removeAll(combinedList);
            StringBuffer aStr = new StringBuffer();
            if (unexpectedInCombined.size() > 0) {
                tmpStr = this.getLocationString(unexpectedInCombined, expectedResults, history) + "\nFound the following " + unexpectedInCombined.size() + " unexpected elements in combined results for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(unexpectedInCombined);
                Log.getLogWriter().info(tmpStr);
                aStr.append(tmpStr);
            }
            if (missingInCombined.size() > 0) {
                tmpStr = this.getLocationString(missingInCombined, expectedResults, history) + "\nThe following " + missingInCombined.size() + " elements were missing from combined results for cq " + cqName + ", " + readableQueryStr + ": " + QueryObject.toStringFull(missingInCombined);
                Log.getLogWriter().info(tmpStr);
                aStr.append(tmpStr);
            }
            if (aStr.length() <= 0) continue;
            throw new TestException("Probably bug 38065: For cq " + cqName + ", " + readableQueryStr + "\n" + aStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + count + " queries");
    }

    private String getLocationString(List inconsistencies, List expected, CQHistory history) {
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < inconsistencies.size(); ++i) {
            QueryObject suspect = (QueryObject)inconsistencies.get(i);
            boolean found = false;
            for (Object key : this.aRegion.keySet()) {
                Region.Entry entry = this.aRegion.getEntry(key);
                QueryObject qo = (QueryObject)entry.getValue();
                if (qo == null || !qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in " + this.aRegion.getFullPath() + " at key " + key + "\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in " + this.aRegion.getFullPath() + "\n");
            }
            found = false;
            for (QueryObject qo : expected) {
                if (!qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in expected results\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in expected results\n");
            }
            SelectResults selResults = history.getSelectResults();
            found = false;
            for (QueryObject qo : selResults) {
                if (!qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in SelectResults\n");
            }
            if (!found) {
                aStr.append(suspect.toStringAbbreviated() + " was NOT found in SelectResults\n");
            }
            found = false;
            List eventList = history.getEvents();
            for (int j = 0; j < eventList.size(); ++j) {
                CqEvent event = (CqEvent)eventList.get(j);
                QueryObject qo = (QueryObject)event.getNewValue();
                if (qo == null || !qo.equals(suspect)) continue;
                found = true;
                aStr.append(qo.toStringAbbreviated() + " was found in event history as new value " + event + "\n");
            }
            if (found) continue;
            aStr.append(suspect.toStringAbbreviated() + " was NOT found in CqEvent history\n");
        }
        return aStr.toString();
    }

    protected int getOp(BitSet bs, int bsSize) {
        int randInt;
        while (!bs.get(randInt = TestConfig.tab().getRandGen().nextInt(1, bsSize))) {
        }
        return randInt;
    }

    protected QueryObject getValueToAdd(Object key) {
        return new QueryObject(NameFactory.getCounterForName(key), 1, -1, this.queryDepth);
    }

    protected Set getRegionKeySet(Region aRegion) {
        return aRegion.keys();
    }

    protected static void registerInterest(Region aRegion) {
        Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES");
        aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
    }

    protected void initializeQueryService() {
        try {
            String usingPool = TestConfig.tab().stringAt(CQUtilPrms.QueryServiceUsingPool, "false");
            boolean queryServiceUsingPool = Boolean.valueOf(usingPool);
            if (queryServiceUsingPool) {
                Pool pool = PoolHelper.createPool(CQUtilPrms.getQueryServicePoolName());
                this.qService = pool.getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Pool. PoolName: " + pool.getName());
            } else {
                this.qService = CacheHelper.getCache().getQueryService();
                Log.getLogWriter().info("Initializing QueryService using Cache.");
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void logNumOps() {
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        int totalOps = this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1000) + this.numNewKeys;
        long numOpsCompleted = sc.read(CQUtilBB.LASTKEY_INVALIDATE) - (long)this.keyIntervals.getFirstKey(1001) + sc.read(CQUtilBB.LASTKEY_DESTROY) - (long)this.keyIntervals.getFirstKey(1003) + sc.read(CQUtilBB.LASTKEY_UPDATE_EXISTING_KEY) - (long)this.keyIntervals.getFirstKey(1005) + sc.read(CQUtilBB.LASTKEY_GET) - (long)this.keyIntervals.getFirstKey(1006) + sc.read(CQUtilBB.NUM_NEW_KEYS_CREATED);
        Log.getLogWriter().info("Total ops is " + totalOps + ", current number of ops completed is " + numOpsCompleted);
    }

    private void startCQsWithHistory() {
        this.initializeQueryService();
        CqAttributesFactory cqFac = new CqAttributesFactory();
        cqFac.addCqListener((CqListener)new CQHistoryListener());
        cqFac.addCqListener((CqListener)new CQGatherListener());
        CqAttributes cqAttr = cqFac.create();
        for (String queryName : this.queryMap.keySet()) {
            String query = (String)this.queryMap.get(queryName);
            try {
                CqQuery cq = this.qService.newCq(queryName, query, cqAttr);
                CQHistory history = new CQHistory(cq.getName());
                CQHistoryListener.recordHistory(history);
                Log.getLogWriter().info("Creating CQ with name " + queryName + ": " + query + ", cq attributes: " + cqAttr);
                Log.getLogWriter().info("Calling executeWithInitialResults on " + cq);
                CqResults rs = cq.executeWithInitialResults();
                SelectResults sr = CQUtil.getSelectResults(rs);
                if (sr == null) {
                    throw new TestException("For cq " + cq + " with name " + cq.getName() + " executeWithInitialResults returned " + sr);
                }
                Log.getLogWriter().info("Done calling executeWithInitializResults on " + cq + " with name " + queryName + ", select results size is " + sr.size());
                history.setSelectResults(sr);
                this.logNumOps();
                List srList = sr.asList();
                StringBuffer aStr = new StringBuffer();
                aStr.append("SelectResults returned from " + queryName + " is\n");
                for (int i = 0; i < srList.size(); ++i) {
                    aStr.append(srList.get(i) + "\n");
                }
                Log.getLogWriter().info(aStr.toString());
            }
            catch (CqExistsException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (RegionNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CqException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    static {
        CQsOn = true;
        verifyRegionContentsIndex = 0;
        verifyRegionContentsErrStr = new StringBuffer();
        verifyRegionContentsCompleted = false;
        verifyQueryIterator = null;
        verifyQueryCount = 0;
        operations = new int[]{1, 2, 3, 4, 5, 6, 7};
    }
}

