/*
 * Decompiled with CFR 0.152.
 */
package container.app.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;

public final class IOUtils {
    public static InputStream open(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format("Failed to open an input stream to resource ({0})!", url), e);
        }
    }

    public static void close(Closeable obj) {
        IOUtils.close(obj, true);
    }

    public static void close(Closeable obj, boolean silent) {
        try {
            obj.close();
        }
        catch (IOException e) {
            if (silent) {
                e.printStackTrace();
            }
            throw new RuntimeException(MessageFormat.format("Failed to close resource ({0})!", obj), e);
        }
    }
}

