/*
 * Decompiled with CFR 0.152.
 */
package container.app.phonedirectory.service;

import container.app.lang.Visitable;
import container.app.lang.Visitor;
import container.app.phonedirectory.dao.PhoneDirectoryDao;
import container.app.phonedirectory.domain.Address;
import container.app.phonedirectory.domain.Person;
import container.app.phonedirectory.domain.PhoneDirectoryEntry;
import container.app.phonedirectory.domain.PhoneNumber;
import container.app.phonedirectory.service.PhoneDirectoryService;
import container.app.remoting.rmi.service.AbstractPingableService;
import container.app.util.Assert;
import container.app.util.ObjectUtils;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EventObject;

public abstract class AbstractPhoneDirectoryService
extends AbstractPingableService
implements PhoneDirectoryService,
Visitable {
    private PhoneDirectoryDao dao;

    protected PhoneDirectoryDao getDao() {
        Assert.state(this.dao != null, "The Phone Directory DAO for Phone Directory Service ({0}) was not properly initialized!", this.getClass().getName());
        return this.dao;
    }

    public final void setDao(PhoneDirectoryDao dao) {
        Assert.notNull(dao, "The Phone Directory DAO for Phone Directory Service ({0}) cannot be null!", this.getClass().getName());
        this.dao = dao;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getDao().accept(visitor);
    }

    @Override
    public void add(Person person, Address address) throws RemoteException {
        this.addInternal(new PhoneDirectoryEntry(person, address));
    }

    @Override
    public void add(Person person, PhoneNumber phoneNumber) throws RemoteException {
        this.addInternal(new PhoneDirectoryEntry(person, phoneNumber));
    }

    @Override
    public void add(Person person, Address address, PhoneNumber phoneNumber) throws RemoteException {
        this.addInternal(new PhoneDirectoryEntry(person, address, phoneNumber));
    }

    protected abstract void addInternal(PhoneDirectoryEntry var1);

    @Override
    public <E extends EventObject> E consumePersistentEvent() throws RemoteException {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public Address getAddress(Person person) throws RemoteException {
        PhoneDirectoryEntry entry = this.getEntry(person);
        return entry != null ? entry.getAddress() : null;
    }

    @Override
    public PhoneDirectoryEntry getEntry(Person person) throws RemoteException {
        for (PhoneDirectoryEntry entry : this.getEntries()) {
            if (!ObjectUtils.equals(person, entry.getPerson())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Collection<PhoneDirectoryEntry> getEntries() throws RemoteException {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public PhoneNumber getPhoneNumber(Person person) throws RemoteException {
        PhoneDirectoryEntry entry = this.getEntry(person);
        return entry != null ? entry.getPhoneNumber() : null;
    }

    @Override
    public void remove(Person person) throws RemoteException {
        throw new UnsupportedOperationException("Not Implemented!");
    }
}

