/*
 * Decompiled with CFR 0.152.
 */
package connPool;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import connPool.ConnPoolBB;
import connPool.ConnPoolPrms;
import hydra.CacheHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.TreeMap;
import util.TestException;

public class ConnPoolUtil {
    protected static final String currentClientConnKey = "CurrentClientConnections_";
    protected static final String currentQueueConnKey = "CurrentQueueConnections_";
    protected static final String queueLoadKey = "QueueLoadKey_";
    protected static final String connectionLoadKey = "ConnectionLoadKey_";

    public static void HydraTask_prepareForValidation() {
        Cache aCache;
        int sleepSec = TestConfig.tasktab().intAt(ConnPoolPrms.sleepSec, TestConfig.tab().intAt(ConnPoolPrms.sleepSec, 0));
        if (sleepSec > 0) {
            Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds to allow connections time to balance");
            MasterController.sleepForMs(sleepSec * 1000);
            Log.getLogWriter().info("Done sleeping for " + sleepSec + " seconds to allow connections time to balance");
        }
        if ((aCache = CacheHelper.getCache()) == null) {
            throw new TestException("Cache is null");
        }
        if (aCache.isServer()) {
            Log.getLogWriter().info("isServer is " + aCache.isServer());
            BridgeServerImpl server = (BridgeServerImpl)aCache.getCacheServers().get(0);
            int currClientConnections = server.getAcceptor().getStats().getCurrentClientConnections();
            Log.getLogWriter().info("Current number of client connections: " + currClientConnections);
            String key = currentClientConnKey + RemoteTestModule.getMyVmid();
            ConnPoolBB.getBB().getSharedMap().put(key, new Integer(currClientConnections));
            int currQueueConnections = server.getAcceptor().getStats().getCurrentQueueConnections();
            Log.getLogWriter().info("Current number of queue connections: " + currQueueConnections);
            key = currentQueueConnKey + RemoteTestModule.getMyVmid();
            ConnPoolBB.getBB().getSharedMap().put(key, new Integer(currQueueConnections));
            double queueLoad = server.getAcceptor().getStats().getQueueLoad();
            Log.getLogWriter().info("Queue load: " + queueLoad);
            key = queueLoadKey + RemoteTestModule.getMyVmid();
            ConnPoolBB.getBB().getSharedMap().put(key, new Double(queueLoad));
            double connectionLoad = server.getAcceptor().getStats().getConnectionLoad();
            Log.getLogWriter().info("Connection load: " + connectionLoad);
            key = connectionLoadKey + RemoteTestModule.getMyVmid();
            ConnPoolBB.getBB().getSharedMap().put(key, new Double(connectionLoad));
        } else {
            Log.getLogWriter().info("Not getting server stats, this is not a server");
        }
    }

    public static void HydraTask_validate() {
        double diffConnectionLoad;
        double diff;
        Cache aCache = CacheHelper.getCache();
        BridgeServerImpl server = (BridgeServerImpl)aCache.getCacheServers().get(0);
        double loadPerConnection = server.getAcceptor().getStats().getLoadPerConnection();
        StringBuffer currentConnStr = new StringBuffer();
        StringBuffer currentQueueStr = new StringBuffer();
        StringBuffer queueLoadStr = new StringBuffer();
        StringBuffer connectionLoadStr = new StringBuffer();
        connectionLoadStr.append("   loadPerConnection is " + loadPerConnection + "\n");
        int minCurrentConn = Integer.MAX_VALUE;
        int maxCurrentConn = 0;
        int minCurrentQueue = Integer.MAX_VALUE;
        int maxCurrentQueue = 0;
        double minQueueLoad = 2.147483647E9;
        double maxQueueLoad = 0.0;
        double minConnectionLoad = Double.MAX_VALUE;
        double maxConnectionLoad = 0.0;
        TreeMap aMap = new TreeMap(ConnPoolBB.getBB().getSharedMap().getMap());
        for (String key : aMap.keySet()) {
            int vmid;
            int vmid2;
            if (key.startsWith(currentClientConnKey)) {
                int value = (Integer)aMap.get(key);
                vmid2 = Integer.valueOf(key.substring(currentClientConnKey.length(), key.length()));
                currentConnStr.append("   for vmid " + vmid2 + ", currentClientConnections is " + value + "\n");
                maxCurrentConn = Math.max(value, maxCurrentConn);
                minCurrentConn = Math.min(value, minCurrentConn);
                continue;
            }
            if (key.startsWith(currentQueueConnKey)) {
                int value = (Integer)aMap.get(key);
                vmid2 = Integer.valueOf(key.substring(currentQueueConnKey.length(), key.length()));
                currentQueueStr.append("   for vmid " + vmid2 + ", currentQueueConnections is " + value + "\n");
                maxCurrentQueue = Math.max(value, maxCurrentQueue);
                minCurrentQueue = Math.min(value, minCurrentQueue);
                continue;
            }
            if (key.startsWith(queueLoadKey)) {
                double value = (Double)aMap.get(key);
                vmid = Integer.valueOf(key.substring(queueLoadKey.length(), key.length()));
                queueLoadStr.append("   for vmid " + vmid + ", queueLoad is " + value + "\n");
                maxQueueLoad = Math.max(value, maxQueueLoad);
                minQueueLoad = Math.min(value, minQueueLoad);
                continue;
            }
            if (!key.startsWith(connectionLoadKey)) continue;
            double value = (Double)aMap.get(key);
            vmid = Integer.valueOf(key.substring(connectionLoadKey.length(), key.length()));
            connectionLoadStr.append("   for vmid " + vmid + ", connectionLoad is " + value + "\n");
            maxConnectionLoad = Math.max(value, maxConnectionLoad);
            minConnectionLoad = Math.min(value, minConnectionLoad);
        }
        String stateStr = currentConnStr + "\n" + currentQueueStr + "\n" + queueLoadStr + "\n" + connectionLoadStr;
        StringBuffer errStr = new StringBuffer();
        int diffConn = Math.abs(minCurrentConn - maxCurrentConn);
        if (diffConn > 1) {
            errStr.append("Unbalanced currentClientConnections");
        }
        if (!((diff = (diffConnectionLoad = Math.abs(minConnectionLoad - maxConnectionLoad)) / loadPerConnection) > 0.9 && diff < 1.1 || !(diffConnectionLoad > loadPerConnection))) {
            if (errStr.length() > 0) {
                errStr.append(" and ");
            }
            errStr.append("Unbalanced connectionLoad; difference between min and max connectionLoad is " + diff + " times the loadPerConnection " + loadPerConnection);
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString() + "\n" + stateStr);
        }
        Log.getLogWriter().info("Validation passed.\n" + stateStr);
    }
}

