/*
 * Decompiled with CFR 0.152.
 */
package compression;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import compression.CompressionBB;
import compression.CompressionPrms;
import compression.CompressionTest;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import objects.Order;
import util.TestException;
import util.TestHelperPrms;
import util.ValueHolder;

public class SerialCompressionTest
extends CompressionTest {
    private static final String keyList_Key = "keyList_Key";
    private static final String parentRegionName = "parent";
    private static final String[] serverRegionNames = new String[]{"repServer", "perRepServer", "partServer0", "partServer1", "perPartServer0", "perPartServer1"};
    private static final String[] emptyRegionNames = new String[]{"repEmpty", "perRepEmpty", "partAccessor0", "partAccessor1", "perPartAccessor0", "perPartAccessor1"};
    private static final String[] compressedRegionNames = new String[]{"repComp", "perRepComp", "partComp0", "partComp1", "perPartComp0", "perPartComp1"};
    private static final String[] unCompressedRegionNames = new String[]{"repUnComp", "perRepUnComp", "partUnComp0", "partUnComp1", "perPartUnComp0", "perPartUnComp1"};
    private int nbrThreadsInClients;
    private SharedMap sharedMap;
    private ArrayList<String> keyList;

    public static synchronized void HydraTask_initialize_Server() {
        if (testInstance == null) {
            testInstance = new SerialCompressionTest();
            testInstance.initialize();
            SerialCompressionTest.InitializeCache();
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
            SerialCompressionTest.InitializeRegions(serverRegionNames);
        }
    }

    public static synchronized void HydraTask_initialize_Client() {
        if (testInstance == null) {
            testInstance = new SerialCompressionTest();
            testInstance.initialize();
            SerialCompressionTest.InitializeCache();
            SerialCompressionTest.InitializeRegions(SerialCompressionTest.DeterminRegionNames());
            for (Region aRegion : SerialCompressionTest.testInstance.theRegions) {
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            }
        }
    }

    public static synchronized void HydraTask_initialize_Peer() {
        if (testInstance == null) {
            testInstance = new SerialCompressionTest();
            testInstance.initialize();
            SerialCompressionTest.InitializeCache();
            SerialCompressionTest.InitializeRegions(SerialCompressionTest.DeterminRegionNames());
        }
    }

    public static synchronized void HydraTask_initialize_Peer_Sub() {
        if (testInstance == null) {
            testInstance = new SerialCompressionTest();
            testInstance.initialize();
            SerialCompressionTest.InitializeCache();
            SerialCompressionTest.InitializeSubRegions();
        }
    }

    public static void HydraTask_doSerialRndRbnOps() {
        Log.getLogWriter().info("SerialCompressionTest.HydraTask_doSerialRndRbnOps.");
        ((SerialCompressionTest)testInstance).doSerialRndRbnOps();
    }

    public static synchronized void HydraTask_CompressionStats() {
        ((SerialCompressionTest)testInstance).compressionStats();
    }

    private static synchronized void InitializeCache() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
        }
    }

    private static synchronized void InitializeRegions(String[] regionNames) {
        for (String regionName : regionNames) {
            Region aRegion = RegionHelper.createRegion(regionName);
            SerialCompressionTest.testInstance.theRegions.add(aRegion);
            Log.getLogWriter().info("SerialCompressionTest.InitializeRegions regionName=" + aRegion.getName() + " Compressor=" + aRegion.getAttributes().getCompressor().getClass().getName());
        }
        testInstance.logRegionHierarchy();
    }

    private static synchronized void InitializeSubRegions() {
        String[] subRegionNames;
        Region parentRegion = RegionHelper.createRegion(parentRegionName);
        for (String subRegionName : subRegionNames = SerialCompressionTest.DeterminRegionNames()) {
            AttributesFactory attributesFactory = RegionHelper.getAttributesFactory(subRegionName);
            RegionAttributes regionAttributes = attributesFactory.createRegionAttributes();
            RecoveryTestVersionHelper.createDiskStore(regionAttributes);
            Region subRegion = parentRegion.createSubregion(subRegionName, regionAttributes);
            SerialCompressionTest.testInstance.theRegions.add(subRegion);
        }
        testInstance.logRegionHierarchy();
    }

    private static synchronized String[] DeterminRegionNames() {
        String[] regionNames = compressedRegionNames;
        if (SerialCompressionTest.ShouldBeUncommpressed()) {
            regionNames = unCompressedRegionNames;
        } else if (SerialCompressionTest.ShouldBeEmpty()) {
            regionNames = emptyRegionNames;
        }
        return regionNames;
    }

    private static synchronized boolean ShouldBeUncommpressed() {
        int desiredNbrOfCompressedRegions;
        boolean shouldBeUncommpressed = false;
        long cntOfCompressedRegions = CompressionBB.getBB().getSharedCounters().read(CompressionBB.CntOfCompressedRegions);
        if (cntOfCompressedRegions < (long)(desiredNbrOfCompressedRegions = CompressionPrms.getNbrOfCompressedRegions())) {
            shouldBeUncommpressed = true;
            CompressionBB.getBB().getSharedCounters().increment(CompressionBB.CntOfCompressedRegions);
        }
        return shouldBeUncommpressed;
    }

    private static synchronized boolean ShouldBeEmpty() {
        int desiredNbrOfEmptyAccessors;
        boolean shouldBeEmpty = false;
        long cntOfEmptyAccessors = CompressionBB.getBB().getSharedCounters().read(CompressionBB.CntOfEmptyAccessors);
        if (cntOfEmptyAccessors < (long)(desiredNbrOfEmptyAccessors = CompressionPrms.getNbrOfEmptyAccessors())) {
            shouldBeEmpty = true;
            CompressionBB.getBB().getSharedCounters().increment(CompressionBB.CntOfEmptyAccessors);
        }
        return shouldBeEmpty;
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    private void doSerialRndRbnOps() {
        Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps.");
        this.nbrThreadsInClients = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        int addPosition = 1;
        int updatePosition = 3;
        int resetPosition = this.nbrThreadsInClients;
        int maxNbrOfRounds = this.nbrThreadsInClients;
        long roundPosition = CompressionBB.getBB().getSharedCounters().incrementAndRead(CompressionBB.RoundPosition);
        Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps roundPosition=" + roundPosition);
        if (roundPosition == (long)resetPosition) {
            Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps we are in the RESET position in the round!");
            this.verifyOps();
            CompressionBB.getBB().getSharedCounters().zero(CompressionBB.RoundPosition);
            roundPosition = CompressionBB.getBB().getSharedCounters().incrementAndRead(CompressionBB.RoundPosition);
        }
        if (roundPosition == (long)addPosition) {
            long roundCounter = CompressionBB.getBB().getSharedCounters().incrementAndRead(CompressionBB.RoundCounter);
            Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps we are in the ADD position in the round! roundCounter=" + roundCounter);
            if (roundCounter > (long)maxNbrOfRounds) {
                Log.getLogWriter().info("MDP9-Success! We are stopping the test!");
                throw new StopSchedulingOrder("Stopping client.");
            }
            String keyPrefix = new Long(roundCounter).toString();
            this.doAddOps(keyPrefix);
        } else if (roundPosition == (long)updatePosition) {
            Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps we are in the UPDATE position in the round!");
            this.doUpdateOps();
            this.verifyOps();
        } else {
            Log.getLogWriter().info("SerialCompressionTest.doSerialRndRbnOps we must be in a VERIFY position in the round!");
            this.verifyOps();
        }
    }

    private void doAddOps(String keyPrefix) {
        Log.getLogWriter().info("MDP-SerialCompressionTest.doAddOps round " + keyPrefix + " of " + this.nbrThreadsInClients);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        this.sharedMap = CompressionBB.getBB().getSharedMap();
        this.keyList = (ArrayList)this.sharedMap.get(keyList_Key);
        if (this.keyList == null) {
            this.keyList = new ArrayList();
        }
        int addCntr = 0;
        do {
            this.storeOps(keyPrefix, ++addCntr, new ValueHolder(this.randomValues));
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        Order order = new Order();
        order.init(1);
        this.storeOps(keyPrefix, ++addCntr, order);
        this.sharedMap.put(keyList_Key, this.keyList);
        Log.getLogWriter().info("MDP-SerialCompressionTest.doAddOps addCntr=" + addCntr);
        CompressionBB.getBB().getSharedCounters().add(CompressionBB.ObjectsAddedCnt, addCntr);
    }

    private void doUpdateOps() {
        Log.getLogWriter().info("MDP-SerialCompressionTest.doUpdateOps.");
        this.sharedMap = CompressionBB.getBB().getSharedMap();
        this.keyList = (ArrayList)this.sharedMap.get(keyList_Key);
        if (this.keyList == null) {
            this.keyList = new ArrayList();
        }
        for (String key : this.keyList) {
            Serializable value;
            if (this.sharedMap.get(key) instanceof ValueHolder) {
                value = new ValueHolder(this.randomValues);
            } else {
                Order order = new Order();
                order.init(2);
                value = order;
            }
            this.storeOps(key, value);
        }
    }

    private void storeOps(String keyPrefix, int keySuffix, Object value) {
        String addKey = keyPrefix + "-" + keySuffix;
        this.keyList.add(addKey);
        this.storeOps(addKey, value);
    }

    private void storeOps(String key, Object value) {
        if (key.equals("1-1")) {
            Log.getLogWriter().info("MDP-SerialCompressionTest.storeOps key=" + key + " value=" + value);
        }
        this.sharedMap.put(key, value);
        for (Region aRegion : this.theRegions) {
            aRegion.put((Object)key, value);
        }
    }

    private void verifyOps() {
        for (Region aRegion : this.theRegions) {
            this.verifyOps(aRegion);
        }
    }

    private void verifyOps(Region aRegion) {
        Log.getLogWriter().info("SerialCompressionTest.verifyOps aRegion.getName()=" + aRegion.getName());
        this.sharedMap = CompressionBB.getBB().getSharedMap();
        this.keyList = (ArrayList)this.sharedMap.get(keyList_Key);
        if (this.keyList == null) {
            throw new TestException("MDP-The keyList should NOT be NULL!");
        }
        Log.getLogWriter().info("SerialCompressionTest.verifyOps keyList.size()=" + this.keyList.size());
        int verifyCntr = 0;
        for (String key : this.keyList) {
            Object bbValue;
            ++verifyCntr;
            Object regionValue = aRegion.get((Object)key);
            if (regionValue instanceof ValueHolder) {
                regionValue = ((ValueHolder)regionValue).getMyValue();
            }
            if ((bbValue = this.sharedMap.get(key)) instanceof ValueHolder) {
                bbValue = ((ValueHolder)bbValue).getMyValue();
            }
            if (regionValue.getClass().isArray() && bbValue.getClass().isArray()) {
                this.verifyArray(key, regionValue, bbValue);
                continue;
            }
            if (regionValue instanceof Map && bbValue instanceof Map) {
                this.verifyMap(key, regionValue, bbValue);
                continue;
            }
            if (regionValue instanceof List && bbValue instanceof List || regionValue instanceof Set && bbValue instanceof Set) {
                this.verifyListOrSet(key, regionValue, bbValue);
                continue;
            }
            this.verifyValues(key, regionValue, bbValue);
        }
        Log.getLogWriter().info("MDP-SerialCompressionTest.verifyOps verifyCntr=" + verifyCntr);
        long addedCnt = CompressionBB.getBB().getSharedCounters().read(CompressionBB.ObjectsAddedCnt);
        if ((long)verifyCntr < addedCnt) {
            throw new TestException("MDP9-Fail! The number of objects verified does not equal the number of objects added to the region.");
        }
    }

    private void verifyMap(String key, Object valueFromRegion, Object valueFromBB) {
        Map regionValueMap = (Map)valueFromRegion;
        Map bbValueMap = (Map)valueFromBB;
        for (Object aMapKey : regionValueMap.keySet()) {
            Object regionMapValue = regionValueMap.get(aMapKey);
            Object bbMapValue = bbValueMap.get(aMapKey);
            if (regionMapValue.getClass().isArray() && bbMapValue.getClass().isArray()) {
                this.verifyArray(key, regionMapValue, bbMapValue);
                continue;
            }
            this.verifyValues(key, regionMapValue, bbMapValue);
        }
    }

    private void verifyListOrSet(String key, Object valueFromRegion, Object valueFromBB) {
        Object[] regionValues = null;
        Object[] bbValues = null;
        if (valueFromRegion instanceof List && valueFromBB instanceof List) {
            regionValues = ((List)valueFromRegion).toArray();
            bbValues = ((List)valueFromBB).toArray();
        } else if (valueFromRegion instanceof Set && valueFromBB instanceof Set) {
            regionValues = ((Set)valueFromRegion).toArray();
            bbValues = ((Set)valueFromBB).toArray();
        }
        if (regionValues != null && bbValues != null) {
            for (int i = 0; i < regionValues.length; ++i) {
                Object regionValue = regionValues[i];
                Object bbValue = bbValues[i];
                if (regionValue.getClass().isArray() && bbValue.getClass().isArray()) {
                    this.verifyArray(key, regionValue, bbValue);
                    continue;
                }
                this.verifyValues(key, regionValue, bbValue);
            }
        }
    }

    private void verifyArray(String key, Object valueFromRegion, Object valueFromBB) {
        Comparable<Boolean> regionArrayValue = null;
        Comparable<Boolean> bbArrayValue = null;
        String regionClassType = valueFromRegion.getClass().getSimpleName();
        int arrayLength = Array.getLength(valueFromRegion);
        for (int i = 0; i < arrayLength; ++i) {
            if (regionClassType.contains("boolean")) {
                regionArrayValue = Array.getBoolean(valueFromRegion, i);
                bbArrayValue = Array.getBoolean(valueFromBB, i);
            } else if (regionClassType.contains("byte")) {
                regionArrayValue = Array.getByte(valueFromRegion, i);
                bbArrayValue = Array.getByte(valueFromBB, i);
            } else if (regionClassType.contains("char")) {
                regionArrayValue = Character.valueOf(Array.getChar(valueFromRegion, i));
                bbArrayValue = Character.valueOf(Array.getChar(valueFromBB, i));
            } else if (regionClassType.contains("double")) {
                regionArrayValue = Array.getDouble(valueFromRegion, i);
                bbArrayValue = Array.getDouble(valueFromBB, i);
            } else if (regionClassType.contains("float")) {
                regionArrayValue = Float.valueOf(Array.getFloat(valueFromRegion, i));
                bbArrayValue = Float.valueOf(Array.getFloat(valueFromBB, i));
            } else if (regionClassType.contains("int")) {
                regionArrayValue = Array.getInt(valueFromRegion, i);
                bbArrayValue = Array.getInt(valueFromBB, i);
            } else if (regionClassType.contains("long")) {
                regionArrayValue = Array.getLong(valueFromRegion, i);
                bbArrayValue = Array.getLong(valueFromBB, i);
            } else if (regionClassType.contains("short")) {
                regionArrayValue = Array.getShort(valueFromRegion, i);
                bbArrayValue = Array.getShort(valueFromBB, i);
            } else {
                Log.getLogWriter().info("MDP-SerialCompressionTest.verifyArray regionClassType=" + regionClassType + " arrayLength=" + arrayLength);
            }
            this.verifyValues(key, regionArrayValue, bbArrayValue);
        }
    }

    private void verifyValues(String key, Object valueFromRegion, Object valueFromBB) {
        if (valueFromRegion instanceof StringBuffer && valueFromBB instanceof StringBuffer || valueFromRegion instanceof Order && valueFromBB instanceof Order) {
            valueFromRegion = valueFromRegion.toString();
            valueFromBB = valueFromBB.toString();
        }
        if (!valueFromRegion.equals(valueFromBB)) {
            throw new TestException("MDP9-Fail! The values are not equal! key=" + key + " valueFromRegion=" + valueFromRegion + " valueFromBB=" + valueFromBB);
        }
    }

    private void compressionStats() {
        StringBuilder errorString = new StringBuilder();
        for (Region aRegion : this.theRegions) {
            String regionName = aRegion.getName();
            Log.getLogWriter().info("MDP-S-SerialCompressionTest.stats regionName = " + regionName);
            RegionAttributes attributes = aRegion.getAttributes();
            Compressor compressor = attributes.getCompressor();
            Log.getLogWriter().info("MDP-S-  Compressor=" + (compressor == null ? null : compressor.getClass().getName()));
            CachePerfStats regionPerfStats = ((LocalRegion)aRegion).getRegionPerfStats();
            if (regionPerfStats == null) continue;
            long totalPreCompressedBytes = regionPerfStats.getTotalPreCompressedBytes();
            long totalCompressionTime = regionPerfStats.getTotalCompressionTime();
            long totalCompressions = regionPerfStats.getTotalCompressions();
            long totalPostCompressedBytes = regionPerfStats.getTotalPostCompressedBytes();
            long totalDecompressionTime = regionPerfStats.getTotalDecompressionTime();
            long totalDecompressions = regionPerfStats.getTotalDecompressions();
            Log.getLogWriter().info("\n        totalPreCompressedBytes   = " + totalPreCompressedBytes + "\n        totalCompressionTime   = " + (double)totalCompressionTime / 1.0E9 + " (sec)\nMDP-S-  totalCompressions      = " + totalCompressions + "\n        totalPostCompressedBytes = " + totalPostCompressedBytes + "\n        totalDecompressionTime = " + (double)totalDecompressionTime / 1.0E9 + " (sec)\n        totalDecompressions    = " + totalDecompressions);
            DataPolicy dataPolicy = attributes.getDataPolicy();
            Log.getLogWriter().info("MDP-S-SerialCompressionTest.stats dataPolicy=" + dataPolicy);
            if (dataPolicy.equals(DataPolicy.EMPTY) || compressor == null) {
                if (totalCompressions != 0L) {
                    errorString.append("The total number of compressions for the region '" + regionName + "' should be zero.\n");
                }
                if (totalPreCompressedBytes != 0L) {
                    errorString.append("The total number of pre-compressed bytes for the region '" + regionName + "' should be zero.\n");
                }
                if (totalCompressionTime != 0L) {
                    errorString.append("The total compression time for the region '" + regionName + "' should be zero.\n");
                }
                if (totalDecompressions != 0L) {
                    errorString.append("The total number of decompressions for the region '" + regionName + "' should be zero.\n");
                }
                if (totalPostCompressedBytes != 0L) {
                    errorString.append("The total number of post-decompressed bytes for the region '" + regionName + "' should be zero.\n");
                }
                if (totalDecompressionTime == 0L) continue;
                errorString.append("The total decompression time for the region '" + regionName + "' should be zero.\n");
                continue;
            }
            if (totalCompressions <= 0L) {
                errorString.append("The total number of compressions for the region '" + regionName + "' should be greater than zero.\n");
            }
            if (totalPreCompressedBytes <= 0L) {
                errorString.append("The total number of pre-compressed bytes for the region '" + regionName + "' should be greater than zero.\n");
            }
            if (totalCompressionTime <= 0L) {
                errorString.append("The total compression time for the region '" + regionName + "' should be greater than zero.\n");
            }
            if (totalDecompressions <= 0L) {
                errorString.append("The total number of decompressions for the region '" + regionName + "' should be greater than zero.\n");
            }
            if (totalPostCompressedBytes <= 0L) {
                errorString.append("The total number of post-decompressed bytes for the region '" + regionName + "' should be greater than zero.\n");
            }
            if (totalDecompressionTime > 0L) continue;
            errorString.append("The total decompression time for the region '" + regionName + "' should be greater than zero.\n");
        }
        if (errorString.length() > 0) {
            throw new TestException("MDP9-Fail! There is a problem with the compression statistics.\n" + errorString.toString());
        }
    }
}

