/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.sequence;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;

public class TimeAxis
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 100;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public int orientation;
    private long minTime;
    private long maxTime;

    public TimeAxis(int orientation, long minTime, long maxTime) {
        this.orientation = orientation;
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(100, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle drawHere = g.getClipBounds();
        int height = this.getHeight();
        double scale = (this.maxTime - this.minTime) / (long)height;
        int increment = 30;
        g.setColor(new Color(230, 163, 4));
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.black);
        int end = 0;
        int start = 0;
        int tickLength = 0;
        String text = null;
        if (this.orientation == 0) {
            start = drawHere.x / increment * increment;
            end = ((drawHere.x + drawHere.width) / increment + 1) * increment;
        } else {
            start = drawHere.y / increment * increment;
            end = ((drawHere.y + drawHere.height) / increment + 1) * increment;
        }
        if (start == 0) {
            text = DATE_FORMAT.format(new Date(this.minTime));
            tickLength = 10;
            if (this.orientation == 0) {
                g.drawLine(0, 99, 0, 100 - tickLength - 1);
                g.drawString(text, 2, 21);
            } else {
                g.drawLine(99, 0, 100 - tickLength - 1, 0);
                g.drawString(text, 9, 10);
            }
            text = null;
            start = increment;
        }
        for (int i = start; i < end; i += increment) {
            tickLength = 10;
            text = DATE_FORMAT.format(new Date((long)((double)this.minTime + (double)i * scale)));
            if (tickLength == 0) continue;
            if (this.orientation == 0) {
                g.drawLine(i, 99, i, 100 - tickLength - 1);
                if (text == null) continue;
                g.drawString(text, i - 3, 21);
                continue;
            }
            g.drawLine(99, i, 100 - tickLength - 1, i);
            if (text == null) continue;
            g.drawString(text, 9, i + 3);
        }
    }
}

