/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.persistence.logging;

import com.gemstone.persistence.logging.Handler;
import com.gemstone.persistence.logging.Level;
import com.gemstone.persistence.logging.LogRecord;
import com.gemstone.persistence.logging.SimpleFormatter;
import com.gemstone.persistence.logging.StreamHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Logger {
    private static boolean DEBUG = Boolean.getBoolean("Logging.DEBUG");
    private static Map loggers = new HashMap();
    private String name;
    private Level level;
    private Set handlers;

    protected Logger(String name) {
        this.name = name;
        String prop = System.getProperty(name + ".LEVEL");
        this.level = prop != null ? Level.parse(prop) : Level.INFO;
        this.handlers = new HashSet();
        this.handlers.add(new StreamHandler(System.err, new SimpleFormatter()));
    }

    public static synchronized Logger getLogger(String name) {
        Logger logger = (Logger)loggers.get(name);
        if (logger == null) {
            logger = new Logger(name);
            loggers.put(name, logger);
        }
        return logger;
    }

    public synchronized void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public synchronized Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[0]);
    }

    public synchronized void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
    }

    public synchronized boolean isLoggable(Level msgLevel) {
        if (msgLevel.equals(Level.ALL)) {
            return true;
        }
        return msgLevel.intValue() >= this.level.intValue();
    }

    public synchronized void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        if (DEBUG) {
            System.out.println("Logging " + record);
        }
        for (Handler handler : this.handlers) {
            handler.publish(record);
            handler.flush();
        }
    }

    public synchronized void config(String msg) {
        LogRecord record = new LogRecord(Level.CONFIG, msg);
        this.log(record);
    }

    public synchronized void config(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.CONFIG, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void config(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.CONFIG, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void config(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.CONFIG, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void entering(String sourceClass, String sourceMethod) {
        LogRecord record = new LogRecord(Level.CONFIG, "Entering method");
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void entering(String sourceClass, String sourceMethod, Object[] params) {
        LogRecord record = new LogRecord(Level.CONFIG, "Entering method");
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void exiting(String sourceClass, String sourceMethod) {
        LogRecord record = new LogRecord(Level.CONFIG, "Exiting method");
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void exiting(String sourceClass, String sourceMethod, Object[] params) {
        LogRecord record = new LogRecord(Level.CONFIG, "Exiting method");
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void fine(String msg) {
        LogRecord record = new LogRecord(Level.FINE, msg);
        this.log(record);
    }

    public synchronized void fine(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINE, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void fine(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.FINE, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void fine(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINE, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void finer(String msg) {
        LogRecord record = new LogRecord(Level.FINER, msg);
        this.log(record);
    }

    public synchronized void finer(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINER, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void finer(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.FINER, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void finer(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINER, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void finest(String msg) {
        LogRecord record = new LogRecord(Level.FINEST, msg);
        this.log(record);
    }

    public synchronized void finest(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINEST, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void finest(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.FINEST, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void finest(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.FINEST, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void info(String msg) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        this.log(record);
    }

    public synchronized void info(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void info(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void info(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String msg) {
        LogRecord record = new LogRecord(msgLevel, msg);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String msg, Object[] params) {
        LogRecord record = new LogRecord(msgLevel, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(msgLevel, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(msgLevel, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(msgLevel, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.log(record);
    }

    public synchronized void log(Level msgLevel, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(msgLevel, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public synchronized void severe(String msg) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        this.log(record);
    }

    public synchronized void severe(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void severe(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void severe(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        LogRecord record = new LogRecord(Level.FINER, "THROWN");
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        this.log(record);
    }

    public synchronized void warning(String msg) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        this.log(record);
    }

    public synchronized void warning(String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        record.setParameters(params);
        this.log(record);
    }

    public synchronized void warning(String sourceClass, String sourceMethod, String msg) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        this.log(record);
    }

    public synchronized void warning(String sourceClass, String sourceMethod, String msg, Object[] params) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        this.log(record);
    }

    public static String format(String format, Object[] objs) {
        return com.gemstone.persistence.admin.Logger.format(format, objs);
    }
}

