/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.security.ClientAuthorizationTestBase;
import com.gemstone.gemfire.security.NotAuthorizedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class ClientCQPostAuthorizationDUnitTest
extends ClientAuthorizationTestBase {
    public static final Map<String, String> cqNameToQueryStrings = new HashMap<String, String>();

    public ClientCQPostAuthorizationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        ClientCQPostAuthorizationDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                ClientCQPostAuthorizationDUnitTest.this.getSystem();
            }
        });
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server2 = host.getVM(1);
        client1 = host.getVM(2);
        client2 = host.getVM(3);
        server1.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        server2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{serverExpectedExceptions});
        client2.invoke(SecurityTestUtil.class, "registerExpectedExceptions", new Object[]{clientExpectedExceptions});
        SecurityTestUtil.registerExpectedExceptions(clientExpectedExceptions);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client1.invoke(SecurityTestUtil.class, "closeCache");
        client2.invoke(SecurityTestUtil.class, "closeCache");
        server1.invoke(SecurityTestUtil.class, "closeCache");
        server2.invoke(SecurityTestUtil.class, "closeCache");
    }

    public void testAllowCQForAllMultiusers() throws Exception {
        this.doStartUp(2, 5, new Boolean[]{true, true});
    }

    public void testDisallowCQForAllMultiusers() throws Exception {
        this.doStartUp(2, 5, new Boolean[]{false, false});
    }

    public void testDisallowCQForSomeMultiusers() throws Exception {
        this.doStartUp(2, 5, new Boolean[]{true, false});
    }

    public void testAllowCQForAllMultiusersWithFailover() throws Exception {
        this.doStartUp(2, 5, new Boolean[]{true, true}, Boolean.TRUE);
    }

    public void doStartUp(Integer numOfUsers, Integer numOfPuts, Boolean[] postAuthzAllowed) throws Exception {
        this.doStartUp(numOfUsers, numOfPuts, postAuthzAllowed, Boolean.FALSE);
    }

    public void doStartUp(Integer numOfUsers, Integer numOfPuts, Boolean[] postAuthzAllowed, Boolean failover) throws Exception {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String accessor = gen.getAuthorizationCallback();
            String authInit = cGen.getAuthInit();
            ClientAuthorizationTestBase.TestAuthzCredentialGenerator tgen = new ClientAuthorizationTestBase.TestAuthzCredentialGenerator(gen);
            Properties serverProps = ClientCQPostAuthorizationDUnitTest.buildProperties(authenticator, accessor, true, extraAuthProps, extraAuthzProps);
            cGen = tgen.getCredentialGenerator();
            Properties javaProps2 = null;
            if (cGen != null) {
                javaProps2 = cGen.getJavaProperties();
            }
            int[] indices = new int[numOfPuts.intValue()];
            for (int index = 0; index < numOfPuts; ++index) {
                indices[index] = index;
            }
            Random rnd = new Random();
            Properties[] authProps = new Properties[numOfUsers.intValue()];
            for (int i = 0; i < numOfUsers; ++i) {
                int rand = rnd.nextInt(100) + 1;
                Properties opCredentials = postAuthzAllowed[i] != false ? tgen.getAllowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.EXECUTE_CQ, OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, indices, rand) : tgen.getDisallowedCredentials(new OperationContext.OperationCode[]{OperationContext.OperationCode.GET}, new String[]{"AuthRegion"}, indices, rand);
                authProps[i] = SecurityTestUtil.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
            }
            Integer port1 = AvailablePort.getRandomAvailablePort((int)0);
            Integer port2 = AvailablePort.getRandomAvailablePort((int)0);
            Integer mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            server1.invoke(SecurityTestUtil.class, "closeCache");
            server2.invoke(SecurityTestUtil.class, "closeCache");
            server1.invoke(ClientCQPostAuthorizationDUnitTest.class, "createServerCache", new Object[]{serverProps, javaProps, mcastPort, port1});
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "createClientCache", new Object[]{javaProps2, authInit, authProps, new Integer[]{port1, port2}, numOfUsers, postAuthzAllowed});
            client2.invoke(ClientCQPostAuthorizationDUnitTest.class, "createClientCache", new Object[]{javaProps2, authInit, authProps, new Integer[]{port1, port2}, numOfUsers, postAuthzAllowed});
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "createCQ", new Object[]{numOfUsers});
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "executeCQ", new Object[]{numOfUsers, new Boolean[]{false, false}, numOfPuts, new String[numOfUsers.intValue()], postAuthzAllowed});
            client2.invoke(ClientCQPostAuthorizationDUnitTest.class, "doPuts", new Object[]{numOfPuts, Boolean.TRUE});
            if (!postAuthzAllowed[0].booleanValue()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "waitForLastKey", new Object[]{0});
                if (postAuthzAllowed[1].booleanValue()) {
                    client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "waitForLastKey", new Object[]{1});
                }
            }
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "checkCQListeners", new Object[]{numOfUsers, postAuthzAllowed, numOfPuts + 1, 0, failover == false});
            if (!failover.booleanValue()) continue;
            server2.invoke(ClientCQPostAuthorizationDUnitTest.class, "createServerCache", new Object[]{serverProps, javaProps, mcastPort, port2});
            server1.invoke(SecurityTestUtil.class, "closeCache");
            server2.invoke(ClientCQPostAuthorizationDUnitTest.class, "allowCQsToRegister", new Object[]{2});
            client2.invoke(ClientCQPostAuthorizationDUnitTest.class, "doPuts", new Object[]{numOfPuts, Boolean.TRUE});
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "waitForLastKeyUpdate", new Object[]{0});
            client1.invoke(ClientCQPostAuthorizationDUnitTest.class, "checkCQListeners", new Object[]{numOfUsers, postAuthzAllowed, numOfPuts + 1, numOfPuts + 1, Boolean.TRUE});
        }
    }

    public static void createServerCache(Properties serverProps, Properties javaProps, Integer serverPort) {
        Integer mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        SecurityTestUtil.createCacheServer(serverProps, javaProps, mcastPort, null, serverPort, Boolean.TRUE, 0);
    }

    public static void createServerCache(Properties serverProps, Properties javaProps, Integer mcastPort, Integer serverPort) {
        SecurityTestUtil.createCacheServer(serverProps, javaProps, mcastPort, null, serverPort, Boolean.TRUE, 0);
    }

    public static void createClientCache(Properties javaProps, String authInit, Properties[] authProps, Integer[] ports, Integer numOfUsers, Boolean[] postAuthzAllowed) {
        SecurityTestUtil.createCacheClientForMultiUserMode(numOfUsers, authInit, authProps, javaProps, ports, null, Boolean.FALSE, 0);
    }

    public static void createCQ(Integer num) {
        for (int i = 0; i < num; ++i) {
            QueryService cqService = SecurityTestUtil.proxyCaches[i].getQueryService();
            String cqName = "CQ_" + i;
            String queryStr = cqNameToQueryStrings.get(cqName) + SecurityTestUtil.proxyCaches[i].getRegion("AuthRegion").getFullPath();
            CqAttributesFactory cqf = new CqAttributesFactory();
            CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(ClientCQPostAuthorizationDUnitTest.getLogWriter())};
            ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
            cqf.initCqListeners(cqListeners);
            CqAttributes cqa = cqf.create();
            try {
                CqQuery cq1 = cqService.newCq(cqName, queryStr, cqa);
                ClientCQPostAuthorizationDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                continue;
            }
            catch (Exception ex) {
                AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                ((Throwable)((Object)err)).initCause(ex);
                ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCQ(Integer num, Boolean[] initialResults, Integer expectedResultsSize, String[] expectedErr, Boolean[] postAuthzAllowed) {
        for (int i = 0; i < num; ++i) {
            try {
                if (expectedErr[i] != null) {
                    SecurityTestUtil.proxyCaches[i].getLogger().info("<ExpectedException action=add>" + expectedErr[i] + "</ExpectedException>");
                }
                CqQuery cq1 = null;
                String cqName = "CQ_" + i;
                String queryStr = cqNameToQueryStrings.get(cqName) + SecurityTestUtil.proxyCaches[i].getRegion("AuthRegion").getFullPath();
                QueryService cqService = SecurityTestUtil.proxyCaches[i].getQueryService();
                try {
                    cq1 = cqService.getCq(cqName);
                    if (cq1 == null) {
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                        ClientCQPostAuthorizationDUnitTest.fail((String)("Failed to get CQ " + cqName));
                    } else {
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
                        ClientCQPostAuthorizationDUnitTest.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    }
                }
                catch (Exception ex) {
                    ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is :" + cqService);
                    ClientCQPostAuthorizationDUnitTest.getLogWriter().error((Throwable)ex);
                    AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                if (initialResults[i].booleanValue()) {
                    CqResults cqResults = null;
                    try {
                        cqResults = cq1.executeWithInitialResults();
                    }
                    catch (CqException ce) {
                        if (ce.getCause() instanceof NotAuthorizedException && !postAuthzAllowed[i].booleanValue()) {
                            ClientCQPostAuthorizationDUnitTest.getLogWriter().info("Got expected exception for CQ " + cqName);
                        }
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is: " + cqService);
                        ce.printStackTrace();
                        AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ce);
                        throw err;
                    }
                    catch (Exception ex) {
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is: " + cqService);
                        ex.printStackTrace();
                        AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        throw err;
                    }
                    ClientCQPostAuthorizationDUnitTest.getLogWriter().info("initial result size = " + cqResults.size());
                    ClientCQPostAuthorizationDUnitTest.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    if (expectedResultsSize < 0) continue;
                    ClientCQPostAuthorizationDUnitTest.assertEquals((String)"unexpected results size", (int)expectedResultsSize, (int)cqResults.size());
                    continue;
                }
                try {
                    cq1.execute();
                }
                catch (CqException ce) {
                    if (ce.getCause() instanceof NotAuthorizedException && !postAuthzAllowed[i].booleanValue()) {
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("Got expected exception for CQ " + cqName);
                    }
                    ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is: " + cqService);
                    ce.printStackTrace();
                    AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ce);
                    throw err;
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to execute CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    if (expectedErr == null) {
                        ClientCQPostAuthorizationDUnitTest.getLogWriter().info("CqService is: " + cqService, (Throwable)((Object)err));
                    }
                    throw err;
                }
                ClientCQPostAuthorizationDUnitTest.assertTrue((String)"execute() state mismatch", (cq1.getState().isRunning() == postAuthzAllowed[i].booleanValue() ? 1 : 0) != 0);
                continue;
            }
            finally {
                if (expectedErr[i] != null) {
                    SecurityTestUtil.proxyCaches[i].getLogger().info("<ExpectedException action=remove>" + expectedErr[i] + "</ExpectedException>");
                }
            }
        }
    }

    public static void doPuts(Integer num, Boolean putLastKey) {
        Region region = SecurityTestUtil.proxyCaches[0].getRegion("AuthRegion");
        for (int i = 0; i < num; ++i) {
            region.put((Object)("CQ_key" + i), (Object)("CQ_value" + i));
        }
        if (putLastKey.booleanValue()) {
            region.put((Object)"LAST_KEY", (Object)"LAST_KEY");
        }
    }

    public static void putLastKey() {
        Region region = GemFireCacheImpl.getInstance().getRegion("AuthRegion");
        region.put((Object)"LAST_KEY", (Object)"LAST_KEY");
    }

    public static void waitForLastKey(Integer cqIndex) {
        String cqName = "CQ_" + cqIndex;
        QueryService qService = SecurityTestUtil.proxyCaches[cqIndex].getQueryService();
        CqQueryImpl cqQuery = (CqQueryImpl)qService.getCq(cqName);
        ((CqQueryTestListener)cqQuery.getCqListeners()[0]).waitForCreated("LAST_KEY");
    }

    public static void waitForLastKeyUpdate(Integer cqIndex) {
        String cqName = "CQ_" + cqIndex;
        QueryService qService = SecurityTestUtil.proxyCaches[cqIndex].getQueryService();
        CqQueryImpl cqQuery = (CqQueryImpl)qService.getCq(cqName);
        ((CqQueryTestListener)cqQuery.getCqListeners()[0]).waitForUpdated("LAST_KEY");
    }

    public static void allowCQsToRegister(Integer number) {
        final int num = number;
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                CqService cqService = CqService.getCqService((Cache)GemFireCacheImpl.getInstance());
                CqQuery[] cqs = cqService.getAllCqs();
                if (cqs != null) {
                    return cqs.length >= num;
                }
                return false;
            }

            @Override
            public String description() {
                return num + "Waited for " + num + " CQs to be registered on this server.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 100L, false);
    }

    public static void checkCQListeners(Integer numOfUsers, Boolean[] expectedListenerInvocation, Integer createEventsSize, Integer updateEventsSize, Boolean closeCache) {
        for (int i = 0; i < numOfUsers; ++i) {
            String cqName = "CQ_" + i;
            QueryService qService = SecurityTestUtil.proxyCaches[i].getQueryService();
            CqQueryImpl cqQuery = (CqQueryImpl)qService.getCq(cqName);
            if (expectedListenerInvocation[i].booleanValue()) {
                for (CqListener listener : cqQuery.getCqListeners()) {
                    ClientCQPostAuthorizationDUnitTest.assertEquals((int)createEventsSize, (int)((CqQueryTestListener)listener).getCreateEventCount());
                    ClientCQPostAuthorizationDUnitTest.assertEquals((int)updateEventsSize, (int)((CqQueryTestListener)listener).getUpdateEventCount());
                }
            } else {
                for (CqListener listener : cqQuery.getCqListeners()) {
                    ClientCQPostAuthorizationDUnitTest.assertEquals((int)0, (int)((CqQueryTestListener)listener).getTotalEventCount());
                }
            }
            if (!closeCache.booleanValue()) continue;
            SecurityTestUtil.proxyCaches[i].close();
        }
    }

    static {
        cqNameToQueryStrings.put("CQ_0", "SELECT * FROM ");
        cqNameToQueryStrings.put("CQ_1", "SELECT * FROM ");
    }
}

