/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.security;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import com.gemstone.gemfire.security.NotAuthorizedException;
import com.gemstone.gemfire.security.SecurityTestUtil;
import dunit.DistributedTestCase;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import security.AuthzCredentialGenerator;
import security.CredentialGenerator;

public class ClientAuthorizationTestBase
extends DistributedTestCase {
    protected static VM server1 = null;
    protected static VM server2 = null;
    protected static VM client1 = null;
    protected static VM client2 = null;
    protected static final String regionName = "AuthRegion";
    protected static final String subregionName = "AuthSubregion";
    protected static final String[] serverExpectedExceptions = new String[]{AuthenticationRequiredException.class.getName(), AuthenticationFailedException.class.getName(), NotAuthorizedException.class.getName(), GemFireSecurityException.class.getName(), RegionDestroyedException.class.getName(), ClassNotFoundException.class.getName()};
    protected static final String[] clientExpectedExceptions = new String[]{AuthenticationFailedException.class.getName(), NotAuthorizedException.class.getName(), RegionDestroyedException.class.getName()};
    private static final int PAUSE = 5000;

    public ClientAuthorizationTestBase(String name) {
        super(name);
    }

    protected static Properties buildProperties(String authenticator, String accessor, boolean isAccessorPP, Properties extraAuthProps, Properties extraAuthzProps) {
        Properties authProps = new Properties();
        if (authenticator != null) {
            authProps.setProperty("security-client-authenticator", authenticator);
        }
        if (accessor != null) {
            if (isAccessorPP) {
                authProps.setProperty("security-client-accessor-pp", accessor);
            } else {
                authProps.setProperty("security-client-accessor", accessor);
            }
        }
        return SecurityTestUtil.concatProperties(new Properties[]{authProps, extraAuthProps, extraAuthzProps});
    }

    public static Integer createCacheServer(Integer mcastPort, Object authProps, Object javaProps) {
        if (mcastPort == null) {
            mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        }
        return SecurityTestUtil.createCacheServer((Properties)authProps, javaProps, mcastPort, null, null, Boolean.TRUE, new Integer(0));
    }

    public static void createCacheServer(Integer mcastPort, Integer serverPort, Object authProps, Object javaProps) {
        if (mcastPort == null) {
            mcastPort = new Integer(AvailablePort.getRandomAvailablePort((int)1));
        }
        SecurityTestUtil.createCacheServer((Properties)authProps, javaProps, mcastPort, null, serverPort, Boolean.TRUE, new Integer(0));
    }

    public static void createCacheClient(Object authInit, Object authProps, Object javaProps, Integer[] ports, Integer numConnections, Boolean setupDynamicRegionFactory, Integer expectedResult) {
        String authInitStr;
        String string = authInitStr = authInit == null ? null : authInit.toString();
        if (authProps == null) {
            authProps = new Properties();
        }
        SecurityTestUtil.createCacheClient(authInitStr, (Properties)authProps, (Properties)javaProps, ports, numConnections, setupDynamicRegionFactory, expectedResult);
    }

    protected static Region getRegion() {
        return SecurityTestUtil.getCache().getRegion(regionName);
    }

    protected static Region getSubregion() {
        return SecurityTestUtil.getCache().getRegion("AuthRegion/AuthSubregion");
    }

    private static Region createSubregion(Region region) {
        Region subregion = ClientAuthorizationTestBase.getSubregion();
        if (subregion == null) {
            subregion = region.createSubregion(subregionName, region.getAttributes());
        }
        return subregion;
    }

    protected static String indicesToString(int[] indices) {
        String str = "";
        if (indices != null && indices.length > 0) {
            str = str + indices[0];
            for (int index = 1; index < indices.length; ++index) {
                str = str + ",";
                str = str + indices[index];
            }
        }
        return str;
    }

    public static void doOp(Byte opCode, int[] indices, Integer flagsI, Integer expectedResult) {
        OperationContext.OperationCode op = OperationContext.OperationCode.fromOrdinal((byte)opCode);
        boolean operationOmitted = false;
        final int flags = flagsI;
        Region region = ClientAuthorizationTestBase.getRegion();
        if ((flags & 0x400) > 0) {
            ClientAuthorizationTestBase.assertNotNull((Object)region);
            Region subregion = null;
            if ((flags & 0x800) > 0) {
                if ((flags & 4) > 0) {
                    SecurityTestUtil.waitForCondition(new Callable(){

                        public Object call() throws Exception {
                            return ClientAuthorizationTestBase.getSubregion() == null;
                        }
                    });
                    subregion = ClientAuthorizationTestBase.getSubregion();
                    ClientAuthorizationTestBase.assertNull((Object)subregion);
                    return;
                }
                SecurityTestUtil.waitForCondition(new Callable(){

                    public Object call() throws Exception {
                        return ClientAuthorizationTestBase.getSubregion() != null;
                    }
                });
                subregion = ClientAuthorizationTestBase.getSubregion();
                ClientAuthorizationTestBase.assertNotNull((Object)subregion);
            } else {
                subregion = ClientAuthorizationTestBase.createSubregion(region);
            }
            ClientAuthorizationTestBase.assertNotNull((Object)subregion);
            region = subregion;
        } else {
            if ((flags & 4) > 0) {
                SecurityTestUtil.waitForCondition(new Callable(){

                    public Object call() throws Exception {
                        return ClientAuthorizationTestBase.getRegion() == null;
                    }
                });
                region = ClientAuthorizationTestBase.getRegion();
                ClientAuthorizationTestBase.assertNull((Object)region);
                return;
            }
            ClientAuthorizationTestBase.assertNotNull((Object)region);
        }
        String[] keys = SecurityTestUtil.keys;
        String[] vals = (flags & 0x10) > 0 ? SecurityTestUtil.nvalues : SecurityTestUtil.values;
        InterestResultPolicy policy = InterestResultPolicy.KEYS_VALUES;
        if ((flags & 0x8000) > 0) {
            policy = InterestResultPolicy.NONE;
        }
        final int numOps = indices.length;
        ClientAuthorizationTestBase.getLogWriter().info("Got doOp for op: " + op.toString() + ", numOps: " + numOps + ", indices: " + ClientAuthorizationTestBase.indicesToString(indices) + ", expect: " + expectedResult);
        boolean exceptionOccured = false;
        boolean breakLoop = false;
        if (op.isGet() || op.isContainsKey() || op.isKeySet() || op.isQuery() || op.isExecuteCQ()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                ClientAuthorizationTestBase.fail((String)"interrupted");
            }
        }
        for (int indexIndex = 0; indexIndex < numOps && !breakLoop; ++indexIndex) {
            int index = indices[indexIndex];
            try {
                final String key = keys[index];
                final String expectedVal = vals[index];
                if (op.isGet()) {
                    Object value = null;
                    if ((flags & 0x20) > 0) {
                        String searchKey;
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            searchKey = keys[keyNum];
                            keyList.add(searchKey);
                            if ((flags & 0x200) > 0) {
                                AbstractRegionEntry entry = (AbstractRegionEntry)((LocalRegion)region).getRegionEntry((Object)searchKey);
                                ClientAuthorizationTestBase.getLogWriter().info("" + keyNum + ": key is " + searchKey + " and entry is " + entry);
                                ClientAuthorizationTestBase.assertFalse((boolean)region.containsKey((Object)searchKey));
                                continue;
                            }
                            if (keyNumIndex % 2 != 1) continue;
                            ClientAuthorizationTestBase.assertTrue((boolean)region.containsKey((Object)searchKey));
                            region.localInvalidate((Object)searchKey);
                        }
                        Map entries = region.getAll(keyList);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            searchKey = keys[keyNum];
                            if ((flags & 1) > 0) {
                                ClientAuthorizationTestBase.assertFalse((boolean)entries.containsKey(searchKey));
                                continue;
                            }
                            ClientAuthorizationTestBase.assertTrue((boolean)entries.containsKey(searchKey));
                            value = entries.get(searchKey);
                            ClientAuthorizationTestBase.assertEquals((Object)vals[keyNum], (Object)value);
                        }
                        break;
                    }
                    if ((flags & 0x100) > 0) {
                        Callable cond = new Callable(){
                            private Region region;

                            public Object call() throws Exception {
                                Object value = SecurityTestUtil.getLocalValue(this.region, key);
                                return (flags & 1) > 0 ? !expectedVal.equals(value) : expectedVal.equals(value);
                            }

                            public Callable init(Region region) {
                                this.region = region;
                                return this;
                            }
                        }.init(region);
                        SecurityTestUtil.waitForCondition(cond);
                        value = SecurityTestUtil.getLocalValue(region, key);
                    } else {
                        if ((flags & 0x200) > 0) {
                            ClientAuthorizationTestBase.assertFalse((boolean)region.containsKey((Object)key));
                        } else {
                            ClientAuthorizationTestBase.assertTrue((region.containsKey((Object)key) || ((LocalRegion)region).getRegionEntry((Object)key).isTombstone() ? 1 : 0) != 0);
                            region.localInvalidate((Object)key);
                        }
                        value = region.get((Object)key);
                    }
                    if ((flags & 1) > 0) {
                        ClientAuthorizationTestBase.assertFalse((boolean)expectedVal.equals(value));
                    } else {
                        ClientAuthorizationTestBase.assertNotNull((Object)value);
                        ClientAuthorizationTestBase.assertEquals((Object)expectedVal, (Object)value);
                    }
                } else if (op.isPut()) {
                    region.put((Object)key, (Object)expectedVal);
                } else if (op.isPutAll()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int i = 0; i < indices.length; ++i) {
                        map.put(keys[indices[i]], vals[indices[i]]);
                    }
                    region.putAll(map);
                    breakLoop = true;
                } else if (op.isDestroy()) {
                    if ((flags & 0x100) > 0) {
                        region.localDestroy((Object)key);
                    } else {
                        region.destroy((Object)key);
                    }
                } else if (op.isInvalidate()) {
                    if (region.containsKey((Object)key)) {
                        if ((flags & 0x100) > 0) {
                            region.localInvalidate((Object)key);
                        } else {
                            region.invalidate((Object)key);
                        }
                    }
                } else if (op.isContainsKey()) {
                    boolean result = (flags & 0x100) > 0 ? region.containsKey((Object)key) : region.containsKeyOnServer((Object)key);
                    if ((flags & 1) > 0) {
                        ClientAuthorizationTestBase.assertFalse((boolean)result);
                    } else {
                        ClientAuthorizationTestBase.assertTrue((boolean)result);
                    }
                } else if (op.isRegisterInterest()) {
                    if ((flags & 0x80) > 0) {
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            keyList.add(keys[keyNum]);
                        }
                        region.registerInterest(keyList, policy);
                    } else if ((flags & 0x40) > 0) {
                        breakLoop = true;
                        region.registerInterestRegex("key[1-" + numOps + ']', policy);
                    } else if ((flags & 0x20) > 0) {
                        breakLoop = true;
                        region.registerInterest((Object)"ALL_KEYS", policy);
                    } else {
                        region.registerInterest((Object)key, policy);
                    }
                } else if (op.isUnregisterInterest()) {
                    if ((flags & 0x80) > 0) {
                        breakLoop = true;
                        ArrayList<String> keyList = new ArrayList<String>(numOps);
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            keyList.add(keys[keyNum]);
                        }
                        region.unregisterInterest(keyList);
                    } else if ((flags & 0x40) > 0) {
                        breakLoop = true;
                        region.unregisterInterestRegex("key[1-" + numOps + ']');
                    } else if ((flags & 0x20) > 0) {
                        breakLoop = true;
                        region.unregisterInterest((Object)"ALL_KEYS");
                    } else {
                        region.unregisterInterest((Object)key);
                    }
                } else if (op.isKeySet()) {
                    breakLoop = true;
                    Set keySet = (flags & 0x100) > 0 ? region.keySet() : region.keySetOnServer();
                    ClientAuthorizationTestBase.assertNotNull((Object)keySet);
                    if ((flags & 1) == 0) {
                        ClientAuthorizationTestBase.assertEquals((int)numOps, (int)keySet.size());
                    }
                    for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                        int keyNum = indices[keyNumIndex];
                        if ((flags & 1) > 0) {
                            ClientAuthorizationTestBase.assertFalse((boolean)keySet.contains(keys[keyNum]));
                            continue;
                        }
                        ClientAuthorizationTestBase.assertTrue((boolean)keySet.contains(keys[keyNum]));
                    }
                } else if (op.isQuery()) {
                    breakLoop = true;
                    SelectResults queryResults = region.query("SELECT DISTINCT * FROM " + region.getFullPath());
                    ClientAuthorizationTestBase.assertNotNull((Object)queryResults);
                    Set queryResultSet = queryResults.asSet();
                    if ((flags & 1) == 0) {
                        ClientAuthorizationTestBase.assertEquals((int)numOps, (int)queryResultSet.size());
                    }
                    for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                        int keyNum = indices[keyNumIndex];
                        if ((flags & 1) > 0) {
                            ClientAuthorizationTestBase.assertFalse((boolean)queryResultSet.contains(vals[keyNum]));
                            continue;
                        }
                        ClientAuthorizationTestBase.assertTrue((boolean)queryResultSet.contains(vals[keyNum]));
                    }
                } else if (op.isExecuteCQ()) {
                    breakLoop = true;
                    QueryService queryService = SecurityTestUtil.getCache().getQueryService();
                    CqQuery cqQuery = queryService.getCq("cq1");
                    if (cqQuery == null) {
                        CqAttributesFactory cqFact = new CqAttributesFactory();
                        cqFact.addCqListener((CqListener)new AuthzCqListener());
                        CqAttributes cqAttrs = cqFact.create();
                        cqQuery = queryService.newCq("cq1", "SELECT * FROM " + region.getFullPath(), cqAttrs);
                    }
                    if ((flags & 0x100) > 0) {
                        final AuthzCqListener listener = (AuthzCqListener)cqQuery.getCqAttributes().getCqListener();
                        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                if ((flags & 1) > 0) {
                                    return 0 == listener.getNumUpdates();
                                }
                                return numOps == listener.getNumUpdates();
                            }

                            @Override
                            public String description() {
                                return null;
                            }
                        };
                        DistributedTestCase.waitForCriterion(ev, 3000L, 200L, true);
                        if ((flags & 1) > 0) {
                            ClientAuthorizationTestBase.assertEquals((int)0, (int)listener.getNumUpdates());
                        } else {
                            ClientAuthorizationTestBase.assertEquals((int)numOps, (int)listener.getNumUpdates());
                            listener.checkPuts(vals, indices);
                        }
                        ClientAuthorizationTestBase.assertEquals((int)0, (int)listener.getNumCreates());
                        ClientAuthorizationTestBase.assertEquals((int)0, (int)listener.getNumDestroys());
                        ClientAuthorizationTestBase.assertEquals((int)0, (int)listener.getNumOtherOps());
                        ClientAuthorizationTestBase.assertEquals((int)0, (int)listener.getNumErrors());
                    } else {
                        CqResults cqResults = cqQuery.executeWithInitialResults();
                        ClientAuthorizationTestBase.assertNotNull((Object)cqResults);
                        HashSet<Object> cqResultValues = new HashSet<Object>();
                        for (Object o : cqResults.asList()) {
                            Struct s = (Struct)o;
                            cqResultValues.add(s.get("value"));
                        }
                        Set cqResultSet = cqResults.asSet();
                        if ((flags & 1) == 0) {
                            ClientAuthorizationTestBase.assertEquals((int)numOps, (int)cqResultSet.size());
                        }
                        for (int keyNumIndex = 0; keyNumIndex < numOps; ++keyNumIndex) {
                            int keyNum = indices[keyNumIndex];
                            if ((flags & 1) > 0) {
                                ClientAuthorizationTestBase.assertFalse((boolean)cqResultValues.contains(vals[keyNum]));
                                continue;
                            }
                            ClientAuthorizationTestBase.assertTrue((boolean)cqResultValues.contains(vals[keyNum]));
                        }
                    }
                } else if (op.isStopCQ()) {
                    breakLoop = true;
                    CqQuery cqQuery = SecurityTestUtil.getCache().getQueryService().getCq("cq1");
                    ((AuthzCqListener)cqQuery.getCqAttributes().getCqListener()).reset();
                    cqQuery.stop();
                } else if (op.isCloseCQ()) {
                    breakLoop = true;
                    CqQuery cqQuery = SecurityTestUtil.getCache().getQueryService().getCq("cq1");
                    ((AuthzCqListener)cqQuery.getCqAttributes().getCqListener()).reset();
                    cqQuery.close();
                } else if (op.isRegionClear()) {
                    breakLoop = true;
                    if ((flags & 0x100) > 0) {
                        region.localClear();
                    } else {
                        region.clear();
                    }
                } else if (op.isRegionCreate()) {
                    breakLoop = true;
                    DynamicRegionFactory drf = DynamicRegionFactory.get();
                    Region subregion = drf.createDynamicRegion(regionName, subregionName);
                    ClientAuthorizationTestBase.assertEquals((String)"/AuthRegion/AuthSubregion", (String)subregion.getFullPath());
                } else if (op.isRegionDestroy()) {
                    breakLoop = true;
                    if ((flags & 0x100) > 0) {
                        region.localDestroyRegion();
                    } else if ((flags & 0x400) > 0) {
                        try {
                            DynamicRegionFactory.get().destroyDynamicRegion(region.getFullPath());
                        }
                        catch (RegionDestroyedException ex) {
                            ClientAuthorizationTestBase.getLogWriter().info("doOp: sub-region " + region.getFullPath() + " already destroyed");
                            operationOmitted = true;
                        }
                    } else {
                        region.destroyRegion();
                    }
                } else {
                    ClientAuthorizationTestBase.fail((String)("doOp: Unhandled operation " + op));
                }
                if (expectedResult == 0 || operationOmitted || op.isUnregisterInterest()) continue;
                ClientAuthorizationTestBase.fail((String)("Expected an exception while performing operation op =" + op + "flags = " + OpFlags.description(flags)));
                continue;
            }
            catch (Exception ex) {
                exceptionOccured = true;
                if ((ex instanceof ServerConnectivityException || ex instanceof QueryInvocationTargetException || ex instanceof CqException) && expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    ClientAuthorizationTestBase.getLogWriter().info("doOp: Got expected NotAuthorizedException when doing operation [" + op + "] with flags " + OpFlags.description(flags) + ": " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    ClientAuthorizationTestBase.getLogWriter().info("doOp: Got expected exception when doing operation: " + ex.toString());
                    continue;
                }
                ClientAuthorizationTestBase.fail("doOp: Got unexpected exception when doing operation. Policy = " + policy + " flags = " + OpFlags.description(flags), ex);
            }
        }
        if (!exceptionOccured && !operationOmitted && expectedResult != 0) {
            ClientAuthorizationTestBase.fail((String)("Expected an exception while performing operation: " + op + " flags = " + OpFlags.description(flags)));
        }
    }

    protected void executeOpBlock(List opBlock, Integer port1, Integer port2, String authInit, Properties extraAuthProps, Properties extraAuthzProps, TestCredentialGenerator gen, Random rnd) {
        for (OperationWithAction currentOp : opBlock) {
            OperationContext.OperationCode opCode = currentOp.getOperationCode();
            int opFlags = currentOp.getFlags();
            int clientNum = currentOp.getClientNum();
            VM clientVM = null;
            boolean useThisVM = false;
            switch (clientNum) {
                case 1: {
                    clientVM = client1;
                    break;
                }
                case 2: {
                    clientVM = client2;
                    break;
                }
                case 3: {
                    useThisVM = true;
                    break;
                }
                default: {
                    ClientAuthorizationTestBase.fail((String)("executeOpBlock: Unknown client number " + clientNum));
                }
            }
            ClientAuthorizationTestBase.getLogWriter().info("executeOpBlock: performing operation number [" + currentOp.getOpNum() + "]: " + currentOp);
            if ((opFlags & 0x1000) == 0) {
                boolean setupDynamicRegionFactory;
                String credentialsTypeStr;
                Properties opCredentials;
                int newRnd = rnd.nextInt(100) + 1;
                String currentRegionName = "/AuthRegion";
                if ((opFlags & 0x400) > 0) {
                    currentRegionName = currentRegionName + "/AuthSubregion";
                }
                OperationContext.OperationCode authOpCode = currentOp.getAuthzOperationCode();
                int[] indices = currentOp.getIndices();
                CredentialGenerator cGen = gen.getCredentialGenerator();
                Properties javaProps = null;
                if ((opFlags & 2) > 0 || (opFlags & 0x2000) > 0) {
                    opCredentials = gen.getDisallowedCredentials(new OperationContext.OperationCode[]{authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " unauthorized " + authOpCode;
                } else {
                    opCredentials = gen.getAllowedCredentials(new OperationContext.OperationCode[]{opCode, authOpCode}, new String[]{currentRegionName}, indices, newRnd);
                    credentialsTypeStr = " authorized " + authOpCode;
                }
                if (cGen != null) {
                    javaProps = cGen.getJavaProperties();
                }
                Properties clientProps = SecurityTestUtil.concatProperties(new Properties[]{opCredentials, extraAuthProps, extraAuthzProps});
                ClientAuthorizationTestBase.getLogWriter().info("executeOpBlock: For client" + clientNum + credentialsTypeStr + " credentials: " + opCredentials);
                boolean bl = setupDynamicRegionFactory = (opFlags & 0x4000) > 0;
                if (useThisVM) {
                    ClientAuthorizationTestBase.createCacheClient(authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, setupDynamicRegionFactory, new Integer(0));
                } else {
                    clientVM.invoke(ClientAuthorizationTestBase.class, "createCacheClient", new Object[]{authInit, clientProps, javaProps, new Integer[]{port1, port2}, null, setupDynamicRegionFactory, new Integer(0)});
                }
            }
            int expectedResult = (opFlags & 2) > 0 ? 4 : ((opFlags & 8) > 0 ? 5 : 0);
            if (useThisVM) {
                ClientAuthorizationTestBase.doOp(new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult));
                continue;
            }
            clientVM.invoke(ClientAuthorizationTestBase.class, "doOp", new Object[]{new Byte(opCode.toOrdinal()), currentOp.getIndices(), new Integer(opFlags), new Integer(expectedResult)});
        }
    }

    protected List getAllGeneratorCombos() {
        ArrayList<AuthzCredentialGenerator> generators = new ArrayList<AuthzCredentialGenerator>();
        List codeGenList = CredentialGenerator.ClassCode.getAll();
        for (AuthzCredentialGenerator.ClassCode authzClassCode : AuthzCredentialGenerator.ClassCode.getAll()) {
            for (CredentialGenerator.ClassCode authClassCode : codeGenList) {
                CredentialGenerator cGen;
                AuthzCredentialGenerator authzGen = AuthzCredentialGenerator.create(authzClassCode);
                if (authzGen == null || (cGen = CredentialGenerator.create(authClassCode)) == null) continue;
                cGen.init();
                if (!authzGen.init(cGen)) continue;
                generators.add(authzGen);
            }
        }
        return generators;
    }

    protected void runOpsWithFailover(OperationWithAction[] opCodes, String testName) {
        for (AuthzCredentialGenerator gen : this.getAllGeneratorCombos()) {
            CredentialGenerator cGen = gen.getCredentialGenerator();
            Properties extraAuthProps = cGen.getSystemProperties();
            Properties javaProps = cGen.getJavaProperties();
            Properties extraAuthzProps = gen.getSystemProperties();
            String authenticator = cGen.getAuthenticator();
            String authInit = cGen.getAuthInit();
            String accessor = gen.getAuthorizationCallback();
            TestAuthzCredentialGenerator tgen = new TestAuthzCredentialGenerator(gen);
            ClientAuthorizationTestBase.getLogWriter().info(testName + ": Using authinit: " + authInit);
            ClientAuthorizationTestBase.getLogWriter().info(testName + ": Using authenticator: " + authenticator);
            ClientAuthorizationTestBase.getLogWriter().info(testName + ": Using accessor: " + accessor);
            Properties serverProps = ClientAuthorizationTestBase.buildProperties(authenticator, accessor, false, extraAuthProps, extraAuthzProps);
            AvailablePort.Keeper port1Keeper = AvailablePort.getRandomAvailablePortKeeper((int)0);
            AvailablePort.Keeper port2Keeper = AvailablePort.getRandomAvailablePortKeeper((int)0);
            int port1 = port1Keeper.getPort();
            int port2 = port2Keeper.getPort();
            ArrayList<OperationWithAction> opBlock = new ArrayList<OperationWithAction>();
            Random rnd = new Random();
            for (int opNum = 0; opNum < opCodes.length; ++opNum) {
                OperationWithAction currentOp = opCodes[opNum];
                if (currentOp.equals(OperationWithAction.OPBLOCK_END) || currentOp.equals(OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                    if (opBlock.size() <= 0) continue;
                    port1Keeper.release();
                    server1.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port1, serverProps, javaProps});
                    server2.invoke(SecurityTestUtil.class, "closeCache");
                    this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    if (!currentOp.equals(OperationWithAction.OPBLOCK_NO_FAILOVER)) {
                        port2Keeper.release();
                        server2.invoke(ClientAuthorizationTestBase.class, "createCacheServer", new Object[]{SecurityTestUtil.getMcastPort(), port2, serverProps, javaProps});
                        server1.invoke(SecurityTestUtil.class, "closeCache");
                        this.executeOpBlock(opBlock, port1, port2, authInit, extraAuthProps, extraAuthzProps, tgen, rnd);
                    }
                    opBlock.clear();
                    continue;
                }
                currentOp.setOpNum(opNum);
                opBlock.add(currentOp);
            }
        }
    }

    protected static class TestAuthzCredentialGenerator
    implements TestCredentialGenerator {
        private AuthzCredentialGenerator authzGen;

        public TestAuthzCredentialGenerator(AuthzCredentialGenerator authzGen) {
            this.authzGen = authzGen;
        }

        @Override
        public Properties getAllowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            return this.authzGen.getAllowedCredentials(opCodes, regionNames, num);
        }

        @Override
        public Properties getDisallowedCredentials(OperationContext.OperationCode[] opCodes, String[] regionNames, int[] keyIndices, int num) {
            return this.authzGen.getDisallowedCredentials(opCodes, regionNames, num);
        }

        @Override
        public CredentialGenerator getCredentialGenerator() {
            return this.authzGen.getCredentialGenerator();
        }
    }

    public static interface TestCredentialGenerator {
        public Properties getAllowedCredentials(OperationContext.OperationCode[] var1, String[] var2, int[] var3, int var4);

        public Properties getDisallowedCredentials(OperationContext.OperationCode[] var1, String[] var2, int[] var3, int var4);

        public CredentialGenerator getCredentialGenerator();
    }

    public static class OperationWithAction {
        private OperationContext.OperationCode opCode;
        private OperationContext.OperationCode authzOpCode;
        private int clientNum;
        private int flags;
        private int[] indices;
        private int opNum;
        public static final OperationWithAction OPBLOCK_END = new OperationWithAction(null, 4);
        public static final OperationWithAction OPBLOCK_NO_FAILOVER = new OperationWithAction(null, 5);

        private void setIndices(int numOps) {
            this.indices = new int[numOps];
            for (int index = 0; index < numOps; ++index) {
                this.indices[index] = index;
            }
        }

        public OperationWithAction(OperationContext.OperationCode opCode) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = 1;
            this.flags = 0;
            this.setIndices(4);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = 0;
            this.setIndices(4);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum, int flags, int numOps) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.setIndices(numOps);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, OperationContext.OperationCode deniedOpCode, int clientNum, int flags, int numOps) {
            this.opCode = opCode;
            this.authzOpCode = deniedOpCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.setIndices(numOps);
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, int clientNum, int flags, int[] indices) {
            this.opCode = opCode;
            this.authzOpCode = opCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.indices = indices;
            this.opNum = 0;
        }

        public OperationWithAction(OperationContext.OperationCode opCode, OperationContext.OperationCode deniedOpCode, int clientNum, int flags, int[] indices) {
            this.opCode = opCode;
            this.authzOpCode = deniedOpCode;
            this.clientNum = clientNum;
            this.flags = flags;
            this.indices = indices;
            this.opNum = 0;
        }

        public OperationContext.OperationCode getOperationCode() {
            return this.opCode;
        }

        public OperationContext.OperationCode getAuthzOperationCode() {
            return this.authzOpCode;
        }

        public int getClientNum() {
            return this.clientNum;
        }

        public int getFlags() {
            return this.flags;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public int getOpNum() {
            return this.opNum;
        }

        public void setOpNum(int opNum) {
            this.opNum = opNum;
        }

        public String toString() {
            return "opCode:" + this.opCode + ",authOpCode:" + this.authzOpCode + ",clientNum:" + this.clientNum + ",flags:" + this.flags + ",numOps:" + this.indices.length + ",indices:" + ClientAuthorizationTestBase.indicesToString(this.indices);
        }
    }

    public static class OpFlags {
        public static final int NONE = 0;
        public static final int CHECK_FAIL = 1;
        public static final int CHECK_NOTAUTHZ = 2;
        public static final int CHECK_NOREGION = 4;
        public static final int CHECK_EXCEPTION = 8;
        public static final int USE_NEWVAL = 16;
        public static final int USE_ALL_KEYS = 32;
        public static final int USE_REGEX = 64;
        public static final int USE_LIST = 128;
        public static final int LOCAL_OP = 256;
        public static final int CHECK_NOKEY = 512;
        public static final int USE_SUBREGION = 1024;
        public static final int NO_CREATE_SUBREGION = 2048;
        public static final int USE_OLDCONN = 4096;
        public static final int USE_NOTAUTHZ = 8192;
        public static final int ENABLE_DRF = 16384;
        public static final int REGISTER_POLICY_NONE = 32768;

        public static String description(int f) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            if ((f & 1) != 0) {
                sb.append("CHECK_FAIL,");
            }
            if ((f & 2) != 0) {
                sb.append("CHECK_NOTAUTHZ,");
            }
            if ((f & 4) != 0) {
                sb.append("CHECK_NOREGION,");
            }
            if ((f & 8) != 0) {
                sb.append("CHECK_EXCEPTION,");
            }
            if ((f & 0x10) != 0) {
                sb.append("USE_NEWVAL,");
            }
            if ((f & 0x20) != 0) {
                sb.append("USE_ALL_KEYS,");
            }
            if ((f & 0x40) != 0) {
                sb.append("USE_REGEX,");
            }
            if ((f & 0x80) != 0) {
                sb.append("USE_LIST,");
            }
            if ((f & 0x100) != 0) {
                sb.append("LOCAL_OP,");
            }
            if ((f & 0x200) != 0) {
                sb.append("CHECK_NOKEY,");
            }
            if ((f & 0x400) != 0) {
                sb.append("USE_SUBREGION,");
            }
            if ((f & 0x800) != 0) {
                sb.append("NO_CREATE_SUBREGION,");
            }
            if ((f & 0x1000) != 0) {
                sb.append("USE_OLDCONN,");
            }
            if ((f & 0x2000) != 0) {
                sb.append("USE_NOTAUTHZ");
            }
            if ((f & 0x4000) != 0) {
                sb.append("ENABLE_DRF,");
            }
            if ((f & 0x8000) != 0) {
                sb.append("REGISTER_POLICY_NONE,");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static class AuthzCqListener
    implements CqListener {
        private List eventList = new ArrayList();
        private int numCreates;
        private int numUpdates;
        private int numDestroys;
        private int numOtherOps;
        private int numErrors;

        public AuthzCqListener() {
            this.reset();
        }

        public void reset() {
            this.eventList.clear();
            this.numCreates = 0;
            this.numUpdates = 0;
            this.numErrors = 0;
        }

        public void onEvent(CqEvent aCqEvent) {
            Operation op = aCqEvent.getBaseOperation();
            if (op.isCreate()) {
                ++this.numCreates;
            } else if (op.isUpdate()) {
                ++this.numUpdates;
            } else if (op.isDestroy()) {
                ++this.numDestroys;
            } else {
                ++this.numOtherOps;
            }
            this.eventList.add(aCqEvent);
        }

        public void onError(CqEvent aCqEvent) {
            ++this.numErrors;
        }

        public void close() {
            this.eventList.clear();
        }

        public int getNumCreates() {
            return this.numCreates;
        }

        public int getNumUpdates() {
            return this.numUpdates;
        }

        public int getNumDestroys() {
            return this.numDestroys;
        }

        public int getNumOtherOps() {
            return this.numOtherOps;
        }

        public int getNumErrors() {
            return this.numErrors;
        }

        public void checkPuts(String[] vals, int[] indices) {
            for (int indexIndex = 0; indexIndex < indices.length; ++indexIndex) {
                int index = indices[indexIndex];
                Iterator eventIter = this.eventList.iterator();
                boolean foundKey = false;
                while (eventIter.hasNext()) {
                    CqEvent event = (CqEvent)eventIter.next();
                    if (!SecurityTestUtil.keys[index].equals(event.getKey())) continue;
                    TestCase.assertEquals((Object)vals[index], (Object)event.getNewValue());
                    foundKey = true;
                    break;
                }
                TestCase.assertTrue((boolean)foundKey);
            }
        }
    }
}

