/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;

public class PdxDeserializationDUnitTest
extends CacheTestCase {
    public PdxDeserializationDUnitTest(String name) {
        super(name);
    }

    public void testP2P() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.doTest(vm0, vm1);
    }

    public void testClientToDataStore() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.doTest(vm2, vm1);
    }

    public void testClientToAccessor() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm3 = host.getVM(3);
        this.doTest(vm3, vm1);
    }

    public void testAccessorToClient() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        VM vm3 = host.getVM(2);
        this.doTest(vm1, vm3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(VM operationVM, VM disallowDeserializationVM) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final int port0 = (Integer)vm0.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = PdxDeserializationDUnitTest.this.getCache();
                CacheServer server = PdxDeserializationDUnitTest.this.createCacheServer(cache);
                cache.createRegionFactory(RegionShortcut.REPLICATE_PROXY).create("replicate");
                cache.createRegionFactory(RegionShortcut.PARTITION_PROXY).create("pr");
                cache.createRegionFactory(RegionShortcut.REPLICATE_PROXY).create("overflow_replicate");
                cache.createRegionFactory(RegionShortcut.PARTITION_PROXY).create("overflow_pr");
                return server.getPort();
            }
        });
        final int port1 = (Integer)vm1.invoke(new SerializableCallable(){

            public Object call() {
                Cache cache = PdxDeserializationDUnitTest.this.getCache();
                CacheServer server = PdxDeserializationDUnitTest.this.createCacheServer(cache);
                cache.createRegionFactory(RegionShortcut.REPLICATE).setCacheLoader((CacheLoader)new TestCacheLoader()).create("replicate");
                cache.createRegionFactory(RegionShortcut.PARTITION).setCacheLoader((CacheLoader)new TestCacheLoader()).create("pr");
                cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).setMaxOplogSize(1L).create("store");
                cache.createRegionFactory(RegionShortcut.REPLICATE_OVERFLOW).setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK)).setDiskStoreName("store").setCacheLoader((CacheLoader)new TestCacheLoader()).create("overflow_replicate");
                cache.createRegionFactory(RegionShortcut.PARTITION_OVERFLOW).setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK)).setDiskStoreName("store").setCacheLoader((CacheLoader)new TestCacheLoader()).create("overflow_pr");
                return server.getPort();
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PdxDeserializationDUnitTest.this.createClient(port0);
                return null;
            }
        });
        vm3.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PdxDeserializationDUnitTest.this.createClient(port1);
                return null;
            }
        });
        disallowDeserializationVM.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestSerializable.throwExceptionOnDeserialization = !CachedDeserializableFactory.preferObject();
            }
        });
        try {
            operationVM.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Cache cache = PdxDeserializationDUnitTest.this.getCache();
                    PdxDeserializationDUnitTest.this.doOperations((Region<Object, Object>)cache.getRegion("replicate"));
                    PdxDeserializationDUnitTest.this.doOperations((Region<Object, Object>)cache.getRegion("pr"));
                    PdxDeserializationDUnitTest.this.doOperations((Region<Object, Object>)cache.getRegion("overflow_replicate"));
                    PdxDeserializationDUnitTest.this.doOperations((Region<Object, Object>)cache.getRegion("overflow_pr"));
                }
            });
            disallowDeserializationVM.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    TestSerializable.throwExceptionOnDeserialization = false;
                }
            });
        }
        catch (Throwable throwable) {
            disallowDeserializationVM.invoke(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PdxDeserializationDUnitTest.this.getCache();
                PdxDeserializationDUnitTest.this.checkValues((Region<Object, Object>)cache.getRegion("replicate"));
                PdxDeserializationDUnitTest.this.checkValues((Region<Object, Object>)cache.getRegion("pr"));
                PdxDeserializationDUnitTest.this.checkValues((Region<Object, Object>)cache.getRegion("overflow_replicate"));
                PdxDeserializationDUnitTest.this.checkValues((Region<Object, Object>)cache.getRegion("overflow_pr"));
            }
        });
        this.checkRegisterInterestValues(vm2);
        this.checkRegisterInterestValues(vm3);
    }

    private void checkRegisterInterestValues(VM vm2) {
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PdxDeserializationDUnitTest.this.getCache();
                PdxDeserializationDUnitTest.this.checkClientValue((Region<Object, Object>)cache.getRegion("replicate"));
                PdxDeserializationDUnitTest.this.checkClientValue((Region<Object, Object>)cache.getRegion("pr"));
                PdxDeserializationDUnitTest.this.checkClientValue((Region<Object, Object>)cache.getRegion("overflow_replicate"));
                PdxDeserializationDUnitTest.this.checkClientValue((Region<Object, Object>)cache.getRegion("overflow_pr"));
            }
        });
    }

    protected void checkClientValue(final Region<Object, Object> region) {
        PdxDeserializationDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return region.get((Object)"A") != null;
            }

            @Override
            public String description() {
                return "Client region never received value for key A";
            }
        }, 30000L, 100L, true);
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"A").getClass());
        region.registerInterest((Object)"B", InterestResultPolicy.KEYS_VALUES);
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"B").getClass());
    }

    private void doOperations(Region<Object, Object> region) {
        region.put((Object)"A", (Object)new TestSerializable());
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"A").getClass());
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"B").getClass());
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"B").getClass());
        if (region.getAttributes().getPoolName() != null) {
            region.registerInterest((Object)".*", InterestResultPolicy.KEYS_VALUES);
        }
        try {
            SelectResults queryResults = (SelectResults)this.getCache().getQueryService().newQuery("select * from " + region.getFullPath()).execute();
            for (Object result : queryResults.asList()) {
                PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, result.getClass());
            }
        }
        catch (Exception e) {
            PdxDeserializationDUnitTest.fail("got exception from query", e);
        }
    }

    private void checkValues(Region<Object, Object> region) {
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"A").getClass());
        PdxDeserializationDUnitTest.assertEquals(TestSerializable.class, region.get((Object)"B").getClass());
    }

    private CacheServer createCacheServer(Cache cache) {
        CacheServer server = cache.addCacheServer();
        server.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        try {
            server.start();
        }
        catch (IOException e) {
            PdxDeserializationDUnitTest.fail("got exception", e);
        }
        return server;
    }

    private void createClient(int port0) {
        ClientCacheFactory cf = new ClientCacheFactory();
        cf.addPoolServer("localhost", port0);
        cf.setPoolSubscriptionEnabled(true);
        ClientCache cache = this.getClientCache(cf);
        Region replicate = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("replicate");
        Region pr = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("pr");
        cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("overflow_replicate");
        cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create("overflow_pr");
        replicate.registerInterest((Object)"A", InterestResultPolicy.KEYS_VALUES);
        pr.registerInterest((Object)"A", InterestResultPolicy.KEYS_VALUES);
    }

    public static class TestSerializable
    implements PdxSerializable {
        private static boolean throwExceptionOnDeserialization = false;

        public void toData(PdxWriter writer) {
        }

        public void fromData(PdxReader reader) {
            if (throwExceptionOnDeserialization) {
                throw new SerializationException("Deserialization should not be happening in this VM");
            }
        }
    }

    public static class TestCacheLoader
    implements CacheLoader {
        public void close() {
        }

        public Object load(LoaderHelper helper) throws CacheLoaderException {
            return new TestSerializable();
        }
    }
}

